// This file is autogenerated by codegen/rust/nodes/node_file/external.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;
use crate::containers::ExternalPtr as Ptr;

use super::internal::InternalNumblock;
use crate::blobs::{HasBlob, Blob};

/// Represents a block that takes numbered parameters (i.e. `proc { _1 }`)
#[repr(C)]
pub struct Numblock {
    pub(crate) blob: Blob<Numblock>
}

impl std::fmt::Debug for Numblock {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        f.debug_struct("Numblock")
            .field("call", &self.get_call())
            .field("numargs", &self.get_numargs())
            .field("body", &self.get_body())
            .field("begin_l", &self.get_begin_l())
            .field("end_l", &self.get_end_l())
            .field("expression_l", &self.get_expression_l())
            .finish()
    }
}

impl PartialEq for Numblock {
    fn eq(&self, other: &Self) -> bool {
        self.get_call() == other.get_call()
            && self.get_numargs() == other.get_numargs()
            && self.get_body() == other.get_body()
            && self.get_begin_l() == other.get_begin_l()
            && self.get_end_l() == other.get_end_l()
            && self.get_expression_l() == other.get_expression_l()
    }
}

impl Numblock {
    /// Returns `call` field
    pub fn get_call(&self) -> &Ptr<Node> {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__numblock__get_call(&self.blob) as *const Ptr<Node>)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `call` field
    pub fn set_call(&mut self, call: Ptr<Node>) {
        unsafe { lib_ruby_parser__external__nodes__numblock__set_call(&mut self.blob, call.into_blob()) }
    }

    /// Returns `numargs` field
    pub fn get_numargs(&self) -> &u8 {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__numblock__get_numargs(&self.blob) as *const u8)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `numargs` field
    pub fn set_numargs(&mut self, numargs: u8) {
        unsafe { lib_ruby_parser__external__nodes__numblock__set_numargs(&mut self.blob, numargs.into_blob()) }
    }

    /// Returns `body` field
    pub fn get_body(&self) -> &Ptr<Node> {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__numblock__get_body(&self.blob) as *const Ptr<Node>)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `body` field
    pub fn set_body(&mut self, body: Ptr<Node>) {
        unsafe { lib_ruby_parser__external__nodes__numblock__set_body(&mut self.blob, body.into_blob()) }
    }

    /// Returns `begin_l` field
    pub fn get_begin_l(&self) -> &Loc {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__numblock__get_begin_l(&self.blob) as *const Loc)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `begin_l` field
    pub fn set_begin_l(&mut self, begin_l: Loc) {
        unsafe { lib_ruby_parser__external__nodes__numblock__set_begin_l(&mut self.blob, begin_l.into_blob()) }
    }

    /// Returns `end_l` field
    pub fn get_end_l(&self) -> &Loc {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__numblock__get_end_l(&self.blob) as *const Loc)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `end_l` field
    pub fn set_end_l(&mut self, end_l: Loc) {
        unsafe { lib_ruby_parser__external__nodes__numblock__set_end_l(&mut self.blob, end_l.into_blob()) }
    }

    /// Returns `expression_l` field
    pub fn get_expression_l(&self) -> &Loc {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__numblock__get_expression_l(&self.blob) as *const Loc)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `expression_l` field
    pub fn set_expression_l(&mut self, expression_l: Loc) {
        unsafe { lib_ruby_parser__external__nodes__numblock__set_expression_l(&mut self.blob, expression_l.into_blob()) }
    }

    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> InternalNumblock {
        unsafe { lib_ruby_parser__external__nodes__numblock__into_internal(self.into_blob()) }
    }
}

extern "C" {
    fn lib_ruby_parser__external__nodes__numblock__get_call(blob: *const Blob<Numblock>) -> *mut Blob<Ptr<Node>>;
    fn lib_ruby_parser__external__nodes__numblock__set_call(blob: *mut Blob<Numblock>, blob: Blob<Ptr<Node>>);
    fn lib_ruby_parser__external__nodes__numblock__get_numargs(blob: *const Blob<Numblock>) -> *mut Blob<u8>;
    fn lib_ruby_parser__external__nodes__numblock__set_numargs(blob: *mut Blob<Numblock>, blob: Blob<u8>);
    fn lib_ruby_parser__external__nodes__numblock__get_body(blob: *const Blob<Numblock>) -> *mut Blob<Ptr<Node>>;
    fn lib_ruby_parser__external__nodes__numblock__set_body(blob: *mut Blob<Numblock>, blob: Blob<Ptr<Node>>);
    fn lib_ruby_parser__external__nodes__numblock__get_begin_l(blob: *const Blob<Numblock>) -> *mut Blob<Loc>;
    fn lib_ruby_parser__external__nodes__numblock__set_begin_l(blob: *mut Blob<Numblock>, blob: Blob<Loc>);
    fn lib_ruby_parser__external__nodes__numblock__get_end_l(blob: *const Blob<Numblock>) -> *mut Blob<Loc>;
    fn lib_ruby_parser__external__nodes__numblock__set_end_l(blob: *mut Blob<Numblock>, blob: Blob<Loc>);
    fn lib_ruby_parser__external__nodes__numblock__get_expression_l(blob: *const Blob<Numblock>) -> *mut Blob<Loc>;
    fn lib_ruby_parser__external__nodes__numblock__set_expression_l(blob: *mut Blob<Numblock>, blob: Blob<Loc>);
    fn lib_ruby_parser__external__nodes__numblock__into_internal(blob: Blob<Numblock>) -> InternalNumblock;
    fn lib_ruby_parser__external__nodes__numblock__drop(blob: *mut Blob<Numblock>);
}

impl InnerNode for Numblock {
    fn expression(&self) -> &Loc {
        self.get_expression_l()
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_node(self.get_call());
        result.push_u8(self.get_numargs());
        result.push_node(self.get_body());
        
        
        
        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "numblock"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        self.get_call().inner_ref().print_with_locs();
        self.get_body().inner_ref().print_with_locs();
        self.get_begin_l().print("begin");
        self.get_end_l().print("end");
        self.get_expression_l().print("expression");
    }
}

impl Drop for Numblock {
    fn drop(&mut self) {
        unsafe { lib_ruby_parser__external__nodes__numblock__drop(&mut self.blob) }
    }
}
