// This file is autogenerated by codegen/rust/nodes/node_file/native.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;

/// Represents numeric global variable (e.g. `$1`)
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct NthRef {
    /// Name of the variable, `String("1")` for `$1`
    pub name: String,

    /// Location of the full expression
    ///
    /// ```text
    /// $1
    /// ~~
    /// ```
    pub expression_l: Loc,
}

impl NthRef {
    #[doc(hidden)]
    pub fn get_name(&self) -> &String {
        &self.name
    }

    #[doc(hidden)]
    pub fn get_name_mut(&mut self) -> &mut String {
        &mut self.name
    }

    #[doc(hidden)]
    pub fn get_expression_l(&self) -> &Loc {
        &self.expression_l
    }

    #[doc(hidden)]
    pub fn get_expression_l_mut(&mut self) -> &mut Loc {
        &mut self.expression_l
    }

    #[doc(hidden)]
    pub fn set_name(&mut self, value: String) {
        self.name = value;
    }

    #[doc(hidden)]
    pub fn set_expression_l(&mut self, value: Loc) {
        self.expression_l = value;
    }

    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> super::InternalNthRef {
        let Self { name, expression_l } = self;
        super::InternalNthRef { name, expression_l }
    }
}

impl InnerNode for NthRef {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_raw_str(&self.name);
        
        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "nth_ref"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        self.expression_l.print("expression");
    }
}
