// This file is autogenerated by codegen/rust/nodes/node_file/external.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;
use crate::containers::ExternalList as List;

use super::internal::InternalNext;
use crate::blobs::{HasBlob, Blob};

/// Represents `next` keyword
#[repr(C)]
pub struct Next {
    pub(crate) blob: Blob<Next>
}

impl std::fmt::Debug for Next {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        f.debug_struct("Next")
            .field("args", &self.get_args())
            .field("keyword_l", &self.get_keyword_l())
            .field("expression_l", &self.get_expression_l())
            .finish()
    }
}

impl PartialEq for Next {
    fn eq(&self, other: &Self) -> bool {
        self.get_args() == other.get_args()
            && self.get_keyword_l() == other.get_keyword_l()
            && self.get_expression_l() == other.get_expression_l()
    }
}

impl Next {
    /// Returns `args` field
    pub fn get_args(&self) -> &List<Node> {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__next__get_args(&self.blob) as *const List<Node>)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `args` field
    pub fn set_args(&mut self, args: List<Node>) {
        unsafe { lib_ruby_parser__external__nodes__next__set_args(&mut self.blob, args.into_blob()) }
    }

    /// Returns `keyword_l` field
    pub fn get_keyword_l(&self) -> &Loc {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__next__get_keyword_l(&self.blob) as *const Loc)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `keyword_l` field
    pub fn set_keyword_l(&mut self, keyword_l: Loc) {
        unsafe { lib_ruby_parser__external__nodes__next__set_keyword_l(&mut self.blob, keyword_l.into_blob()) }
    }

    /// Returns `expression_l` field
    pub fn get_expression_l(&self) -> &Loc {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__next__get_expression_l(&self.blob) as *const Loc)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `expression_l` field
    pub fn set_expression_l(&mut self, expression_l: Loc) {
        unsafe { lib_ruby_parser__external__nodes__next__set_expression_l(&mut self.blob, expression_l.into_blob()) }
    }

    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> InternalNext {
        unsafe { lib_ruby_parser__external__nodes__next__into_internal(self.into_blob()) }
    }
}

extern "C" {
    fn lib_ruby_parser__external__nodes__next__get_args(blob: *const Blob<Next>) -> *mut Blob<List<Node>>;
    fn lib_ruby_parser__external__nodes__next__set_args(blob: *mut Blob<Next>, blob: Blob<List<Node>>);
    fn lib_ruby_parser__external__nodes__next__get_keyword_l(blob: *const Blob<Next>) -> *mut Blob<Loc>;
    fn lib_ruby_parser__external__nodes__next__set_keyword_l(blob: *mut Blob<Next>, blob: Blob<Loc>);
    fn lib_ruby_parser__external__nodes__next__get_expression_l(blob: *const Blob<Next>) -> *mut Blob<Loc>;
    fn lib_ruby_parser__external__nodes__next__set_expression_l(blob: *mut Blob<Next>, blob: Blob<Loc>);
    fn lib_ruby_parser__external__nodes__next__into_internal(blob: Blob<Next>) -> InternalNext;
    fn lib_ruby_parser__external__nodes__next__drop(blob: *mut Blob<Next>);
}

impl InnerNode for Next {
    fn expression(&self) -> &Loc {
        self.get_expression_l()
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_nodes(self.get_args());
        
        
        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "next"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        for node in self.get_args().iter() {
          node.inner_ref().print_with_locs();
        }
        self.get_keyword_l().print("keyword");
        self.get_expression_l().print("expression");
    }
}

impl Drop for Next {
    fn drop(&mut self) {
        unsafe { lib_ruby_parser__external__nodes__next__drop(&mut self.blob) }
    }
}
