// This file is autogenerated by codegen/rust/nodes/node_file/native.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;

/// Represents left hand statement of the mass-assignment (i.e. `foo, bar` in `foo, bar = 1, 2`)
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct Mlhs {
    /// A list of items that are assigned
    pub items: Vec<Node>,

    /// Location of the open parenthesis
    ///
    /// ```text
    /// (a, b) = 1, 2
    /// ~
    /// ```
    ///
    /// `None` if there are no parentheses
    pub begin_l: Option<Loc>,

    /// Location of the closing parenthesis
    ///
    /// ```text
    /// (a, b) = 1, 2
    ///      ~
    /// ```
    ///
    /// `None` if there are no parentheses
    pub end_l: Option<Loc>,

    /// Location of the full expression
    ///
    /// ```text
    /// (a, b) = 1, 2
    /// ~~~~~~
    /// ```
    pub expression_l: Loc,
}

impl Mlhs {
    #[doc(hidden)]
    pub fn get_items(&self) -> &Vec<Node> {
        &self.items
    }

    #[doc(hidden)]
    pub fn get_items_mut(&mut self) -> &mut Vec<Node> {
        &mut self.items
    }

    #[doc(hidden)]
    pub fn get_begin_l(&self) -> &Option<Loc> {
        &self.begin_l
    }

    #[doc(hidden)]
    pub fn get_begin_l_mut(&mut self) -> &mut Option<Loc> {
        &mut self.begin_l
    }

    #[doc(hidden)]
    pub fn get_end_l(&self) -> &Option<Loc> {
        &self.end_l
    }

    #[doc(hidden)]
    pub fn get_end_l_mut(&mut self) -> &mut Option<Loc> {
        &mut self.end_l
    }

    #[doc(hidden)]
    pub fn get_expression_l(&self) -> &Loc {
        &self.expression_l
    }

    #[doc(hidden)]
    pub fn get_expression_l_mut(&mut self) -> &mut Loc {
        &mut self.expression_l
    }

    #[doc(hidden)]
    pub fn set_items(&mut self, value: Vec<Node>) {
        self.items = value;
    }

    #[doc(hidden)]
    pub fn set_begin_l(&mut self, value: Option<Loc>) {
        self.begin_l = value;
    }

    #[doc(hidden)]
    pub fn set_end_l(&mut self, value: Option<Loc>) {
        self.end_l = value;
    }

    #[doc(hidden)]
    pub fn set_expression_l(&mut self, value: Loc) {
        self.expression_l = value;
    }

    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> super::InternalMlhs {
        let Self { items, begin_l, end_l, expression_l } = self;
        super::InternalMlhs { items, begin_l, end_l, expression_l }
    }
}

impl InnerNode for Mlhs {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_nodes(&self.items);
        
        
        
        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "mlhs"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        for node in self.items.iter() {
          node.inner_ref().print_with_locs();
        }
        self.begin_l.as_ref().map(|loc| loc.print("begin"));
        self.end_l.as_ref().map(|loc| loc.print("end"));
        self.expression_l.print("expression");
    }
}
