// This file is autogenerated by codegen/rust/nodes/node_file/external.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;
use crate::containers::ExternalMaybe as Maybe;
use crate::containers::ExternalPtr as Ptr;

use super::internal::InternalMatchRest;
use crate::blobs::{HasBlob, Blob};

/// Represents a wildcard pattern used in pattern matching (i.e. `in *foo`)
#[repr(C)]
pub struct MatchRest {
    pub(crate) blob: Blob<MatchRest>
}

impl std::fmt::Debug for MatchRest {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        f.debug_struct("MatchRest")
            .field("name", &self.get_name())
            .field("operator_l", &self.get_operator_l())
            .field("expression_l", &self.get_expression_l())
            .finish()
    }
}

impl PartialEq for MatchRest {
    fn eq(&self, other: &Self) -> bool {
        self.get_name() == other.get_name()
            && self.get_operator_l() == other.get_operator_l()
            && self.get_expression_l() == other.get_expression_l()
    }
}

impl MatchRest {
    /// Returns `name` field
    pub fn get_name(&self) -> &Maybe<Ptr<Node>> {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__match_rest__get_name(&self.blob) as *const Maybe<Ptr<Node>>)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `name` field
    pub fn set_name(&mut self, name: Maybe<Ptr<Node>>) {
        unsafe { lib_ruby_parser__external__nodes__match_rest__set_name(&mut self.blob, name.into_blob()) }
    }

    /// Returns `operator_l` field
    pub fn get_operator_l(&self) -> &Loc {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__match_rest__get_operator_l(&self.blob) as *const Loc)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `operator_l` field
    pub fn set_operator_l(&mut self, operator_l: Loc) {
        unsafe { lib_ruby_parser__external__nodes__match_rest__set_operator_l(&mut self.blob, operator_l.into_blob()) }
    }

    /// Returns `expression_l` field
    pub fn get_expression_l(&self) -> &Loc {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__match_rest__get_expression_l(&self.blob) as *const Loc)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `expression_l` field
    pub fn set_expression_l(&mut self, expression_l: Loc) {
        unsafe { lib_ruby_parser__external__nodes__match_rest__set_expression_l(&mut self.blob, expression_l.into_blob()) }
    }

    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> InternalMatchRest {
        unsafe { lib_ruby_parser__external__nodes__match_rest__into_internal(self.into_blob()) }
    }
}

extern "C" {
    fn lib_ruby_parser__external__nodes__match_rest__get_name(blob: *const Blob<MatchRest>) -> *mut Blob<Maybe<Ptr<Node>>>;
    fn lib_ruby_parser__external__nodes__match_rest__set_name(blob: *mut Blob<MatchRest>, blob: Blob<Maybe<Ptr<Node>>>);
    fn lib_ruby_parser__external__nodes__match_rest__get_operator_l(blob: *const Blob<MatchRest>) -> *mut Blob<Loc>;
    fn lib_ruby_parser__external__nodes__match_rest__set_operator_l(blob: *mut Blob<MatchRest>, blob: Blob<Loc>);
    fn lib_ruby_parser__external__nodes__match_rest__get_expression_l(blob: *const Blob<MatchRest>) -> *mut Blob<Loc>;
    fn lib_ruby_parser__external__nodes__match_rest__set_expression_l(blob: *mut Blob<MatchRest>, blob: Blob<Loc>);
    fn lib_ruby_parser__external__nodes__match_rest__into_internal(blob: Blob<MatchRest>) -> InternalMatchRest;
    fn lib_ruby_parser__external__nodes__match_rest__drop(blob: *mut Blob<MatchRest>);
}

impl InnerNode for MatchRest {
    fn expression(&self) -> &Loc {
        self.get_expression_l()
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_maybe_node(self.get_name());
        
        
        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "match_rest"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        if let Some(node) = self.get_name().as_ref() { node.inner_ref().print_with_locs() }
        self.get_operator_l().print("operator");
        self.get_expression_l().print("expression");
    }
}

impl Drop for MatchRest {
    fn drop(&mut self) {
        unsafe { lib_ruby_parser__external__nodes__match_rest__drop(&mut self.blob) }
    }
}
