// This file is autogenerated by codegen/rust/nodes/node_file/native.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;

/// Represents matching with renaming into specified local variable (i.e. `case 1; in Integer => a; end`)
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct MatchAs {
    /// Pattern that is used for matching
    pub value: Box<Node>,

    /// Variable that is assigned if matched (see `MatchVar` node)
    pub as_: Box<Node>,

    /// Location of the `=>` operator
    ///
    /// ```text
    /// case 1; in Integer => a; end
    ///                    ~~
    /// ```
    pub operator_l: Loc,

    /// Location of the full expression
    ///
    /// ```text
    /// case 1; in Integer => a; end
    ///            ~~~~~~~~~~~~
    /// ```
    pub expression_l: Loc,
}

impl MatchAs {
    #[doc(hidden)]
    pub fn get_value(&self) -> &Box<Node> {
        &self.value
    }

    #[doc(hidden)]
    pub fn get_value_mut(&mut self) -> &mut Box<Node> {
        &mut self.value
    }

    #[doc(hidden)]
    pub fn get_as(&self) -> &Box<Node> {
        &self.as_
    }

    #[doc(hidden)]
    pub fn get_as_mut(&mut self) -> &mut Box<Node> {
        &mut self.as_
    }

    #[doc(hidden)]
    pub fn get_operator_l(&self) -> &Loc {
        &self.operator_l
    }

    #[doc(hidden)]
    pub fn get_operator_l_mut(&mut self) -> &mut Loc {
        &mut self.operator_l
    }

    #[doc(hidden)]
    pub fn get_expression_l(&self) -> &Loc {
        &self.expression_l
    }

    #[doc(hidden)]
    pub fn get_expression_l_mut(&mut self) -> &mut Loc {
        &mut self.expression_l
    }

    #[doc(hidden)]
    pub fn set_value(&mut self, value: Box<Node>) {
        self.value = value;
    }

    #[doc(hidden)]
    pub fn set_as(&mut self, value: Box<Node>) {
        self.as_ = value;
    }

    #[doc(hidden)]
    pub fn set_operator_l(&mut self, value: Loc) {
        self.operator_l = value;
    }

    #[doc(hidden)]
    pub fn set_expression_l(&mut self, value: Loc) {
        self.expression_l = value;
    }

    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> super::InternalMatchAs {
        let Self { value, as_, operator_l, expression_l } = self;
        super::InternalMatchAs { value, as_, operator_l, expression_l }
    }
}

impl InnerNode for MatchAs {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_node(&self.value);
        result.push_node(&self.as_);
        
        
        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "match_as"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        self.value.inner_ref().print_with_locs();
        self.as_.inner_ref().print_with_locs();
        self.operator_l.print("operator");
        self.expression_l.print("expression");
    }
}
