// This file is autogenerated by codegen/rust/nodes/node_file/external.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;
use crate::containers::ExternalPtr as Ptr;

use super::internal::InternalMatchAs;
use crate::blobs::{HasBlob, Blob};

/// Represents matching with renaming into specified local variable (i.e. `case 1; in Integer => a; end`)
#[repr(C)]
pub struct MatchAs {
    pub(crate) blob: Blob<MatchAs>
}

impl std::fmt::Debug for MatchAs {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        f.debug_struct("MatchAs")
            .field("value", &self.get_value())
            .field("as_", &self.get_as())
            .field("operator_l", &self.get_operator_l())
            .field("expression_l", &self.get_expression_l())
            .finish()
    }
}

impl PartialEq for MatchAs {
    fn eq(&self, other: &Self) -> bool {
        self.get_value() == other.get_value()
            && self.get_as() == other.get_as()
            && self.get_operator_l() == other.get_operator_l()
            && self.get_expression_l() == other.get_expression_l()
    }
}

impl MatchAs {
    /// Returns `value` field
    pub fn get_value(&self) -> &Ptr<Node> {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__match_as__get_value(&self.blob) as *const Ptr<Node>)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `value` field
    pub fn set_value(&mut self, value: Ptr<Node>) {
        unsafe { lib_ruby_parser__external__nodes__match_as__set_value(&mut self.blob, value.into_blob()) }
    }

    /// Returns `as_` field
    pub fn get_as(&self) -> &Ptr<Node> {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__match_as__get_as(&self.blob) as *const Ptr<Node>)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `as_` field
    pub fn set_as(&mut self, as_: Ptr<Node>) {
        unsafe { lib_ruby_parser__external__nodes__match_as__set_as(&mut self.blob, as_.into_blob()) }
    }

    /// Returns `operator_l` field
    pub fn get_operator_l(&self) -> &Loc {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__match_as__get_operator_l(&self.blob) as *const Loc)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `operator_l` field
    pub fn set_operator_l(&mut self, operator_l: Loc) {
        unsafe { lib_ruby_parser__external__nodes__match_as__set_operator_l(&mut self.blob, operator_l.into_blob()) }
    }

    /// Returns `expression_l` field
    pub fn get_expression_l(&self) -> &Loc {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__match_as__get_expression_l(&self.blob) as *const Loc)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `expression_l` field
    pub fn set_expression_l(&mut self, expression_l: Loc) {
        unsafe { lib_ruby_parser__external__nodes__match_as__set_expression_l(&mut self.blob, expression_l.into_blob()) }
    }

    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> InternalMatchAs {
        unsafe { lib_ruby_parser__external__nodes__match_as__into_internal(self.into_blob()) }
    }
}

extern "C" {
    fn lib_ruby_parser__external__nodes__match_as__get_value(blob: *const Blob<MatchAs>) -> *mut Blob<Ptr<Node>>;
    fn lib_ruby_parser__external__nodes__match_as__set_value(blob: *mut Blob<MatchAs>, blob: Blob<Ptr<Node>>);
    fn lib_ruby_parser__external__nodes__match_as__get_as(blob: *const Blob<MatchAs>) -> *mut Blob<Ptr<Node>>;
    fn lib_ruby_parser__external__nodes__match_as__set_as(blob: *mut Blob<MatchAs>, blob: Blob<Ptr<Node>>);
    fn lib_ruby_parser__external__nodes__match_as__get_operator_l(blob: *const Blob<MatchAs>) -> *mut Blob<Loc>;
    fn lib_ruby_parser__external__nodes__match_as__set_operator_l(blob: *mut Blob<MatchAs>, blob: Blob<Loc>);
    fn lib_ruby_parser__external__nodes__match_as__get_expression_l(blob: *const Blob<MatchAs>) -> *mut Blob<Loc>;
    fn lib_ruby_parser__external__nodes__match_as__set_expression_l(blob: *mut Blob<MatchAs>, blob: Blob<Loc>);
    fn lib_ruby_parser__external__nodes__match_as__into_internal(blob: Blob<MatchAs>) -> InternalMatchAs;
    fn lib_ruby_parser__external__nodes__match_as__drop(blob: *mut Blob<MatchAs>);
}

impl InnerNode for MatchAs {
    fn expression(&self) -> &Loc {
        self.get_expression_l()
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_node(self.get_value());
        result.push_node(self.get_as());
        
        
        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "match_as"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        self.get_value().inner_ref().print_with_locs();
        self.get_as().inner_ref().print_with_locs();
        self.get_operator_l().print("operator");
        self.get_expression_l().print("expression");
    }
}

impl Drop for MatchAs {
    fn drop(&mut self) {
        unsafe { lib_ruby_parser__external__nodes__match_as__drop(&mut self.blob) }
    }
}
