// This file is autogenerated by codegen/rust/nodes/node_file/native.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;

/// Represents an optional keyword argument (i.e. `foo` in `def m(foo: 42); end`)
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct Kwoptarg {
    /// Name of the optional keyword argument
    pub name: String,

    /// Default value of the optional keyword argument
    pub default: Box<Node>,

    /// Location of the argument name
    ///
    /// ```text
    /// def m(foo: 1); end
    ///       ~~~
    /// ```
    pub name_l: Loc,

    /// Location of the argument name
    ///
    /// ```text
    /// def m(foo: 1); end
    ///       ~~~~~~
    /// ```
    pub expression_l: Loc,
}

impl Kwoptarg {
    #[doc(hidden)]
    pub fn get_name(&self) -> &String {
        &self.name
    }

    #[doc(hidden)]
    pub fn get_name_mut(&mut self) -> &mut String {
        &mut self.name
    }

    #[doc(hidden)]
    pub fn get_default(&self) -> &Box<Node> {
        &self.default
    }

    #[doc(hidden)]
    pub fn get_default_mut(&mut self) -> &mut Box<Node> {
        &mut self.default
    }

    #[doc(hidden)]
    pub fn get_name_l(&self) -> &Loc {
        &self.name_l
    }

    #[doc(hidden)]
    pub fn get_name_l_mut(&mut self) -> &mut Loc {
        &mut self.name_l
    }

    #[doc(hidden)]
    pub fn get_expression_l(&self) -> &Loc {
        &self.expression_l
    }

    #[doc(hidden)]
    pub fn get_expression_l_mut(&mut self) -> &mut Loc {
        &mut self.expression_l
    }

    #[doc(hidden)]
    pub fn set_name(&mut self, value: String) {
        self.name = value;
    }

    #[doc(hidden)]
    pub fn set_default(&mut self, value: Box<Node>) {
        self.default = value;
    }

    #[doc(hidden)]
    pub fn set_name_l(&mut self, value: Loc) {
        self.name_l = value;
    }

    #[doc(hidden)]
    pub fn set_expression_l(&mut self, value: Loc) {
        self.expression_l = value;
    }

    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> super::InternalKwoptarg {
        let Self { name, default, name_l, expression_l } = self;
        super::InternalKwoptarg { name, default, name_l, expression_l }
    }
}

impl InnerNode for Kwoptarg {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_str(&self.name);
        result.push_node(&self.default);
        
        
        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "kwoptarg"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        self.default.inner_ref().print_with_locs();
        self.name_l.print("name");
        self.expression_l.print("expression");
    }
}
