// This file is autogenerated by codegen/rust/nodes/node_file/native.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;

/// Represents an special argument that rejects all keyword arguments (i.e. `def m(**nil); end`)
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct Kwnilarg {
    /// Location of the `nil`
    ///
    /// ```text
    /// def m(**nil); end
    ///         ~~~
    /// ```
    pub name_l: Loc,

    /// Location of the `nil`
    ///
    /// ```text
    /// def m(**nil); end
    ///       ~~~~~
    /// ```
    pub expression_l: Loc,
}

impl Kwnilarg {
    #[doc(hidden)]
    pub fn get_name_l(&self) -> &Loc {
        &self.name_l
    }

    #[doc(hidden)]
    pub fn get_name_l_mut(&mut self) -> &mut Loc {
        &mut self.name_l
    }

    #[doc(hidden)]
    pub fn get_expression_l(&self) -> &Loc {
        &self.expression_l
    }

    #[doc(hidden)]
    pub fn get_expression_l_mut(&mut self) -> &mut Loc {
        &mut self.expression_l
    }

    #[doc(hidden)]
    pub fn set_name_l(&mut self, value: Loc) {
        self.name_l = value;
    }

    #[doc(hidden)]
    pub fn set_expression_l(&mut self, value: Loc) {
        self.expression_l = value;
    }

    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> super::InternalKwnilarg {
        let Self { name_l, expression_l } = self;
        super::InternalKwnilarg { name_l, expression_l }
    }
}

impl InnerNode for Kwnilarg {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        
        
        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "kwnilarg"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        self.name_l.print("name");
        self.expression_l.print("expression");
    }
}
