// This file is autogenerated by codegen/rust/nodes/node_file/native.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;

/// Represents required keyword argument (i.e. `foo` in `def m(foo:); end`)
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct Kwarg {
    /// Name of the keyword argument
    pub name: String,

    /// Location of the name
    ///
    /// ```text
    /// def foo(bar:); end
    ///         ~~~
    /// ```
    pub name_l: Loc,

    /// Location of the full expression
    ///
    /// ```text
    /// def foo(bar:); end
    ///         ~~~~
    /// ```
    pub expression_l: Loc,
}

impl Kwarg {
    #[doc(hidden)]
    pub fn get_name(&self) -> &String {
        &self.name
    }

    #[doc(hidden)]
    pub fn get_name_mut(&mut self) -> &mut String {
        &mut self.name
    }

    #[doc(hidden)]
    pub fn get_name_l(&self) -> &Loc {
        &self.name_l
    }

    #[doc(hidden)]
    pub fn get_name_l_mut(&mut self) -> &mut Loc {
        &mut self.name_l
    }

    #[doc(hidden)]
    pub fn get_expression_l(&self) -> &Loc {
        &self.expression_l
    }

    #[doc(hidden)]
    pub fn get_expression_l_mut(&mut self) -> &mut Loc {
        &mut self.expression_l
    }

    #[doc(hidden)]
    pub fn set_name(&mut self, value: String) {
        self.name = value;
    }

    #[doc(hidden)]
    pub fn set_name_l(&mut self, value: Loc) {
        self.name_l = value;
    }

    #[doc(hidden)]
    pub fn set_expression_l(&mut self, value: Loc) {
        self.expression_l = value;
    }

    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> super::InternalKwarg {
        let Self { name, name_l, expression_l } = self;
        super::InternalKwarg { name, name_l, expression_l }
    }
}

impl InnerNode for Kwarg {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_str(&self.name);
        
        
        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "kwarg"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        self.name_l.print("name");
        self.expression_l.print("expression");
    }
}
