// This file is autogenerated by codegen/rust/nodes/node_file/external.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;
use crate::containers::ExternalMaybe as Maybe;
use crate::containers::ExternalPtr as Ptr;

use super::internal::InternalIrange;
use crate::blobs::{HasBlob, Blob};

/// Represents inclusive range (i.e. `2..4`)
#[repr(C)]
pub struct Irange {
    pub(crate) blob: Blob<Irange>
}

impl std::fmt::Debug for Irange {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        f.debug_struct("Irange")
            .field("left", &self.get_left())
            .field("right", &self.get_right())
            .field("operator_l", &self.get_operator_l())
            .field("expression_l", &self.get_expression_l())
            .finish()
    }
}

impl PartialEq for Irange {
    fn eq(&self, other: &Self) -> bool {
        self.get_left() == other.get_left()
            && self.get_right() == other.get_right()
            && self.get_operator_l() == other.get_operator_l()
            && self.get_expression_l() == other.get_expression_l()
    }
}

impl Irange {
    /// Returns `left` field
    pub fn get_left(&self) -> &Maybe<Ptr<Node>> {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__irange__get_left(&self.blob) as *const Maybe<Ptr<Node>>)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `left` field
    pub fn set_left(&mut self, left: Maybe<Ptr<Node>>) {
        unsafe { lib_ruby_parser__external__nodes__irange__set_left(&mut self.blob, left.into_blob()) }
    }

    /// Returns `right` field
    pub fn get_right(&self) -> &Maybe<Ptr<Node>> {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__irange__get_right(&self.blob) as *const Maybe<Ptr<Node>>)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `right` field
    pub fn set_right(&mut self, right: Maybe<Ptr<Node>>) {
        unsafe { lib_ruby_parser__external__nodes__irange__set_right(&mut self.blob, right.into_blob()) }
    }

    /// Returns `operator_l` field
    pub fn get_operator_l(&self) -> &Loc {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__irange__get_operator_l(&self.blob) as *const Loc)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `operator_l` field
    pub fn set_operator_l(&mut self, operator_l: Loc) {
        unsafe { lib_ruby_parser__external__nodes__irange__set_operator_l(&mut self.blob, operator_l.into_blob()) }
    }

    /// Returns `expression_l` field
    pub fn get_expression_l(&self) -> &Loc {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__irange__get_expression_l(&self.blob) as *const Loc)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `expression_l` field
    pub fn set_expression_l(&mut self, expression_l: Loc) {
        unsafe { lib_ruby_parser__external__nodes__irange__set_expression_l(&mut self.blob, expression_l.into_blob()) }
    }

    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> InternalIrange {
        unsafe { lib_ruby_parser__external__nodes__irange__into_internal(self.into_blob()) }
    }
}

extern "C" {
    fn lib_ruby_parser__external__nodes__irange__get_left(blob: *const Blob<Irange>) -> *mut Blob<Maybe<Ptr<Node>>>;
    fn lib_ruby_parser__external__nodes__irange__set_left(blob: *mut Blob<Irange>, blob: Blob<Maybe<Ptr<Node>>>);
    fn lib_ruby_parser__external__nodes__irange__get_right(blob: *const Blob<Irange>) -> *mut Blob<Maybe<Ptr<Node>>>;
    fn lib_ruby_parser__external__nodes__irange__set_right(blob: *mut Blob<Irange>, blob: Blob<Maybe<Ptr<Node>>>);
    fn lib_ruby_parser__external__nodes__irange__get_operator_l(blob: *const Blob<Irange>) -> *mut Blob<Loc>;
    fn lib_ruby_parser__external__nodes__irange__set_operator_l(blob: *mut Blob<Irange>, blob: Blob<Loc>);
    fn lib_ruby_parser__external__nodes__irange__get_expression_l(blob: *const Blob<Irange>) -> *mut Blob<Loc>;
    fn lib_ruby_parser__external__nodes__irange__set_expression_l(blob: *mut Blob<Irange>, blob: Blob<Loc>);
    fn lib_ruby_parser__external__nodes__irange__into_internal(blob: Blob<Irange>) -> InternalIrange;
    fn lib_ruby_parser__external__nodes__irange__drop(blob: *mut Blob<Irange>);
}

impl InnerNode for Irange {
    fn expression(&self) -> &Loc {
        self.get_expression_l()
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_maybe_node_or_nil(self.get_left());
        result.push_maybe_node_or_nil(self.get_right());
        
        
        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "irange"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        if let Some(node) = self.get_left().as_ref() { node.inner_ref().print_with_locs() }
        if let Some(node) = self.get_right().as_ref() { node.inner_ref().print_with_locs() }
        self.get_operator_l().print("operator");
        self.get_expression_l().print("expression");
    }
}

impl Drop for Irange {
    fn drop(&mut self) {
        unsafe { lib_ruby_parser__external__nodes__irange__drop(&mut self.blob) }
    }
}
