// This file is autogenerated by codegen/rust/nodes/node_file/native.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;

/// Represents indexing operation (i.e. `foo[1,2,3]`)
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct Index {
    /// Receiver of indexing
    pub recv: Box<Node>,

    /// A list of indexes
    pub indexes: Vec<Node>,

    /// Location of open bracket
    ///
    /// ```text
    /// foo[1, 2, 3]
    ///    ~
    /// ```
    pub begin_l: Loc,

    /// Location of closing bracket
    ///
    /// ```text
    /// foo[1, 2, 3]
    ///            ~
    /// ```
    pub end_l: Loc,

    /// Location of the full expression
    ///
    /// ```text
    /// foo[1, 2, 3]
    /// ~~~~~~~~~~~~
    /// ```
    pub expression_l: Loc,
}

impl Index {
    #[doc(hidden)]
    pub fn get_recv(&self) -> &Box<Node> {
        &self.recv
    }

    #[doc(hidden)]
    pub fn get_recv_mut(&mut self) -> &mut Box<Node> {
        &mut self.recv
    }

    #[doc(hidden)]
    pub fn get_indexes(&self) -> &Vec<Node> {
        &self.indexes
    }

    #[doc(hidden)]
    pub fn get_indexes_mut(&mut self) -> &mut Vec<Node> {
        &mut self.indexes
    }

    #[doc(hidden)]
    pub fn get_begin_l(&self) -> &Loc {
        &self.begin_l
    }

    #[doc(hidden)]
    pub fn get_begin_l_mut(&mut self) -> &mut Loc {
        &mut self.begin_l
    }

    #[doc(hidden)]
    pub fn get_end_l(&self) -> &Loc {
        &self.end_l
    }

    #[doc(hidden)]
    pub fn get_end_l_mut(&mut self) -> &mut Loc {
        &mut self.end_l
    }

    #[doc(hidden)]
    pub fn get_expression_l(&self) -> &Loc {
        &self.expression_l
    }

    #[doc(hidden)]
    pub fn get_expression_l_mut(&mut self) -> &mut Loc {
        &mut self.expression_l
    }

    #[doc(hidden)]
    pub fn set_recv(&mut self, value: Box<Node>) {
        self.recv = value;
    }

    #[doc(hidden)]
    pub fn set_indexes(&mut self, value: Vec<Node>) {
        self.indexes = value;
    }

    #[doc(hidden)]
    pub fn set_begin_l(&mut self, value: Loc) {
        self.begin_l = value;
    }

    #[doc(hidden)]
    pub fn set_end_l(&mut self, value: Loc) {
        self.end_l = value;
    }

    #[doc(hidden)]
    pub fn set_expression_l(&mut self, value: Loc) {
        self.expression_l = value;
    }

    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> super::InternalIndex {
        let Self { recv, indexes, begin_l, end_l, expression_l } = self;
        super::InternalIndex { recv, indexes, begin_l, end_l, expression_l }
    }
}

impl InnerNode for Index {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_node(&self.recv);
        result.push_nodes(&self.indexes);
        
        
        
        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "index"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        self.recv.inner_ref().print_with_locs();
        for node in self.indexes.iter() {
          node.inner_ref().print_with_locs();
        }
        self.begin_l.print("begin");
        self.end_l.print("end");
        self.expression_l.print("expression");
    }
}
