// This file is autogenerated by codegen/rust/nodes/node_file/external.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;
use crate::containers::ExternalPtr as Ptr;
use crate::containers::ExternalList as List;

use super::internal::InternalIndex;
use crate::blobs::{HasBlob, Blob};

/// Represents indexing operation (i.e. `foo[1,2,3]`)
#[repr(C)]
pub struct Index {
    pub(crate) blob: Blob<Index>
}

impl std::fmt::Debug for Index {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        f.debug_struct("Index")
            .field("recv", &self.get_recv())
            .field("indexes", &self.get_indexes())
            .field("begin_l", &self.get_begin_l())
            .field("end_l", &self.get_end_l())
            .field("expression_l", &self.get_expression_l())
            .finish()
    }
}

impl PartialEq for Index {
    fn eq(&self, other: &Self) -> bool {
        self.get_recv() == other.get_recv()
            && self.get_indexes() == other.get_indexes()
            && self.get_begin_l() == other.get_begin_l()
            && self.get_end_l() == other.get_end_l()
            && self.get_expression_l() == other.get_expression_l()
    }
}

impl Index {
    /// Returns `recv` field
    pub fn get_recv(&self) -> &Ptr<Node> {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__index__get_recv(&self.blob) as *const Ptr<Node>)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `recv` field
    pub fn set_recv(&mut self, recv: Ptr<Node>) {
        unsafe { lib_ruby_parser__external__nodes__index__set_recv(&mut self.blob, recv.into_blob()) }
    }

    /// Returns `indexes` field
    pub fn get_indexes(&self) -> &List<Node> {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__index__get_indexes(&self.blob) as *const List<Node>)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `indexes` field
    pub fn set_indexes(&mut self, indexes: List<Node>) {
        unsafe { lib_ruby_parser__external__nodes__index__set_indexes(&mut self.blob, indexes.into_blob()) }
    }

    /// Returns `begin_l` field
    pub fn get_begin_l(&self) -> &Loc {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__index__get_begin_l(&self.blob) as *const Loc)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `begin_l` field
    pub fn set_begin_l(&mut self, begin_l: Loc) {
        unsafe { lib_ruby_parser__external__nodes__index__set_begin_l(&mut self.blob, begin_l.into_blob()) }
    }

    /// Returns `end_l` field
    pub fn get_end_l(&self) -> &Loc {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__index__get_end_l(&self.blob) as *const Loc)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `end_l` field
    pub fn set_end_l(&mut self, end_l: Loc) {
        unsafe { lib_ruby_parser__external__nodes__index__set_end_l(&mut self.blob, end_l.into_blob()) }
    }

    /// Returns `expression_l` field
    pub fn get_expression_l(&self) -> &Loc {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__index__get_expression_l(&self.blob) as *const Loc)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `expression_l` field
    pub fn set_expression_l(&mut self, expression_l: Loc) {
        unsafe { lib_ruby_parser__external__nodes__index__set_expression_l(&mut self.blob, expression_l.into_blob()) }
    }

    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> InternalIndex {
        unsafe { lib_ruby_parser__external__nodes__index__into_internal(self.into_blob()) }
    }
}

extern "C" {
    fn lib_ruby_parser__external__nodes__index__get_recv(blob: *const Blob<Index>) -> *mut Blob<Ptr<Node>>;
    fn lib_ruby_parser__external__nodes__index__set_recv(blob: *mut Blob<Index>, blob: Blob<Ptr<Node>>);
    fn lib_ruby_parser__external__nodes__index__get_indexes(blob: *const Blob<Index>) -> *mut Blob<List<Node>>;
    fn lib_ruby_parser__external__nodes__index__set_indexes(blob: *mut Blob<Index>, blob: Blob<List<Node>>);
    fn lib_ruby_parser__external__nodes__index__get_begin_l(blob: *const Blob<Index>) -> *mut Blob<Loc>;
    fn lib_ruby_parser__external__nodes__index__set_begin_l(blob: *mut Blob<Index>, blob: Blob<Loc>);
    fn lib_ruby_parser__external__nodes__index__get_end_l(blob: *const Blob<Index>) -> *mut Blob<Loc>;
    fn lib_ruby_parser__external__nodes__index__set_end_l(blob: *mut Blob<Index>, blob: Blob<Loc>);
    fn lib_ruby_parser__external__nodes__index__get_expression_l(blob: *const Blob<Index>) -> *mut Blob<Loc>;
    fn lib_ruby_parser__external__nodes__index__set_expression_l(blob: *mut Blob<Index>, blob: Blob<Loc>);
    fn lib_ruby_parser__external__nodes__index__into_internal(blob: Blob<Index>) -> InternalIndex;
    fn lib_ruby_parser__external__nodes__index__drop(blob: *mut Blob<Index>);
}

impl InnerNode for Index {
    fn expression(&self) -> &Loc {
        self.get_expression_l()
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_node(self.get_recv());
        result.push_nodes(self.get_indexes());
        
        
        
        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "index"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        self.get_recv().inner_ref().print_with_locs();
        for node in self.get_indexes().iter() {
          node.inner_ref().print_with_locs();
        }
        self.get_begin_l().print("begin");
        self.get_end_l().print("end");
        self.get_expression_l().print("expression");
    }
}

impl Drop for Index {
    fn drop(&mut self) {
        unsafe { lib_ruby_parser__external__nodes__index__drop(&mut self.blob) }
    }
}
