// This file is autogenerated by codegen/rust/nodes/node_file/native.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;

/// Represents ternary `if` statement (i.e. `cond ? if_true : if_false`)
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct IfTernary {
    /// Condition of the `if` statement
    pub cond: Box<Node>,

    /// True-branch
    pub if_true: Box<Node>,

    /// True-branch
    pub if_false: Box<Node>,

    /// Location of the `?` operator
    ///
    /// ```text
    /// cond ? if_true : if_false
    ///      ~
    /// ```
    pub question_l: Loc,

    /// Location of the `:` operator
    ///
    /// ```text
    /// cond ? if_true : if_false
    ///                ~
    /// ```
    pub colon_l: Loc,

    /// Location of the full expression
    ///
    /// ```text
    /// cond ? if_true : if_false
    /// ~~~~~~~~~~~~~~~~~~~~~~~~~
    /// ```
    pub expression_l: Loc,
}

impl IfTernary {
    #[doc(hidden)]
    pub fn get_cond(&self) -> &Box<Node> {
        &self.cond
    }

    #[doc(hidden)]
    pub fn get_cond_mut(&mut self) -> &mut Box<Node> {
        &mut self.cond
    }

    #[doc(hidden)]
    pub fn get_if_true(&self) -> &Box<Node> {
        &self.if_true
    }

    #[doc(hidden)]
    pub fn get_if_true_mut(&mut self) -> &mut Box<Node> {
        &mut self.if_true
    }

    #[doc(hidden)]
    pub fn get_if_false(&self) -> &Box<Node> {
        &self.if_false
    }

    #[doc(hidden)]
    pub fn get_if_false_mut(&mut self) -> &mut Box<Node> {
        &mut self.if_false
    }

    #[doc(hidden)]
    pub fn get_question_l(&self) -> &Loc {
        &self.question_l
    }

    #[doc(hidden)]
    pub fn get_question_l_mut(&mut self) -> &mut Loc {
        &mut self.question_l
    }

    #[doc(hidden)]
    pub fn get_colon_l(&self) -> &Loc {
        &self.colon_l
    }

    #[doc(hidden)]
    pub fn get_colon_l_mut(&mut self) -> &mut Loc {
        &mut self.colon_l
    }

    #[doc(hidden)]
    pub fn get_expression_l(&self) -> &Loc {
        &self.expression_l
    }

    #[doc(hidden)]
    pub fn get_expression_l_mut(&mut self) -> &mut Loc {
        &mut self.expression_l
    }

    #[doc(hidden)]
    pub fn set_cond(&mut self, value: Box<Node>) {
        self.cond = value;
    }

    #[doc(hidden)]
    pub fn set_if_true(&mut self, value: Box<Node>) {
        self.if_true = value;
    }

    #[doc(hidden)]
    pub fn set_if_false(&mut self, value: Box<Node>) {
        self.if_false = value;
    }

    #[doc(hidden)]
    pub fn set_question_l(&mut self, value: Loc) {
        self.question_l = value;
    }

    #[doc(hidden)]
    pub fn set_colon_l(&mut self, value: Loc) {
        self.colon_l = value;
    }

    #[doc(hidden)]
    pub fn set_expression_l(&mut self, value: Loc) {
        self.expression_l = value;
    }

    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> super::InternalIfTernary {
        let Self { cond, if_true, if_false, question_l, colon_l, expression_l } = self;
        super::InternalIfTernary { cond, if_true, if_false, question_l, colon_l, expression_l }
    }
}

impl InnerNode for IfTernary {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_node(&self.cond);
        result.push_node(&self.if_true);
        result.push_node(&self.if_false);
        
        
        
        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "if"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        self.cond.inner_ref().print_with_locs();
        self.if_true.inner_ref().print_with_locs();
        self.if_false.inner_ref().print_with_locs();
        self.question_l.print("question");
        self.colon_l.print("colon");
        self.expression_l.print("expression");
    }
}
