// This file is autogenerated by codegen/rust/nodes/node_file/native.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;

/// Represents a hash pattern used in pattern matching (i.e. `in { a: 1 }`)
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct HashPattern {
    /// A list of inner patterns
    pub elements: Vec<Node>,

    /// Location of the open parenthesis
    ///
    /// ```text
    /// case foo; in { a: 1 }; end
    ///              ~
    /// ```
    ///
    /// `None` if there are no parentheses
    pub begin_l: Option<Loc>,

    /// Location of the open parenthesis
    ///
    /// ```text
    /// case foo; in { a: 1 }; end
    ///                     ~
    /// ```
    ///
    /// `None` if there are no parentheses
    pub end_l: Option<Loc>,

    /// Location of the full expression
    ///
    /// ```text
    /// case foo; in { a: 1 }; end
    ///              ~~~~~~~~
    /// ```
    pub expression_l: Loc,
}

impl HashPattern {
    #[doc(hidden)]
    pub fn get_elements(&self) -> &Vec<Node> {
        &self.elements
    }

    #[doc(hidden)]
    pub fn get_elements_mut(&mut self) -> &mut Vec<Node> {
        &mut self.elements
    }

    #[doc(hidden)]
    pub fn get_begin_l(&self) -> &Option<Loc> {
        &self.begin_l
    }

    #[doc(hidden)]
    pub fn get_begin_l_mut(&mut self) -> &mut Option<Loc> {
        &mut self.begin_l
    }

    #[doc(hidden)]
    pub fn get_end_l(&self) -> &Option<Loc> {
        &self.end_l
    }

    #[doc(hidden)]
    pub fn get_end_l_mut(&mut self) -> &mut Option<Loc> {
        &mut self.end_l
    }

    #[doc(hidden)]
    pub fn get_expression_l(&self) -> &Loc {
        &self.expression_l
    }

    #[doc(hidden)]
    pub fn get_expression_l_mut(&mut self) -> &mut Loc {
        &mut self.expression_l
    }

    #[doc(hidden)]
    pub fn set_elements(&mut self, value: Vec<Node>) {
        self.elements = value;
    }

    #[doc(hidden)]
    pub fn set_begin_l(&mut self, value: Option<Loc>) {
        self.begin_l = value;
    }

    #[doc(hidden)]
    pub fn set_end_l(&mut self, value: Option<Loc>) {
        self.end_l = value;
    }

    #[doc(hidden)]
    pub fn set_expression_l(&mut self, value: Loc) {
        self.expression_l = value;
    }

    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> super::InternalHashPattern {
        let Self { elements, begin_l, end_l, expression_l } = self;
        super::InternalHashPattern { elements, begin_l, end_l, expression_l }
    }
}

impl InnerNode for HashPattern {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_nodes(&self.elements);
        
        
        
        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "hash_pattern"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        for node in self.elements.iter() {
          node.inner_ref().print_with_locs();
        }
        self.begin_l.as_ref().map(|loc| loc.print("begin"));
        self.end_l.as_ref().map(|loc| loc.print("end"));
        self.expression_l.print("expression");
    }
}
