// This file is autogenerated by codegen/rust/nodes/node_file/native.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;

/// Represents a hash literal (i.e. `{ foo: 42 }`)
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct Hash {
    /// A list of key-value pairs
    pub pairs: Vec<Node>,

    /// Location of the open parenthesis
    ///
    /// ```text
    /// { a: 1 }
    /// ~
    /// ```
    ///
    /// `None` if hash literal is implicit, e.g. `foo(key: "value")`
    pub begin_l: Option<Loc>,

    /// Location of the closing parenthesis
    ///
    /// ```text
    /// { a: 1 }
    ///        ~
    /// ```
    ///
    /// `None` if hash literal is implicit, e.g. `foo(key: "value")`
    pub end_l: Option<Loc>,

    /// Location of the full expression
    ///
    /// ```text
    /// { a: 1 }
    /// ~~~~~~~~
    /// ```
    pub expression_l: Loc,
}

impl Hash {
    #[doc(hidden)]
    pub fn get_pairs(&self) -> &Vec<Node> {
        &self.pairs
    }

    #[doc(hidden)]
    pub fn get_pairs_mut(&mut self) -> &mut Vec<Node> {
        &mut self.pairs
    }

    #[doc(hidden)]
    pub fn get_begin_l(&self) -> &Option<Loc> {
        &self.begin_l
    }

    #[doc(hidden)]
    pub fn get_begin_l_mut(&mut self) -> &mut Option<Loc> {
        &mut self.begin_l
    }

    #[doc(hidden)]
    pub fn get_end_l(&self) -> &Option<Loc> {
        &self.end_l
    }

    #[doc(hidden)]
    pub fn get_end_l_mut(&mut self) -> &mut Option<Loc> {
        &mut self.end_l
    }

    #[doc(hidden)]
    pub fn get_expression_l(&self) -> &Loc {
        &self.expression_l
    }

    #[doc(hidden)]
    pub fn get_expression_l_mut(&mut self) -> &mut Loc {
        &mut self.expression_l
    }

    #[doc(hidden)]
    pub fn set_pairs(&mut self, value: Vec<Node>) {
        self.pairs = value;
    }

    #[doc(hidden)]
    pub fn set_begin_l(&mut self, value: Option<Loc>) {
        self.begin_l = value;
    }

    #[doc(hidden)]
    pub fn set_end_l(&mut self, value: Option<Loc>) {
        self.end_l = value;
    }

    #[doc(hidden)]
    pub fn set_expression_l(&mut self, value: Loc) {
        self.expression_l = value;
    }

    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> super::InternalHash {
        let Self { pairs, begin_l, end_l, expression_l } = self;
        super::InternalHash { pairs, begin_l, end_l, expression_l }
    }
}

impl InnerNode for Hash {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_nodes(&self.pairs);
        
        
        
        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "hash"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        for node in self.pairs.iter() {
          node.inner_ref().print_with_locs();
        }
        self.begin_l.as_ref().map(|loc| loc.print("begin"));
        self.end_l.as_ref().map(|loc| loc.print("end"));
        self.expression_l.print("expression");
    }
}
