// This file is autogenerated by codegen/rust/nodes/node_file/native.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;

/// Represents global variable assignment (i.e. `$foo = 42`)
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct Gvasgn {
    /// Name of the global variable, `String("$foo")` for `$foo`
    pub name: String,

    /// Value that is assigned to global variable, `Int("42")` for `$foo = 42`
    ///
    /// `None` if global variable assignment is a part of the multi-assignment.
    /// In such case `value` is a part of the `Masgn` node.
    pub value: Option<Box<Node>>,

    /// Location of the global variable name
    ///
    /// ```text
    /// $foo = 42
    /// ~~~~
    /// ```
    pub name_l: Loc,

    /// Location of the `=` operator
    ///
    /// ```text
    /// $foo = 42
    ///      ~
    /// ```
    ///
    /// `None` if global variable assignment is a part of the multi-assignment.
    /// In such case `=` operator belongs to the `Masgn` node.
    pub operator_l: Option<Loc>,

    /// Location of the full expression
    ///
    /// ```text
    /// $foo = 42
    /// ~~~~~~~~~
    /// ```
    pub expression_l: Loc,
}

impl Gvasgn {
    #[doc(hidden)]
    pub fn get_name(&self) -> &String {
        &self.name
    }

    #[doc(hidden)]
    pub fn get_name_mut(&mut self) -> &mut String {
        &mut self.name
    }

    #[doc(hidden)]
    pub fn get_value(&self) -> &Option<Box<Node>> {
        &self.value
    }

    #[doc(hidden)]
    pub fn get_value_mut(&mut self) -> &mut Option<Box<Node>> {
        &mut self.value
    }

    #[doc(hidden)]
    pub fn get_name_l(&self) -> &Loc {
        &self.name_l
    }

    #[doc(hidden)]
    pub fn get_name_l_mut(&mut self) -> &mut Loc {
        &mut self.name_l
    }

    #[doc(hidden)]
    pub fn get_operator_l(&self) -> &Option<Loc> {
        &self.operator_l
    }

    #[doc(hidden)]
    pub fn get_operator_l_mut(&mut self) -> &mut Option<Loc> {
        &mut self.operator_l
    }

    #[doc(hidden)]
    pub fn get_expression_l(&self) -> &Loc {
        &self.expression_l
    }

    #[doc(hidden)]
    pub fn get_expression_l_mut(&mut self) -> &mut Loc {
        &mut self.expression_l
    }

    #[doc(hidden)]
    pub fn set_name(&mut self, value: String) {
        self.name = value;
    }

    #[doc(hidden)]
    pub fn set_value(&mut self, value: Option<Box<Node>>) {
        self.value = value;
    }

    #[doc(hidden)]
    pub fn set_name_l(&mut self, value: Loc) {
        self.name_l = value;
    }

    #[doc(hidden)]
    pub fn set_operator_l(&mut self, value: Option<Loc>) {
        self.operator_l = value;
    }

    #[doc(hidden)]
    pub fn set_expression_l(&mut self, value: Loc) {
        self.expression_l = value;
    }

    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> super::InternalGvasgn {
        let Self { name, value, name_l, operator_l, expression_l } = self;
        super::InternalGvasgn { name, value, name_l, operator_l, expression_l }
    }
}

impl InnerNode for Gvasgn {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_str(&self.name);
        result.push_maybe_node(&self.value);
        
        
        
        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "gvasgn"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        self.value.as_ref().map(|node| node.inner_ref().print_with_locs());
        self.name_l.print("name");
        self.operator_l.as_ref().map(|loc| loc.print("operator"));
        self.expression_l.print("expression");
    }
}
