// This file is autogenerated by codegen/rust/nodes/node_file/native.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;

/// Represents a `for` loop
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct For {
    /// Variable that is used in loop, `Lvasgn("a")` in `for a in b; end`
    pub iterator: Box<Node>,

    /// Collection that is for iteration. `Lvar("b")` in `for a in b; end`
    pub iteratee: Box<Node>,

    /// Body of the loop. `None` if there's no body
    pub body: Option<Box<Node>>,

    /// Location of the `for` keyword
    ///
    /// ```text
    /// for a in b; end
    /// ~~~
    /// ```
    pub keyword_l: Loc,

    /// Location of the `in` keyword
    ///
    /// ```text
    /// for a in b; end
    ///       ~~
    /// ```
    pub operator_l: Loc,

    /// Location of the `do` keyword
    ///
    /// ```text
    /// for a in b do; end
    ///            ~~
    /// ```
    ///
    /// **Note**: this `do` is optional, and so `begin_l` can be `None`.
    pub begin_l: Loc,

    /// Location of the `end` keyword
    ///
    /// ```text
    /// for a in b; end
    ///             ~~~
    /// ```
    pub end_l: Loc,

    /// Location of the full expression
    ///
    /// ```text
    /// for a in b; end
    /// ~~~~~~~~~~~~~~~
    /// ```
    pub expression_l: Loc,
}

impl For {
    #[doc(hidden)]
    pub fn get_iterator(&self) -> &Box<Node> {
        &self.iterator
    }

    #[doc(hidden)]
    pub fn get_iterator_mut(&mut self) -> &mut Box<Node> {
        &mut self.iterator
    }

    #[doc(hidden)]
    pub fn get_iteratee(&self) -> &Box<Node> {
        &self.iteratee
    }

    #[doc(hidden)]
    pub fn get_iteratee_mut(&mut self) -> &mut Box<Node> {
        &mut self.iteratee
    }

    #[doc(hidden)]
    pub fn get_body(&self) -> &Option<Box<Node>> {
        &self.body
    }

    #[doc(hidden)]
    pub fn get_body_mut(&mut self) -> &mut Option<Box<Node>> {
        &mut self.body
    }

    #[doc(hidden)]
    pub fn get_keyword_l(&self) -> &Loc {
        &self.keyword_l
    }

    #[doc(hidden)]
    pub fn get_keyword_l_mut(&mut self) -> &mut Loc {
        &mut self.keyword_l
    }

    #[doc(hidden)]
    pub fn get_operator_l(&self) -> &Loc {
        &self.operator_l
    }

    #[doc(hidden)]
    pub fn get_operator_l_mut(&mut self) -> &mut Loc {
        &mut self.operator_l
    }

    #[doc(hidden)]
    pub fn get_begin_l(&self) -> &Loc {
        &self.begin_l
    }

    #[doc(hidden)]
    pub fn get_begin_l_mut(&mut self) -> &mut Loc {
        &mut self.begin_l
    }

    #[doc(hidden)]
    pub fn get_end_l(&self) -> &Loc {
        &self.end_l
    }

    #[doc(hidden)]
    pub fn get_end_l_mut(&mut self) -> &mut Loc {
        &mut self.end_l
    }

    #[doc(hidden)]
    pub fn get_expression_l(&self) -> &Loc {
        &self.expression_l
    }

    #[doc(hidden)]
    pub fn get_expression_l_mut(&mut self) -> &mut Loc {
        &mut self.expression_l
    }

    #[doc(hidden)]
    pub fn set_iterator(&mut self, value: Box<Node>) {
        self.iterator = value;
    }

    #[doc(hidden)]
    pub fn set_iteratee(&mut self, value: Box<Node>) {
        self.iteratee = value;
    }

    #[doc(hidden)]
    pub fn set_body(&mut self, value: Option<Box<Node>>) {
        self.body = value;
    }

    #[doc(hidden)]
    pub fn set_keyword_l(&mut self, value: Loc) {
        self.keyword_l = value;
    }

    #[doc(hidden)]
    pub fn set_operator_l(&mut self, value: Loc) {
        self.operator_l = value;
    }

    #[doc(hidden)]
    pub fn set_begin_l(&mut self, value: Loc) {
        self.begin_l = value;
    }

    #[doc(hidden)]
    pub fn set_end_l(&mut self, value: Loc) {
        self.end_l = value;
    }

    #[doc(hidden)]
    pub fn set_expression_l(&mut self, value: Loc) {
        self.expression_l = value;
    }

    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> super::InternalFor {
        let Self { iterator, iteratee, body, keyword_l, operator_l, begin_l, end_l, expression_l } = self;
        super::InternalFor { iterator, iteratee, body, keyword_l, operator_l, begin_l, end_l, expression_l }
    }
}

impl InnerNode for For {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_node(&self.iterator);
        result.push_node(&self.iteratee);
        result.push_maybe_node_or_nil(&self.body);
        
        
        
        
        
        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "for"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        self.iterator.inner_ref().print_with_locs();
        self.iteratee.inner_ref().print_with_locs();
        self.body.as_ref().map(|node| node.inner_ref().print_with_locs());
        self.keyword_l.print("keyword");
        self.operator_l.print("operator");
        self.begin_l.print("begin");
        self.end_l.print("end");
        self.expression_l.print("expression");
    }
}
