// This file is autogenerated by codegen/rust/nodes/node_file/external.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::containers::ExternalMaybe as Maybe;
use crate::containers::ExternalStringPtr as StringPtr;

use super::internal::InternalFloat;
use crate::blobs::{HasBlob, Blob};

/// Represents a float literal (i.e. `42.5`)
#[repr(C)]
pub struct Float {
    pub(crate) blob: Blob<Float>
}

impl std::fmt::Debug for Float {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        f.debug_struct("Float")
            .field("value", &self.get_value())
            .field("operator_l", &self.get_operator_l())
            .field("expression_l", &self.get_expression_l())
            .finish()
    }
}

impl PartialEq for Float {
    fn eq(&self, other: &Self) -> bool {
        self.get_value() == other.get_value()
            && self.get_operator_l() == other.get_operator_l()
            && self.get_expression_l() == other.get_expression_l()
    }
}

impl Float {
    /// Returns `value` field
    pub fn get_value(&self) -> &StringPtr {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__float__get_value(&self.blob) as *const StringPtr)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `value` field
    pub fn set_value(&mut self, value: StringPtr) {
        unsafe { lib_ruby_parser__external__nodes__float__set_value(&mut self.blob, value.into_blob()) }
    }

    /// Returns `operator_l` field
    pub fn get_operator_l(&self) -> &Maybe<Loc> {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__float__get_operator_l(&self.blob) as *const Maybe<Loc>)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `operator_l` field
    pub fn set_operator_l(&mut self, operator_l: Maybe<Loc>) {
        unsafe { lib_ruby_parser__external__nodes__float__set_operator_l(&mut self.blob, operator_l.into_blob()) }
    }

    /// Returns `expression_l` field
    pub fn get_expression_l(&self) -> &Loc {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__float__get_expression_l(&self.blob) as *const Loc)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `expression_l` field
    pub fn set_expression_l(&mut self, expression_l: Loc) {
        unsafe { lib_ruby_parser__external__nodes__float__set_expression_l(&mut self.blob, expression_l.into_blob()) }
    }

    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> InternalFloat {
        unsafe { lib_ruby_parser__external__nodes__float__into_internal(self.into_blob()) }
    }
}

extern "C" {
    fn lib_ruby_parser__external__nodes__float__get_value(blob: *const Blob<Float>) -> *mut Blob<StringPtr>;
    fn lib_ruby_parser__external__nodes__float__set_value(blob: *mut Blob<Float>, blob: Blob<StringPtr>);
    fn lib_ruby_parser__external__nodes__float__get_operator_l(blob: *const Blob<Float>) -> *mut Blob<Maybe<Loc>>;
    fn lib_ruby_parser__external__nodes__float__set_operator_l(blob: *mut Blob<Float>, blob: Blob<Maybe<Loc>>);
    fn lib_ruby_parser__external__nodes__float__get_expression_l(blob: *const Blob<Float>) -> *mut Blob<Loc>;
    fn lib_ruby_parser__external__nodes__float__set_expression_l(blob: *mut Blob<Float>, blob: Blob<Loc>);
    fn lib_ruby_parser__external__nodes__float__into_internal(blob: Blob<Float>) -> InternalFloat;
    fn lib_ruby_parser__external__nodes__float__drop(blob: *mut Blob<Float>);
}

impl InnerNode for Float {
    fn expression(&self) -> &Loc {
        self.get_expression_l()
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_str(self.get_value());
        
        
        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "float"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        if let Some(loc) = self.get_operator_l().as_ref() { loc.print("operator") }
        self.get_expression_l().print("expression");
    }
}

impl Drop for Float {
    fn drop(&mut self) {
        unsafe { lib_ruby_parser__external__nodes__float__drop(&mut self.blob) }
    }
}
