// This file is autogenerated by codegen/rust/nodes/node_file/external.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;

use super::internal::InternalFile;
use crate::blobs::{HasBlob, Blob};

/// Represents a special `__FILE__` literal
#[repr(C)]
pub struct File {
    pub(crate) blob: Blob<File>
}

impl std::fmt::Debug for File {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        f.debug_struct("File")
            .field("expression_l", &self.get_expression_l())
            .finish()
    }
}

impl PartialEq for File {
    fn eq(&self, other: &Self) -> bool {
        self.get_expression_l() == other.get_expression_l()
    }
}

impl File {
    /// Returns `expression_l` field
    pub fn get_expression_l(&self) -> &Loc {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__file__get_expression_l(&self.blob) as *const Loc)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `expression_l` field
    pub fn set_expression_l(&mut self, expression_l: Loc) {
        unsafe { lib_ruby_parser__external__nodes__file__set_expression_l(&mut self.blob, expression_l.into_blob()) }
    }

    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> InternalFile {
        unsafe { lib_ruby_parser__external__nodes__file__into_internal(self.into_blob()) }
    }
}

extern "C" {
    fn lib_ruby_parser__external__nodes__file__get_expression_l(blob: *const Blob<File>) -> *mut Blob<Loc>;
    fn lib_ruby_parser__external__nodes__file__set_expression_l(blob: *mut Blob<File>, blob: Blob<Loc>);
    fn lib_ruby_parser__external__nodes__file__into_internal(blob: Blob<File>) -> InternalFile;
    fn lib_ruby_parser__external__nodes__file__drop(blob: *mut Blob<File>);
}

impl InnerNode for File {
    fn expression(&self) -> &Loc {
        self.get_expression_l()
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        
        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "__FILE__"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        self.get_expression_l().print("expression");
    }
}

impl Drop for File {
    fn drop(&mut self) {
        unsafe { lib_ruby_parser__external__nodes__file__drop(&mut self.blob) }
    }
}
