// This file is autogenerated by codegen/rust/nodes/node_file/external.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;

use super::internal::InternalFalse;
use crate::blobs::{HasBlob, Blob};

/// Represents a `false` literal
#[repr(C)]
pub struct False {
    pub(crate) blob: Blob<False>
}

impl std::fmt::Debug for False {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        f.debug_struct("False")
            .field("expression_l", &self.get_expression_l())
            .finish()
    }
}

impl PartialEq for False {
    fn eq(&self, other: &Self) -> bool {
        self.get_expression_l() == other.get_expression_l()
    }
}

impl False {
    /// Returns `expression_l` field
    pub fn get_expression_l(&self) -> &Loc {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__false__get_expression_l(&self.blob) as *const Loc)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `expression_l` field
    pub fn set_expression_l(&mut self, expression_l: Loc) {
        unsafe { lib_ruby_parser__external__nodes__false__set_expression_l(&mut self.blob, expression_l.into_blob()) }
    }

    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> InternalFalse {
        unsafe { lib_ruby_parser__external__nodes__false__into_internal(self.into_blob()) }
    }
}

extern "C" {
    fn lib_ruby_parser__external__nodes__false__get_expression_l(blob: *const Blob<False>) -> *mut Blob<Loc>;
    fn lib_ruby_parser__external__nodes__false__set_expression_l(blob: *mut Blob<False>, blob: Blob<Loc>);
    fn lib_ruby_parser__external__nodes__false__into_internal(blob: Blob<False>) -> InternalFalse;
    fn lib_ruby_parser__external__nodes__false__drop(blob: *mut Blob<False>);
}

impl InnerNode for False {
    fn expression(&self) -> &Loc {
        self.get_expression_l()
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        
        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "false"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        self.get_expression_l().print("expression");
    }
}

impl Drop for False {
    fn drop(&mut self) {
        unsafe { lib_ruby_parser__external__nodes__false__drop(&mut self.blob) }
    }
}
