// This file is autogenerated by codegen/rust/nodes/node_file/native.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;

/// Represents exclusive flip-flop (i.e. in `if foo...bar; end`)
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct EFlipFlop {
    /// Left part of the flip-flop. `None` if based on a range without begin (`...bar`)
    pub left: Option<Box<Node>>,

    /// Right part of the flip-flop. `None` if based on a range without end (`foo...`)
    pub right: Option<Box<Node>>,

    /// Location of the `...` operator
    ///
    /// ```text
    /// if foo...bar; end
    ///       ~~~
    /// ```
    pub operator_l: Loc,

    /// Location of the full expression
    ///
    /// ```text
    /// if foo...bar; end
    ///    ~~~~~~~~~
    /// ```
    pub expression_l: Loc,
}

impl EFlipFlop {
    #[doc(hidden)]
    pub fn get_left(&self) -> &Option<Box<Node>> {
        &self.left
    }

    #[doc(hidden)]
    pub fn get_left_mut(&mut self) -> &mut Option<Box<Node>> {
        &mut self.left
    }

    #[doc(hidden)]
    pub fn get_right(&self) -> &Option<Box<Node>> {
        &self.right
    }

    #[doc(hidden)]
    pub fn get_right_mut(&mut self) -> &mut Option<Box<Node>> {
        &mut self.right
    }

    #[doc(hidden)]
    pub fn get_operator_l(&self) -> &Loc {
        &self.operator_l
    }

    #[doc(hidden)]
    pub fn get_operator_l_mut(&mut self) -> &mut Loc {
        &mut self.operator_l
    }

    #[doc(hidden)]
    pub fn get_expression_l(&self) -> &Loc {
        &self.expression_l
    }

    #[doc(hidden)]
    pub fn get_expression_l_mut(&mut self) -> &mut Loc {
        &mut self.expression_l
    }

    #[doc(hidden)]
    pub fn set_left(&mut self, value: Option<Box<Node>>) {
        self.left = value;
    }

    #[doc(hidden)]
    pub fn set_right(&mut self, value: Option<Box<Node>>) {
        self.right = value;
    }

    #[doc(hidden)]
    pub fn set_operator_l(&mut self, value: Loc) {
        self.operator_l = value;
    }

    #[doc(hidden)]
    pub fn set_expression_l(&mut self, value: Loc) {
        self.expression_l = value;
    }

    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> super::InternalEFlipFlop {
        let Self { left, right, operator_l, expression_l } = self;
        super::InternalEFlipFlop { left, right, operator_l, expression_l }
    }
}

impl InnerNode for EFlipFlop {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_maybe_node_or_nil(&self.left);
        result.push_maybe_node_or_nil(&self.right);
        
        
        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "eflipflop"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        self.left.as_ref().map(|node| node.inner_ref().print_with_locs());
        self.right.as_ref().map(|node| node.inner_ref().print_with_locs());
        self.operator_l.print("operator");
        self.expression_l.print("expression");
    }
}
