// This file is autogenerated by codegen/rust/nodes/node_file/external.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;
use crate::containers::ExternalMaybe as Maybe;
use crate::containers::ExternalPtr as Ptr;
use crate::containers::ExternalStringPtr as StringPtr;

use super::internal::InternalDef;
use crate::blobs::{HasBlob, Blob};

/// Represents method definition using `def` keyword (not on a singleton, see `Defs` node).
#[repr(C)]
pub struct Def {
    pub(crate) blob: Blob<Def>
}

impl std::fmt::Debug for Def {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        f.debug_struct("Def")
            .field("name", &self.get_name())
            .field("args", &self.get_args())
            .field("body", &self.get_body())
            .field("keyword_l", &self.get_keyword_l())
            .field("name_l", &self.get_name_l())
            .field("end_l", &self.get_end_l())
            .field("assignment_l", &self.get_assignment_l())
            .field("expression_l", &self.get_expression_l())
            .finish()
    }
}

impl PartialEq for Def {
    fn eq(&self, other: &Self) -> bool {
        self.get_name() == other.get_name()
            && self.get_args() == other.get_args()
            && self.get_body() == other.get_body()
            && self.get_keyword_l() == other.get_keyword_l()
            && self.get_name_l() == other.get_name_l()
            && self.get_end_l() == other.get_end_l()
            && self.get_assignment_l() == other.get_assignment_l()
            && self.get_expression_l() == other.get_expression_l()
    }
}

impl Def {
    /// Returns `name` field
    pub fn get_name(&self) -> &StringPtr {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__def__get_name(&self.blob) as *const StringPtr)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `name` field
    pub fn set_name(&mut self, name: StringPtr) {
        unsafe { lib_ruby_parser__external__nodes__def__set_name(&mut self.blob, name.into_blob()) }
    }

    /// Returns `args` field
    pub fn get_args(&self) -> &Maybe<Ptr<Node>> {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__def__get_args(&self.blob) as *const Maybe<Ptr<Node>>)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `args` field
    pub fn set_args(&mut self, args: Maybe<Ptr<Node>>) {
        unsafe { lib_ruby_parser__external__nodes__def__set_args(&mut self.blob, args.into_blob()) }
    }

    /// Returns `body` field
    pub fn get_body(&self) -> &Maybe<Ptr<Node>> {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__def__get_body(&self.blob) as *const Maybe<Ptr<Node>>)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `body` field
    pub fn set_body(&mut self, body: Maybe<Ptr<Node>>) {
        unsafe { lib_ruby_parser__external__nodes__def__set_body(&mut self.blob, body.into_blob()) }
    }

    /// Returns `keyword_l` field
    pub fn get_keyword_l(&self) -> &Loc {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__def__get_keyword_l(&self.blob) as *const Loc)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `keyword_l` field
    pub fn set_keyword_l(&mut self, keyword_l: Loc) {
        unsafe { lib_ruby_parser__external__nodes__def__set_keyword_l(&mut self.blob, keyword_l.into_blob()) }
    }

    /// Returns `name_l` field
    pub fn get_name_l(&self) -> &Loc {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__def__get_name_l(&self.blob) as *const Loc)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `name_l` field
    pub fn set_name_l(&mut self, name_l: Loc) {
        unsafe { lib_ruby_parser__external__nodes__def__set_name_l(&mut self.blob, name_l.into_blob()) }
    }

    /// Returns `end_l` field
    pub fn get_end_l(&self) -> &Maybe<Loc> {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__def__get_end_l(&self.blob) as *const Maybe<Loc>)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `end_l` field
    pub fn set_end_l(&mut self, end_l: Maybe<Loc>) {
        unsafe { lib_ruby_parser__external__nodes__def__set_end_l(&mut self.blob, end_l.into_blob()) }
    }

    /// Returns `assignment_l` field
    pub fn get_assignment_l(&self) -> &Maybe<Loc> {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__def__get_assignment_l(&self.blob) as *const Maybe<Loc>)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `assignment_l` field
    pub fn set_assignment_l(&mut self, assignment_l: Maybe<Loc>) {
        unsafe { lib_ruby_parser__external__nodes__def__set_assignment_l(&mut self.blob, assignment_l.into_blob()) }
    }

    /// Returns `expression_l` field
    pub fn get_expression_l(&self) -> &Loc {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__def__get_expression_l(&self.blob) as *const Loc)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `expression_l` field
    pub fn set_expression_l(&mut self, expression_l: Loc) {
        unsafe { lib_ruby_parser__external__nodes__def__set_expression_l(&mut self.blob, expression_l.into_blob()) }
    }

    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> InternalDef {
        unsafe { lib_ruby_parser__external__nodes__def__into_internal(self.into_blob()) }
    }
}

extern "C" {
    fn lib_ruby_parser__external__nodes__def__get_name(blob: *const Blob<Def>) -> *mut Blob<StringPtr>;
    fn lib_ruby_parser__external__nodes__def__set_name(blob: *mut Blob<Def>, blob: Blob<StringPtr>);
    fn lib_ruby_parser__external__nodes__def__get_args(blob: *const Blob<Def>) -> *mut Blob<Maybe<Ptr<Node>>>;
    fn lib_ruby_parser__external__nodes__def__set_args(blob: *mut Blob<Def>, blob: Blob<Maybe<Ptr<Node>>>);
    fn lib_ruby_parser__external__nodes__def__get_body(blob: *const Blob<Def>) -> *mut Blob<Maybe<Ptr<Node>>>;
    fn lib_ruby_parser__external__nodes__def__set_body(blob: *mut Blob<Def>, blob: Blob<Maybe<Ptr<Node>>>);
    fn lib_ruby_parser__external__nodes__def__get_keyword_l(blob: *const Blob<Def>) -> *mut Blob<Loc>;
    fn lib_ruby_parser__external__nodes__def__set_keyword_l(blob: *mut Blob<Def>, blob: Blob<Loc>);
    fn lib_ruby_parser__external__nodes__def__get_name_l(blob: *const Blob<Def>) -> *mut Blob<Loc>;
    fn lib_ruby_parser__external__nodes__def__set_name_l(blob: *mut Blob<Def>, blob: Blob<Loc>);
    fn lib_ruby_parser__external__nodes__def__get_end_l(blob: *const Blob<Def>) -> *mut Blob<Maybe<Loc>>;
    fn lib_ruby_parser__external__nodes__def__set_end_l(blob: *mut Blob<Def>, blob: Blob<Maybe<Loc>>);
    fn lib_ruby_parser__external__nodes__def__get_assignment_l(blob: *const Blob<Def>) -> *mut Blob<Maybe<Loc>>;
    fn lib_ruby_parser__external__nodes__def__set_assignment_l(blob: *mut Blob<Def>, blob: Blob<Maybe<Loc>>);
    fn lib_ruby_parser__external__nodes__def__get_expression_l(blob: *const Blob<Def>) -> *mut Blob<Loc>;
    fn lib_ruby_parser__external__nodes__def__set_expression_l(blob: *mut Blob<Def>, blob: Blob<Loc>);
    fn lib_ruby_parser__external__nodes__def__into_internal(blob: Blob<Def>) -> InternalDef;
    fn lib_ruby_parser__external__nodes__def__drop(blob: *mut Blob<Def>);
}

impl InnerNode for Def {
    fn expression(&self) -> &Loc {
        self.get_expression_l()
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_str(self.get_name());
        result.push_maybe_node_or_nil(self.get_args());
        result.push_maybe_node_or_nil(self.get_body());
        
        
        
        
        
        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "def"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        if let Some(node) = self.get_args().as_ref() { node.inner_ref().print_with_locs() }
        if let Some(node) = self.get_body().as_ref() { node.inner_ref().print_with_locs() }
        self.get_keyword_l().print("keyword");
        self.get_name_l().print("name");
        if let Some(loc) = self.get_end_l().as_ref() { loc.print("end") }
        if let Some(loc) = self.get_assignment_l().as_ref() { loc.print("assignment") }
        self.get_expression_l().print("expression");
    }
}

impl Drop for Def {
    fn drop(&mut self) {
        unsafe { lib_ruby_parser__external__nodes__def__drop(&mut self.blob) }
    }
}
