// This file is autogenerated by codegen/rust/nodes/node_file/external.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::containers::ExternalStringPtr as StringPtr;

use super::internal::InternalCvar;
use crate::blobs::{HasBlob, Blob};

/// Represents access to class variable (i.e. `@@var`)
#[repr(C)]
pub struct Cvar {
    pub(crate) blob: Blob<Cvar>
}

impl std::fmt::Debug for Cvar {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        f.debug_struct("Cvar")
            .field("name", &self.get_name())
            .field("expression_l", &self.get_expression_l())
            .finish()
    }
}

impl PartialEq for Cvar {
    fn eq(&self, other: &Self) -> bool {
        self.get_name() == other.get_name()
            && self.get_expression_l() == other.get_expression_l()
    }
}

impl Cvar {
    /// Returns `name` field
    pub fn get_name(&self) -> &StringPtr {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__cvar__get_name(&self.blob) as *const StringPtr)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `name` field
    pub fn set_name(&mut self, name: StringPtr) {
        unsafe { lib_ruby_parser__external__nodes__cvar__set_name(&mut self.blob, name.into_blob()) }
    }

    /// Returns `expression_l` field
    pub fn get_expression_l(&self) -> &Loc {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__cvar__get_expression_l(&self.blob) as *const Loc)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `expression_l` field
    pub fn set_expression_l(&mut self, expression_l: Loc) {
        unsafe { lib_ruby_parser__external__nodes__cvar__set_expression_l(&mut self.blob, expression_l.into_blob()) }
    }

    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> InternalCvar {
        unsafe { lib_ruby_parser__external__nodes__cvar__into_internal(self.into_blob()) }
    }
}

extern "C" {
    fn lib_ruby_parser__external__nodes__cvar__get_name(blob: *const Blob<Cvar>) -> *mut Blob<StringPtr>;
    fn lib_ruby_parser__external__nodes__cvar__set_name(blob: *mut Blob<Cvar>, blob: Blob<StringPtr>);
    fn lib_ruby_parser__external__nodes__cvar__get_expression_l(blob: *const Blob<Cvar>) -> *mut Blob<Loc>;
    fn lib_ruby_parser__external__nodes__cvar__set_expression_l(blob: *mut Blob<Cvar>, blob: Blob<Loc>);
    fn lib_ruby_parser__external__nodes__cvar__into_internal(blob: Blob<Cvar>) -> InternalCvar;
    fn lib_ruby_parser__external__nodes__cvar__drop(blob: *mut Blob<Cvar>);
}

impl InnerNode for Cvar {
    fn expression(&self) -> &Loc {
        self.get_expression_l()
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_str(self.get_name());
        
        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "cvar"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        self.get_expression_l().print("expression");
    }
}

impl Drop for Cvar {
    fn drop(&mut self) {
        unsafe { lib_ruby_parser__external__nodes__cvar__drop(&mut self.blob) }
    }
}
