// This file is autogenerated by codegen/rust/nodes/node_file/native.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;

/// Const pattern used in pattern matching (e.g. `in A(1, 2)`)
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct ConstPattern {
    /// Constant that is used, `Const("Foo")` for `in For(42)`
    pub const_: Box<Node>,

    /// Inner part of the constant pattern
    ///
    /// `ArrayPattern(vec![ Int("1") ])` for `Foo(1)`
    pub pattern: Box<Node>,

    /// Location of the open parenthesis
    ///
    /// ```text
    /// case 1; in Foo(42); end
    ///               ~
    /// ```
    pub begin_l: Loc,

    /// Location of the closing parenthesis
    ///
    /// ```text
    /// case 1; in Foo(42); end
    ///                  ~
    /// ```
    pub end_l: Loc,

    /// Location of the full expression
    ///
    /// ```text
    /// case 1; in Foo(42); end
    ///            ~~~~~~~
    /// ```
    pub expression_l: Loc,
}

impl ConstPattern {
    #[doc(hidden)]
    pub fn get_const(&self) -> &Box<Node> {
        &self.const_
    }

    #[doc(hidden)]
    pub fn get_const_mut(&mut self) -> &mut Box<Node> {
        &mut self.const_
    }

    #[doc(hidden)]
    pub fn get_pattern(&self) -> &Box<Node> {
        &self.pattern
    }

    #[doc(hidden)]
    pub fn get_pattern_mut(&mut self) -> &mut Box<Node> {
        &mut self.pattern
    }

    #[doc(hidden)]
    pub fn get_begin_l(&self) -> &Loc {
        &self.begin_l
    }

    #[doc(hidden)]
    pub fn get_begin_l_mut(&mut self) -> &mut Loc {
        &mut self.begin_l
    }

    #[doc(hidden)]
    pub fn get_end_l(&self) -> &Loc {
        &self.end_l
    }

    #[doc(hidden)]
    pub fn get_end_l_mut(&mut self) -> &mut Loc {
        &mut self.end_l
    }

    #[doc(hidden)]
    pub fn get_expression_l(&self) -> &Loc {
        &self.expression_l
    }

    #[doc(hidden)]
    pub fn get_expression_l_mut(&mut self) -> &mut Loc {
        &mut self.expression_l
    }

    #[doc(hidden)]
    pub fn set_const(&mut self, value: Box<Node>) {
        self.const_ = value;
    }

    #[doc(hidden)]
    pub fn set_pattern(&mut self, value: Box<Node>) {
        self.pattern = value;
    }

    #[doc(hidden)]
    pub fn set_begin_l(&mut self, value: Loc) {
        self.begin_l = value;
    }

    #[doc(hidden)]
    pub fn set_end_l(&mut self, value: Loc) {
        self.end_l = value;
    }

    #[doc(hidden)]
    pub fn set_expression_l(&mut self, value: Loc) {
        self.expression_l = value;
    }

    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> super::InternalConstPattern {
        let Self { const_, pattern, begin_l, end_l, expression_l } = self;
        super::InternalConstPattern { const_, pattern, begin_l, end_l, expression_l }
    }
}

impl InnerNode for ConstPattern {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_node(&self.const_);
        result.push_node(&self.pattern);
        
        
        
        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "const_pattern"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        self.const_.inner_ref().print_with_locs();
        self.pattern.inner_ref().print_with_locs();
        self.begin_l.print("begin");
        self.end_l.print("end");
        self.expression_l.print("expression");
    }
}
