// This file is autogenerated by codegen/rust/nodes/node_file/external.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;
use crate::containers::ExternalMaybe as Maybe;
use crate::containers::ExternalPtr as Ptr;
use crate::containers::ExternalStringPtr as StringPtr;

use super::internal::InternalConst;
use crate::blobs::{HasBlob, Blob};

/// Represents constant access (i.e. `Foo::Bar`)
#[repr(C)]
pub struct Const {
    pub(crate) blob: Blob<Const>
}

impl std::fmt::Debug for Const {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        f.debug_struct("Const")
            .field("scope", &self.get_scope())
            .field("name", &self.get_name())
            .field("double_colon_l", &self.get_double_colon_l())
            .field("name_l", &self.get_name_l())
            .field("expression_l", &self.get_expression_l())
            .finish()
    }
}

impl PartialEq for Const {
    fn eq(&self, other: &Self) -> bool {
        self.get_scope() == other.get_scope()
            && self.get_name() == other.get_name()
            && self.get_double_colon_l() == other.get_double_colon_l()
            && self.get_name_l() == other.get_name_l()
            && self.get_expression_l() == other.get_expression_l()
    }
}

impl Const {
    /// Returns `scope` field
    pub fn get_scope(&self) -> &Maybe<Ptr<Node>> {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__const__get_scope(&self.blob) as *const Maybe<Ptr<Node>>)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `scope` field
    pub fn set_scope(&mut self, scope: Maybe<Ptr<Node>>) {
        unsafe { lib_ruby_parser__external__nodes__const__set_scope(&mut self.blob, scope.into_blob()) }
    }

    /// Returns `name` field
    pub fn get_name(&self) -> &StringPtr {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__const__get_name(&self.blob) as *const StringPtr)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `name` field
    pub fn set_name(&mut self, name: StringPtr) {
        unsafe { lib_ruby_parser__external__nodes__const__set_name(&mut self.blob, name.into_blob()) }
    }

    /// Returns `double_colon_l` field
    pub fn get_double_colon_l(&self) -> &Maybe<Loc> {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__const__get_double_colon_l(&self.blob) as *const Maybe<Loc>)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `double_colon_l` field
    pub fn set_double_colon_l(&mut self, double_colon_l: Maybe<Loc>) {
        unsafe { lib_ruby_parser__external__nodes__const__set_double_colon_l(&mut self.blob, double_colon_l.into_blob()) }
    }

    /// Returns `name_l` field
    pub fn get_name_l(&self) -> &Loc {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__const__get_name_l(&self.blob) as *const Loc)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `name_l` field
    pub fn set_name_l(&mut self, name_l: Loc) {
        unsafe { lib_ruby_parser__external__nodes__const__set_name_l(&mut self.blob, name_l.into_blob()) }
    }

    /// Returns `expression_l` field
    pub fn get_expression_l(&self) -> &Loc {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__const__get_expression_l(&self.blob) as *const Loc)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `expression_l` field
    pub fn set_expression_l(&mut self, expression_l: Loc) {
        unsafe { lib_ruby_parser__external__nodes__const__set_expression_l(&mut self.blob, expression_l.into_blob()) }
    }

    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> InternalConst {
        unsafe { lib_ruby_parser__external__nodes__const__into_internal(self.into_blob()) }
    }
}

extern "C" {
    fn lib_ruby_parser__external__nodes__const__get_scope(blob: *const Blob<Const>) -> *mut Blob<Maybe<Ptr<Node>>>;
    fn lib_ruby_parser__external__nodes__const__set_scope(blob: *mut Blob<Const>, blob: Blob<Maybe<Ptr<Node>>>);
    fn lib_ruby_parser__external__nodes__const__get_name(blob: *const Blob<Const>) -> *mut Blob<StringPtr>;
    fn lib_ruby_parser__external__nodes__const__set_name(blob: *mut Blob<Const>, blob: Blob<StringPtr>);
    fn lib_ruby_parser__external__nodes__const__get_double_colon_l(blob: *const Blob<Const>) -> *mut Blob<Maybe<Loc>>;
    fn lib_ruby_parser__external__nodes__const__set_double_colon_l(blob: *mut Blob<Const>, blob: Blob<Maybe<Loc>>);
    fn lib_ruby_parser__external__nodes__const__get_name_l(blob: *const Blob<Const>) -> *mut Blob<Loc>;
    fn lib_ruby_parser__external__nodes__const__set_name_l(blob: *mut Blob<Const>, blob: Blob<Loc>);
    fn lib_ruby_parser__external__nodes__const__get_expression_l(blob: *const Blob<Const>) -> *mut Blob<Loc>;
    fn lib_ruby_parser__external__nodes__const__set_expression_l(blob: *mut Blob<Const>, blob: Blob<Loc>);
    fn lib_ruby_parser__external__nodes__const__into_internal(blob: Blob<Const>) -> InternalConst;
    fn lib_ruby_parser__external__nodes__const__drop(blob: *mut Blob<Const>);
}

impl InnerNode for Const {
    fn expression(&self) -> &Loc {
        self.get_expression_l()
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_maybe_node_or_nil(self.get_scope());
        result.push_str(self.get_name());
        
        
        
        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "const"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        if let Some(node) = self.get_scope().as_ref() { node.inner_ref().print_with_locs() }
        if let Some(loc) = self.get_double_colon_l().as_ref() { loc.print("double_colon") }
        self.get_name_l().print("name");
        self.get_expression_l().print("expression");
    }
}

impl Drop for Const {
    fn drop(&mut self) {
        unsafe { lib_ruby_parser__external__nodes__const__drop(&mut self.blob) }
    }
}
