// This file is autogenerated by codegen/rust/nodes/node_file/external.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;
use crate::containers::ExternalMaybe as Maybe;
use crate::containers::ExternalPtr as Ptr;
use crate::containers::ExternalList as List;

use super::internal::InternalCaseMatch;
use crate::blobs::{HasBlob, Blob};

/// Represents a `case` statement used for pattern matching (for regular `case` see `Case` node)
#[repr(C)]
pub struct CaseMatch {
    pub(crate) blob: Blob<CaseMatch>
}

impl std::fmt::Debug for CaseMatch {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        f.debug_struct("CaseMatch")
            .field("expr", &self.get_expr())
            .field("in_bodies", &self.get_in_bodies())
            .field("else_body", &self.get_else_body())
            .field("keyword_l", &self.get_keyword_l())
            .field("else_l", &self.get_else_l())
            .field("end_l", &self.get_end_l())
            .field("expression_l", &self.get_expression_l())
            .finish()
    }
}

impl PartialEq for CaseMatch {
    fn eq(&self, other: &Self) -> bool {
        self.get_expr() == other.get_expr()
            && self.get_in_bodies() == other.get_in_bodies()
            && self.get_else_body() == other.get_else_body()
            && self.get_keyword_l() == other.get_keyword_l()
            && self.get_else_l() == other.get_else_l()
            && self.get_end_l() == other.get_end_l()
            && self.get_expression_l() == other.get_expression_l()
    }
}

impl CaseMatch {
    /// Returns `expr` field
    pub fn get_expr(&self) -> &Ptr<Node> {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__case_match__get_expr(&self.blob) as *const Ptr<Node>)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `expr` field
    pub fn set_expr(&mut self, expr: Ptr<Node>) {
        unsafe { lib_ruby_parser__external__nodes__case_match__set_expr(&mut self.blob, expr.into_blob()) }
    }

    /// Returns `in_bodies` field
    pub fn get_in_bodies(&self) -> &List<Node> {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__case_match__get_in_bodies(&self.blob) as *const List<Node>)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `in_bodies` field
    pub fn set_in_bodies(&mut self, in_bodies: List<Node>) {
        unsafe { lib_ruby_parser__external__nodes__case_match__set_in_bodies(&mut self.blob, in_bodies.into_blob()) }
    }

    /// Returns `else_body` field
    pub fn get_else_body(&self) -> &Maybe<Ptr<Node>> {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__case_match__get_else_body(&self.blob) as *const Maybe<Ptr<Node>>)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `else_body` field
    pub fn set_else_body(&mut self, else_body: Maybe<Ptr<Node>>) {
        unsafe { lib_ruby_parser__external__nodes__case_match__set_else_body(&mut self.blob, else_body.into_blob()) }
    }

    /// Returns `keyword_l` field
    pub fn get_keyword_l(&self) -> &Loc {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__case_match__get_keyword_l(&self.blob) as *const Loc)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `keyword_l` field
    pub fn set_keyword_l(&mut self, keyword_l: Loc) {
        unsafe { lib_ruby_parser__external__nodes__case_match__set_keyword_l(&mut self.blob, keyword_l.into_blob()) }
    }

    /// Returns `else_l` field
    pub fn get_else_l(&self) -> &Maybe<Loc> {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__case_match__get_else_l(&self.blob) as *const Maybe<Loc>)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `else_l` field
    pub fn set_else_l(&mut self, else_l: Maybe<Loc>) {
        unsafe { lib_ruby_parser__external__nodes__case_match__set_else_l(&mut self.blob, else_l.into_blob()) }
    }

    /// Returns `end_l` field
    pub fn get_end_l(&self) -> &Loc {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__case_match__get_end_l(&self.blob) as *const Loc)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `end_l` field
    pub fn set_end_l(&mut self, end_l: Loc) {
        unsafe { lib_ruby_parser__external__nodes__case_match__set_end_l(&mut self.blob, end_l.into_blob()) }
    }

    /// Returns `expression_l` field
    pub fn get_expression_l(&self) -> &Loc {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__case_match__get_expression_l(&self.blob) as *const Loc)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `expression_l` field
    pub fn set_expression_l(&mut self, expression_l: Loc) {
        unsafe { lib_ruby_parser__external__nodes__case_match__set_expression_l(&mut self.blob, expression_l.into_blob()) }
    }

    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> InternalCaseMatch {
        unsafe { lib_ruby_parser__external__nodes__case_match__into_internal(self.into_blob()) }
    }
}

extern "C" {
    fn lib_ruby_parser__external__nodes__case_match__get_expr(blob: *const Blob<CaseMatch>) -> *mut Blob<Ptr<Node>>;
    fn lib_ruby_parser__external__nodes__case_match__set_expr(blob: *mut Blob<CaseMatch>, blob: Blob<Ptr<Node>>);
    fn lib_ruby_parser__external__nodes__case_match__get_in_bodies(blob: *const Blob<CaseMatch>) -> *mut Blob<List<Node>>;
    fn lib_ruby_parser__external__nodes__case_match__set_in_bodies(blob: *mut Blob<CaseMatch>, blob: Blob<List<Node>>);
    fn lib_ruby_parser__external__nodes__case_match__get_else_body(blob: *const Blob<CaseMatch>) -> *mut Blob<Maybe<Ptr<Node>>>;
    fn lib_ruby_parser__external__nodes__case_match__set_else_body(blob: *mut Blob<CaseMatch>, blob: Blob<Maybe<Ptr<Node>>>);
    fn lib_ruby_parser__external__nodes__case_match__get_keyword_l(blob: *const Blob<CaseMatch>) -> *mut Blob<Loc>;
    fn lib_ruby_parser__external__nodes__case_match__set_keyword_l(blob: *mut Blob<CaseMatch>, blob: Blob<Loc>);
    fn lib_ruby_parser__external__nodes__case_match__get_else_l(blob: *const Blob<CaseMatch>) -> *mut Blob<Maybe<Loc>>;
    fn lib_ruby_parser__external__nodes__case_match__set_else_l(blob: *mut Blob<CaseMatch>, blob: Blob<Maybe<Loc>>);
    fn lib_ruby_parser__external__nodes__case_match__get_end_l(blob: *const Blob<CaseMatch>) -> *mut Blob<Loc>;
    fn lib_ruby_parser__external__nodes__case_match__set_end_l(blob: *mut Blob<CaseMatch>, blob: Blob<Loc>);
    fn lib_ruby_parser__external__nodes__case_match__get_expression_l(blob: *const Blob<CaseMatch>) -> *mut Blob<Loc>;
    fn lib_ruby_parser__external__nodes__case_match__set_expression_l(blob: *mut Blob<CaseMatch>, blob: Blob<Loc>);
    fn lib_ruby_parser__external__nodes__case_match__into_internal(blob: Blob<CaseMatch>) -> InternalCaseMatch;
    fn lib_ruby_parser__external__nodes__case_match__drop(blob: *mut Blob<CaseMatch>);
}

impl InnerNode for CaseMatch {
    fn expression(&self) -> &Loc {
        self.get_expression_l()
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_node(self.get_expr());
        result.push_nodes(self.get_in_bodies());
        result.push_maybe_node_or_nil(self.get_else_body());
        
        
        
        
        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "case_match"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        self.get_expr().inner_ref().print_with_locs();
        for node in self.get_in_bodies().iter() {
          node.inner_ref().print_with_locs();
        }
        if let Some(node) = self.get_else_body().as_ref() { node.inner_ref().print_with_locs() }
        self.get_keyword_l().print("keyword");
        if let Some(loc) = self.get_else_l().as_ref() { loc.print("else") }
        self.get_end_l().print("end");
        self.get_expression_l().print("expression");
    }
}

impl Drop for CaseMatch {
    fn drop(&mut self) {
        unsafe { lib_ruby_parser__external__nodes__case_match__drop(&mut self.blob) }
    }
}
