// This file is autogenerated by codegen/rust/nodes/node_file/native.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;

/// Represents a `case` statement (for pattern matching see `CaseMatch` node)
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct Case {
    /// Expression given to `case`, `Int("1")` for `case 1; end`
    /// `None` for code like
    ///
    /// ```text
    /// case
    /// when pattern
    /// end
    /// ```
    pub expr: Option<Box<Node>>,

    /// A list of `When` nodes (each has `patterns` and `body`)
    pub when_bodies: Vec<Node>,

    /// Body of the `else` branch, `None` if there's no `else` branch
    pub else_body: Option<Box<Node>>,

    /// Location of the `case` keyword
    ///
    /// ```text
    /// case 1; end
    /// ~~~~
    /// ```
    pub keyword_l: Loc,

    /// Location of the `else` keyword
    ///
    /// ```text
    /// case 1; else; end
    ///         ~~~~
    /// ```
    ///
    /// `None` if there's no `else` branch
    pub else_l: Option<Loc>,

    /// Location of the `end` keyword
    ///
    /// ```text
    /// case 1; end
    ///         ~~~
    /// ```
    pub end_l: Loc,

    /// Location of the full expression
    ///
    /// ```text
    /// case 1; end
    /// ~~~~~~~~~~~
    /// ```
    pub expression_l: Loc,
}

impl Case {
    #[doc(hidden)]
    pub fn get_expr(&self) -> &Option<Box<Node>> {
        &self.expr
    }

    #[doc(hidden)]
    pub fn get_expr_mut(&mut self) -> &mut Option<Box<Node>> {
        &mut self.expr
    }

    #[doc(hidden)]
    pub fn get_when_bodies(&self) -> &Vec<Node> {
        &self.when_bodies
    }

    #[doc(hidden)]
    pub fn get_when_bodies_mut(&mut self) -> &mut Vec<Node> {
        &mut self.when_bodies
    }

    #[doc(hidden)]
    pub fn get_else_body(&self) -> &Option<Box<Node>> {
        &self.else_body
    }

    #[doc(hidden)]
    pub fn get_else_body_mut(&mut self) -> &mut Option<Box<Node>> {
        &mut self.else_body
    }

    #[doc(hidden)]
    pub fn get_keyword_l(&self) -> &Loc {
        &self.keyword_l
    }

    #[doc(hidden)]
    pub fn get_keyword_l_mut(&mut self) -> &mut Loc {
        &mut self.keyword_l
    }

    #[doc(hidden)]
    pub fn get_else_l(&self) -> &Option<Loc> {
        &self.else_l
    }

    #[doc(hidden)]
    pub fn get_else_l_mut(&mut self) -> &mut Option<Loc> {
        &mut self.else_l
    }

    #[doc(hidden)]
    pub fn get_end_l(&self) -> &Loc {
        &self.end_l
    }

    #[doc(hidden)]
    pub fn get_end_l_mut(&mut self) -> &mut Loc {
        &mut self.end_l
    }

    #[doc(hidden)]
    pub fn get_expression_l(&self) -> &Loc {
        &self.expression_l
    }

    #[doc(hidden)]
    pub fn get_expression_l_mut(&mut self) -> &mut Loc {
        &mut self.expression_l
    }

    #[doc(hidden)]
    pub fn set_expr(&mut self, value: Option<Box<Node>>) {
        self.expr = value;
    }

    #[doc(hidden)]
    pub fn set_when_bodies(&mut self, value: Vec<Node>) {
        self.when_bodies = value;
    }

    #[doc(hidden)]
    pub fn set_else_body(&mut self, value: Option<Box<Node>>) {
        self.else_body = value;
    }

    #[doc(hidden)]
    pub fn set_keyword_l(&mut self, value: Loc) {
        self.keyword_l = value;
    }

    #[doc(hidden)]
    pub fn set_else_l(&mut self, value: Option<Loc>) {
        self.else_l = value;
    }

    #[doc(hidden)]
    pub fn set_end_l(&mut self, value: Loc) {
        self.end_l = value;
    }

    #[doc(hidden)]
    pub fn set_expression_l(&mut self, value: Loc) {
        self.expression_l = value;
    }

    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> super::InternalCase {
        let Self { expr, when_bodies, else_body, keyword_l, else_l, end_l, expression_l } = self;
        super::InternalCase { expr, when_bodies, else_body, keyword_l, else_l, end_l, expression_l }
    }
}

impl InnerNode for Case {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_maybe_node_or_nil(&self.expr);
        result.push_nodes(&self.when_bodies);
        result.push_maybe_node_or_nil(&self.else_body);
        
        
        
        
        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "case"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        self.expr.as_ref().map(|node| node.inner_ref().print_with_locs());
        for node in self.when_bodies.iter() {
          node.inner_ref().print_with_locs();
        }
        self.else_body.as_ref().map(|node| node.inner_ref().print_with_locs());
        self.keyword_l.print("keyword");
        self.else_l.as_ref().map(|loc| loc.print("else"));
        self.end_l.print("end");
        self.expression_l.print("expression");
    }
}
