// This file is autogenerated by codegen/rust/nodes/node_file/native.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;

/// Represents conditional method call using `&.` operator
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct CSend {
    /// Receiver of the method call, `Int("1")` for `1&.foo`
    pub recv: Box<Node>,

    /// Name of the method, `String("foo")` for `1&.foo`
    pub method_name: String,

    /// List of arguments
    ///
    /// ```text
    /// foo&.bar(42)
    /// # and also setters like
    /// foo&.bar = 42
    /// ```
    pub args: Vec<Node>,

    /// Location of the `&.` operator
    ///
    /// ```text
    /// foo&.bar
    ///    ~~
    /// ```
    pub dot_l: Loc,

    /// Location of the method name
    ///
    /// ```text
    /// foo&.bar(42)
    ///      ~~~
    /// ```
    ///
    /// `None` in a very special case when method call is implicit (i.e. `foo&.()`)
    pub selector_l: Option<Loc>,

    /// Location of the open parenthesis
    ///
    /// ```text
    /// foo&.bar(42)
    ///         ~
    /// ```
    ///
    /// `None` if there are no parentheses
    pub begin_l: Option<Loc>,

    /// Location of the closing parenthesis
    ///
    /// ```text
    /// foo&.bar(42)
    ///            ~
    /// ```
    ///
    /// `None` if there are no parentheses
    pub end_l: Option<Loc>,

    /// Location of the operator if `CSend` is a part of assignment like
    ///
    /// ```text
    /// foo&.bar = 1
    ///          ~
    /// ```
    ///
    /// `None` for a regular call.
    pub operator_l: Option<Loc>,

    /// Location of the full expression
    ///
    /// ```text
    /// foo&.bar(42)
    /// ~~~~~~~~~~~~
    /// ```
    pub expression_l: Loc,
}

impl CSend {
    #[doc(hidden)]
    pub fn get_recv(&self) -> &Box<Node> {
        &self.recv
    }

    #[doc(hidden)]
    pub fn get_recv_mut(&mut self) -> &mut Box<Node> {
        &mut self.recv
    }

    #[doc(hidden)]
    pub fn get_method_name(&self) -> &String {
        &self.method_name
    }

    #[doc(hidden)]
    pub fn get_method_name_mut(&mut self) -> &mut String {
        &mut self.method_name
    }

    #[doc(hidden)]
    pub fn get_args(&self) -> &Vec<Node> {
        &self.args
    }

    #[doc(hidden)]
    pub fn get_args_mut(&mut self) -> &mut Vec<Node> {
        &mut self.args
    }

    #[doc(hidden)]
    pub fn get_dot_l(&self) -> &Loc {
        &self.dot_l
    }

    #[doc(hidden)]
    pub fn get_dot_l_mut(&mut self) -> &mut Loc {
        &mut self.dot_l
    }

    #[doc(hidden)]
    pub fn get_selector_l(&self) -> &Option<Loc> {
        &self.selector_l
    }

    #[doc(hidden)]
    pub fn get_selector_l_mut(&mut self) -> &mut Option<Loc> {
        &mut self.selector_l
    }

    #[doc(hidden)]
    pub fn get_begin_l(&self) -> &Option<Loc> {
        &self.begin_l
    }

    #[doc(hidden)]
    pub fn get_begin_l_mut(&mut self) -> &mut Option<Loc> {
        &mut self.begin_l
    }

    #[doc(hidden)]
    pub fn get_end_l(&self) -> &Option<Loc> {
        &self.end_l
    }

    #[doc(hidden)]
    pub fn get_end_l_mut(&mut self) -> &mut Option<Loc> {
        &mut self.end_l
    }

    #[doc(hidden)]
    pub fn get_operator_l(&self) -> &Option<Loc> {
        &self.operator_l
    }

    #[doc(hidden)]
    pub fn get_operator_l_mut(&mut self) -> &mut Option<Loc> {
        &mut self.operator_l
    }

    #[doc(hidden)]
    pub fn get_expression_l(&self) -> &Loc {
        &self.expression_l
    }

    #[doc(hidden)]
    pub fn get_expression_l_mut(&mut self) -> &mut Loc {
        &mut self.expression_l
    }

    #[doc(hidden)]
    pub fn set_recv(&mut self, value: Box<Node>) {
        self.recv = value;
    }

    #[doc(hidden)]
    pub fn set_method_name(&mut self, value: String) {
        self.method_name = value;
    }

    #[doc(hidden)]
    pub fn set_args(&mut self, value: Vec<Node>) {
        self.args = value;
    }

    #[doc(hidden)]
    pub fn set_dot_l(&mut self, value: Loc) {
        self.dot_l = value;
    }

    #[doc(hidden)]
    pub fn set_selector_l(&mut self, value: Option<Loc>) {
        self.selector_l = value;
    }

    #[doc(hidden)]
    pub fn set_begin_l(&mut self, value: Option<Loc>) {
        self.begin_l = value;
    }

    #[doc(hidden)]
    pub fn set_end_l(&mut self, value: Option<Loc>) {
        self.end_l = value;
    }

    #[doc(hidden)]
    pub fn set_operator_l(&mut self, value: Option<Loc>) {
        self.operator_l = value;
    }

    #[doc(hidden)]
    pub fn set_expression_l(&mut self, value: Loc) {
        self.expression_l = value;
    }

    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> super::InternalCSend {
        let Self { recv, method_name, args, dot_l, selector_l, begin_l, end_l, operator_l, expression_l } = self;
        super::InternalCSend { recv, method_name, args, dot_l, selector_l, begin_l, end_l, operator_l, expression_l }
    }
}

impl InnerNode for CSend {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_node(&self.recv);
        result.push_str(&self.method_name);
        result.push_nodes(&self.args);
        
        
        
        
        
        
        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "csend"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        self.recv.inner_ref().print_with_locs();
        for node in self.args.iter() {
          node.inner_ref().print_with_locs();
        }
        self.dot_l.print("dot");
        self.selector_l.as_ref().map(|loc| loc.print("selector"));
        self.begin_l.as_ref().map(|loc| loc.print("begin"));
        self.end_l.as_ref().map(|loc| loc.print("end"));
        self.operator_l.as_ref().map(|loc| loc.print("operator"));
        self.expression_l.print("expression");
    }
}
