// This file is autogenerated by codegen/rust/nodes/node_file/native.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;

/// Represents a `&blk` argument of the method call (but not of the method definition, see `BlockArg`)
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct BlockPass {
    /// Value that is converted to a block
    ///
    /// `Int("1")` in `foo(&1)` (yes, it's possible)
    pub value: Box<Node>,

    /// Location of the `&` operator
    ///
    /// ```text
    /// foo(&blk)
    ///     ~
    /// ```
    pub operator_l: Loc,

    /// Location of the full expression
    ///
    /// ```text
    /// foo(&bar)
    ///     ~~~~
    /// ```
    pub expression_l: Loc,
}

impl BlockPass {
    #[doc(hidden)]
    pub fn get_value(&self) -> &Box<Node> {
        &self.value
    }

    #[doc(hidden)]
    pub fn get_value_mut(&mut self) -> &mut Box<Node> {
        &mut self.value
    }

    #[doc(hidden)]
    pub fn get_operator_l(&self) -> &Loc {
        &self.operator_l
    }

    #[doc(hidden)]
    pub fn get_operator_l_mut(&mut self) -> &mut Loc {
        &mut self.operator_l
    }

    #[doc(hidden)]
    pub fn get_expression_l(&self) -> &Loc {
        &self.expression_l
    }

    #[doc(hidden)]
    pub fn get_expression_l_mut(&mut self) -> &mut Loc {
        &mut self.expression_l
    }

    #[doc(hidden)]
    pub fn set_value(&mut self, value: Box<Node>) {
        self.value = value;
    }

    #[doc(hidden)]
    pub fn set_operator_l(&mut self, value: Loc) {
        self.operator_l = value;
    }

    #[doc(hidden)]
    pub fn set_expression_l(&mut self, value: Loc) {
        self.expression_l = value;
    }

    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> super::InternalBlockPass {
        let Self { value, operator_l, expression_l } = self;
        super::InternalBlockPass { value, operator_l, expression_l }
    }
}

impl InnerNode for BlockPass {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_node(&self.value);
        
        
        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "block_pass"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        self.value.inner_ref().print_with_locs();
        self.operator_l.print("operator");
        self.expression_l.print("expression");
    }
}
