// This file is autogenerated by codegen/rust/nodes/node_file/native.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;

/// Represents compound statement (i.e. a multi-statement)
///
/// Basically all blocks of code are wrapped into `Begin` node (e.g. method/block body, rescue/ensure handler etc)
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct Begin {
    /// A list of statements
    pub statements: Vec<Node>,

    /// Begin of the block
    ///
    /// ```text
    /// (1; 2)
    /// ~
    /// ```
    ///
    /// `None` if the block of code is "implicit", like
    ///
    /// ```text
    /// if true; 1; 2; end
    /// ```
    pub begin_l: Option<Loc>,

    /// End of the block
    ///
    /// ```text
    /// (1; 2)
    ///      ~
    /// ```
    ///
    /// `None` if the block of code is "implicit", like
    ///
    /// ```text
    /// if true; 1; 2; end
    /// ```
    pub end_l: Option<Loc>,

    /// Location of the full expression
    ///
    /// ```text
    /// (1; 2)
    /// ~~~~~~
    /// ```
    pub expression_l: Loc,
}

impl Begin {
    #[doc(hidden)]
    pub fn get_statements(&self) -> &Vec<Node> {
        &self.statements
    }

    #[doc(hidden)]
    pub fn get_statements_mut(&mut self) -> &mut Vec<Node> {
        &mut self.statements
    }

    #[doc(hidden)]
    pub fn get_begin_l(&self) -> &Option<Loc> {
        &self.begin_l
    }

    #[doc(hidden)]
    pub fn get_begin_l_mut(&mut self) -> &mut Option<Loc> {
        &mut self.begin_l
    }

    #[doc(hidden)]
    pub fn get_end_l(&self) -> &Option<Loc> {
        &self.end_l
    }

    #[doc(hidden)]
    pub fn get_end_l_mut(&mut self) -> &mut Option<Loc> {
        &mut self.end_l
    }

    #[doc(hidden)]
    pub fn get_expression_l(&self) -> &Loc {
        &self.expression_l
    }

    #[doc(hidden)]
    pub fn get_expression_l_mut(&mut self) -> &mut Loc {
        &mut self.expression_l
    }

    #[doc(hidden)]
    pub fn set_statements(&mut self, value: Vec<Node>) {
        self.statements = value;
    }

    #[doc(hidden)]
    pub fn set_begin_l(&mut self, value: Option<Loc>) {
        self.begin_l = value;
    }

    #[doc(hidden)]
    pub fn set_end_l(&mut self, value: Option<Loc>) {
        self.end_l = value;
    }

    #[doc(hidden)]
    pub fn set_expression_l(&mut self, value: Loc) {
        self.expression_l = value;
    }

    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> super::InternalBegin {
        let Self { statements, begin_l, end_l, expression_l } = self;
        super::InternalBegin { statements, begin_l, end_l, expression_l }
    }
}

impl InnerNode for Begin {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_nodes(&self.statements);
        
        
        
        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "begin"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        for node in self.statements.iter() {
          node.inner_ref().print_with_locs();
        }
        self.begin_l.as_ref().map(|loc| loc.print("begin"));
        self.end_l.as_ref().map(|loc| loc.print("end"));
        self.expression_l.print("expression");
    }
}
