// This file is autogenerated by codegen/rust/nodes/node_file/external.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;
use crate::containers::ExternalMaybe as Maybe;
use crate::containers::ExternalList as List;

use super::internal::InternalArray;
use crate::blobs::{HasBlob, Blob};

/// Represents an array literal
#[repr(C)]
pub struct Array {
    pub(crate) blob: Blob<Array>
}

impl std::fmt::Debug for Array {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        f.debug_struct("Array")
            .field("elements", &self.get_elements())
            .field("begin_l", &self.get_begin_l())
            .field("end_l", &self.get_end_l())
            .field("expression_l", &self.get_expression_l())
            .finish()
    }
}

impl PartialEq for Array {
    fn eq(&self, other: &Self) -> bool {
        self.get_elements() == other.get_elements()
            && self.get_begin_l() == other.get_begin_l()
            && self.get_end_l() == other.get_end_l()
            && self.get_expression_l() == other.get_expression_l()
    }
}

impl Array {
    /// Returns `elements` field
    pub fn get_elements(&self) -> &List<Node> {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__array__get_elements(&self.blob) as *const List<Node>)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `elements` field
    pub fn set_elements(&mut self, elements: List<Node>) {
        unsafe { lib_ruby_parser__external__nodes__array__set_elements(&mut self.blob, elements.into_blob()) }
    }

    /// Returns `begin_l` field
    pub fn get_begin_l(&self) -> &Maybe<Loc> {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__array__get_begin_l(&self.blob) as *const Maybe<Loc>)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `begin_l` field
    pub fn set_begin_l(&mut self, begin_l: Maybe<Loc>) {
        unsafe { lib_ruby_parser__external__nodes__array__set_begin_l(&mut self.blob, begin_l.into_blob()) }
    }

    /// Returns `end_l` field
    pub fn get_end_l(&self) -> &Maybe<Loc> {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__array__get_end_l(&self.blob) as *const Maybe<Loc>)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `end_l` field
    pub fn set_end_l(&mut self, end_l: Maybe<Loc>) {
        unsafe { lib_ruby_parser__external__nodes__array__set_end_l(&mut self.blob, end_l.into_blob()) }
    }

    /// Returns `expression_l` field
    pub fn get_expression_l(&self) -> &Loc {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__array__get_expression_l(&self.blob) as *const Loc)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `expression_l` field
    pub fn set_expression_l(&mut self, expression_l: Loc) {
        unsafe { lib_ruby_parser__external__nodes__array__set_expression_l(&mut self.blob, expression_l.into_blob()) }
    }

    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> InternalArray {
        unsafe { lib_ruby_parser__external__nodes__array__into_internal(self.into_blob()) }
    }
}

extern "C" {
    fn lib_ruby_parser__external__nodes__array__get_elements(blob: *const Blob<Array>) -> *mut Blob<List<Node>>;
    fn lib_ruby_parser__external__nodes__array__set_elements(blob: *mut Blob<Array>, blob: Blob<List<Node>>);
    fn lib_ruby_parser__external__nodes__array__get_begin_l(blob: *const Blob<Array>) -> *mut Blob<Maybe<Loc>>;
    fn lib_ruby_parser__external__nodes__array__set_begin_l(blob: *mut Blob<Array>, blob: Blob<Maybe<Loc>>);
    fn lib_ruby_parser__external__nodes__array__get_end_l(blob: *const Blob<Array>) -> *mut Blob<Maybe<Loc>>;
    fn lib_ruby_parser__external__nodes__array__set_end_l(blob: *mut Blob<Array>, blob: Blob<Maybe<Loc>>);
    fn lib_ruby_parser__external__nodes__array__get_expression_l(blob: *const Blob<Array>) -> *mut Blob<Loc>;
    fn lib_ruby_parser__external__nodes__array__set_expression_l(blob: *mut Blob<Array>, blob: Blob<Loc>);
    fn lib_ruby_parser__external__nodes__array__into_internal(blob: Blob<Array>) -> InternalArray;
    fn lib_ruby_parser__external__nodes__array__drop(blob: *mut Blob<Array>);
}

impl InnerNode for Array {
    fn expression(&self) -> &Loc {
        self.get_expression_l()
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_nodes(self.get_elements());
        
        
        
        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "array"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        for node in self.get_elements().iter() {
          node.inner_ref().print_with_locs();
        }
        if let Some(loc) = self.get_begin_l().as_ref() { loc.print("begin") }
        if let Some(loc) = self.get_end_l().as_ref() { loc.print("end") }
        self.get_expression_l().print("expression");
    }
}

impl Drop for Array {
    fn drop(&mut self) {
        unsafe { lib_ruby_parser__external__nodes__array__drop(&mut self.blob) }
    }
}
