// This file is autogenerated by codegen/rust/nodes/node_file/native.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;

/// Represents `alias to from` statement.
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct Alias {
    /// Target of the `alias`.
    ///
    /// `Sym("foo")` node for `alias :foo :bar`
    pub to: Box<Node>,

    /// Source of the `alias`.
    ///
    /// `Sym("bar")` node for `alias :foo :bar`
    pub from: Box<Node>,

    /// Location of the `alias` keyword
    ///
    /// ```text
    /// alias foo bar
    /// ~~~~~
    /// ```
    pub keyword_l: Loc,

    /// Location of the full expression
    ///
    /// ```text
    /// alias foo bar
    /// ~~~~~~~~~~~~~
    /// ```
    pub expression_l: Loc,
}

impl Alias {
    #[doc(hidden)]
    pub fn get_to(&self) -> &Box<Node> {
        &self.to
    }

    #[doc(hidden)]
    pub fn get_to_mut(&mut self) -> &mut Box<Node> {
        &mut self.to
    }

    #[doc(hidden)]
    pub fn get_from(&self) -> &Box<Node> {
        &self.from
    }

    #[doc(hidden)]
    pub fn get_from_mut(&mut self) -> &mut Box<Node> {
        &mut self.from
    }

    #[doc(hidden)]
    pub fn get_keyword_l(&self) -> &Loc {
        &self.keyword_l
    }

    #[doc(hidden)]
    pub fn get_keyword_l_mut(&mut self) -> &mut Loc {
        &mut self.keyword_l
    }

    #[doc(hidden)]
    pub fn get_expression_l(&self) -> &Loc {
        &self.expression_l
    }

    #[doc(hidden)]
    pub fn get_expression_l_mut(&mut self) -> &mut Loc {
        &mut self.expression_l
    }

    #[doc(hidden)]
    pub fn set_to(&mut self, value: Box<Node>) {
        self.to = value;
    }

    #[doc(hidden)]
    pub fn set_from(&mut self, value: Box<Node>) {
        self.from = value;
    }

    #[doc(hidden)]
    pub fn set_keyword_l(&mut self, value: Loc) {
        self.keyword_l = value;
    }

    #[doc(hidden)]
    pub fn set_expression_l(&mut self, value: Loc) {
        self.expression_l = value;
    }

    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> super::InternalAlias {
        let Self { to, from, keyword_l, expression_l } = self;
        super::InternalAlias { to, from, keyword_l, expression_l }
    }
}

impl InnerNode for Alias {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_node(&self.to);
        result.push_node(&self.from);
        
        
        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "alias"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        self.to.inner_ref().print_with_locs();
        self.from.inner_ref().print_with_locs();
        self.keyword_l.print("keyword");
        self.expression_l.print("expression");
    }
}
