// This file is autogenerated by codegen/rust/nodes/node_enum/external.rs

use crate::nodes::InnerNode;
use crate::nodes::*;

use crate::Loc;
use crate::Bytes;
use crate::containers::ExternalPtr as Ptr;
use crate::containers::ExternalList as List;
use crate::containers::ExternalMaybe as Maybe;
use crate::containers::ExternalStringPtr as StringPtr;

use crate::blobs::{HasBlob, Blob};

/// Generic combination of all known nodes.
#[repr(C)]
pub struct Node {
    pub(crate) blob: Blob<Node>,
}

impl std::fmt::Debug for Node {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        if let Some(inner) = self.as_alias() {
            write!(f, "Alias({:?})", inner)
        } else if let Some(inner) = self.as_and_asgn() {
            write!(f, "AndAsgn({:?})", inner)
        } else if let Some(inner) = self.as_and() {
            write!(f, "And({:?})", inner)
        } else if let Some(inner) = self.as_arg() {
            write!(f, "Arg({:?})", inner)
        } else if let Some(inner) = self.as_args() {
            write!(f, "Args({:?})", inner)
        } else if let Some(inner) = self.as_array() {
            write!(f, "Array({:?})", inner)
        } else if let Some(inner) = self.as_array_pattern() {
            write!(f, "ArrayPattern({:?})", inner)
        } else if let Some(inner) = self.as_array_pattern_with_tail() {
            write!(f, "ArrayPatternWithTail({:?})", inner)
        } else if let Some(inner) = self.as_back_ref() {
            write!(f, "BackRef({:?})", inner)
        } else if let Some(inner) = self.as_begin() {
            write!(f, "Begin({:?})", inner)
        } else if let Some(inner) = self.as_block() {
            write!(f, "Block({:?})", inner)
        } else if let Some(inner) = self.as_block_pass() {
            write!(f, "BlockPass({:?})", inner)
        } else if let Some(inner) = self.as_blockarg() {
            write!(f, "Blockarg({:?})", inner)
        } else if let Some(inner) = self.as_break() {
            write!(f, "Break({:?})", inner)
        } else if let Some(inner) = self.as_case() {
            write!(f, "Case({:?})", inner)
        } else if let Some(inner) = self.as_case_match() {
            write!(f, "CaseMatch({:?})", inner)
        } else if let Some(inner) = self.as_casgn() {
            write!(f, "Casgn({:?})", inner)
        } else if let Some(inner) = self.as_cbase() {
            write!(f, "Cbase({:?})", inner)
        } else if let Some(inner) = self.as_class() {
            write!(f, "Class({:?})", inner)
        } else if let Some(inner) = self.as_complex() {
            write!(f, "Complex({:?})", inner)
        } else if let Some(inner) = self.as_const() {
            write!(f, "Const({:?})", inner)
        } else if let Some(inner) = self.as_const_pattern() {
            write!(f, "ConstPattern({:?})", inner)
        } else if let Some(inner) = self.as_c_send() {
            write!(f, "CSend({:?})", inner)
        } else if let Some(inner) = self.as_cvar() {
            write!(f, "Cvar({:?})", inner)
        } else if let Some(inner) = self.as_cvasgn() {
            write!(f, "Cvasgn({:?})", inner)
        } else if let Some(inner) = self.as_def() {
            write!(f, "Def({:?})", inner)
        } else if let Some(inner) = self.as_defined() {
            write!(f, "Defined({:?})", inner)
        } else if let Some(inner) = self.as_defs() {
            write!(f, "Defs({:?})", inner)
        } else if let Some(inner) = self.as_dstr() {
            write!(f, "Dstr({:?})", inner)
        } else if let Some(inner) = self.as_dsym() {
            write!(f, "Dsym({:?})", inner)
        } else if let Some(inner) = self.as_e_flip_flop() {
            write!(f, "EFlipFlop({:?})", inner)
        } else if let Some(inner) = self.as_empty_else() {
            write!(f, "EmptyElse({:?})", inner)
        } else if let Some(inner) = self.as_encoding() {
            write!(f, "Encoding({:?})", inner)
        } else if let Some(inner) = self.as_ensure() {
            write!(f, "Ensure({:?})", inner)
        } else if let Some(inner) = self.as_erange() {
            write!(f, "Erange({:?})", inner)
        } else if let Some(inner) = self.as_false() {
            write!(f, "False({:?})", inner)
        } else if let Some(inner) = self.as_file() {
            write!(f, "File({:?})", inner)
        } else if let Some(inner) = self.as_find_pattern() {
            write!(f, "FindPattern({:?})", inner)
        } else if let Some(inner) = self.as_float() {
            write!(f, "Float({:?})", inner)
        } else if let Some(inner) = self.as_for() {
            write!(f, "For({:?})", inner)
        } else if let Some(inner) = self.as_forward_arg() {
            write!(f, "ForwardArg({:?})", inner)
        } else if let Some(inner) = self.as_forwarded_args() {
            write!(f, "ForwardedArgs({:?})", inner)
        } else if let Some(inner) = self.as_gvar() {
            write!(f, "Gvar({:?})", inner)
        } else if let Some(inner) = self.as_gvasgn() {
            write!(f, "Gvasgn({:?})", inner)
        } else if let Some(inner) = self.as_hash() {
            write!(f, "Hash({:?})", inner)
        } else if let Some(inner) = self.as_kwargs() {
            write!(f, "Kwargs({:?})", inner)
        } else if let Some(inner) = self.as_hash_pattern() {
            write!(f, "HashPattern({:?})", inner)
        } else if let Some(inner) = self.as_heredoc() {
            write!(f, "Heredoc({:?})", inner)
        } else if let Some(inner) = self.as_if() {
            write!(f, "If({:?})", inner)
        } else if let Some(inner) = self.as_if_guard() {
            write!(f, "IfGuard({:?})", inner)
        } else if let Some(inner) = self.as_if_mod() {
            write!(f, "IfMod({:?})", inner)
        } else if let Some(inner) = self.as_if_ternary() {
            write!(f, "IfTernary({:?})", inner)
        } else if let Some(inner) = self.as_i_flip_flop() {
            write!(f, "IFlipFlop({:?})", inner)
        } else if let Some(inner) = self.as_match_pattern() {
            write!(f, "MatchPattern({:?})", inner)
        } else if let Some(inner) = self.as_match_pattern_p() {
            write!(f, "MatchPatternP({:?})", inner)
        } else if let Some(inner) = self.as_in_pattern() {
            write!(f, "InPattern({:?})", inner)
        } else if let Some(inner) = self.as_index() {
            write!(f, "Index({:?})", inner)
        } else if let Some(inner) = self.as_index_asgn() {
            write!(f, "IndexAsgn({:?})", inner)
        } else if let Some(inner) = self.as_int() {
            write!(f, "Int({:?})", inner)
        } else if let Some(inner) = self.as_irange() {
            write!(f, "Irange({:?})", inner)
        } else if let Some(inner) = self.as_ivar() {
            write!(f, "Ivar({:?})", inner)
        } else if let Some(inner) = self.as_ivasgn() {
            write!(f, "Ivasgn({:?})", inner)
        } else if let Some(inner) = self.as_kwarg() {
            write!(f, "Kwarg({:?})", inner)
        } else if let Some(inner) = self.as_kw_begin() {
            write!(f, "KwBegin({:?})", inner)
        } else if let Some(inner) = self.as_kwnilarg() {
            write!(f, "Kwnilarg({:?})", inner)
        } else if let Some(inner) = self.as_kwoptarg() {
            write!(f, "Kwoptarg({:?})", inner)
        } else if let Some(inner) = self.as_kwrestarg() {
            write!(f, "Kwrestarg({:?})", inner)
        } else if let Some(inner) = self.as_kwsplat() {
            write!(f, "Kwsplat({:?})", inner)
        } else if let Some(inner) = self.as_lambda() {
            write!(f, "Lambda({:?})", inner)
        } else if let Some(inner) = self.as_line() {
            write!(f, "Line({:?})", inner)
        } else if let Some(inner) = self.as_lvar() {
            write!(f, "Lvar({:?})", inner)
        } else if let Some(inner) = self.as_lvasgn() {
            write!(f, "Lvasgn({:?})", inner)
        } else if let Some(inner) = self.as_masgn() {
            write!(f, "Masgn({:?})", inner)
        } else if let Some(inner) = self.as_match_alt() {
            write!(f, "MatchAlt({:?})", inner)
        } else if let Some(inner) = self.as_match_as() {
            write!(f, "MatchAs({:?})", inner)
        } else if let Some(inner) = self.as_match_current_line() {
            write!(f, "MatchCurrentLine({:?})", inner)
        } else if let Some(inner) = self.as_match_nil_pattern() {
            write!(f, "MatchNilPattern({:?})", inner)
        } else if let Some(inner) = self.as_match_rest() {
            write!(f, "MatchRest({:?})", inner)
        } else if let Some(inner) = self.as_match_var() {
            write!(f, "MatchVar({:?})", inner)
        } else if let Some(inner) = self.as_match_with_lvasgn() {
            write!(f, "MatchWithLvasgn({:?})", inner)
        } else if let Some(inner) = self.as_mlhs() {
            write!(f, "Mlhs({:?})", inner)
        } else if let Some(inner) = self.as_module() {
            write!(f, "Module({:?})", inner)
        } else if let Some(inner) = self.as_next() {
            write!(f, "Next({:?})", inner)
        } else if let Some(inner) = self.as_nil() {
            write!(f, "Nil({:?})", inner)
        } else if let Some(inner) = self.as_nth_ref() {
            write!(f, "NthRef({:?})", inner)
        } else if let Some(inner) = self.as_numblock() {
            write!(f, "Numblock({:?})", inner)
        } else if let Some(inner) = self.as_op_asgn() {
            write!(f, "OpAsgn({:?})", inner)
        } else if let Some(inner) = self.as_optarg() {
            write!(f, "Optarg({:?})", inner)
        } else if let Some(inner) = self.as_or() {
            write!(f, "Or({:?})", inner)
        } else if let Some(inner) = self.as_or_asgn() {
            write!(f, "OrAsgn({:?})", inner)
        } else if let Some(inner) = self.as_pair() {
            write!(f, "Pair({:?})", inner)
        } else if let Some(inner) = self.as_pin() {
            write!(f, "Pin({:?})", inner)
        } else if let Some(inner) = self.as_postexe() {
            write!(f, "Postexe({:?})", inner)
        } else if let Some(inner) = self.as_preexe() {
            write!(f, "Preexe({:?})", inner)
        } else if let Some(inner) = self.as_procarg0() {
            write!(f, "Procarg0({:?})", inner)
        } else if let Some(inner) = self.as_rational() {
            write!(f, "Rational({:?})", inner)
        } else if let Some(inner) = self.as_redo() {
            write!(f, "Redo({:?})", inner)
        } else if let Some(inner) = self.as_reg_opt() {
            write!(f, "RegOpt({:?})", inner)
        } else if let Some(inner) = self.as_regexp() {
            write!(f, "Regexp({:?})", inner)
        } else if let Some(inner) = self.as_rescue() {
            write!(f, "Rescue({:?})", inner)
        } else if let Some(inner) = self.as_rescue_body() {
            write!(f, "RescueBody({:?})", inner)
        } else if let Some(inner) = self.as_restarg() {
            write!(f, "Restarg({:?})", inner)
        } else if let Some(inner) = self.as_retry() {
            write!(f, "Retry({:?})", inner)
        } else if let Some(inner) = self.as_return() {
            write!(f, "Return({:?})", inner)
        } else if let Some(inner) = self.as_s_class() {
            write!(f, "SClass({:?})", inner)
        } else if let Some(inner) = self.as_self() {
            write!(f, "Self_({:?})", inner)
        } else if let Some(inner) = self.as_send() {
            write!(f, "Send({:?})", inner)
        } else if let Some(inner) = self.as_shadowarg() {
            write!(f, "Shadowarg({:?})", inner)
        } else if let Some(inner) = self.as_splat() {
            write!(f, "Splat({:?})", inner)
        } else if let Some(inner) = self.as_str() {
            write!(f, "Str({:?})", inner)
        } else if let Some(inner) = self.as_super() {
            write!(f, "Super({:?})", inner)
        } else if let Some(inner) = self.as_sym() {
            write!(f, "Sym({:?})", inner)
        } else if let Some(inner) = self.as_true() {
            write!(f, "True({:?})", inner)
        } else if let Some(inner) = self.as_undef() {
            write!(f, "Undef({:?})", inner)
        } else if let Some(inner) = self.as_unless_guard() {
            write!(f, "UnlessGuard({:?})", inner)
        } else if let Some(inner) = self.as_until() {
            write!(f, "Until({:?})", inner)
        } else if let Some(inner) = self.as_until_post() {
            write!(f, "UntilPost({:?})", inner)
        } else if let Some(inner) = self.as_when() {
            write!(f, "When({:?})", inner)
        } else if let Some(inner) = self.as_while() {
            write!(f, "While({:?})", inner)
        } else if let Some(inner) = self.as_while_post() {
            write!(f, "WhilePost({:?})", inner)
        } else if let Some(inner) = self.as_x_heredoc() {
            write!(f, "XHeredoc({:?})", inner)
        } else if let Some(inner) = self.as_xstr() {
            write!(f, "Xstr({:?})", inner)
        } else if let Some(inner) = self.as_yield() {
            write!(f, "Yield({:?})", inner)
        } else if let Some(inner) = self.as_z_super() {
            write!(f, "ZSuper({:?})", inner)
        } else {
            panic!("bug: unknown node type")
        }
    }
}

impl Clone for Node {
    fn clone(&self) -> Self {
        if let Some(inner) = self.as_alias() {
            Self::new_alias(inner.get_to().clone(), inner.get_from().clone(), inner.get_keyword_l().clone(), inner.get_expression_l().clone())
        } else if let Some(inner) = self.as_and_asgn() {
            Self::new_and_asgn(inner.get_recv().clone(), inner.get_value().clone(), inner.get_operator_l().clone(), inner.get_expression_l().clone())
        } else if let Some(inner) = self.as_and() {
            Self::new_and(inner.get_lhs().clone(), inner.get_rhs().clone(), inner.get_operator_l().clone(), inner.get_expression_l().clone())
        } else if let Some(inner) = self.as_arg() {
            Self::new_arg(inner.get_name().clone(), inner.get_expression_l().clone())
        } else if let Some(inner) = self.as_args() {
            Self::new_args(inner.get_args().clone(), inner.get_expression_l().clone(), inner.get_begin_l().clone(), inner.get_end_l().clone())
        } else if let Some(inner) = self.as_array() {
            Self::new_array(inner.get_elements().clone(), inner.get_begin_l().clone(), inner.get_end_l().clone(), inner.get_expression_l().clone())
        } else if let Some(inner) = self.as_array_pattern() {
            Self::new_array_pattern(inner.get_elements().clone(), inner.get_begin_l().clone(), inner.get_end_l().clone(), inner.get_expression_l().clone())
        } else if let Some(inner) = self.as_array_pattern_with_tail() {
            Self::new_array_pattern_with_tail(inner.get_elements().clone(), inner.get_begin_l().clone(), inner.get_end_l().clone(), inner.get_expression_l().clone())
        } else if let Some(inner) = self.as_back_ref() {
            Self::new_back_ref(inner.get_name().clone(), inner.get_expression_l().clone())
        } else if let Some(inner) = self.as_begin() {
            Self::new_begin(inner.get_statements().clone(), inner.get_begin_l().clone(), inner.get_end_l().clone(), inner.get_expression_l().clone())
        } else if let Some(inner) = self.as_block() {
            Self::new_block(inner.get_call().clone(), inner.get_args().clone(), inner.get_body().clone(), inner.get_begin_l().clone(), inner.get_end_l().clone(), inner.get_expression_l().clone())
        } else if let Some(inner) = self.as_block_pass() {
            Self::new_block_pass(inner.get_value().clone(), inner.get_operator_l().clone(), inner.get_expression_l().clone())
        } else if let Some(inner) = self.as_blockarg() {
            Self::new_blockarg(inner.get_name().clone(), inner.get_operator_l().clone(), inner.get_name_l().clone(), inner.get_expression_l().clone())
        } else if let Some(inner) = self.as_break() {
            Self::new_break(inner.get_args().clone(), inner.get_keyword_l().clone(), inner.get_expression_l().clone())
        } else if let Some(inner) = self.as_case() {
            Self::new_case(inner.get_expr().clone(), inner.get_when_bodies().clone(), inner.get_else_body().clone(), inner.get_keyword_l().clone(), inner.get_else_l().clone(), inner.get_end_l().clone(), inner.get_expression_l().clone())
        } else if let Some(inner) = self.as_case_match() {
            Self::new_case_match(inner.get_expr().clone(), inner.get_in_bodies().clone(), inner.get_else_body().clone(), inner.get_keyword_l().clone(), inner.get_else_l().clone(), inner.get_end_l().clone(), inner.get_expression_l().clone())
        } else if let Some(inner) = self.as_casgn() {
            Self::new_casgn(inner.get_scope().clone(), inner.get_name().clone(), inner.get_value().clone(), inner.get_double_colon_l().clone(), inner.get_name_l().clone(), inner.get_operator_l().clone(), inner.get_expression_l().clone())
        } else if let Some(inner) = self.as_cbase() {
            Self::new_cbase(inner.get_expression_l().clone())
        } else if let Some(inner) = self.as_class() {
            Self::new_class(inner.get_name().clone(), inner.get_superclass().clone(), inner.get_body().clone(), inner.get_keyword_l().clone(), inner.get_operator_l().clone(), inner.get_end_l().clone(), inner.get_expression_l().clone())
        } else if let Some(inner) = self.as_complex() {
            Self::new_complex(inner.get_value().clone(), inner.get_operator_l().clone(), inner.get_expression_l().clone())
        } else if let Some(inner) = self.as_const() {
            Self::new_const(inner.get_scope().clone(), inner.get_name().clone(), inner.get_double_colon_l().clone(), inner.get_name_l().clone(), inner.get_expression_l().clone())
        } else if let Some(inner) = self.as_const_pattern() {
            Self::new_const_pattern(inner.get_const().clone(), inner.get_pattern().clone(), inner.get_begin_l().clone(), inner.get_end_l().clone(), inner.get_expression_l().clone())
        } else if let Some(inner) = self.as_c_send() {
            Self::new_c_send(inner.get_recv().clone(), inner.get_method_name().clone(), inner.get_args().clone(), inner.get_dot_l().clone(), inner.get_selector_l().clone(), inner.get_begin_l().clone(), inner.get_end_l().clone(), inner.get_operator_l().clone(), inner.get_expression_l().clone())
        } else if let Some(inner) = self.as_cvar() {
            Self::new_cvar(inner.get_name().clone(), inner.get_expression_l().clone())
        } else if let Some(inner) = self.as_cvasgn() {
            Self::new_cvasgn(inner.get_name().clone(), inner.get_value().clone(), inner.get_name_l().clone(), inner.get_operator_l().clone(), inner.get_expression_l().clone())
        } else if let Some(inner) = self.as_def() {
            Self::new_def(inner.get_name().clone(), inner.get_args().clone(), inner.get_body().clone(), inner.get_keyword_l().clone(), inner.get_name_l().clone(), inner.get_end_l().clone(), inner.get_assignment_l().clone(), inner.get_expression_l().clone())
        } else if let Some(inner) = self.as_defined() {
            Self::new_defined(inner.get_value().clone(), inner.get_keyword_l().clone(), inner.get_begin_l().clone(), inner.get_end_l().clone(), inner.get_expression_l().clone())
        } else if let Some(inner) = self.as_defs() {
            Self::new_defs(inner.get_definee().clone(), inner.get_name().clone(), inner.get_args().clone(), inner.get_body().clone(), inner.get_keyword_l().clone(), inner.get_operator_l().clone(), inner.get_name_l().clone(), inner.get_assignment_l().clone(), inner.get_end_l().clone(), inner.get_expression_l().clone())
        } else if let Some(inner) = self.as_dstr() {
            Self::new_dstr(inner.get_parts().clone(), inner.get_begin_l().clone(), inner.get_end_l().clone(), inner.get_expression_l().clone())
        } else if let Some(inner) = self.as_dsym() {
            Self::new_dsym(inner.get_parts().clone(), inner.get_begin_l().clone(), inner.get_end_l().clone(), inner.get_expression_l().clone())
        } else if let Some(inner) = self.as_e_flip_flop() {
            Self::new_e_flip_flop(inner.get_left().clone(), inner.get_right().clone(), inner.get_operator_l().clone(), inner.get_expression_l().clone())
        } else if let Some(inner) = self.as_empty_else() {
            Self::new_empty_else(inner.get_expression_l().clone())
        } else if let Some(inner) = self.as_encoding() {
            Self::new_encoding(inner.get_expression_l().clone())
        } else if let Some(inner) = self.as_ensure() {
            Self::new_ensure(inner.get_body().clone(), inner.get_ensure().clone(), inner.get_keyword_l().clone(), inner.get_expression_l().clone())
        } else if let Some(inner) = self.as_erange() {
            Self::new_erange(inner.get_left().clone(), inner.get_right().clone(), inner.get_operator_l().clone(), inner.get_expression_l().clone())
        } else if let Some(inner) = self.as_false() {
            Self::new_false(inner.get_expression_l().clone())
        } else if let Some(inner) = self.as_file() {
            Self::new_file(inner.get_expression_l().clone())
        } else if let Some(inner) = self.as_find_pattern() {
            Self::new_find_pattern(inner.get_elements().clone(), inner.get_begin_l().clone(), inner.get_end_l().clone(), inner.get_expression_l().clone())
        } else if let Some(inner) = self.as_float() {
            Self::new_float(inner.get_value().clone(), inner.get_operator_l().clone(), inner.get_expression_l().clone())
        } else if let Some(inner) = self.as_for() {
            Self::new_for(inner.get_iterator().clone(), inner.get_iteratee().clone(), inner.get_body().clone(), inner.get_keyword_l().clone(), inner.get_operator_l().clone(), inner.get_begin_l().clone(), inner.get_end_l().clone(), inner.get_expression_l().clone())
        } else if let Some(inner) = self.as_forward_arg() {
            Self::new_forward_arg(inner.get_expression_l().clone())
        } else if let Some(inner) = self.as_forwarded_args() {
            Self::new_forwarded_args(inner.get_expression_l().clone())
        } else if let Some(inner) = self.as_gvar() {
            Self::new_gvar(inner.get_name().clone(), inner.get_expression_l().clone())
        } else if let Some(inner) = self.as_gvasgn() {
            Self::new_gvasgn(inner.get_name().clone(), inner.get_value().clone(), inner.get_name_l().clone(), inner.get_operator_l().clone(), inner.get_expression_l().clone())
        } else if let Some(inner) = self.as_hash() {
            Self::new_hash(inner.get_pairs().clone(), inner.get_begin_l().clone(), inner.get_end_l().clone(), inner.get_expression_l().clone())
        } else if let Some(inner) = self.as_kwargs() {
            Self::new_kwargs(inner.get_pairs().clone(), inner.get_expression_l().clone())
        } else if let Some(inner) = self.as_hash_pattern() {
            Self::new_hash_pattern(inner.get_elements().clone(), inner.get_begin_l().clone(), inner.get_end_l().clone(), inner.get_expression_l().clone())
        } else if let Some(inner) = self.as_heredoc() {
            Self::new_heredoc(inner.get_parts().clone(), inner.get_heredoc_body_l().clone(), inner.get_heredoc_end_l().clone(), inner.get_expression_l().clone())
        } else if let Some(inner) = self.as_if() {
            Self::new_if(inner.get_cond().clone(), inner.get_if_true().clone(), inner.get_if_false().clone(), inner.get_keyword_l().clone(), inner.get_begin_l().clone(), inner.get_else_l().clone(), inner.get_end_l().clone(), inner.get_expression_l().clone())
        } else if let Some(inner) = self.as_if_guard() {
            Self::new_if_guard(inner.get_cond().clone(), inner.get_keyword_l().clone(), inner.get_expression_l().clone())
        } else if let Some(inner) = self.as_if_mod() {
            Self::new_if_mod(inner.get_cond().clone(), inner.get_if_true().clone(), inner.get_if_false().clone(), inner.get_keyword_l().clone(), inner.get_expression_l().clone())
        } else if let Some(inner) = self.as_if_ternary() {
            Self::new_if_ternary(inner.get_cond().clone(), inner.get_if_true().clone(), inner.get_if_false().clone(), inner.get_question_l().clone(), inner.get_colon_l().clone(), inner.get_expression_l().clone())
        } else if let Some(inner) = self.as_i_flip_flop() {
            Self::new_i_flip_flop(inner.get_left().clone(), inner.get_right().clone(), inner.get_operator_l().clone(), inner.get_expression_l().clone())
        } else if let Some(inner) = self.as_match_pattern() {
            Self::new_match_pattern(inner.get_value().clone(), inner.get_pattern().clone(), inner.get_operator_l().clone(), inner.get_expression_l().clone())
        } else if let Some(inner) = self.as_match_pattern_p() {
            Self::new_match_pattern_p(inner.get_value().clone(), inner.get_pattern().clone(), inner.get_operator_l().clone(), inner.get_expression_l().clone())
        } else if let Some(inner) = self.as_in_pattern() {
            Self::new_in_pattern(inner.get_pattern().clone(), inner.get_guard().clone(), inner.get_body().clone(), inner.get_keyword_l().clone(), inner.get_begin_l().clone(), inner.get_expression_l().clone())
        } else if let Some(inner) = self.as_index() {
            Self::new_index(inner.get_recv().clone(), inner.get_indexes().clone(), inner.get_begin_l().clone(), inner.get_end_l().clone(), inner.get_expression_l().clone())
        } else if let Some(inner) = self.as_index_asgn() {
            Self::new_index_asgn(inner.get_recv().clone(), inner.get_indexes().clone(), inner.get_value().clone(), inner.get_begin_l().clone(), inner.get_end_l().clone(), inner.get_operator_l().clone(), inner.get_expression_l().clone())
        } else if let Some(inner) = self.as_int() {
            Self::new_int(inner.get_value().clone(), inner.get_operator_l().clone(), inner.get_expression_l().clone())
        } else if let Some(inner) = self.as_irange() {
            Self::new_irange(inner.get_left().clone(), inner.get_right().clone(), inner.get_operator_l().clone(), inner.get_expression_l().clone())
        } else if let Some(inner) = self.as_ivar() {
            Self::new_ivar(inner.get_name().clone(), inner.get_expression_l().clone())
        } else if let Some(inner) = self.as_ivasgn() {
            Self::new_ivasgn(inner.get_name().clone(), inner.get_value().clone(), inner.get_name_l().clone(), inner.get_operator_l().clone(), inner.get_expression_l().clone())
        } else if let Some(inner) = self.as_kwarg() {
            Self::new_kwarg(inner.get_name().clone(), inner.get_name_l().clone(), inner.get_expression_l().clone())
        } else if let Some(inner) = self.as_kw_begin() {
            Self::new_kw_begin(inner.get_statements().clone(), inner.get_begin_l().clone(), inner.get_end_l().clone(), inner.get_expression_l().clone())
        } else if let Some(inner) = self.as_kwnilarg() {
            Self::new_kwnilarg(inner.get_name_l().clone(), inner.get_expression_l().clone())
        } else if let Some(inner) = self.as_kwoptarg() {
            Self::new_kwoptarg(inner.get_name().clone(), inner.get_default().clone(), inner.get_name_l().clone(), inner.get_expression_l().clone())
        } else if let Some(inner) = self.as_kwrestarg() {
            Self::new_kwrestarg(inner.get_name().clone(), inner.get_operator_l().clone(), inner.get_name_l().clone(), inner.get_expression_l().clone())
        } else if let Some(inner) = self.as_kwsplat() {
            Self::new_kwsplat(inner.get_value().clone(), inner.get_operator_l().clone(), inner.get_expression_l().clone())
        } else if let Some(inner) = self.as_lambda() {
            Self::new_lambda(inner.get_expression_l().clone())
        } else if let Some(inner) = self.as_line() {
            Self::new_line(inner.get_expression_l().clone())
        } else if let Some(inner) = self.as_lvar() {
            Self::new_lvar(inner.get_name().clone(), inner.get_expression_l().clone())
        } else if let Some(inner) = self.as_lvasgn() {
            Self::new_lvasgn(inner.get_name().clone(), inner.get_value().clone(), inner.get_name_l().clone(), inner.get_operator_l().clone(), inner.get_expression_l().clone())
        } else if let Some(inner) = self.as_masgn() {
            Self::new_masgn(inner.get_lhs().clone(), inner.get_rhs().clone(), inner.get_operator_l().clone(), inner.get_expression_l().clone())
        } else if let Some(inner) = self.as_match_alt() {
            Self::new_match_alt(inner.get_lhs().clone(), inner.get_rhs().clone(), inner.get_operator_l().clone(), inner.get_expression_l().clone())
        } else if let Some(inner) = self.as_match_as() {
            Self::new_match_as(inner.get_value().clone(), inner.get_as().clone(), inner.get_operator_l().clone(), inner.get_expression_l().clone())
        } else if let Some(inner) = self.as_match_current_line() {
            Self::new_match_current_line(inner.get_re().clone(), inner.get_expression_l().clone())
        } else if let Some(inner) = self.as_match_nil_pattern() {
            Self::new_match_nil_pattern(inner.get_operator_l().clone(), inner.get_name_l().clone(), inner.get_expression_l().clone())
        } else if let Some(inner) = self.as_match_rest() {
            Self::new_match_rest(inner.get_name().clone(), inner.get_operator_l().clone(), inner.get_expression_l().clone())
        } else if let Some(inner) = self.as_match_var() {
            Self::new_match_var(inner.get_name().clone(), inner.get_name_l().clone(), inner.get_expression_l().clone())
        } else if let Some(inner) = self.as_match_with_lvasgn() {
            Self::new_match_with_lvasgn(inner.get_re().clone(), inner.get_value().clone(), inner.get_operator_l().clone(), inner.get_expression_l().clone())
        } else if let Some(inner) = self.as_mlhs() {
            Self::new_mlhs(inner.get_items().clone(), inner.get_begin_l().clone(), inner.get_end_l().clone(), inner.get_expression_l().clone())
        } else if let Some(inner) = self.as_module() {
            Self::new_module(inner.get_name().clone(), inner.get_body().clone(), inner.get_keyword_l().clone(), inner.get_end_l().clone(), inner.get_expression_l().clone())
        } else if let Some(inner) = self.as_next() {
            Self::new_next(inner.get_args().clone(), inner.get_keyword_l().clone(), inner.get_expression_l().clone())
        } else if let Some(inner) = self.as_nil() {
            Self::new_nil(inner.get_expression_l().clone())
        } else if let Some(inner) = self.as_nth_ref() {
            Self::new_nth_ref(inner.get_name().clone(), inner.get_expression_l().clone())
        } else if let Some(inner) = self.as_numblock() {
            Self::new_numblock(inner.get_call().clone(), *inner.get_numargs(), inner.get_body().clone(), inner.get_begin_l().clone(), inner.get_end_l().clone(), inner.get_expression_l().clone())
        } else if let Some(inner) = self.as_op_asgn() {
            Self::new_op_asgn(inner.get_recv().clone(), inner.get_operator().clone(), inner.get_value().clone(), inner.get_operator_l().clone(), inner.get_expression_l().clone())
        } else if let Some(inner) = self.as_optarg() {
            Self::new_optarg(inner.get_name().clone(), inner.get_default().clone(), inner.get_name_l().clone(), inner.get_operator_l().clone(), inner.get_expression_l().clone())
        } else if let Some(inner) = self.as_or() {
            Self::new_or(inner.get_lhs().clone(), inner.get_rhs().clone(), inner.get_operator_l().clone(), inner.get_expression_l().clone())
        } else if let Some(inner) = self.as_or_asgn() {
            Self::new_or_asgn(inner.get_recv().clone(), inner.get_value().clone(), inner.get_operator_l().clone(), inner.get_expression_l().clone())
        } else if let Some(inner) = self.as_pair() {
            Self::new_pair(inner.get_key().clone(), inner.get_value().clone(), inner.get_operator_l().clone(), inner.get_expression_l().clone())
        } else if let Some(inner) = self.as_pin() {
            Self::new_pin(inner.get_var().clone(), inner.get_selector_l().clone(), inner.get_expression_l().clone())
        } else if let Some(inner) = self.as_postexe() {
            Self::new_postexe(inner.get_body().clone(), inner.get_keyword_l().clone(), inner.get_begin_l().clone(), inner.get_end_l().clone(), inner.get_expression_l().clone())
        } else if let Some(inner) = self.as_preexe() {
            Self::new_preexe(inner.get_body().clone(), inner.get_keyword_l().clone(), inner.get_begin_l().clone(), inner.get_end_l().clone(), inner.get_expression_l().clone())
        } else if let Some(inner) = self.as_procarg0() {
            Self::new_procarg0(inner.get_args().clone(), inner.get_begin_l().clone(), inner.get_end_l().clone(), inner.get_expression_l().clone())
        } else if let Some(inner) = self.as_rational() {
            Self::new_rational(inner.get_value().clone(), inner.get_operator_l().clone(), inner.get_expression_l().clone())
        } else if let Some(inner) = self.as_redo() {
            Self::new_redo(inner.get_expression_l().clone())
        } else if let Some(inner) = self.as_reg_opt() {
            Self::new_reg_opt(inner.get_options().clone(), inner.get_expression_l().clone())
        } else if let Some(inner) = self.as_regexp() {
            Self::new_regexp(inner.get_parts().clone(), inner.get_options().clone(), inner.get_begin_l().clone(), inner.get_end_l().clone(), inner.get_expression_l().clone())
        } else if let Some(inner) = self.as_rescue() {
            Self::new_rescue(inner.get_body().clone(), inner.get_rescue_bodies().clone(), inner.get_else().clone(), inner.get_else_l().clone(), inner.get_expression_l().clone())
        } else if let Some(inner) = self.as_rescue_body() {
            Self::new_rescue_body(inner.get_exc_list().clone(), inner.get_exc_var().clone(), inner.get_body().clone(), inner.get_keyword_l().clone(), inner.get_assoc_l().clone(), inner.get_begin_l().clone(), inner.get_expression_l().clone())
        } else if let Some(inner) = self.as_restarg() {
            Self::new_restarg(inner.get_name().clone(), inner.get_operator_l().clone(), inner.get_name_l().clone(), inner.get_expression_l().clone())
        } else if let Some(inner) = self.as_retry() {
            Self::new_retry(inner.get_expression_l().clone())
        } else if let Some(inner) = self.as_return() {
            Self::new_return(inner.get_args().clone(), inner.get_keyword_l().clone(), inner.get_expression_l().clone())
        } else if let Some(inner) = self.as_s_class() {
            Self::new_s_class(inner.get_expr().clone(), inner.get_body().clone(), inner.get_keyword_l().clone(), inner.get_operator_l().clone(), inner.get_end_l().clone(), inner.get_expression_l().clone())
        } else if let Some(inner) = self.as_self() {
            Self::new_self(inner.get_expression_l().clone())
        } else if let Some(inner) = self.as_send() {
            Self::new_send(inner.get_recv().clone(), inner.get_method_name().clone(), inner.get_args().clone(), inner.get_dot_l().clone(), inner.get_selector_l().clone(), inner.get_begin_l().clone(), inner.get_end_l().clone(), inner.get_operator_l().clone(), inner.get_expression_l().clone())
        } else if let Some(inner) = self.as_shadowarg() {
            Self::new_shadowarg(inner.get_name().clone(), inner.get_expression_l().clone())
        } else if let Some(inner) = self.as_splat() {
            Self::new_splat(inner.get_value().clone(), inner.get_operator_l().clone(), inner.get_expression_l().clone())
        } else if let Some(inner) = self.as_str() {
            Self::new_str(inner.get_value().clone(), inner.get_begin_l().clone(), inner.get_end_l().clone(), inner.get_expression_l().clone())
        } else if let Some(inner) = self.as_super() {
            Self::new_super(inner.get_args().clone(), inner.get_keyword_l().clone(), inner.get_begin_l().clone(), inner.get_end_l().clone(), inner.get_expression_l().clone())
        } else if let Some(inner) = self.as_sym() {
            Self::new_sym(inner.get_name().clone(), inner.get_begin_l().clone(), inner.get_end_l().clone(), inner.get_expression_l().clone())
        } else if let Some(inner) = self.as_true() {
            Self::new_true(inner.get_expression_l().clone())
        } else if let Some(inner) = self.as_undef() {
            Self::new_undef(inner.get_names().clone(), inner.get_keyword_l().clone(), inner.get_expression_l().clone())
        } else if let Some(inner) = self.as_unless_guard() {
            Self::new_unless_guard(inner.get_cond().clone(), inner.get_keyword_l().clone(), inner.get_expression_l().clone())
        } else if let Some(inner) = self.as_until() {
            Self::new_until(inner.get_cond().clone(), inner.get_body().clone(), inner.get_keyword_l().clone(), inner.get_begin_l().clone(), inner.get_end_l().clone(), inner.get_expression_l().clone())
        } else if let Some(inner) = self.as_until_post() {
            Self::new_until_post(inner.get_cond().clone(), inner.get_body().clone(), inner.get_keyword_l().clone(), inner.get_expression_l().clone())
        } else if let Some(inner) = self.as_when() {
            Self::new_when(inner.get_patterns().clone(), inner.get_body().clone(), inner.get_keyword_l().clone(), inner.get_begin_l().clone(), inner.get_expression_l().clone())
        } else if let Some(inner) = self.as_while() {
            Self::new_while(inner.get_cond().clone(), inner.get_body().clone(), inner.get_keyword_l().clone(), inner.get_begin_l().clone(), inner.get_end_l().clone(), inner.get_expression_l().clone())
        } else if let Some(inner) = self.as_while_post() {
            Self::new_while_post(inner.get_cond().clone(), inner.get_body().clone(), inner.get_keyword_l().clone(), inner.get_expression_l().clone())
        } else if let Some(inner) = self.as_x_heredoc() {
            Self::new_x_heredoc(inner.get_parts().clone(), inner.get_heredoc_body_l().clone(), inner.get_heredoc_end_l().clone(), inner.get_expression_l().clone())
        } else if let Some(inner) = self.as_xstr() {
            Self::new_xstr(inner.get_parts().clone(), inner.get_begin_l().clone(), inner.get_end_l().clone(), inner.get_expression_l().clone())
        } else if let Some(inner) = self.as_yield() {
            Self::new_yield(inner.get_args().clone(), inner.get_keyword_l().clone(), inner.get_begin_l().clone(), inner.get_end_l().clone(), inner.get_expression_l().clone())
        } else if let Some(inner) = self.as_z_super() {
            Self::new_z_super(inner.get_expression_l().clone())
        } else {
            panic!("bug: unknown node type")
        }
    }
}

impl PartialEq for Node {
    fn eq(&self, other: &Self) -> bool {
        if let Some(lhs) = self.as_alias() {
            if let Some(rhs) = other.as_alias() {
                lhs == rhs
            } else {
                false
            }
        } else if let Some(lhs) = self.as_and_asgn() {
            if let Some(rhs) = other.as_and_asgn() {
                lhs == rhs
            } else {
                false
            }
        } else if let Some(lhs) = self.as_and() {
            if let Some(rhs) = other.as_and() {
                lhs == rhs
            } else {
                false
            }
        } else if let Some(lhs) = self.as_arg() {
            if let Some(rhs) = other.as_arg() {
                lhs == rhs
            } else {
                false
            }
        } else if let Some(lhs) = self.as_args() {
            if let Some(rhs) = other.as_args() {
                lhs == rhs
            } else {
                false
            }
        } else if let Some(lhs) = self.as_array() {
            if let Some(rhs) = other.as_array() {
                lhs == rhs
            } else {
                false
            }
        } else if let Some(lhs) = self.as_array_pattern() {
            if let Some(rhs) = other.as_array_pattern() {
                lhs == rhs
            } else {
                false
            }
        } else if let Some(lhs) = self.as_array_pattern_with_tail() {
            if let Some(rhs) = other.as_array_pattern_with_tail() {
                lhs == rhs
            } else {
                false
            }
        } else if let Some(lhs) = self.as_back_ref() {
            if let Some(rhs) = other.as_back_ref() {
                lhs == rhs
            } else {
                false
            }
        } else if let Some(lhs) = self.as_begin() {
            if let Some(rhs) = other.as_begin() {
                lhs == rhs
            } else {
                false
            }
        } else if let Some(lhs) = self.as_block() {
            if let Some(rhs) = other.as_block() {
                lhs == rhs
            } else {
                false
            }
        } else if let Some(lhs) = self.as_block_pass() {
            if let Some(rhs) = other.as_block_pass() {
                lhs == rhs
            } else {
                false
            }
        } else if let Some(lhs) = self.as_blockarg() {
            if let Some(rhs) = other.as_blockarg() {
                lhs == rhs
            } else {
                false
            }
        } else if let Some(lhs) = self.as_break() {
            if let Some(rhs) = other.as_break() {
                lhs == rhs
            } else {
                false
            }
        } else if let Some(lhs) = self.as_case() {
            if let Some(rhs) = other.as_case() {
                lhs == rhs
            } else {
                false
            }
        } else if let Some(lhs) = self.as_case_match() {
            if let Some(rhs) = other.as_case_match() {
                lhs == rhs
            } else {
                false
            }
        } else if let Some(lhs) = self.as_casgn() {
            if let Some(rhs) = other.as_casgn() {
                lhs == rhs
            } else {
                false
            }
        } else if let Some(lhs) = self.as_cbase() {
            if let Some(rhs) = other.as_cbase() {
                lhs == rhs
            } else {
                false
            }
        } else if let Some(lhs) = self.as_class() {
            if let Some(rhs) = other.as_class() {
                lhs == rhs
            } else {
                false
            }
        } else if let Some(lhs) = self.as_complex() {
            if let Some(rhs) = other.as_complex() {
                lhs == rhs
            } else {
                false
            }
        } else if let Some(lhs) = self.as_const() {
            if let Some(rhs) = other.as_const() {
                lhs == rhs
            } else {
                false
            }
        } else if let Some(lhs) = self.as_const_pattern() {
            if let Some(rhs) = other.as_const_pattern() {
                lhs == rhs
            } else {
                false
            }
        } else if let Some(lhs) = self.as_c_send() {
            if let Some(rhs) = other.as_c_send() {
                lhs == rhs
            } else {
                false
            }
        } else if let Some(lhs) = self.as_cvar() {
            if let Some(rhs) = other.as_cvar() {
                lhs == rhs
            } else {
                false
            }
        } else if let Some(lhs) = self.as_cvasgn() {
            if let Some(rhs) = other.as_cvasgn() {
                lhs == rhs
            } else {
                false
            }
        } else if let Some(lhs) = self.as_def() {
            if let Some(rhs) = other.as_def() {
                lhs == rhs
            } else {
                false
            }
        } else if let Some(lhs) = self.as_defined() {
            if let Some(rhs) = other.as_defined() {
                lhs == rhs
            } else {
                false
            }
        } else if let Some(lhs) = self.as_defs() {
            if let Some(rhs) = other.as_defs() {
                lhs == rhs
            } else {
                false
            }
        } else if let Some(lhs) = self.as_dstr() {
            if let Some(rhs) = other.as_dstr() {
                lhs == rhs
            } else {
                false
            }
        } else if let Some(lhs) = self.as_dsym() {
            if let Some(rhs) = other.as_dsym() {
                lhs == rhs
            } else {
                false
            }
        } else if let Some(lhs) = self.as_e_flip_flop() {
            if let Some(rhs) = other.as_e_flip_flop() {
                lhs == rhs
            } else {
                false
            }
        } else if let Some(lhs) = self.as_empty_else() {
            if let Some(rhs) = other.as_empty_else() {
                lhs == rhs
            } else {
                false
            }
        } else if let Some(lhs) = self.as_encoding() {
            if let Some(rhs) = other.as_encoding() {
                lhs == rhs
            } else {
                false
            }
        } else if let Some(lhs) = self.as_ensure() {
            if let Some(rhs) = other.as_ensure() {
                lhs == rhs
            } else {
                false
            }
        } else if let Some(lhs) = self.as_erange() {
            if let Some(rhs) = other.as_erange() {
                lhs == rhs
            } else {
                false
            }
        } else if let Some(lhs) = self.as_false() {
            if let Some(rhs) = other.as_false() {
                lhs == rhs
            } else {
                false
            }
        } else if let Some(lhs) = self.as_file() {
            if let Some(rhs) = other.as_file() {
                lhs == rhs
            } else {
                false
            }
        } else if let Some(lhs) = self.as_find_pattern() {
            if let Some(rhs) = other.as_find_pattern() {
                lhs == rhs
            } else {
                false
            }
        } else if let Some(lhs) = self.as_float() {
            if let Some(rhs) = other.as_float() {
                lhs == rhs
            } else {
                false
            }
        } else if let Some(lhs) = self.as_for() {
            if let Some(rhs) = other.as_for() {
                lhs == rhs
            } else {
                false
            }
        } else if let Some(lhs) = self.as_forward_arg() {
            if let Some(rhs) = other.as_forward_arg() {
                lhs == rhs
            } else {
                false
            }
        } else if let Some(lhs) = self.as_forwarded_args() {
            if let Some(rhs) = other.as_forwarded_args() {
                lhs == rhs
            } else {
                false
            }
        } else if let Some(lhs) = self.as_gvar() {
            if let Some(rhs) = other.as_gvar() {
                lhs == rhs
            } else {
                false
            }
        } else if let Some(lhs) = self.as_gvasgn() {
            if let Some(rhs) = other.as_gvasgn() {
                lhs == rhs
            } else {
                false
            }
        } else if let Some(lhs) = self.as_hash() {
            if let Some(rhs) = other.as_hash() {
                lhs == rhs
            } else {
                false
            }
        } else if let Some(lhs) = self.as_kwargs() {
            if let Some(rhs) = other.as_kwargs() {
                lhs == rhs
            } else {
                false
            }
        } else if let Some(lhs) = self.as_hash_pattern() {
            if let Some(rhs) = other.as_hash_pattern() {
                lhs == rhs
            } else {
                false
            }
        } else if let Some(lhs) = self.as_heredoc() {
            if let Some(rhs) = other.as_heredoc() {
                lhs == rhs
            } else {
                false
            }
        } else if let Some(lhs) = self.as_if() {
            if let Some(rhs) = other.as_if() {
                lhs == rhs
            } else {
                false
            }
        } else if let Some(lhs) = self.as_if_guard() {
            if let Some(rhs) = other.as_if_guard() {
                lhs == rhs
            } else {
                false
            }
        } else if let Some(lhs) = self.as_if_mod() {
            if let Some(rhs) = other.as_if_mod() {
                lhs == rhs
            } else {
                false
            }
        } else if let Some(lhs) = self.as_if_ternary() {
            if let Some(rhs) = other.as_if_ternary() {
                lhs == rhs
            } else {
                false
            }
        } else if let Some(lhs) = self.as_i_flip_flop() {
            if let Some(rhs) = other.as_i_flip_flop() {
                lhs == rhs
            } else {
                false
            }
        } else if let Some(lhs) = self.as_match_pattern() {
            if let Some(rhs) = other.as_match_pattern() {
                lhs == rhs
            } else {
                false
            }
        } else if let Some(lhs) = self.as_match_pattern_p() {
            if let Some(rhs) = other.as_match_pattern_p() {
                lhs == rhs
            } else {
                false
            }
        } else if let Some(lhs) = self.as_in_pattern() {
            if let Some(rhs) = other.as_in_pattern() {
                lhs == rhs
            } else {
                false
            }
        } else if let Some(lhs) = self.as_index() {
            if let Some(rhs) = other.as_index() {
                lhs == rhs
            } else {
                false
            }
        } else if let Some(lhs) = self.as_index_asgn() {
            if let Some(rhs) = other.as_index_asgn() {
                lhs == rhs
            } else {
                false
            }
        } else if let Some(lhs) = self.as_int() {
            if let Some(rhs) = other.as_int() {
                lhs == rhs
            } else {
                false
            }
        } else if let Some(lhs) = self.as_irange() {
            if let Some(rhs) = other.as_irange() {
                lhs == rhs
            } else {
                false
            }
        } else if let Some(lhs) = self.as_ivar() {
            if let Some(rhs) = other.as_ivar() {
                lhs == rhs
            } else {
                false
            }
        } else if let Some(lhs) = self.as_ivasgn() {
            if let Some(rhs) = other.as_ivasgn() {
                lhs == rhs
            } else {
                false
            }
        } else if let Some(lhs) = self.as_kwarg() {
            if let Some(rhs) = other.as_kwarg() {
                lhs == rhs
            } else {
                false
            }
        } else if let Some(lhs) = self.as_kw_begin() {
            if let Some(rhs) = other.as_kw_begin() {
                lhs == rhs
            } else {
                false
            }
        } else if let Some(lhs) = self.as_kwnilarg() {
            if let Some(rhs) = other.as_kwnilarg() {
                lhs == rhs
            } else {
                false
            }
        } else if let Some(lhs) = self.as_kwoptarg() {
            if let Some(rhs) = other.as_kwoptarg() {
                lhs == rhs
            } else {
                false
            }
        } else if let Some(lhs) = self.as_kwrestarg() {
            if let Some(rhs) = other.as_kwrestarg() {
                lhs == rhs
            } else {
                false
            }
        } else if let Some(lhs) = self.as_kwsplat() {
            if let Some(rhs) = other.as_kwsplat() {
                lhs == rhs
            } else {
                false
            }
        } else if let Some(lhs) = self.as_lambda() {
            if let Some(rhs) = other.as_lambda() {
                lhs == rhs
            } else {
                false
            }
        } else if let Some(lhs) = self.as_line() {
            if let Some(rhs) = other.as_line() {
                lhs == rhs
            } else {
                false
            }
        } else if let Some(lhs) = self.as_lvar() {
            if let Some(rhs) = other.as_lvar() {
                lhs == rhs
            } else {
                false
            }
        } else if let Some(lhs) = self.as_lvasgn() {
            if let Some(rhs) = other.as_lvasgn() {
                lhs == rhs
            } else {
                false
            }
        } else if let Some(lhs) = self.as_masgn() {
            if let Some(rhs) = other.as_masgn() {
                lhs == rhs
            } else {
                false
            }
        } else if let Some(lhs) = self.as_match_alt() {
            if let Some(rhs) = other.as_match_alt() {
                lhs == rhs
            } else {
                false
            }
        } else if let Some(lhs) = self.as_match_as() {
            if let Some(rhs) = other.as_match_as() {
                lhs == rhs
            } else {
                false
            }
        } else if let Some(lhs) = self.as_match_current_line() {
            if let Some(rhs) = other.as_match_current_line() {
                lhs == rhs
            } else {
                false
            }
        } else if let Some(lhs) = self.as_match_nil_pattern() {
            if let Some(rhs) = other.as_match_nil_pattern() {
                lhs == rhs
            } else {
                false
            }
        } else if let Some(lhs) = self.as_match_rest() {
            if let Some(rhs) = other.as_match_rest() {
                lhs == rhs
            } else {
                false
            }
        } else if let Some(lhs) = self.as_match_var() {
            if let Some(rhs) = other.as_match_var() {
                lhs == rhs
            } else {
                false
            }
        } else if let Some(lhs) = self.as_match_with_lvasgn() {
            if let Some(rhs) = other.as_match_with_lvasgn() {
                lhs == rhs
            } else {
                false
            }
        } else if let Some(lhs) = self.as_mlhs() {
            if let Some(rhs) = other.as_mlhs() {
                lhs == rhs
            } else {
                false
            }
        } else if let Some(lhs) = self.as_module() {
            if let Some(rhs) = other.as_module() {
                lhs == rhs
            } else {
                false
            }
        } else if let Some(lhs) = self.as_next() {
            if let Some(rhs) = other.as_next() {
                lhs == rhs
            } else {
                false
            }
        } else if let Some(lhs) = self.as_nil() {
            if let Some(rhs) = other.as_nil() {
                lhs == rhs
            } else {
                false
            }
        } else if let Some(lhs) = self.as_nth_ref() {
            if let Some(rhs) = other.as_nth_ref() {
                lhs == rhs
            } else {
                false
            }
        } else if let Some(lhs) = self.as_numblock() {
            if let Some(rhs) = other.as_numblock() {
                lhs == rhs
            } else {
                false
            }
        } else if let Some(lhs) = self.as_op_asgn() {
            if let Some(rhs) = other.as_op_asgn() {
                lhs == rhs
            } else {
                false
            }
        } else if let Some(lhs) = self.as_optarg() {
            if let Some(rhs) = other.as_optarg() {
                lhs == rhs
            } else {
                false
            }
        } else if let Some(lhs) = self.as_or() {
            if let Some(rhs) = other.as_or() {
                lhs == rhs
            } else {
                false
            }
        } else if let Some(lhs) = self.as_or_asgn() {
            if let Some(rhs) = other.as_or_asgn() {
                lhs == rhs
            } else {
                false
            }
        } else if let Some(lhs) = self.as_pair() {
            if let Some(rhs) = other.as_pair() {
                lhs == rhs
            } else {
                false
            }
        } else if let Some(lhs) = self.as_pin() {
            if let Some(rhs) = other.as_pin() {
                lhs == rhs
            } else {
                false
            }
        } else if let Some(lhs) = self.as_postexe() {
            if let Some(rhs) = other.as_postexe() {
                lhs == rhs
            } else {
                false
            }
        } else if let Some(lhs) = self.as_preexe() {
            if let Some(rhs) = other.as_preexe() {
                lhs == rhs
            } else {
                false
            }
        } else if let Some(lhs) = self.as_procarg0() {
            if let Some(rhs) = other.as_procarg0() {
                lhs == rhs
            } else {
                false
            }
        } else if let Some(lhs) = self.as_rational() {
            if let Some(rhs) = other.as_rational() {
                lhs == rhs
            } else {
                false
            }
        } else if let Some(lhs) = self.as_redo() {
            if let Some(rhs) = other.as_redo() {
                lhs == rhs
            } else {
                false
            }
        } else if let Some(lhs) = self.as_reg_opt() {
            if let Some(rhs) = other.as_reg_opt() {
                lhs == rhs
            } else {
                false
            }
        } else if let Some(lhs) = self.as_regexp() {
            if let Some(rhs) = other.as_regexp() {
                lhs == rhs
            } else {
                false
            }
        } else if let Some(lhs) = self.as_rescue() {
            if let Some(rhs) = other.as_rescue() {
                lhs == rhs
            } else {
                false
            }
        } else if let Some(lhs) = self.as_rescue_body() {
            if let Some(rhs) = other.as_rescue_body() {
                lhs == rhs
            } else {
                false
            }
        } else if let Some(lhs) = self.as_restarg() {
            if let Some(rhs) = other.as_restarg() {
                lhs == rhs
            } else {
                false
            }
        } else if let Some(lhs) = self.as_retry() {
            if let Some(rhs) = other.as_retry() {
                lhs == rhs
            } else {
                false
            }
        } else if let Some(lhs) = self.as_return() {
            if let Some(rhs) = other.as_return() {
                lhs == rhs
            } else {
                false
            }
        } else if let Some(lhs) = self.as_s_class() {
            if let Some(rhs) = other.as_s_class() {
                lhs == rhs
            } else {
                false
            }
        } else if let Some(lhs) = self.as_self() {
            if let Some(rhs) = other.as_self() {
                lhs == rhs
            } else {
                false
            }
        } else if let Some(lhs) = self.as_send() {
            if let Some(rhs) = other.as_send() {
                lhs == rhs
            } else {
                false
            }
        } else if let Some(lhs) = self.as_shadowarg() {
            if let Some(rhs) = other.as_shadowarg() {
                lhs == rhs
            } else {
                false
            }
        } else if let Some(lhs) = self.as_splat() {
            if let Some(rhs) = other.as_splat() {
                lhs == rhs
            } else {
                false
            }
        } else if let Some(lhs) = self.as_str() {
            if let Some(rhs) = other.as_str() {
                lhs == rhs
            } else {
                false
            }
        } else if let Some(lhs) = self.as_super() {
            if let Some(rhs) = other.as_super() {
                lhs == rhs
            } else {
                false
            }
        } else if let Some(lhs) = self.as_sym() {
            if let Some(rhs) = other.as_sym() {
                lhs == rhs
            } else {
                false
            }
        } else if let Some(lhs) = self.as_true() {
            if let Some(rhs) = other.as_true() {
                lhs == rhs
            } else {
                false
            }
        } else if let Some(lhs) = self.as_undef() {
            if let Some(rhs) = other.as_undef() {
                lhs == rhs
            } else {
                false
            }
        } else if let Some(lhs) = self.as_unless_guard() {
            if let Some(rhs) = other.as_unless_guard() {
                lhs == rhs
            } else {
                false
            }
        } else if let Some(lhs) = self.as_until() {
            if let Some(rhs) = other.as_until() {
                lhs == rhs
            } else {
                false
            }
        } else if let Some(lhs) = self.as_until_post() {
            if let Some(rhs) = other.as_until_post() {
                lhs == rhs
            } else {
                false
            }
        } else if let Some(lhs) = self.as_when() {
            if let Some(rhs) = other.as_when() {
                lhs == rhs
            } else {
                false
            }
        } else if let Some(lhs) = self.as_while() {
            if let Some(rhs) = other.as_while() {
                lhs == rhs
            } else {
                false
            }
        } else if let Some(lhs) = self.as_while_post() {
            if let Some(rhs) = other.as_while_post() {
                lhs == rhs
            } else {
                false
            }
        } else if let Some(lhs) = self.as_x_heredoc() {
            if let Some(rhs) = other.as_x_heredoc() {
                lhs == rhs
            } else {
                false
            }
        } else if let Some(lhs) = self.as_xstr() {
            if let Some(rhs) = other.as_xstr() {
                lhs == rhs
            } else {
                false
            }
        } else if let Some(lhs) = self.as_yield() {
            if let Some(rhs) = other.as_yield() {
                lhs == rhs
            } else {
                false
            }
        } else if let Some(lhs) = self.as_z_super() {
            if let Some(rhs) = other.as_z_super() {
                lhs == rhs
            } else {
                false
            }
        } else {
            panic!("bug: unknown node type")
        }
    }
}

impl Node {
    pub(crate) fn inner_ref(&self) -> &dyn InnerNode {
        if let Some(inner) = self.as_alias() {
            return inner;
        }
        if let Some(inner) = self.as_and_asgn() {
            return inner;
        }
        if let Some(inner) = self.as_and() {
            return inner;
        }
        if let Some(inner) = self.as_arg() {
            return inner;
        }
        if let Some(inner) = self.as_args() {
            return inner;
        }
        if let Some(inner) = self.as_array() {
            return inner;
        }
        if let Some(inner) = self.as_array_pattern() {
            return inner;
        }
        if let Some(inner) = self.as_array_pattern_with_tail() {
            return inner;
        }
        if let Some(inner) = self.as_back_ref() {
            return inner;
        }
        if let Some(inner) = self.as_begin() {
            return inner;
        }
        if let Some(inner) = self.as_block() {
            return inner;
        }
        if let Some(inner) = self.as_block_pass() {
            return inner;
        }
        if let Some(inner) = self.as_blockarg() {
            return inner;
        }
        if let Some(inner) = self.as_break() {
            return inner;
        }
        if let Some(inner) = self.as_case() {
            return inner;
        }
        if let Some(inner) = self.as_case_match() {
            return inner;
        }
        if let Some(inner) = self.as_casgn() {
            return inner;
        }
        if let Some(inner) = self.as_cbase() {
            return inner;
        }
        if let Some(inner) = self.as_class() {
            return inner;
        }
        if let Some(inner) = self.as_complex() {
            return inner;
        }
        if let Some(inner) = self.as_const() {
            return inner;
        }
        if let Some(inner) = self.as_const_pattern() {
            return inner;
        }
        if let Some(inner) = self.as_c_send() {
            return inner;
        }
        if let Some(inner) = self.as_cvar() {
            return inner;
        }
        if let Some(inner) = self.as_cvasgn() {
            return inner;
        }
        if let Some(inner) = self.as_def() {
            return inner;
        }
        if let Some(inner) = self.as_defined() {
            return inner;
        }
        if let Some(inner) = self.as_defs() {
            return inner;
        }
        if let Some(inner) = self.as_dstr() {
            return inner;
        }
        if let Some(inner) = self.as_dsym() {
            return inner;
        }
        if let Some(inner) = self.as_e_flip_flop() {
            return inner;
        }
        if let Some(inner) = self.as_empty_else() {
            return inner;
        }
        if let Some(inner) = self.as_encoding() {
            return inner;
        }
        if let Some(inner) = self.as_ensure() {
            return inner;
        }
        if let Some(inner) = self.as_erange() {
            return inner;
        }
        if let Some(inner) = self.as_false() {
            return inner;
        }
        if let Some(inner) = self.as_file() {
            return inner;
        }
        if let Some(inner) = self.as_find_pattern() {
            return inner;
        }
        if let Some(inner) = self.as_float() {
            return inner;
        }
        if let Some(inner) = self.as_for() {
            return inner;
        }
        if let Some(inner) = self.as_forward_arg() {
            return inner;
        }
        if let Some(inner) = self.as_forwarded_args() {
            return inner;
        }
        if let Some(inner) = self.as_gvar() {
            return inner;
        }
        if let Some(inner) = self.as_gvasgn() {
            return inner;
        }
        if let Some(inner) = self.as_hash() {
            return inner;
        }
        if let Some(inner) = self.as_kwargs() {
            return inner;
        }
        if let Some(inner) = self.as_hash_pattern() {
            return inner;
        }
        if let Some(inner) = self.as_heredoc() {
            return inner;
        }
        if let Some(inner) = self.as_if() {
            return inner;
        }
        if let Some(inner) = self.as_if_guard() {
            return inner;
        }
        if let Some(inner) = self.as_if_mod() {
            return inner;
        }
        if let Some(inner) = self.as_if_ternary() {
            return inner;
        }
        if let Some(inner) = self.as_i_flip_flop() {
            return inner;
        }
        if let Some(inner) = self.as_match_pattern() {
            return inner;
        }
        if let Some(inner) = self.as_match_pattern_p() {
            return inner;
        }
        if let Some(inner) = self.as_in_pattern() {
            return inner;
        }
        if let Some(inner) = self.as_index() {
            return inner;
        }
        if let Some(inner) = self.as_index_asgn() {
            return inner;
        }
        if let Some(inner) = self.as_int() {
            return inner;
        }
        if let Some(inner) = self.as_irange() {
            return inner;
        }
        if let Some(inner) = self.as_ivar() {
            return inner;
        }
        if let Some(inner) = self.as_ivasgn() {
            return inner;
        }
        if let Some(inner) = self.as_kwarg() {
            return inner;
        }
        if let Some(inner) = self.as_kw_begin() {
            return inner;
        }
        if let Some(inner) = self.as_kwnilarg() {
            return inner;
        }
        if let Some(inner) = self.as_kwoptarg() {
            return inner;
        }
        if let Some(inner) = self.as_kwrestarg() {
            return inner;
        }
        if let Some(inner) = self.as_kwsplat() {
            return inner;
        }
        if let Some(inner) = self.as_lambda() {
            return inner;
        }
        if let Some(inner) = self.as_line() {
            return inner;
        }
        if let Some(inner) = self.as_lvar() {
            return inner;
        }
        if let Some(inner) = self.as_lvasgn() {
            return inner;
        }
        if let Some(inner) = self.as_masgn() {
            return inner;
        }
        if let Some(inner) = self.as_match_alt() {
            return inner;
        }
        if let Some(inner) = self.as_match_as() {
            return inner;
        }
        if let Some(inner) = self.as_match_current_line() {
            return inner;
        }
        if let Some(inner) = self.as_match_nil_pattern() {
            return inner;
        }
        if let Some(inner) = self.as_match_rest() {
            return inner;
        }
        if let Some(inner) = self.as_match_var() {
            return inner;
        }
        if let Some(inner) = self.as_match_with_lvasgn() {
            return inner;
        }
        if let Some(inner) = self.as_mlhs() {
            return inner;
        }
        if let Some(inner) = self.as_module() {
            return inner;
        }
        if let Some(inner) = self.as_next() {
            return inner;
        }
        if let Some(inner) = self.as_nil() {
            return inner;
        }
        if let Some(inner) = self.as_nth_ref() {
            return inner;
        }
        if let Some(inner) = self.as_numblock() {
            return inner;
        }
        if let Some(inner) = self.as_op_asgn() {
            return inner;
        }
        if let Some(inner) = self.as_optarg() {
            return inner;
        }
        if let Some(inner) = self.as_or() {
            return inner;
        }
        if let Some(inner) = self.as_or_asgn() {
            return inner;
        }
        if let Some(inner) = self.as_pair() {
            return inner;
        }
        if let Some(inner) = self.as_pin() {
            return inner;
        }
        if let Some(inner) = self.as_postexe() {
            return inner;
        }
        if let Some(inner) = self.as_preexe() {
            return inner;
        }
        if let Some(inner) = self.as_procarg0() {
            return inner;
        }
        if let Some(inner) = self.as_rational() {
            return inner;
        }
        if let Some(inner) = self.as_redo() {
            return inner;
        }
        if let Some(inner) = self.as_reg_opt() {
            return inner;
        }
        if let Some(inner) = self.as_regexp() {
            return inner;
        }
        if let Some(inner) = self.as_rescue() {
            return inner;
        }
        if let Some(inner) = self.as_rescue_body() {
            return inner;
        }
        if let Some(inner) = self.as_restarg() {
            return inner;
        }
        if let Some(inner) = self.as_retry() {
            return inner;
        }
        if let Some(inner) = self.as_return() {
            return inner;
        }
        if let Some(inner) = self.as_s_class() {
            return inner;
        }
        if let Some(inner) = self.as_self() {
            return inner;
        }
        if let Some(inner) = self.as_send() {
            return inner;
        }
        if let Some(inner) = self.as_shadowarg() {
            return inner;
        }
        if let Some(inner) = self.as_splat() {
            return inner;
        }
        if let Some(inner) = self.as_str() {
            return inner;
        }
        if let Some(inner) = self.as_super() {
            return inner;
        }
        if let Some(inner) = self.as_sym() {
            return inner;
        }
        if let Some(inner) = self.as_true() {
            return inner;
        }
        if let Some(inner) = self.as_undef() {
            return inner;
        }
        if let Some(inner) = self.as_unless_guard() {
            return inner;
        }
        if let Some(inner) = self.as_until() {
            return inner;
        }
        if let Some(inner) = self.as_until_post() {
            return inner;
        }
        if let Some(inner) = self.as_when() {
            return inner;
        }
        if let Some(inner) = self.as_while() {
            return inner;
        }
        if let Some(inner) = self.as_while_post() {
            return inner;
        }
        if let Some(inner) = self.as_x_heredoc() {
            return inner;
        }
        if let Some(inner) = self.as_xstr() {
            return inner;
        }
        if let Some(inner) = self.as_yield() {
            return inner;
        }
        if let Some(inner) = self.as_z_super() {
            return inner;
        }

        panic!("bug: unknown node type")
    }

    // new_<node> FNs
    /// Constructs `Node::Alias` variant
    pub(crate) fn new_alias(to: Ptr<Node>, from: Ptr<Node>, keyword_l: Loc, expression_l: Loc) -> Self {
        let blob = unsafe { lib_ruby_parser__external__nodes__new_alias(to.into_blob(), from.into_blob(), keyword_l.into_blob(), expression_l.into_blob()) };
        Self { blob }
    }
    /// Constructs `Node::AndAsgn` variant
    pub(crate) fn new_and_asgn(recv: Ptr<Node>, value: Ptr<Node>, operator_l: Loc, expression_l: Loc) -> Self {
        let blob = unsafe { lib_ruby_parser__external__nodes__new_and_asgn(recv.into_blob(), value.into_blob(), operator_l.into_blob(), expression_l.into_blob()) };
        Self { blob }
    }
    /// Constructs `Node::And` variant
    pub(crate) fn new_and(lhs: Ptr<Node>, rhs: Ptr<Node>, operator_l: Loc, expression_l: Loc) -> Self {
        let blob = unsafe { lib_ruby_parser__external__nodes__new_and(lhs.into_blob(), rhs.into_blob(), operator_l.into_blob(), expression_l.into_blob()) };
        Self { blob }
    }
    /// Constructs `Node::Arg` variant
    pub(crate) fn new_arg(name: StringPtr, expression_l: Loc) -> Self {
        let blob = unsafe { lib_ruby_parser__external__nodes__new_arg(name.into_blob(), expression_l.into_blob()) };
        Self { blob }
    }
    /// Constructs `Node::Args` variant
    pub(crate) fn new_args(args: List<Node>, expression_l: Loc, begin_l: Maybe<Loc>, end_l: Maybe<Loc>) -> Self {
        let blob = unsafe { lib_ruby_parser__external__nodes__new_args(args.into_blob(), expression_l.into_blob(), begin_l.into_blob(), end_l.into_blob()) };
        Self { blob }
    }
    /// Constructs `Node::Array` variant
    pub(crate) fn new_array(elements: List<Node>, begin_l: Maybe<Loc>, end_l: Maybe<Loc>, expression_l: Loc) -> Self {
        let blob = unsafe { lib_ruby_parser__external__nodes__new_array(elements.into_blob(), begin_l.into_blob(), end_l.into_blob(), expression_l.into_blob()) };
        Self { blob }
    }
    /// Constructs `Node::ArrayPattern` variant
    pub(crate) fn new_array_pattern(elements: List<Node>, begin_l: Maybe<Loc>, end_l: Maybe<Loc>, expression_l: Loc) -> Self {
        let blob = unsafe { lib_ruby_parser__external__nodes__new_array_pattern(elements.into_blob(), begin_l.into_blob(), end_l.into_blob(), expression_l.into_blob()) };
        Self { blob }
    }
    /// Constructs `Node::ArrayPatternWithTail` variant
    pub(crate) fn new_array_pattern_with_tail(elements: List<Node>, begin_l: Maybe<Loc>, end_l: Maybe<Loc>, expression_l: Loc) -> Self {
        let blob = unsafe { lib_ruby_parser__external__nodes__new_array_pattern_with_tail(elements.into_blob(), begin_l.into_blob(), end_l.into_blob(), expression_l.into_blob()) };
        Self { blob }
    }
    /// Constructs `Node::BackRef` variant
    pub(crate) fn new_back_ref(name: StringPtr, expression_l: Loc) -> Self {
        let blob = unsafe { lib_ruby_parser__external__nodes__new_back_ref(name.into_blob(), expression_l.into_blob()) };
        Self { blob }
    }
    /// Constructs `Node::Begin` variant
    pub(crate) fn new_begin(statements: List<Node>, begin_l: Maybe<Loc>, end_l: Maybe<Loc>, expression_l: Loc) -> Self {
        let blob = unsafe { lib_ruby_parser__external__nodes__new_begin(statements.into_blob(), begin_l.into_blob(), end_l.into_blob(), expression_l.into_blob()) };
        Self { blob }
    }
    /// Constructs `Node::Block` variant
    pub(crate) fn new_block(call: Ptr<Node>, args: Maybe<Ptr<Node>>, body: Maybe<Ptr<Node>>, begin_l: Loc, end_l: Loc, expression_l: Loc) -> Self {
        let blob = unsafe { lib_ruby_parser__external__nodes__new_block(call.into_blob(), args.into_blob(), body.into_blob(), begin_l.into_blob(), end_l.into_blob(), expression_l.into_blob()) };
        Self { blob }
    }
    /// Constructs `Node::BlockPass` variant
    pub(crate) fn new_block_pass(value: Ptr<Node>, operator_l: Loc, expression_l: Loc) -> Self {
        let blob = unsafe { lib_ruby_parser__external__nodes__new_block_pass(value.into_blob(), operator_l.into_blob(), expression_l.into_blob()) };
        Self { blob }
    }
    /// Constructs `Node::Blockarg` variant
    pub(crate) fn new_blockarg(name: StringPtr, operator_l: Loc, name_l: Loc, expression_l: Loc) -> Self {
        let blob = unsafe { lib_ruby_parser__external__nodes__new_blockarg(name.into_blob(), operator_l.into_blob(), name_l.into_blob(), expression_l.into_blob()) };
        Self { blob }
    }
    /// Constructs `Node::Break` variant
    pub(crate) fn new_break(args: List<Node>, keyword_l: Loc, expression_l: Loc) -> Self {
        let blob = unsafe { lib_ruby_parser__external__nodes__new_break(args.into_blob(), keyword_l.into_blob(), expression_l.into_blob()) };
        Self { blob }
    }
    /// Constructs `Node::Case` variant
    pub(crate) fn new_case(expr: Maybe<Ptr<Node>>, when_bodies: List<Node>, else_body: Maybe<Ptr<Node>>, keyword_l: Loc, else_l: Maybe<Loc>, end_l: Loc, expression_l: Loc) -> Self {
        let blob = unsafe { lib_ruby_parser__external__nodes__new_case(expr.into_blob(), when_bodies.into_blob(), else_body.into_blob(), keyword_l.into_blob(), else_l.into_blob(), end_l.into_blob(), expression_l.into_blob()) };
        Self { blob }
    }
    /// Constructs `Node::CaseMatch` variant
    pub(crate) fn new_case_match(expr: Ptr<Node>, in_bodies: List<Node>, else_body: Maybe<Ptr<Node>>, keyword_l: Loc, else_l: Maybe<Loc>, end_l: Loc, expression_l: Loc) -> Self {
        let blob = unsafe { lib_ruby_parser__external__nodes__new_case_match(expr.into_blob(), in_bodies.into_blob(), else_body.into_blob(), keyword_l.into_blob(), else_l.into_blob(), end_l.into_blob(), expression_l.into_blob()) };
        Self { blob }
    }
    /// Constructs `Node::Casgn` variant
    pub(crate) fn new_casgn(scope: Maybe<Ptr<Node>>, name: StringPtr, value: Maybe<Ptr<Node>>, double_colon_l: Maybe<Loc>, name_l: Loc, operator_l: Maybe<Loc>, expression_l: Loc) -> Self {
        let blob = unsafe { lib_ruby_parser__external__nodes__new_casgn(scope.into_blob(), name.into_blob(), value.into_blob(), double_colon_l.into_blob(), name_l.into_blob(), operator_l.into_blob(), expression_l.into_blob()) };
        Self { blob }
    }
    /// Constructs `Node::Cbase` variant
    pub(crate) fn new_cbase(expression_l: Loc) -> Self {
        let blob = unsafe { lib_ruby_parser__external__nodes__new_cbase(expression_l.into_blob()) };
        Self { blob }
    }
    /// Constructs `Node::Class` variant
    pub(crate) fn new_class(name: Ptr<Node>, superclass: Maybe<Ptr<Node>>, body: Maybe<Ptr<Node>>, keyword_l: Loc, operator_l: Maybe<Loc>, end_l: Loc, expression_l: Loc) -> Self {
        let blob = unsafe { lib_ruby_parser__external__nodes__new_class(name.into_blob(), superclass.into_blob(), body.into_blob(), keyword_l.into_blob(), operator_l.into_blob(), end_l.into_blob(), expression_l.into_blob()) };
        Self { blob }
    }
    /// Constructs `Node::Complex` variant
    pub(crate) fn new_complex(value: StringPtr, operator_l: Maybe<Loc>, expression_l: Loc) -> Self {
        let blob = unsafe { lib_ruby_parser__external__nodes__new_complex(value.into_blob(), operator_l.into_blob(), expression_l.into_blob()) };
        Self { blob }
    }
    /// Constructs `Node::Const` variant
    pub(crate) fn new_const(scope: Maybe<Ptr<Node>>, name: StringPtr, double_colon_l: Maybe<Loc>, name_l: Loc, expression_l: Loc) -> Self {
        let blob = unsafe { lib_ruby_parser__external__nodes__new_const(scope.into_blob(), name.into_blob(), double_colon_l.into_blob(), name_l.into_blob(), expression_l.into_blob()) };
        Self { blob }
    }
    /// Constructs `Node::ConstPattern` variant
    pub(crate) fn new_const_pattern(const_: Ptr<Node>, pattern: Ptr<Node>, begin_l: Loc, end_l: Loc, expression_l: Loc) -> Self {
        let blob = unsafe { lib_ruby_parser__external__nodes__new_const_pattern(const_.into_blob(), pattern.into_blob(), begin_l.into_blob(), end_l.into_blob(), expression_l.into_blob()) };
        Self { blob }
    }
    /// Constructs `Node::CSend` variant
    pub(crate) fn new_c_send(recv: Ptr<Node>, method_name: StringPtr, args: List<Node>, dot_l: Loc, selector_l: Maybe<Loc>, begin_l: Maybe<Loc>, end_l: Maybe<Loc>, operator_l: Maybe<Loc>, expression_l: Loc) -> Self {
        let blob = unsafe { lib_ruby_parser__external__nodes__new_c_send(recv.into_blob(), method_name.into_blob(), args.into_blob(), dot_l.into_blob(), selector_l.into_blob(), begin_l.into_blob(), end_l.into_blob(), operator_l.into_blob(), expression_l.into_blob()) };
        Self { blob }
    }
    /// Constructs `Node::Cvar` variant
    pub(crate) fn new_cvar(name: StringPtr, expression_l: Loc) -> Self {
        let blob = unsafe { lib_ruby_parser__external__nodes__new_cvar(name.into_blob(), expression_l.into_blob()) };
        Self { blob }
    }
    /// Constructs `Node::Cvasgn` variant
    pub(crate) fn new_cvasgn(name: StringPtr, value: Maybe<Ptr<Node>>, name_l: Loc, operator_l: Maybe<Loc>, expression_l: Loc) -> Self {
        let blob = unsafe { lib_ruby_parser__external__nodes__new_cvasgn(name.into_blob(), value.into_blob(), name_l.into_blob(), operator_l.into_blob(), expression_l.into_blob()) };
        Self { blob }
    }
    /// Constructs `Node::Def` variant
    pub(crate) fn new_def(name: StringPtr, args: Maybe<Ptr<Node>>, body: Maybe<Ptr<Node>>, keyword_l: Loc, name_l: Loc, end_l: Maybe<Loc>, assignment_l: Maybe<Loc>, expression_l: Loc) -> Self {
        let blob = unsafe { lib_ruby_parser__external__nodes__new_def(name.into_blob(), args.into_blob(), body.into_blob(), keyword_l.into_blob(), name_l.into_blob(), end_l.into_blob(), assignment_l.into_blob(), expression_l.into_blob()) };
        Self { blob }
    }
    /// Constructs `Node::Defined` variant
    pub(crate) fn new_defined(value: Ptr<Node>, keyword_l: Loc, begin_l: Maybe<Loc>, end_l: Maybe<Loc>, expression_l: Loc) -> Self {
        let blob = unsafe { lib_ruby_parser__external__nodes__new_defined(value.into_blob(), keyword_l.into_blob(), begin_l.into_blob(), end_l.into_blob(), expression_l.into_blob()) };
        Self { blob }
    }
    /// Constructs `Node::Defs` variant
    pub(crate) fn new_defs(definee: Ptr<Node>, name: StringPtr, args: Maybe<Ptr<Node>>, body: Maybe<Ptr<Node>>, keyword_l: Loc, operator_l: Loc, name_l: Loc, assignment_l: Maybe<Loc>, end_l: Maybe<Loc>, expression_l: Loc) -> Self {
        let blob = unsafe { lib_ruby_parser__external__nodes__new_defs(definee.into_blob(), name.into_blob(), args.into_blob(), body.into_blob(), keyword_l.into_blob(), operator_l.into_blob(), name_l.into_blob(), assignment_l.into_blob(), end_l.into_blob(), expression_l.into_blob()) };
        Self { blob }
    }
    /// Constructs `Node::Dstr` variant
    pub(crate) fn new_dstr(parts: List<Node>, begin_l: Maybe<Loc>, end_l: Maybe<Loc>, expression_l: Loc) -> Self {
        let blob = unsafe { lib_ruby_parser__external__nodes__new_dstr(parts.into_blob(), begin_l.into_blob(), end_l.into_blob(), expression_l.into_blob()) };
        Self { blob }
    }
    /// Constructs `Node::Dsym` variant
    pub(crate) fn new_dsym(parts: List<Node>, begin_l: Maybe<Loc>, end_l: Maybe<Loc>, expression_l: Loc) -> Self {
        let blob = unsafe { lib_ruby_parser__external__nodes__new_dsym(parts.into_blob(), begin_l.into_blob(), end_l.into_blob(), expression_l.into_blob()) };
        Self { blob }
    }
    /// Constructs `Node::EFlipFlop` variant
    pub(crate) fn new_e_flip_flop(left: Maybe<Ptr<Node>>, right: Maybe<Ptr<Node>>, operator_l: Loc, expression_l: Loc) -> Self {
        let blob = unsafe { lib_ruby_parser__external__nodes__new_e_flip_flop(left.into_blob(), right.into_blob(), operator_l.into_blob(), expression_l.into_blob()) };
        Self { blob }
    }
    /// Constructs `Node::EmptyElse` variant
    pub(crate) fn new_empty_else(expression_l: Loc) -> Self {
        let blob = unsafe { lib_ruby_parser__external__nodes__new_empty_else(expression_l.into_blob()) };
        Self { blob }
    }
    /// Constructs `Node::Encoding` variant
    pub(crate) fn new_encoding(expression_l: Loc) -> Self {
        let blob = unsafe { lib_ruby_parser__external__nodes__new_encoding(expression_l.into_blob()) };
        Self { blob }
    }
    /// Constructs `Node::Ensure` variant
    pub(crate) fn new_ensure(body: Maybe<Ptr<Node>>, ensure: Maybe<Ptr<Node>>, keyword_l: Loc, expression_l: Loc) -> Self {
        let blob = unsafe { lib_ruby_parser__external__nodes__new_ensure(body.into_blob(), ensure.into_blob(), keyword_l.into_blob(), expression_l.into_blob()) };
        Self { blob }
    }
    /// Constructs `Node::Erange` variant
    pub(crate) fn new_erange(left: Maybe<Ptr<Node>>, right: Maybe<Ptr<Node>>, operator_l: Loc, expression_l: Loc) -> Self {
        let blob = unsafe { lib_ruby_parser__external__nodes__new_erange(left.into_blob(), right.into_blob(), operator_l.into_blob(), expression_l.into_blob()) };
        Self { blob }
    }
    /// Constructs `Node::False` variant
    pub(crate) fn new_false(expression_l: Loc) -> Self {
        let blob = unsafe { lib_ruby_parser__external__nodes__new_false(expression_l.into_blob()) };
        Self { blob }
    }
    /// Constructs `Node::File` variant
    pub(crate) fn new_file(expression_l: Loc) -> Self {
        let blob = unsafe { lib_ruby_parser__external__nodes__new_file(expression_l.into_blob()) };
        Self { blob }
    }
    /// Constructs `Node::FindPattern` variant
    pub(crate) fn new_find_pattern(elements: List<Node>, begin_l: Maybe<Loc>, end_l: Maybe<Loc>, expression_l: Loc) -> Self {
        let blob = unsafe { lib_ruby_parser__external__nodes__new_find_pattern(elements.into_blob(), begin_l.into_blob(), end_l.into_blob(), expression_l.into_blob()) };
        Self { blob }
    }
    /// Constructs `Node::Float` variant
    pub(crate) fn new_float(value: StringPtr, operator_l: Maybe<Loc>, expression_l: Loc) -> Self {
        let blob = unsafe { lib_ruby_parser__external__nodes__new_float(value.into_blob(), operator_l.into_blob(), expression_l.into_blob()) };
        Self { blob }
    }
    /// Constructs `Node::For` variant
    pub(crate) fn new_for(iterator: Ptr<Node>, iteratee: Ptr<Node>, body: Maybe<Ptr<Node>>, keyword_l: Loc, operator_l: Loc, begin_l: Loc, end_l: Loc, expression_l: Loc) -> Self {
        let blob = unsafe { lib_ruby_parser__external__nodes__new_for(iterator.into_blob(), iteratee.into_blob(), body.into_blob(), keyword_l.into_blob(), operator_l.into_blob(), begin_l.into_blob(), end_l.into_blob(), expression_l.into_blob()) };
        Self { blob }
    }
    /// Constructs `Node::ForwardArg` variant
    pub(crate) fn new_forward_arg(expression_l: Loc) -> Self {
        let blob = unsafe { lib_ruby_parser__external__nodes__new_forward_arg(expression_l.into_blob()) };
        Self { blob }
    }
    /// Constructs `Node::ForwardedArgs` variant
    pub(crate) fn new_forwarded_args(expression_l: Loc) -> Self {
        let blob = unsafe { lib_ruby_parser__external__nodes__new_forwarded_args(expression_l.into_blob()) };
        Self { blob }
    }
    /// Constructs `Node::Gvar` variant
    pub(crate) fn new_gvar(name: StringPtr, expression_l: Loc) -> Self {
        let blob = unsafe { lib_ruby_parser__external__nodes__new_gvar(name.into_blob(), expression_l.into_blob()) };
        Self { blob }
    }
    /// Constructs `Node::Gvasgn` variant
    pub(crate) fn new_gvasgn(name: StringPtr, value: Maybe<Ptr<Node>>, name_l: Loc, operator_l: Maybe<Loc>, expression_l: Loc) -> Self {
        let blob = unsafe { lib_ruby_parser__external__nodes__new_gvasgn(name.into_blob(), value.into_blob(), name_l.into_blob(), operator_l.into_blob(), expression_l.into_blob()) };
        Self { blob }
    }
    /// Constructs `Node::Hash` variant
    pub(crate) fn new_hash(pairs: List<Node>, begin_l: Maybe<Loc>, end_l: Maybe<Loc>, expression_l: Loc) -> Self {
        let blob = unsafe { lib_ruby_parser__external__nodes__new_hash(pairs.into_blob(), begin_l.into_blob(), end_l.into_blob(), expression_l.into_blob()) };
        Self { blob }
    }
    /// Constructs `Node::Kwargs` variant
    pub(crate) fn new_kwargs(pairs: List<Node>, expression_l: Loc) -> Self {
        let blob = unsafe { lib_ruby_parser__external__nodes__new_kwargs(pairs.into_blob(), expression_l.into_blob()) };
        Self { blob }
    }
    /// Constructs `Node::HashPattern` variant
    pub(crate) fn new_hash_pattern(elements: List<Node>, begin_l: Maybe<Loc>, end_l: Maybe<Loc>, expression_l: Loc) -> Self {
        let blob = unsafe { lib_ruby_parser__external__nodes__new_hash_pattern(elements.into_blob(), begin_l.into_blob(), end_l.into_blob(), expression_l.into_blob()) };
        Self { blob }
    }
    /// Constructs `Node::Heredoc` variant
    pub(crate) fn new_heredoc(parts: List<Node>, heredoc_body_l: Loc, heredoc_end_l: Loc, expression_l: Loc) -> Self {
        let blob = unsafe { lib_ruby_parser__external__nodes__new_heredoc(parts.into_blob(), heredoc_body_l.into_blob(), heredoc_end_l.into_blob(), expression_l.into_blob()) };
        Self { blob }
    }
    /// Constructs `Node::If` variant
    pub(crate) fn new_if(cond: Ptr<Node>, if_true: Maybe<Ptr<Node>>, if_false: Maybe<Ptr<Node>>, keyword_l: Loc, begin_l: Loc, else_l: Maybe<Loc>, end_l: Maybe<Loc>, expression_l: Loc) -> Self {
        let blob = unsafe { lib_ruby_parser__external__nodes__new_if(cond.into_blob(), if_true.into_blob(), if_false.into_blob(), keyword_l.into_blob(), begin_l.into_blob(), else_l.into_blob(), end_l.into_blob(), expression_l.into_blob()) };
        Self { blob }
    }
    /// Constructs `Node::IfGuard` variant
    pub(crate) fn new_if_guard(cond: Ptr<Node>, keyword_l: Loc, expression_l: Loc) -> Self {
        let blob = unsafe { lib_ruby_parser__external__nodes__new_if_guard(cond.into_blob(), keyword_l.into_blob(), expression_l.into_blob()) };
        Self { blob }
    }
    /// Constructs `Node::IfMod` variant
    pub(crate) fn new_if_mod(cond: Ptr<Node>, if_true: Maybe<Ptr<Node>>, if_false: Maybe<Ptr<Node>>, keyword_l: Loc, expression_l: Loc) -> Self {
        let blob = unsafe { lib_ruby_parser__external__nodes__new_if_mod(cond.into_blob(), if_true.into_blob(), if_false.into_blob(), keyword_l.into_blob(), expression_l.into_blob()) };
        Self { blob }
    }
    /// Constructs `Node::IfTernary` variant
    pub(crate) fn new_if_ternary(cond: Ptr<Node>, if_true: Ptr<Node>, if_false: Ptr<Node>, question_l: Loc, colon_l: Loc, expression_l: Loc) -> Self {
        let blob = unsafe { lib_ruby_parser__external__nodes__new_if_ternary(cond.into_blob(), if_true.into_blob(), if_false.into_blob(), question_l.into_blob(), colon_l.into_blob(), expression_l.into_blob()) };
        Self { blob }
    }
    /// Constructs `Node::IFlipFlop` variant
    pub(crate) fn new_i_flip_flop(left: Maybe<Ptr<Node>>, right: Maybe<Ptr<Node>>, operator_l: Loc, expression_l: Loc) -> Self {
        let blob = unsafe { lib_ruby_parser__external__nodes__new_i_flip_flop(left.into_blob(), right.into_blob(), operator_l.into_blob(), expression_l.into_blob()) };
        Self { blob }
    }
    /// Constructs `Node::MatchPattern` variant
    pub(crate) fn new_match_pattern(value: Ptr<Node>, pattern: Ptr<Node>, operator_l: Loc, expression_l: Loc) -> Self {
        let blob = unsafe { lib_ruby_parser__external__nodes__new_match_pattern(value.into_blob(), pattern.into_blob(), operator_l.into_blob(), expression_l.into_blob()) };
        Self { blob }
    }
    /// Constructs `Node::MatchPatternP` variant
    pub(crate) fn new_match_pattern_p(value: Ptr<Node>, pattern: Ptr<Node>, operator_l: Loc, expression_l: Loc) -> Self {
        let blob = unsafe { lib_ruby_parser__external__nodes__new_match_pattern_p(value.into_blob(), pattern.into_blob(), operator_l.into_blob(), expression_l.into_blob()) };
        Self { blob }
    }
    /// Constructs `Node::InPattern` variant
    pub(crate) fn new_in_pattern(pattern: Ptr<Node>, guard: Maybe<Ptr<Node>>, body: Maybe<Ptr<Node>>, keyword_l: Loc, begin_l: Loc, expression_l: Loc) -> Self {
        let blob = unsafe { lib_ruby_parser__external__nodes__new_in_pattern(pattern.into_blob(), guard.into_blob(), body.into_blob(), keyword_l.into_blob(), begin_l.into_blob(), expression_l.into_blob()) };
        Self { blob }
    }
    /// Constructs `Node::Index` variant
    pub(crate) fn new_index(recv: Ptr<Node>, indexes: List<Node>, begin_l: Loc, end_l: Loc, expression_l: Loc) -> Self {
        let blob = unsafe { lib_ruby_parser__external__nodes__new_index(recv.into_blob(), indexes.into_blob(), begin_l.into_blob(), end_l.into_blob(), expression_l.into_blob()) };
        Self { blob }
    }
    /// Constructs `Node::IndexAsgn` variant
    pub(crate) fn new_index_asgn(recv: Ptr<Node>, indexes: List<Node>, value: Maybe<Ptr<Node>>, begin_l: Loc, end_l: Loc, operator_l: Maybe<Loc>, expression_l: Loc) -> Self {
        let blob = unsafe { lib_ruby_parser__external__nodes__new_index_asgn(recv.into_blob(), indexes.into_blob(), value.into_blob(), begin_l.into_blob(), end_l.into_blob(), operator_l.into_blob(), expression_l.into_blob()) };
        Self { blob }
    }
    /// Constructs `Node::Int` variant
    pub(crate) fn new_int(value: StringPtr, operator_l: Maybe<Loc>, expression_l: Loc) -> Self {
        let blob = unsafe { lib_ruby_parser__external__nodes__new_int(value.into_blob(), operator_l.into_blob(), expression_l.into_blob()) };
        Self { blob }
    }
    /// Constructs `Node::Irange` variant
    pub(crate) fn new_irange(left: Maybe<Ptr<Node>>, right: Maybe<Ptr<Node>>, operator_l: Loc, expression_l: Loc) -> Self {
        let blob = unsafe { lib_ruby_parser__external__nodes__new_irange(left.into_blob(), right.into_blob(), operator_l.into_blob(), expression_l.into_blob()) };
        Self { blob }
    }
    /// Constructs `Node::Ivar` variant
    pub(crate) fn new_ivar(name: StringPtr, expression_l: Loc) -> Self {
        let blob = unsafe { lib_ruby_parser__external__nodes__new_ivar(name.into_blob(), expression_l.into_blob()) };
        Self { blob }
    }
    /// Constructs `Node::Ivasgn` variant
    pub(crate) fn new_ivasgn(name: StringPtr, value: Maybe<Ptr<Node>>, name_l: Loc, operator_l: Maybe<Loc>, expression_l: Loc) -> Self {
        let blob = unsafe { lib_ruby_parser__external__nodes__new_ivasgn(name.into_blob(), value.into_blob(), name_l.into_blob(), operator_l.into_blob(), expression_l.into_blob()) };
        Self { blob }
    }
    /// Constructs `Node::Kwarg` variant
    pub(crate) fn new_kwarg(name: StringPtr, name_l: Loc, expression_l: Loc) -> Self {
        let blob = unsafe { lib_ruby_parser__external__nodes__new_kwarg(name.into_blob(), name_l.into_blob(), expression_l.into_blob()) };
        Self { blob }
    }
    /// Constructs `Node::KwBegin` variant
    pub(crate) fn new_kw_begin(statements: List<Node>, begin_l: Maybe<Loc>, end_l: Maybe<Loc>, expression_l: Loc) -> Self {
        let blob = unsafe { lib_ruby_parser__external__nodes__new_kw_begin(statements.into_blob(), begin_l.into_blob(), end_l.into_blob(), expression_l.into_blob()) };
        Self { blob }
    }
    /// Constructs `Node::Kwnilarg` variant
    pub(crate) fn new_kwnilarg(name_l: Loc, expression_l: Loc) -> Self {
        let blob = unsafe { lib_ruby_parser__external__nodes__new_kwnilarg(name_l.into_blob(), expression_l.into_blob()) };
        Self { blob }
    }
    /// Constructs `Node::Kwoptarg` variant
    pub(crate) fn new_kwoptarg(name: StringPtr, default: Ptr<Node>, name_l: Loc, expression_l: Loc) -> Self {
        let blob = unsafe { lib_ruby_parser__external__nodes__new_kwoptarg(name.into_blob(), default.into_blob(), name_l.into_blob(), expression_l.into_blob()) };
        Self { blob }
    }
    /// Constructs `Node::Kwrestarg` variant
    pub(crate) fn new_kwrestarg(name: Maybe<StringPtr>, operator_l: Loc, name_l: Maybe<Loc>, expression_l: Loc) -> Self {
        let blob = unsafe { lib_ruby_parser__external__nodes__new_kwrestarg(name.into_blob(), operator_l.into_blob(), name_l.into_blob(), expression_l.into_blob()) };
        Self { blob }
    }
    /// Constructs `Node::Kwsplat` variant
    pub(crate) fn new_kwsplat(value: Ptr<Node>, operator_l: Loc, expression_l: Loc) -> Self {
        let blob = unsafe { lib_ruby_parser__external__nodes__new_kwsplat(value.into_blob(), operator_l.into_blob(), expression_l.into_blob()) };
        Self { blob }
    }
    /// Constructs `Node::Lambda` variant
    pub(crate) fn new_lambda(expression_l: Loc) -> Self {
        let blob = unsafe { lib_ruby_parser__external__nodes__new_lambda(expression_l.into_blob()) };
        Self { blob }
    }
    /// Constructs `Node::Line` variant
    pub(crate) fn new_line(expression_l: Loc) -> Self {
        let blob = unsafe { lib_ruby_parser__external__nodes__new_line(expression_l.into_blob()) };
        Self { blob }
    }
    /// Constructs `Node::Lvar` variant
    pub(crate) fn new_lvar(name: StringPtr, expression_l: Loc) -> Self {
        let blob = unsafe { lib_ruby_parser__external__nodes__new_lvar(name.into_blob(), expression_l.into_blob()) };
        Self { blob }
    }
    /// Constructs `Node::Lvasgn` variant
    pub(crate) fn new_lvasgn(name: StringPtr, value: Maybe<Ptr<Node>>, name_l: Loc, operator_l: Maybe<Loc>, expression_l: Loc) -> Self {
        let blob = unsafe { lib_ruby_parser__external__nodes__new_lvasgn(name.into_blob(), value.into_blob(), name_l.into_blob(), operator_l.into_blob(), expression_l.into_blob()) };
        Self { blob }
    }
    /// Constructs `Node::Masgn` variant
    pub(crate) fn new_masgn(lhs: Ptr<Node>, rhs: Ptr<Node>, operator_l: Loc, expression_l: Loc) -> Self {
        let blob = unsafe { lib_ruby_parser__external__nodes__new_masgn(lhs.into_blob(), rhs.into_blob(), operator_l.into_blob(), expression_l.into_blob()) };
        Self { blob }
    }
    /// Constructs `Node::MatchAlt` variant
    pub(crate) fn new_match_alt(lhs: Ptr<Node>, rhs: Ptr<Node>, operator_l: Loc, expression_l: Loc) -> Self {
        let blob = unsafe { lib_ruby_parser__external__nodes__new_match_alt(lhs.into_blob(), rhs.into_blob(), operator_l.into_blob(), expression_l.into_blob()) };
        Self { blob }
    }
    /// Constructs `Node::MatchAs` variant
    pub(crate) fn new_match_as(value: Ptr<Node>, as_: Ptr<Node>, operator_l: Loc, expression_l: Loc) -> Self {
        let blob = unsafe { lib_ruby_parser__external__nodes__new_match_as(value.into_blob(), as_.into_blob(), operator_l.into_blob(), expression_l.into_blob()) };
        Self { blob }
    }
    /// Constructs `Node::MatchCurrentLine` variant
    pub(crate) fn new_match_current_line(re: Ptr<Node>, expression_l: Loc) -> Self {
        let blob = unsafe { lib_ruby_parser__external__nodes__new_match_current_line(re.into_blob(), expression_l.into_blob()) };
        Self { blob }
    }
    /// Constructs `Node::MatchNilPattern` variant
    pub(crate) fn new_match_nil_pattern(operator_l: Loc, name_l: Loc, expression_l: Loc) -> Self {
        let blob = unsafe { lib_ruby_parser__external__nodes__new_match_nil_pattern(operator_l.into_blob(), name_l.into_blob(), expression_l.into_blob()) };
        Self { blob }
    }
    /// Constructs `Node::MatchRest` variant
    pub(crate) fn new_match_rest(name: Maybe<Ptr<Node>>, operator_l: Loc, expression_l: Loc) -> Self {
        let blob = unsafe { lib_ruby_parser__external__nodes__new_match_rest(name.into_blob(), operator_l.into_blob(), expression_l.into_blob()) };
        Self { blob }
    }
    /// Constructs `Node::MatchVar` variant
    pub(crate) fn new_match_var(name: StringPtr, name_l: Loc, expression_l: Loc) -> Self {
        let blob = unsafe { lib_ruby_parser__external__nodes__new_match_var(name.into_blob(), name_l.into_blob(), expression_l.into_blob()) };
        Self { blob }
    }
    /// Constructs `Node::MatchWithLvasgn` variant
    pub(crate) fn new_match_with_lvasgn(re: Ptr<Node>, value: Ptr<Node>, operator_l: Loc, expression_l: Loc) -> Self {
        let blob = unsafe { lib_ruby_parser__external__nodes__new_match_with_lvasgn(re.into_blob(), value.into_blob(), operator_l.into_blob(), expression_l.into_blob()) };
        Self { blob }
    }
    /// Constructs `Node::Mlhs` variant
    pub(crate) fn new_mlhs(items: List<Node>, begin_l: Maybe<Loc>, end_l: Maybe<Loc>, expression_l: Loc) -> Self {
        let blob = unsafe { lib_ruby_parser__external__nodes__new_mlhs(items.into_blob(), begin_l.into_blob(), end_l.into_blob(), expression_l.into_blob()) };
        Self { blob }
    }
    /// Constructs `Node::Module` variant
    pub(crate) fn new_module(name: Ptr<Node>, body: Maybe<Ptr<Node>>, keyword_l: Loc, end_l: Loc, expression_l: Loc) -> Self {
        let blob = unsafe { lib_ruby_parser__external__nodes__new_module(name.into_blob(), body.into_blob(), keyword_l.into_blob(), end_l.into_blob(), expression_l.into_blob()) };
        Self { blob }
    }
    /// Constructs `Node::Next` variant
    pub(crate) fn new_next(args: List<Node>, keyword_l: Loc, expression_l: Loc) -> Self {
        let blob = unsafe { lib_ruby_parser__external__nodes__new_next(args.into_blob(), keyword_l.into_blob(), expression_l.into_blob()) };
        Self { blob }
    }
    /// Constructs `Node::Nil` variant
    pub(crate) fn new_nil(expression_l: Loc) -> Self {
        let blob = unsafe { lib_ruby_parser__external__nodes__new_nil(expression_l.into_blob()) };
        Self { blob }
    }
    /// Constructs `Node::NthRef` variant
    pub(crate) fn new_nth_ref(name: StringPtr, expression_l: Loc) -> Self {
        let blob = unsafe { lib_ruby_parser__external__nodes__new_nth_ref(name.into_blob(), expression_l.into_blob()) };
        Self { blob }
    }
    /// Constructs `Node::Numblock` variant
    pub(crate) fn new_numblock(call: Ptr<Node>, numargs: u8, body: Ptr<Node>, begin_l: Loc, end_l: Loc, expression_l: Loc) -> Self {
        let blob = unsafe { lib_ruby_parser__external__nodes__new_numblock(call.into_blob(), numargs.into_blob(), body.into_blob(), begin_l.into_blob(), end_l.into_blob(), expression_l.into_blob()) };
        Self { blob }
    }
    /// Constructs `Node::OpAsgn` variant
    pub(crate) fn new_op_asgn(recv: Ptr<Node>, operator: StringPtr, value: Ptr<Node>, operator_l: Loc, expression_l: Loc) -> Self {
        let blob = unsafe { lib_ruby_parser__external__nodes__new_op_asgn(recv.into_blob(), operator.into_blob(), value.into_blob(), operator_l.into_blob(), expression_l.into_blob()) };
        Self { blob }
    }
    /// Constructs `Node::Optarg` variant
    pub(crate) fn new_optarg(name: StringPtr, default: Ptr<Node>, name_l: Loc, operator_l: Loc, expression_l: Loc) -> Self {
        let blob = unsafe { lib_ruby_parser__external__nodes__new_optarg(name.into_blob(), default.into_blob(), name_l.into_blob(), operator_l.into_blob(), expression_l.into_blob()) };
        Self { blob }
    }
    /// Constructs `Node::Or` variant
    pub(crate) fn new_or(lhs: Ptr<Node>, rhs: Ptr<Node>, operator_l: Loc, expression_l: Loc) -> Self {
        let blob = unsafe { lib_ruby_parser__external__nodes__new_or(lhs.into_blob(), rhs.into_blob(), operator_l.into_blob(), expression_l.into_blob()) };
        Self { blob }
    }
    /// Constructs `Node::OrAsgn` variant
    pub(crate) fn new_or_asgn(recv: Ptr<Node>, value: Ptr<Node>, operator_l: Loc, expression_l: Loc) -> Self {
        let blob = unsafe { lib_ruby_parser__external__nodes__new_or_asgn(recv.into_blob(), value.into_blob(), operator_l.into_blob(), expression_l.into_blob()) };
        Self { blob }
    }
    /// Constructs `Node::Pair` variant
    pub(crate) fn new_pair(key: Ptr<Node>, value: Ptr<Node>, operator_l: Loc, expression_l: Loc) -> Self {
        let blob = unsafe { lib_ruby_parser__external__nodes__new_pair(key.into_blob(), value.into_blob(), operator_l.into_blob(), expression_l.into_blob()) };
        Self { blob }
    }
    /// Constructs `Node::Pin` variant
    pub(crate) fn new_pin(var: Ptr<Node>, selector_l: Loc, expression_l: Loc) -> Self {
        let blob = unsafe { lib_ruby_parser__external__nodes__new_pin(var.into_blob(), selector_l.into_blob(), expression_l.into_blob()) };
        Self { blob }
    }
    /// Constructs `Node::Postexe` variant
    pub(crate) fn new_postexe(body: Maybe<Ptr<Node>>, keyword_l: Loc, begin_l: Loc, end_l: Loc, expression_l: Loc) -> Self {
        let blob = unsafe { lib_ruby_parser__external__nodes__new_postexe(body.into_blob(), keyword_l.into_blob(), begin_l.into_blob(), end_l.into_blob(), expression_l.into_blob()) };
        Self { blob }
    }
    /// Constructs `Node::Preexe` variant
    pub(crate) fn new_preexe(body: Maybe<Ptr<Node>>, keyword_l: Loc, begin_l: Loc, end_l: Loc, expression_l: Loc) -> Self {
        let blob = unsafe { lib_ruby_parser__external__nodes__new_preexe(body.into_blob(), keyword_l.into_blob(), begin_l.into_blob(), end_l.into_blob(), expression_l.into_blob()) };
        Self { blob }
    }
    /// Constructs `Node::Procarg0` variant
    pub(crate) fn new_procarg0(args: List<Node>, begin_l: Maybe<Loc>, end_l: Maybe<Loc>, expression_l: Loc) -> Self {
        let blob = unsafe { lib_ruby_parser__external__nodes__new_procarg0(args.into_blob(), begin_l.into_blob(), end_l.into_blob(), expression_l.into_blob()) };
        Self { blob }
    }
    /// Constructs `Node::Rational` variant
    pub(crate) fn new_rational(value: StringPtr, operator_l: Maybe<Loc>, expression_l: Loc) -> Self {
        let blob = unsafe { lib_ruby_parser__external__nodes__new_rational(value.into_blob(), operator_l.into_blob(), expression_l.into_blob()) };
        Self { blob }
    }
    /// Constructs `Node::Redo` variant
    pub(crate) fn new_redo(expression_l: Loc) -> Self {
        let blob = unsafe { lib_ruby_parser__external__nodes__new_redo(expression_l.into_blob()) };
        Self { blob }
    }
    /// Constructs `Node::RegOpt` variant
    pub(crate) fn new_reg_opt(options: Maybe<StringPtr>, expression_l: Loc) -> Self {
        let blob = unsafe { lib_ruby_parser__external__nodes__new_reg_opt(options.into_blob(), expression_l.into_blob()) };
        Self { blob }
    }
    /// Constructs `Node::Regexp` variant
    pub(crate) fn new_regexp(parts: List<Node>, options: Maybe<Ptr<Node>>, begin_l: Loc, end_l: Loc, expression_l: Loc) -> Self {
        let blob = unsafe { lib_ruby_parser__external__nodes__new_regexp(parts.into_blob(), options.into_blob(), begin_l.into_blob(), end_l.into_blob(), expression_l.into_blob()) };
        Self { blob }
    }
    /// Constructs `Node::Rescue` variant
    pub(crate) fn new_rescue(body: Maybe<Ptr<Node>>, rescue_bodies: List<Node>, else_: Maybe<Ptr<Node>>, else_l: Maybe<Loc>, expression_l: Loc) -> Self {
        let blob = unsafe { lib_ruby_parser__external__nodes__new_rescue(body.into_blob(), rescue_bodies.into_blob(), else_.into_blob(), else_l.into_blob(), expression_l.into_blob()) };
        Self { blob }
    }
    /// Constructs `Node::RescueBody` variant
    pub(crate) fn new_rescue_body(exc_list: Maybe<Ptr<Node>>, exc_var: Maybe<Ptr<Node>>, body: Maybe<Ptr<Node>>, keyword_l: Loc, assoc_l: Maybe<Loc>, begin_l: Maybe<Loc>, expression_l: Loc) -> Self {
        let blob = unsafe { lib_ruby_parser__external__nodes__new_rescue_body(exc_list.into_blob(), exc_var.into_blob(), body.into_blob(), keyword_l.into_blob(), assoc_l.into_blob(), begin_l.into_blob(), expression_l.into_blob()) };
        Self { blob }
    }
    /// Constructs `Node::Restarg` variant
    pub(crate) fn new_restarg(name: Maybe<StringPtr>, operator_l: Loc, name_l: Maybe<Loc>, expression_l: Loc) -> Self {
        let blob = unsafe { lib_ruby_parser__external__nodes__new_restarg(name.into_blob(), operator_l.into_blob(), name_l.into_blob(), expression_l.into_blob()) };
        Self { blob }
    }
    /// Constructs `Node::Retry` variant
    pub(crate) fn new_retry(expression_l: Loc) -> Self {
        let blob = unsafe { lib_ruby_parser__external__nodes__new_retry(expression_l.into_blob()) };
        Self { blob }
    }
    /// Constructs `Node::Return` variant
    pub(crate) fn new_return(args: List<Node>, keyword_l: Loc, expression_l: Loc) -> Self {
        let blob = unsafe { lib_ruby_parser__external__nodes__new_return(args.into_blob(), keyword_l.into_blob(), expression_l.into_blob()) };
        Self { blob }
    }
    /// Constructs `Node::SClass` variant
    pub(crate) fn new_s_class(expr: Ptr<Node>, body: Maybe<Ptr<Node>>, keyword_l: Loc, operator_l: Loc, end_l: Loc, expression_l: Loc) -> Self {
        let blob = unsafe { lib_ruby_parser__external__nodes__new_s_class(expr.into_blob(), body.into_blob(), keyword_l.into_blob(), operator_l.into_blob(), end_l.into_blob(), expression_l.into_blob()) };
        Self { blob }
    }
    /// Constructs `Node::Self_` variant
    pub(crate) fn new_self(expression_l: Loc) -> Self {
        let blob = unsafe { lib_ruby_parser__external__nodes__new_self(expression_l.into_blob()) };
        Self { blob }
    }
    /// Constructs `Node::Send` variant
    pub(crate) fn new_send(recv: Maybe<Ptr<Node>>, method_name: StringPtr, args: List<Node>, dot_l: Maybe<Loc>, selector_l: Maybe<Loc>, begin_l: Maybe<Loc>, end_l: Maybe<Loc>, operator_l: Maybe<Loc>, expression_l: Loc) -> Self {
        let blob = unsafe { lib_ruby_parser__external__nodes__new_send(recv.into_blob(), method_name.into_blob(), args.into_blob(), dot_l.into_blob(), selector_l.into_blob(), begin_l.into_blob(), end_l.into_blob(), operator_l.into_blob(), expression_l.into_blob()) };
        Self { blob }
    }
    /// Constructs `Node::Shadowarg` variant
    pub(crate) fn new_shadowarg(name: StringPtr, expression_l: Loc) -> Self {
        let blob = unsafe { lib_ruby_parser__external__nodes__new_shadowarg(name.into_blob(), expression_l.into_blob()) };
        Self { blob }
    }
    /// Constructs `Node::Splat` variant
    pub(crate) fn new_splat(value: Maybe<Ptr<Node>>, operator_l: Loc, expression_l: Loc) -> Self {
        let blob = unsafe { lib_ruby_parser__external__nodes__new_splat(value.into_blob(), operator_l.into_blob(), expression_l.into_blob()) };
        Self { blob }
    }
    /// Constructs `Node::Str` variant
    pub(crate) fn new_str(value: Bytes, begin_l: Maybe<Loc>, end_l: Maybe<Loc>, expression_l: Loc) -> Self {
        let blob = unsafe { lib_ruby_parser__external__nodes__new_str(value.into_blob(), begin_l.into_blob(), end_l.into_blob(), expression_l.into_blob()) };
        Self { blob }
    }
    /// Constructs `Node::Super` variant
    pub(crate) fn new_super(args: List<Node>, keyword_l: Loc, begin_l: Maybe<Loc>, end_l: Maybe<Loc>, expression_l: Loc) -> Self {
        let blob = unsafe { lib_ruby_parser__external__nodes__new_super(args.into_blob(), keyword_l.into_blob(), begin_l.into_blob(), end_l.into_blob(), expression_l.into_blob()) };
        Self { blob }
    }
    /// Constructs `Node::Sym` variant
    pub(crate) fn new_sym(name: Bytes, begin_l: Maybe<Loc>, end_l: Maybe<Loc>, expression_l: Loc) -> Self {
        let blob = unsafe { lib_ruby_parser__external__nodes__new_sym(name.into_blob(), begin_l.into_blob(), end_l.into_blob(), expression_l.into_blob()) };
        Self { blob }
    }
    /// Constructs `Node::True` variant
    pub(crate) fn new_true(expression_l: Loc) -> Self {
        let blob = unsafe { lib_ruby_parser__external__nodes__new_true(expression_l.into_blob()) };
        Self { blob }
    }
    /// Constructs `Node::Undef` variant
    pub(crate) fn new_undef(names: List<Node>, keyword_l: Loc, expression_l: Loc) -> Self {
        let blob = unsafe { lib_ruby_parser__external__nodes__new_undef(names.into_blob(), keyword_l.into_blob(), expression_l.into_blob()) };
        Self { blob }
    }
    /// Constructs `Node::UnlessGuard` variant
    pub(crate) fn new_unless_guard(cond: Ptr<Node>, keyword_l: Loc, expression_l: Loc) -> Self {
        let blob = unsafe { lib_ruby_parser__external__nodes__new_unless_guard(cond.into_blob(), keyword_l.into_blob(), expression_l.into_blob()) };
        Self { blob }
    }
    /// Constructs `Node::Until` variant
    pub(crate) fn new_until(cond: Ptr<Node>, body: Maybe<Ptr<Node>>, keyword_l: Loc, begin_l: Maybe<Loc>, end_l: Maybe<Loc>, expression_l: Loc) -> Self {
        let blob = unsafe { lib_ruby_parser__external__nodes__new_until(cond.into_blob(), body.into_blob(), keyword_l.into_blob(), begin_l.into_blob(), end_l.into_blob(), expression_l.into_blob()) };
        Self { blob }
    }
    /// Constructs `Node::UntilPost` variant
    pub(crate) fn new_until_post(cond: Ptr<Node>, body: Ptr<Node>, keyword_l: Loc, expression_l: Loc) -> Self {
        let blob = unsafe { lib_ruby_parser__external__nodes__new_until_post(cond.into_blob(), body.into_blob(), keyword_l.into_blob(), expression_l.into_blob()) };
        Self { blob }
    }
    /// Constructs `Node::When` variant
    pub(crate) fn new_when(patterns: List<Node>, body: Maybe<Ptr<Node>>, keyword_l: Loc, begin_l: Loc, expression_l: Loc) -> Self {
        let blob = unsafe { lib_ruby_parser__external__nodes__new_when(patterns.into_blob(), body.into_blob(), keyword_l.into_blob(), begin_l.into_blob(), expression_l.into_blob()) };
        Self { blob }
    }
    /// Constructs `Node::While` variant
    pub(crate) fn new_while(cond: Ptr<Node>, body: Maybe<Ptr<Node>>, keyword_l: Loc, begin_l: Maybe<Loc>, end_l: Maybe<Loc>, expression_l: Loc) -> Self {
        let blob = unsafe { lib_ruby_parser__external__nodes__new_while(cond.into_blob(), body.into_blob(), keyword_l.into_blob(), begin_l.into_blob(), end_l.into_blob(), expression_l.into_blob()) };
        Self { blob }
    }
    /// Constructs `Node::WhilePost` variant
    pub(crate) fn new_while_post(cond: Ptr<Node>, body: Ptr<Node>, keyword_l: Loc, expression_l: Loc) -> Self {
        let blob = unsafe { lib_ruby_parser__external__nodes__new_while_post(cond.into_blob(), body.into_blob(), keyword_l.into_blob(), expression_l.into_blob()) };
        Self { blob }
    }
    /// Constructs `Node::XHeredoc` variant
    pub(crate) fn new_x_heredoc(parts: List<Node>, heredoc_body_l: Loc, heredoc_end_l: Loc, expression_l: Loc) -> Self {
        let blob = unsafe { lib_ruby_parser__external__nodes__new_x_heredoc(parts.into_blob(), heredoc_body_l.into_blob(), heredoc_end_l.into_blob(), expression_l.into_blob()) };
        Self { blob }
    }
    /// Constructs `Node::Xstr` variant
    pub(crate) fn new_xstr(parts: List<Node>, begin_l: Loc, end_l: Loc, expression_l: Loc) -> Self {
        let blob = unsafe { lib_ruby_parser__external__nodes__new_xstr(parts.into_blob(), begin_l.into_blob(), end_l.into_blob(), expression_l.into_blob()) };
        Self { blob }
    }
    /// Constructs `Node::Yield` variant
    pub(crate) fn new_yield(args: List<Node>, keyword_l: Loc, begin_l: Maybe<Loc>, end_l: Maybe<Loc>, expression_l: Loc) -> Self {
        let blob = unsafe { lib_ruby_parser__external__nodes__new_yield(args.into_blob(), keyword_l.into_blob(), begin_l.into_blob(), end_l.into_blob(), expression_l.into_blob()) };
        Self { blob }
    }
    /// Constructs `Node::ZSuper` variant
    pub(crate) fn new_z_super(expression_l: Loc) -> Self {
        let blob = unsafe { lib_ruby_parser__external__nodes__new_z_super(expression_l.into_blob()) };
        Self { blob }
    }

    // is_<node> FNs

    /// Returns true if `self` is `Node::Alias`
    pub fn is_alias(&self) -> bool {
        unsafe { lib_ruby_parser__external__nodes__is_alias(&self.blob) }
    }
    /// Returns true if `self` is `Node::AndAsgn`
    pub fn is_and_asgn(&self) -> bool {
        unsafe { lib_ruby_parser__external__nodes__is_and_asgn(&self.blob) }
    }
    /// Returns true if `self` is `Node::And`
    pub fn is_and(&self) -> bool {
        unsafe { lib_ruby_parser__external__nodes__is_and(&self.blob) }
    }
    /// Returns true if `self` is `Node::Arg`
    pub fn is_arg(&self) -> bool {
        unsafe { lib_ruby_parser__external__nodes__is_arg(&self.blob) }
    }
    /// Returns true if `self` is `Node::Args`
    pub fn is_args(&self) -> bool {
        unsafe { lib_ruby_parser__external__nodes__is_args(&self.blob) }
    }
    /// Returns true if `self` is `Node::Array`
    pub fn is_array(&self) -> bool {
        unsafe { lib_ruby_parser__external__nodes__is_array(&self.blob) }
    }
    /// Returns true if `self` is `Node::ArrayPattern`
    pub fn is_array_pattern(&self) -> bool {
        unsafe { lib_ruby_parser__external__nodes__is_array_pattern(&self.blob) }
    }
    /// Returns true if `self` is `Node::ArrayPatternWithTail`
    pub fn is_array_pattern_with_tail(&self) -> bool {
        unsafe { lib_ruby_parser__external__nodes__is_array_pattern_with_tail(&self.blob) }
    }
    /// Returns true if `self` is `Node::BackRef`
    pub fn is_back_ref(&self) -> bool {
        unsafe { lib_ruby_parser__external__nodes__is_back_ref(&self.blob) }
    }
    /// Returns true if `self` is `Node::Begin`
    pub fn is_begin(&self) -> bool {
        unsafe { lib_ruby_parser__external__nodes__is_begin(&self.blob) }
    }
    /// Returns true if `self` is `Node::Block`
    pub fn is_block(&self) -> bool {
        unsafe { lib_ruby_parser__external__nodes__is_block(&self.blob) }
    }
    /// Returns true if `self` is `Node::BlockPass`
    pub fn is_block_pass(&self) -> bool {
        unsafe { lib_ruby_parser__external__nodes__is_block_pass(&self.blob) }
    }
    /// Returns true if `self` is `Node::Blockarg`
    pub fn is_blockarg(&self) -> bool {
        unsafe { lib_ruby_parser__external__nodes__is_blockarg(&self.blob) }
    }
    /// Returns true if `self` is `Node::Break`
    pub fn is_break(&self) -> bool {
        unsafe { lib_ruby_parser__external__nodes__is_break(&self.blob) }
    }
    /// Returns true if `self` is `Node::Case`
    pub fn is_case(&self) -> bool {
        unsafe { lib_ruby_parser__external__nodes__is_case(&self.blob) }
    }
    /// Returns true if `self` is `Node::CaseMatch`
    pub fn is_case_match(&self) -> bool {
        unsafe { lib_ruby_parser__external__nodes__is_case_match(&self.blob) }
    }
    /// Returns true if `self` is `Node::Casgn`
    pub fn is_casgn(&self) -> bool {
        unsafe { lib_ruby_parser__external__nodes__is_casgn(&self.blob) }
    }
    /// Returns true if `self` is `Node::Cbase`
    pub fn is_cbase(&self) -> bool {
        unsafe { lib_ruby_parser__external__nodes__is_cbase(&self.blob) }
    }
    /// Returns true if `self` is `Node::Class`
    pub fn is_class(&self) -> bool {
        unsafe { lib_ruby_parser__external__nodes__is_class(&self.blob) }
    }
    /// Returns true if `self` is `Node::Complex`
    pub fn is_complex(&self) -> bool {
        unsafe { lib_ruby_parser__external__nodes__is_complex(&self.blob) }
    }
    /// Returns true if `self` is `Node::Const`
    pub fn is_const(&self) -> bool {
        unsafe { lib_ruby_parser__external__nodes__is_const(&self.blob) }
    }
    /// Returns true if `self` is `Node::ConstPattern`
    pub fn is_const_pattern(&self) -> bool {
        unsafe { lib_ruby_parser__external__nodes__is_const_pattern(&self.blob) }
    }
    /// Returns true if `self` is `Node::CSend`
    pub fn is_c_send(&self) -> bool {
        unsafe { lib_ruby_parser__external__nodes__is_c_send(&self.blob) }
    }
    /// Returns true if `self` is `Node::Cvar`
    pub fn is_cvar(&self) -> bool {
        unsafe { lib_ruby_parser__external__nodes__is_cvar(&self.blob) }
    }
    /// Returns true if `self` is `Node::Cvasgn`
    pub fn is_cvasgn(&self) -> bool {
        unsafe { lib_ruby_parser__external__nodes__is_cvasgn(&self.blob) }
    }
    /// Returns true if `self` is `Node::Def`
    pub fn is_def(&self) -> bool {
        unsafe { lib_ruby_parser__external__nodes__is_def(&self.blob) }
    }
    /// Returns true if `self` is `Node::Defined`
    pub fn is_defined(&self) -> bool {
        unsafe { lib_ruby_parser__external__nodes__is_defined(&self.blob) }
    }
    /// Returns true if `self` is `Node::Defs`
    pub fn is_defs(&self) -> bool {
        unsafe { lib_ruby_parser__external__nodes__is_defs(&self.blob) }
    }
    /// Returns true if `self` is `Node::Dstr`
    pub fn is_dstr(&self) -> bool {
        unsafe { lib_ruby_parser__external__nodes__is_dstr(&self.blob) }
    }
    /// Returns true if `self` is `Node::Dsym`
    pub fn is_dsym(&self) -> bool {
        unsafe { lib_ruby_parser__external__nodes__is_dsym(&self.blob) }
    }
    /// Returns true if `self` is `Node::EFlipFlop`
    pub fn is_e_flip_flop(&self) -> bool {
        unsafe { lib_ruby_parser__external__nodes__is_e_flip_flop(&self.blob) }
    }
    /// Returns true if `self` is `Node::EmptyElse`
    pub fn is_empty_else(&self) -> bool {
        unsafe { lib_ruby_parser__external__nodes__is_empty_else(&self.blob) }
    }
    /// Returns true if `self` is `Node::Encoding`
    pub fn is_encoding(&self) -> bool {
        unsafe { lib_ruby_parser__external__nodes__is_encoding(&self.blob) }
    }
    /// Returns true if `self` is `Node::Ensure`
    pub fn is_ensure(&self) -> bool {
        unsafe { lib_ruby_parser__external__nodes__is_ensure(&self.blob) }
    }
    /// Returns true if `self` is `Node::Erange`
    pub fn is_erange(&self) -> bool {
        unsafe { lib_ruby_parser__external__nodes__is_erange(&self.blob) }
    }
    /// Returns true if `self` is `Node::False`
    pub fn is_false(&self) -> bool {
        unsafe { lib_ruby_parser__external__nodes__is_false(&self.blob) }
    }
    /// Returns true if `self` is `Node::File`
    pub fn is_file(&self) -> bool {
        unsafe { lib_ruby_parser__external__nodes__is_file(&self.blob) }
    }
    /// Returns true if `self` is `Node::FindPattern`
    pub fn is_find_pattern(&self) -> bool {
        unsafe { lib_ruby_parser__external__nodes__is_find_pattern(&self.blob) }
    }
    /// Returns true if `self` is `Node::Float`
    pub fn is_float(&self) -> bool {
        unsafe { lib_ruby_parser__external__nodes__is_float(&self.blob) }
    }
    /// Returns true if `self` is `Node::For`
    pub fn is_for(&self) -> bool {
        unsafe { lib_ruby_parser__external__nodes__is_for(&self.blob) }
    }
    /// Returns true if `self` is `Node::ForwardArg`
    pub fn is_forward_arg(&self) -> bool {
        unsafe { lib_ruby_parser__external__nodes__is_forward_arg(&self.blob) }
    }
    /// Returns true if `self` is `Node::ForwardedArgs`
    pub fn is_forwarded_args(&self) -> bool {
        unsafe { lib_ruby_parser__external__nodes__is_forwarded_args(&self.blob) }
    }
    /// Returns true if `self` is `Node::Gvar`
    pub fn is_gvar(&self) -> bool {
        unsafe { lib_ruby_parser__external__nodes__is_gvar(&self.blob) }
    }
    /// Returns true if `self` is `Node::Gvasgn`
    pub fn is_gvasgn(&self) -> bool {
        unsafe { lib_ruby_parser__external__nodes__is_gvasgn(&self.blob) }
    }
    /// Returns true if `self` is `Node::Hash`
    pub fn is_hash(&self) -> bool {
        unsafe { lib_ruby_parser__external__nodes__is_hash(&self.blob) }
    }
    /// Returns true if `self` is `Node::Kwargs`
    pub fn is_kwargs(&self) -> bool {
        unsafe { lib_ruby_parser__external__nodes__is_kwargs(&self.blob) }
    }
    /// Returns true if `self` is `Node::HashPattern`
    pub fn is_hash_pattern(&self) -> bool {
        unsafe { lib_ruby_parser__external__nodes__is_hash_pattern(&self.blob) }
    }
    /// Returns true if `self` is `Node::Heredoc`
    pub fn is_heredoc(&self) -> bool {
        unsafe { lib_ruby_parser__external__nodes__is_heredoc(&self.blob) }
    }
    /// Returns true if `self` is `Node::If`
    pub fn is_if(&self) -> bool {
        unsafe { lib_ruby_parser__external__nodes__is_if(&self.blob) }
    }
    /// Returns true if `self` is `Node::IfGuard`
    pub fn is_if_guard(&self) -> bool {
        unsafe { lib_ruby_parser__external__nodes__is_if_guard(&self.blob) }
    }
    /// Returns true if `self` is `Node::IfMod`
    pub fn is_if_mod(&self) -> bool {
        unsafe { lib_ruby_parser__external__nodes__is_if_mod(&self.blob) }
    }
    /// Returns true if `self` is `Node::IfTernary`
    pub fn is_if_ternary(&self) -> bool {
        unsafe { lib_ruby_parser__external__nodes__is_if_ternary(&self.blob) }
    }
    /// Returns true if `self` is `Node::IFlipFlop`
    pub fn is_i_flip_flop(&self) -> bool {
        unsafe { lib_ruby_parser__external__nodes__is_i_flip_flop(&self.blob) }
    }
    /// Returns true if `self` is `Node::MatchPattern`
    pub fn is_match_pattern(&self) -> bool {
        unsafe { lib_ruby_parser__external__nodes__is_match_pattern(&self.blob) }
    }
    /// Returns true if `self` is `Node::MatchPatternP`
    pub fn is_match_pattern_p(&self) -> bool {
        unsafe { lib_ruby_parser__external__nodes__is_match_pattern_p(&self.blob) }
    }
    /// Returns true if `self` is `Node::InPattern`
    pub fn is_in_pattern(&self) -> bool {
        unsafe { lib_ruby_parser__external__nodes__is_in_pattern(&self.blob) }
    }
    /// Returns true if `self` is `Node::Index`
    pub fn is_index(&self) -> bool {
        unsafe { lib_ruby_parser__external__nodes__is_index(&self.blob) }
    }
    /// Returns true if `self` is `Node::IndexAsgn`
    pub fn is_index_asgn(&self) -> bool {
        unsafe { lib_ruby_parser__external__nodes__is_index_asgn(&self.blob) }
    }
    /// Returns true if `self` is `Node::Int`
    pub fn is_int(&self) -> bool {
        unsafe { lib_ruby_parser__external__nodes__is_int(&self.blob) }
    }
    /// Returns true if `self` is `Node::Irange`
    pub fn is_irange(&self) -> bool {
        unsafe { lib_ruby_parser__external__nodes__is_irange(&self.blob) }
    }
    /// Returns true if `self` is `Node::Ivar`
    pub fn is_ivar(&self) -> bool {
        unsafe { lib_ruby_parser__external__nodes__is_ivar(&self.blob) }
    }
    /// Returns true if `self` is `Node::Ivasgn`
    pub fn is_ivasgn(&self) -> bool {
        unsafe { lib_ruby_parser__external__nodes__is_ivasgn(&self.blob) }
    }
    /// Returns true if `self` is `Node::Kwarg`
    pub fn is_kwarg(&self) -> bool {
        unsafe { lib_ruby_parser__external__nodes__is_kwarg(&self.blob) }
    }
    /// Returns true if `self` is `Node::KwBegin`
    pub fn is_kw_begin(&self) -> bool {
        unsafe { lib_ruby_parser__external__nodes__is_kw_begin(&self.blob) }
    }
    /// Returns true if `self` is `Node::Kwnilarg`
    pub fn is_kwnilarg(&self) -> bool {
        unsafe { lib_ruby_parser__external__nodes__is_kwnilarg(&self.blob) }
    }
    /// Returns true if `self` is `Node::Kwoptarg`
    pub fn is_kwoptarg(&self) -> bool {
        unsafe { lib_ruby_parser__external__nodes__is_kwoptarg(&self.blob) }
    }
    /// Returns true if `self` is `Node::Kwrestarg`
    pub fn is_kwrestarg(&self) -> bool {
        unsafe { lib_ruby_parser__external__nodes__is_kwrestarg(&self.blob) }
    }
    /// Returns true if `self` is `Node::Kwsplat`
    pub fn is_kwsplat(&self) -> bool {
        unsafe { lib_ruby_parser__external__nodes__is_kwsplat(&self.blob) }
    }
    /// Returns true if `self` is `Node::Lambda`
    pub fn is_lambda(&self) -> bool {
        unsafe { lib_ruby_parser__external__nodes__is_lambda(&self.blob) }
    }
    /// Returns true if `self` is `Node::Line`
    pub fn is_line(&self) -> bool {
        unsafe { lib_ruby_parser__external__nodes__is_line(&self.blob) }
    }
    /// Returns true if `self` is `Node::Lvar`
    pub fn is_lvar(&self) -> bool {
        unsafe { lib_ruby_parser__external__nodes__is_lvar(&self.blob) }
    }
    /// Returns true if `self` is `Node::Lvasgn`
    pub fn is_lvasgn(&self) -> bool {
        unsafe { lib_ruby_parser__external__nodes__is_lvasgn(&self.blob) }
    }
    /// Returns true if `self` is `Node::Masgn`
    pub fn is_masgn(&self) -> bool {
        unsafe { lib_ruby_parser__external__nodes__is_masgn(&self.blob) }
    }
    /// Returns true if `self` is `Node::MatchAlt`
    pub fn is_match_alt(&self) -> bool {
        unsafe { lib_ruby_parser__external__nodes__is_match_alt(&self.blob) }
    }
    /// Returns true if `self` is `Node::MatchAs`
    pub fn is_match_as(&self) -> bool {
        unsafe { lib_ruby_parser__external__nodes__is_match_as(&self.blob) }
    }
    /// Returns true if `self` is `Node::MatchCurrentLine`
    pub fn is_match_current_line(&self) -> bool {
        unsafe { lib_ruby_parser__external__nodes__is_match_current_line(&self.blob) }
    }
    /// Returns true if `self` is `Node::MatchNilPattern`
    pub fn is_match_nil_pattern(&self) -> bool {
        unsafe { lib_ruby_parser__external__nodes__is_match_nil_pattern(&self.blob) }
    }
    /// Returns true if `self` is `Node::MatchRest`
    pub fn is_match_rest(&self) -> bool {
        unsafe { lib_ruby_parser__external__nodes__is_match_rest(&self.blob) }
    }
    /// Returns true if `self` is `Node::MatchVar`
    pub fn is_match_var(&self) -> bool {
        unsafe { lib_ruby_parser__external__nodes__is_match_var(&self.blob) }
    }
    /// Returns true if `self` is `Node::MatchWithLvasgn`
    pub fn is_match_with_lvasgn(&self) -> bool {
        unsafe { lib_ruby_parser__external__nodes__is_match_with_lvasgn(&self.blob) }
    }
    /// Returns true if `self` is `Node::Mlhs`
    pub fn is_mlhs(&self) -> bool {
        unsafe { lib_ruby_parser__external__nodes__is_mlhs(&self.blob) }
    }
    /// Returns true if `self` is `Node::Module`
    pub fn is_module(&self) -> bool {
        unsafe { lib_ruby_parser__external__nodes__is_module(&self.blob) }
    }
    /// Returns true if `self` is `Node::Next`
    pub fn is_next(&self) -> bool {
        unsafe { lib_ruby_parser__external__nodes__is_next(&self.blob) }
    }
    /// Returns true if `self` is `Node::Nil`
    pub fn is_nil(&self) -> bool {
        unsafe { lib_ruby_parser__external__nodes__is_nil(&self.blob) }
    }
    /// Returns true if `self` is `Node::NthRef`
    pub fn is_nth_ref(&self) -> bool {
        unsafe { lib_ruby_parser__external__nodes__is_nth_ref(&self.blob) }
    }
    /// Returns true if `self` is `Node::Numblock`
    pub fn is_numblock(&self) -> bool {
        unsafe { lib_ruby_parser__external__nodes__is_numblock(&self.blob) }
    }
    /// Returns true if `self` is `Node::OpAsgn`
    pub fn is_op_asgn(&self) -> bool {
        unsafe { lib_ruby_parser__external__nodes__is_op_asgn(&self.blob) }
    }
    /// Returns true if `self` is `Node::Optarg`
    pub fn is_optarg(&self) -> bool {
        unsafe { lib_ruby_parser__external__nodes__is_optarg(&self.blob) }
    }
    /// Returns true if `self` is `Node::Or`
    pub fn is_or(&self) -> bool {
        unsafe { lib_ruby_parser__external__nodes__is_or(&self.blob) }
    }
    /// Returns true if `self` is `Node::OrAsgn`
    pub fn is_or_asgn(&self) -> bool {
        unsafe { lib_ruby_parser__external__nodes__is_or_asgn(&self.blob) }
    }
    /// Returns true if `self` is `Node::Pair`
    pub fn is_pair(&self) -> bool {
        unsafe { lib_ruby_parser__external__nodes__is_pair(&self.blob) }
    }
    /// Returns true if `self` is `Node::Pin`
    pub fn is_pin(&self) -> bool {
        unsafe { lib_ruby_parser__external__nodes__is_pin(&self.blob) }
    }
    /// Returns true if `self` is `Node::Postexe`
    pub fn is_postexe(&self) -> bool {
        unsafe { lib_ruby_parser__external__nodes__is_postexe(&self.blob) }
    }
    /// Returns true if `self` is `Node::Preexe`
    pub fn is_preexe(&self) -> bool {
        unsafe { lib_ruby_parser__external__nodes__is_preexe(&self.blob) }
    }
    /// Returns true if `self` is `Node::Procarg0`
    pub fn is_procarg0(&self) -> bool {
        unsafe { lib_ruby_parser__external__nodes__is_procarg0(&self.blob) }
    }
    /// Returns true if `self` is `Node::Rational`
    pub fn is_rational(&self) -> bool {
        unsafe { lib_ruby_parser__external__nodes__is_rational(&self.blob) }
    }
    /// Returns true if `self` is `Node::Redo`
    pub fn is_redo(&self) -> bool {
        unsafe { lib_ruby_parser__external__nodes__is_redo(&self.blob) }
    }
    /// Returns true if `self` is `Node::RegOpt`
    pub fn is_reg_opt(&self) -> bool {
        unsafe { lib_ruby_parser__external__nodes__is_reg_opt(&self.blob) }
    }
    /// Returns true if `self` is `Node::Regexp`
    pub fn is_regexp(&self) -> bool {
        unsafe { lib_ruby_parser__external__nodes__is_regexp(&self.blob) }
    }
    /// Returns true if `self` is `Node::Rescue`
    pub fn is_rescue(&self) -> bool {
        unsafe { lib_ruby_parser__external__nodes__is_rescue(&self.blob) }
    }
    /// Returns true if `self` is `Node::RescueBody`
    pub fn is_rescue_body(&self) -> bool {
        unsafe { lib_ruby_parser__external__nodes__is_rescue_body(&self.blob) }
    }
    /// Returns true if `self` is `Node::Restarg`
    pub fn is_restarg(&self) -> bool {
        unsafe { lib_ruby_parser__external__nodes__is_restarg(&self.blob) }
    }
    /// Returns true if `self` is `Node::Retry`
    pub fn is_retry(&self) -> bool {
        unsafe { lib_ruby_parser__external__nodes__is_retry(&self.blob) }
    }
    /// Returns true if `self` is `Node::Return`
    pub fn is_return(&self) -> bool {
        unsafe { lib_ruby_parser__external__nodes__is_return(&self.blob) }
    }
    /// Returns true if `self` is `Node::SClass`
    pub fn is_s_class(&self) -> bool {
        unsafe { lib_ruby_parser__external__nodes__is_s_class(&self.blob) }
    }
    /// Returns true if `self` is `Node::Self_`
    pub fn is_self(&self) -> bool {
        unsafe { lib_ruby_parser__external__nodes__is_self(&self.blob) }
    }
    /// Returns true if `self` is `Node::Send`
    pub fn is_send(&self) -> bool {
        unsafe { lib_ruby_parser__external__nodes__is_send(&self.blob) }
    }
    /// Returns true if `self` is `Node::Shadowarg`
    pub fn is_shadowarg(&self) -> bool {
        unsafe { lib_ruby_parser__external__nodes__is_shadowarg(&self.blob) }
    }
    /// Returns true if `self` is `Node::Splat`
    pub fn is_splat(&self) -> bool {
        unsafe { lib_ruby_parser__external__nodes__is_splat(&self.blob) }
    }
    /// Returns true if `self` is `Node::Str`
    pub fn is_str(&self) -> bool {
        unsafe { lib_ruby_parser__external__nodes__is_str(&self.blob) }
    }
    /// Returns true if `self` is `Node::Super`
    pub fn is_super(&self) -> bool {
        unsafe { lib_ruby_parser__external__nodes__is_super(&self.blob) }
    }
    /// Returns true if `self` is `Node::Sym`
    pub fn is_sym(&self) -> bool {
        unsafe { lib_ruby_parser__external__nodes__is_sym(&self.blob) }
    }
    /// Returns true if `self` is `Node::True`
    pub fn is_true(&self) -> bool {
        unsafe { lib_ruby_parser__external__nodes__is_true(&self.blob) }
    }
    /// Returns true if `self` is `Node::Undef`
    pub fn is_undef(&self) -> bool {
        unsafe { lib_ruby_parser__external__nodes__is_undef(&self.blob) }
    }
    /// Returns true if `self` is `Node::UnlessGuard`
    pub fn is_unless_guard(&self) -> bool {
        unsafe { lib_ruby_parser__external__nodes__is_unless_guard(&self.blob) }
    }
    /// Returns true if `self` is `Node::Until`
    pub fn is_until(&self) -> bool {
        unsafe { lib_ruby_parser__external__nodes__is_until(&self.blob) }
    }
    /// Returns true if `self` is `Node::UntilPost`
    pub fn is_until_post(&self) -> bool {
        unsafe { lib_ruby_parser__external__nodes__is_until_post(&self.blob) }
    }
    /// Returns true if `self` is `Node::When`
    pub fn is_when(&self) -> bool {
        unsafe { lib_ruby_parser__external__nodes__is_when(&self.blob) }
    }
    /// Returns true if `self` is `Node::While`
    pub fn is_while(&self) -> bool {
        unsafe { lib_ruby_parser__external__nodes__is_while(&self.blob) }
    }
    /// Returns true if `self` is `Node::WhilePost`
    pub fn is_while_post(&self) -> bool {
        unsafe { lib_ruby_parser__external__nodes__is_while_post(&self.blob) }
    }
    /// Returns true if `self` is `Node::XHeredoc`
    pub fn is_x_heredoc(&self) -> bool {
        unsafe { lib_ruby_parser__external__nodes__is_x_heredoc(&self.blob) }
    }
    /// Returns true if `self` is `Node::Xstr`
    pub fn is_xstr(&self) -> bool {
        unsafe { lib_ruby_parser__external__nodes__is_xstr(&self.blob) }
    }
    /// Returns true if `self` is `Node::Yield`
    pub fn is_yield(&self) -> bool {
        unsafe { lib_ruby_parser__external__nodes__is_yield(&self.blob) }
    }
    /// Returns true if `self` is `Node::ZSuper`
    pub fn is_z_super(&self) -> bool {
        unsafe { lib_ruby_parser__external__nodes__is_z_super(&self.blob) }
    }

    // as_<node> FNs
    /// Casts `&Node` to `Option<&nodes::Alias>`
    pub fn as_alias(&self) -> Option<&Alias> {
        unsafe { (lib_ruby_parser__external__nodes__get_alias(&self.blob) as *const Alias).as_ref() }
    }
    /// Casts `&Node` to `Option<&nodes::AndAsgn>`
    pub fn as_and_asgn(&self) -> Option<&AndAsgn> {
        unsafe { (lib_ruby_parser__external__nodes__get_and_asgn(&self.blob) as *const AndAsgn).as_ref() }
    }
    /// Casts `&Node` to `Option<&nodes::And>`
    pub fn as_and(&self) -> Option<&And> {
        unsafe { (lib_ruby_parser__external__nodes__get_and(&self.blob) as *const And).as_ref() }
    }
    /// Casts `&Node` to `Option<&nodes::Arg>`
    pub fn as_arg(&self) -> Option<&Arg> {
        unsafe { (lib_ruby_parser__external__nodes__get_arg(&self.blob) as *const Arg).as_ref() }
    }
    /// Casts `&Node` to `Option<&nodes::Args>`
    pub fn as_args(&self) -> Option<&Args> {
        unsafe { (lib_ruby_parser__external__nodes__get_args(&self.blob) as *const Args).as_ref() }
    }
    /// Casts `&Node` to `Option<&nodes::Array>`
    pub fn as_array(&self) -> Option<&Array> {
        unsafe { (lib_ruby_parser__external__nodes__get_array(&self.blob) as *const Array).as_ref() }
    }
    /// Casts `&Node` to `Option<&nodes::ArrayPattern>`
    pub fn as_array_pattern(&self) -> Option<&ArrayPattern> {
        unsafe { (lib_ruby_parser__external__nodes__get_array_pattern(&self.blob) as *const ArrayPattern).as_ref() }
    }
    /// Casts `&Node` to `Option<&nodes::ArrayPatternWithTail>`
    pub fn as_array_pattern_with_tail(&self) -> Option<&ArrayPatternWithTail> {
        unsafe { (lib_ruby_parser__external__nodes__get_array_pattern_with_tail(&self.blob) as *const ArrayPatternWithTail).as_ref() }
    }
    /// Casts `&Node` to `Option<&nodes::BackRef>`
    pub fn as_back_ref(&self) -> Option<&BackRef> {
        unsafe { (lib_ruby_parser__external__nodes__get_back_ref(&self.blob) as *const BackRef).as_ref() }
    }
    /// Casts `&Node` to `Option<&nodes::Begin>`
    pub fn as_begin(&self) -> Option<&Begin> {
        unsafe { (lib_ruby_parser__external__nodes__get_begin(&self.blob) as *const Begin).as_ref() }
    }
    /// Casts `&Node` to `Option<&nodes::Block>`
    pub fn as_block(&self) -> Option<&Block> {
        unsafe { (lib_ruby_parser__external__nodes__get_block(&self.blob) as *const Block).as_ref() }
    }
    /// Casts `&Node` to `Option<&nodes::BlockPass>`
    pub fn as_block_pass(&self) -> Option<&BlockPass> {
        unsafe { (lib_ruby_parser__external__nodes__get_block_pass(&self.blob) as *const BlockPass).as_ref() }
    }
    /// Casts `&Node` to `Option<&nodes::Blockarg>`
    pub fn as_blockarg(&self) -> Option<&Blockarg> {
        unsafe { (lib_ruby_parser__external__nodes__get_blockarg(&self.blob) as *const Blockarg).as_ref() }
    }
    /// Casts `&Node` to `Option<&nodes::Break>`
    pub fn as_break(&self) -> Option<&Break> {
        unsafe { (lib_ruby_parser__external__nodes__get_break(&self.blob) as *const Break).as_ref() }
    }
    /// Casts `&Node` to `Option<&nodes::Case>`
    pub fn as_case(&self) -> Option<&Case> {
        unsafe { (lib_ruby_parser__external__nodes__get_case(&self.blob) as *const Case).as_ref() }
    }
    /// Casts `&Node` to `Option<&nodes::CaseMatch>`
    pub fn as_case_match(&self) -> Option<&CaseMatch> {
        unsafe { (lib_ruby_parser__external__nodes__get_case_match(&self.blob) as *const CaseMatch).as_ref() }
    }
    /// Casts `&Node` to `Option<&nodes::Casgn>`
    pub fn as_casgn(&self) -> Option<&Casgn> {
        unsafe { (lib_ruby_parser__external__nodes__get_casgn(&self.blob) as *const Casgn).as_ref() }
    }
    /// Casts `&Node` to `Option<&nodes::Cbase>`
    pub fn as_cbase(&self) -> Option<&Cbase> {
        unsafe { (lib_ruby_parser__external__nodes__get_cbase(&self.blob) as *const Cbase).as_ref() }
    }
    /// Casts `&Node` to `Option<&nodes::Class>`
    pub fn as_class(&self) -> Option<&Class> {
        unsafe { (lib_ruby_parser__external__nodes__get_class(&self.blob) as *const Class).as_ref() }
    }
    /// Casts `&Node` to `Option<&nodes::Complex>`
    pub fn as_complex(&self) -> Option<&Complex> {
        unsafe { (lib_ruby_parser__external__nodes__get_complex(&self.blob) as *const Complex).as_ref() }
    }
    /// Casts `&Node` to `Option<&nodes::Const>`
    pub fn as_const(&self) -> Option<&Const> {
        unsafe { (lib_ruby_parser__external__nodes__get_const(&self.blob) as *const Const).as_ref() }
    }
    /// Casts `&Node` to `Option<&nodes::ConstPattern>`
    pub fn as_const_pattern(&self) -> Option<&ConstPattern> {
        unsafe { (lib_ruby_parser__external__nodes__get_const_pattern(&self.blob) as *const ConstPattern).as_ref() }
    }
    /// Casts `&Node` to `Option<&nodes::CSend>`
    pub fn as_c_send(&self) -> Option<&CSend> {
        unsafe { (lib_ruby_parser__external__nodes__get_c_send(&self.blob) as *const CSend).as_ref() }
    }
    /// Casts `&Node` to `Option<&nodes::Cvar>`
    pub fn as_cvar(&self) -> Option<&Cvar> {
        unsafe { (lib_ruby_parser__external__nodes__get_cvar(&self.blob) as *const Cvar).as_ref() }
    }
    /// Casts `&Node` to `Option<&nodes::Cvasgn>`
    pub fn as_cvasgn(&self) -> Option<&Cvasgn> {
        unsafe { (lib_ruby_parser__external__nodes__get_cvasgn(&self.blob) as *const Cvasgn).as_ref() }
    }
    /// Casts `&Node` to `Option<&nodes::Def>`
    pub fn as_def(&self) -> Option<&Def> {
        unsafe { (lib_ruby_parser__external__nodes__get_def(&self.blob) as *const Def).as_ref() }
    }
    /// Casts `&Node` to `Option<&nodes::Defined>`
    pub fn as_defined(&self) -> Option<&Defined> {
        unsafe { (lib_ruby_parser__external__nodes__get_defined(&self.blob) as *const Defined).as_ref() }
    }
    /// Casts `&Node` to `Option<&nodes::Defs>`
    pub fn as_defs(&self) -> Option<&Defs> {
        unsafe { (lib_ruby_parser__external__nodes__get_defs(&self.blob) as *const Defs).as_ref() }
    }
    /// Casts `&Node` to `Option<&nodes::Dstr>`
    pub fn as_dstr(&self) -> Option<&Dstr> {
        unsafe { (lib_ruby_parser__external__nodes__get_dstr(&self.blob) as *const Dstr).as_ref() }
    }
    /// Casts `&Node` to `Option<&nodes::Dsym>`
    pub fn as_dsym(&self) -> Option<&Dsym> {
        unsafe { (lib_ruby_parser__external__nodes__get_dsym(&self.blob) as *const Dsym).as_ref() }
    }
    /// Casts `&Node` to `Option<&nodes::EFlipFlop>`
    pub fn as_e_flip_flop(&self) -> Option<&EFlipFlop> {
        unsafe { (lib_ruby_parser__external__nodes__get_e_flip_flop(&self.blob) as *const EFlipFlop).as_ref() }
    }
    /// Casts `&Node` to `Option<&nodes::EmptyElse>`
    pub fn as_empty_else(&self) -> Option<&EmptyElse> {
        unsafe { (lib_ruby_parser__external__nodes__get_empty_else(&self.blob) as *const EmptyElse).as_ref() }
    }
    /// Casts `&Node` to `Option<&nodes::Encoding>`
    pub fn as_encoding(&self) -> Option<&Encoding> {
        unsafe { (lib_ruby_parser__external__nodes__get_encoding(&self.blob) as *const Encoding).as_ref() }
    }
    /// Casts `&Node` to `Option<&nodes::Ensure>`
    pub fn as_ensure(&self) -> Option<&Ensure> {
        unsafe { (lib_ruby_parser__external__nodes__get_ensure(&self.blob) as *const Ensure).as_ref() }
    }
    /// Casts `&Node` to `Option<&nodes::Erange>`
    pub fn as_erange(&self) -> Option<&Erange> {
        unsafe { (lib_ruby_parser__external__nodes__get_erange(&self.blob) as *const Erange).as_ref() }
    }
    /// Casts `&Node` to `Option<&nodes::False>`
    pub fn as_false(&self) -> Option<&False> {
        unsafe { (lib_ruby_parser__external__nodes__get_false(&self.blob) as *const False).as_ref() }
    }
    /// Casts `&Node` to `Option<&nodes::File>`
    pub fn as_file(&self) -> Option<&File> {
        unsafe { (lib_ruby_parser__external__nodes__get_file(&self.blob) as *const File).as_ref() }
    }
    /// Casts `&Node` to `Option<&nodes::FindPattern>`
    pub fn as_find_pattern(&self) -> Option<&FindPattern> {
        unsafe { (lib_ruby_parser__external__nodes__get_find_pattern(&self.blob) as *const FindPattern).as_ref() }
    }
    /// Casts `&Node` to `Option<&nodes::Float>`
    pub fn as_float(&self) -> Option<&Float> {
        unsafe { (lib_ruby_parser__external__nodes__get_float(&self.blob) as *const Float).as_ref() }
    }
    /// Casts `&Node` to `Option<&nodes::For>`
    pub fn as_for(&self) -> Option<&For> {
        unsafe { (lib_ruby_parser__external__nodes__get_for(&self.blob) as *const For).as_ref() }
    }
    /// Casts `&Node` to `Option<&nodes::ForwardArg>`
    pub fn as_forward_arg(&self) -> Option<&ForwardArg> {
        unsafe { (lib_ruby_parser__external__nodes__get_forward_arg(&self.blob) as *const ForwardArg).as_ref() }
    }
    /// Casts `&Node` to `Option<&nodes::ForwardedArgs>`
    pub fn as_forwarded_args(&self) -> Option<&ForwardedArgs> {
        unsafe { (lib_ruby_parser__external__nodes__get_forwarded_args(&self.blob) as *const ForwardedArgs).as_ref() }
    }
    /// Casts `&Node` to `Option<&nodes::Gvar>`
    pub fn as_gvar(&self) -> Option<&Gvar> {
        unsafe { (lib_ruby_parser__external__nodes__get_gvar(&self.blob) as *const Gvar).as_ref() }
    }
    /// Casts `&Node` to `Option<&nodes::Gvasgn>`
    pub fn as_gvasgn(&self) -> Option<&Gvasgn> {
        unsafe { (lib_ruby_parser__external__nodes__get_gvasgn(&self.blob) as *const Gvasgn).as_ref() }
    }
    /// Casts `&Node` to `Option<&nodes::Hash>`
    pub fn as_hash(&self) -> Option<&Hash> {
        unsafe { (lib_ruby_parser__external__nodes__get_hash(&self.blob) as *const Hash).as_ref() }
    }
    /// Casts `&Node` to `Option<&nodes::Kwargs>`
    pub fn as_kwargs(&self) -> Option<&Kwargs> {
        unsafe { (lib_ruby_parser__external__nodes__get_kwargs(&self.blob) as *const Kwargs).as_ref() }
    }
    /// Casts `&Node` to `Option<&nodes::HashPattern>`
    pub fn as_hash_pattern(&self) -> Option<&HashPattern> {
        unsafe { (lib_ruby_parser__external__nodes__get_hash_pattern(&self.blob) as *const HashPattern).as_ref() }
    }
    /// Casts `&Node` to `Option<&nodes::Heredoc>`
    pub fn as_heredoc(&self) -> Option<&Heredoc> {
        unsafe { (lib_ruby_parser__external__nodes__get_heredoc(&self.blob) as *const Heredoc).as_ref() }
    }
    /// Casts `&Node` to `Option<&nodes::If>`
    pub fn as_if(&self) -> Option<&If> {
        unsafe { (lib_ruby_parser__external__nodes__get_if(&self.blob) as *const If).as_ref() }
    }
    /// Casts `&Node` to `Option<&nodes::IfGuard>`
    pub fn as_if_guard(&self) -> Option<&IfGuard> {
        unsafe { (lib_ruby_parser__external__nodes__get_if_guard(&self.blob) as *const IfGuard).as_ref() }
    }
    /// Casts `&Node` to `Option<&nodes::IfMod>`
    pub fn as_if_mod(&self) -> Option<&IfMod> {
        unsafe { (lib_ruby_parser__external__nodes__get_if_mod(&self.blob) as *const IfMod).as_ref() }
    }
    /// Casts `&Node` to `Option<&nodes::IfTernary>`
    pub fn as_if_ternary(&self) -> Option<&IfTernary> {
        unsafe { (lib_ruby_parser__external__nodes__get_if_ternary(&self.blob) as *const IfTernary).as_ref() }
    }
    /// Casts `&Node` to `Option<&nodes::IFlipFlop>`
    pub fn as_i_flip_flop(&self) -> Option<&IFlipFlop> {
        unsafe { (lib_ruby_parser__external__nodes__get_i_flip_flop(&self.blob) as *const IFlipFlop).as_ref() }
    }
    /// Casts `&Node` to `Option<&nodes::MatchPattern>`
    pub fn as_match_pattern(&self) -> Option<&MatchPattern> {
        unsafe { (lib_ruby_parser__external__nodes__get_match_pattern(&self.blob) as *const MatchPattern).as_ref() }
    }
    /// Casts `&Node` to `Option<&nodes::MatchPatternP>`
    pub fn as_match_pattern_p(&self) -> Option<&MatchPatternP> {
        unsafe { (lib_ruby_parser__external__nodes__get_match_pattern_p(&self.blob) as *const MatchPatternP).as_ref() }
    }
    /// Casts `&Node` to `Option<&nodes::InPattern>`
    pub fn as_in_pattern(&self) -> Option<&InPattern> {
        unsafe { (lib_ruby_parser__external__nodes__get_in_pattern(&self.blob) as *const InPattern).as_ref() }
    }
    /// Casts `&Node` to `Option<&nodes::Index>`
    pub fn as_index(&self) -> Option<&Index> {
        unsafe { (lib_ruby_parser__external__nodes__get_index(&self.blob) as *const Index).as_ref() }
    }
    /// Casts `&Node` to `Option<&nodes::IndexAsgn>`
    pub fn as_index_asgn(&self) -> Option<&IndexAsgn> {
        unsafe { (lib_ruby_parser__external__nodes__get_index_asgn(&self.blob) as *const IndexAsgn).as_ref() }
    }
    /// Casts `&Node` to `Option<&nodes::Int>`
    pub fn as_int(&self) -> Option<&Int> {
        unsafe { (lib_ruby_parser__external__nodes__get_int(&self.blob) as *const Int).as_ref() }
    }
    /// Casts `&Node` to `Option<&nodes::Irange>`
    pub fn as_irange(&self) -> Option<&Irange> {
        unsafe { (lib_ruby_parser__external__nodes__get_irange(&self.blob) as *const Irange).as_ref() }
    }
    /// Casts `&Node` to `Option<&nodes::Ivar>`
    pub fn as_ivar(&self) -> Option<&Ivar> {
        unsafe { (lib_ruby_parser__external__nodes__get_ivar(&self.blob) as *const Ivar).as_ref() }
    }
    /// Casts `&Node` to `Option<&nodes::Ivasgn>`
    pub fn as_ivasgn(&self) -> Option<&Ivasgn> {
        unsafe { (lib_ruby_parser__external__nodes__get_ivasgn(&self.blob) as *const Ivasgn).as_ref() }
    }
    /// Casts `&Node` to `Option<&nodes::Kwarg>`
    pub fn as_kwarg(&self) -> Option<&Kwarg> {
        unsafe { (lib_ruby_parser__external__nodes__get_kwarg(&self.blob) as *const Kwarg).as_ref() }
    }
    /// Casts `&Node` to `Option<&nodes::KwBegin>`
    pub fn as_kw_begin(&self) -> Option<&KwBegin> {
        unsafe { (lib_ruby_parser__external__nodes__get_kw_begin(&self.blob) as *const KwBegin).as_ref() }
    }
    /// Casts `&Node` to `Option<&nodes::Kwnilarg>`
    pub fn as_kwnilarg(&self) -> Option<&Kwnilarg> {
        unsafe { (lib_ruby_parser__external__nodes__get_kwnilarg(&self.blob) as *const Kwnilarg).as_ref() }
    }
    /// Casts `&Node` to `Option<&nodes::Kwoptarg>`
    pub fn as_kwoptarg(&self) -> Option<&Kwoptarg> {
        unsafe { (lib_ruby_parser__external__nodes__get_kwoptarg(&self.blob) as *const Kwoptarg).as_ref() }
    }
    /// Casts `&Node` to `Option<&nodes::Kwrestarg>`
    pub fn as_kwrestarg(&self) -> Option<&Kwrestarg> {
        unsafe { (lib_ruby_parser__external__nodes__get_kwrestarg(&self.blob) as *const Kwrestarg).as_ref() }
    }
    /// Casts `&Node` to `Option<&nodes::Kwsplat>`
    pub fn as_kwsplat(&self) -> Option<&Kwsplat> {
        unsafe { (lib_ruby_parser__external__nodes__get_kwsplat(&self.blob) as *const Kwsplat).as_ref() }
    }
    /// Casts `&Node` to `Option<&nodes::Lambda>`
    pub fn as_lambda(&self) -> Option<&Lambda> {
        unsafe { (lib_ruby_parser__external__nodes__get_lambda(&self.blob) as *const Lambda).as_ref() }
    }
    /// Casts `&Node` to `Option<&nodes::Line>`
    pub fn as_line(&self) -> Option<&Line> {
        unsafe { (lib_ruby_parser__external__nodes__get_line(&self.blob) as *const Line).as_ref() }
    }
    /// Casts `&Node` to `Option<&nodes::Lvar>`
    pub fn as_lvar(&self) -> Option<&Lvar> {
        unsafe { (lib_ruby_parser__external__nodes__get_lvar(&self.blob) as *const Lvar).as_ref() }
    }
    /// Casts `&Node` to `Option<&nodes::Lvasgn>`
    pub fn as_lvasgn(&self) -> Option<&Lvasgn> {
        unsafe { (lib_ruby_parser__external__nodes__get_lvasgn(&self.blob) as *const Lvasgn).as_ref() }
    }
    /// Casts `&Node` to `Option<&nodes::Masgn>`
    pub fn as_masgn(&self) -> Option<&Masgn> {
        unsafe { (lib_ruby_parser__external__nodes__get_masgn(&self.blob) as *const Masgn).as_ref() }
    }
    /// Casts `&Node` to `Option<&nodes::MatchAlt>`
    pub fn as_match_alt(&self) -> Option<&MatchAlt> {
        unsafe { (lib_ruby_parser__external__nodes__get_match_alt(&self.blob) as *const MatchAlt).as_ref() }
    }
    /// Casts `&Node` to `Option<&nodes::MatchAs>`
    pub fn as_match_as(&self) -> Option<&MatchAs> {
        unsafe { (lib_ruby_parser__external__nodes__get_match_as(&self.blob) as *const MatchAs).as_ref() }
    }
    /// Casts `&Node` to `Option<&nodes::MatchCurrentLine>`
    pub fn as_match_current_line(&self) -> Option<&MatchCurrentLine> {
        unsafe { (lib_ruby_parser__external__nodes__get_match_current_line(&self.blob) as *const MatchCurrentLine).as_ref() }
    }
    /// Casts `&Node` to `Option<&nodes::MatchNilPattern>`
    pub fn as_match_nil_pattern(&self) -> Option<&MatchNilPattern> {
        unsafe { (lib_ruby_parser__external__nodes__get_match_nil_pattern(&self.blob) as *const MatchNilPattern).as_ref() }
    }
    /// Casts `&Node` to `Option<&nodes::MatchRest>`
    pub fn as_match_rest(&self) -> Option<&MatchRest> {
        unsafe { (lib_ruby_parser__external__nodes__get_match_rest(&self.blob) as *const MatchRest).as_ref() }
    }
    /// Casts `&Node` to `Option<&nodes::MatchVar>`
    pub fn as_match_var(&self) -> Option<&MatchVar> {
        unsafe { (lib_ruby_parser__external__nodes__get_match_var(&self.blob) as *const MatchVar).as_ref() }
    }
    /// Casts `&Node` to `Option<&nodes::MatchWithLvasgn>`
    pub fn as_match_with_lvasgn(&self) -> Option<&MatchWithLvasgn> {
        unsafe { (lib_ruby_parser__external__nodes__get_match_with_lvasgn(&self.blob) as *const MatchWithLvasgn).as_ref() }
    }
    /// Casts `&Node` to `Option<&nodes::Mlhs>`
    pub fn as_mlhs(&self) -> Option<&Mlhs> {
        unsafe { (lib_ruby_parser__external__nodes__get_mlhs(&self.blob) as *const Mlhs).as_ref() }
    }
    /// Casts `&Node` to `Option<&nodes::Module>`
    pub fn as_module(&self) -> Option<&Module> {
        unsafe { (lib_ruby_parser__external__nodes__get_module(&self.blob) as *const Module).as_ref() }
    }
    /// Casts `&Node` to `Option<&nodes::Next>`
    pub fn as_next(&self) -> Option<&Next> {
        unsafe { (lib_ruby_parser__external__nodes__get_next(&self.blob) as *const Next).as_ref() }
    }
    /// Casts `&Node` to `Option<&nodes::Nil>`
    pub fn as_nil(&self) -> Option<&Nil> {
        unsafe { (lib_ruby_parser__external__nodes__get_nil(&self.blob) as *const Nil).as_ref() }
    }
    /// Casts `&Node` to `Option<&nodes::NthRef>`
    pub fn as_nth_ref(&self) -> Option<&NthRef> {
        unsafe { (lib_ruby_parser__external__nodes__get_nth_ref(&self.blob) as *const NthRef).as_ref() }
    }
    /// Casts `&Node` to `Option<&nodes::Numblock>`
    pub fn as_numblock(&self) -> Option<&Numblock> {
        unsafe { (lib_ruby_parser__external__nodes__get_numblock(&self.blob) as *const Numblock).as_ref() }
    }
    /// Casts `&Node` to `Option<&nodes::OpAsgn>`
    pub fn as_op_asgn(&self) -> Option<&OpAsgn> {
        unsafe { (lib_ruby_parser__external__nodes__get_op_asgn(&self.blob) as *const OpAsgn).as_ref() }
    }
    /// Casts `&Node` to `Option<&nodes::Optarg>`
    pub fn as_optarg(&self) -> Option<&Optarg> {
        unsafe { (lib_ruby_parser__external__nodes__get_optarg(&self.blob) as *const Optarg).as_ref() }
    }
    /// Casts `&Node` to `Option<&nodes::Or>`
    pub fn as_or(&self) -> Option<&Or> {
        unsafe { (lib_ruby_parser__external__nodes__get_or(&self.blob) as *const Or).as_ref() }
    }
    /// Casts `&Node` to `Option<&nodes::OrAsgn>`
    pub fn as_or_asgn(&self) -> Option<&OrAsgn> {
        unsafe { (lib_ruby_parser__external__nodes__get_or_asgn(&self.blob) as *const OrAsgn).as_ref() }
    }
    /// Casts `&Node` to `Option<&nodes::Pair>`
    pub fn as_pair(&self) -> Option<&Pair> {
        unsafe { (lib_ruby_parser__external__nodes__get_pair(&self.blob) as *const Pair).as_ref() }
    }
    /// Casts `&Node` to `Option<&nodes::Pin>`
    pub fn as_pin(&self) -> Option<&Pin> {
        unsafe { (lib_ruby_parser__external__nodes__get_pin(&self.blob) as *const Pin).as_ref() }
    }
    /// Casts `&Node` to `Option<&nodes::Postexe>`
    pub fn as_postexe(&self) -> Option<&Postexe> {
        unsafe { (lib_ruby_parser__external__nodes__get_postexe(&self.blob) as *const Postexe).as_ref() }
    }
    /// Casts `&Node` to `Option<&nodes::Preexe>`
    pub fn as_preexe(&self) -> Option<&Preexe> {
        unsafe { (lib_ruby_parser__external__nodes__get_preexe(&self.blob) as *const Preexe).as_ref() }
    }
    /// Casts `&Node` to `Option<&nodes::Procarg0>`
    pub fn as_procarg0(&self) -> Option<&Procarg0> {
        unsafe { (lib_ruby_parser__external__nodes__get_procarg0(&self.blob) as *const Procarg0).as_ref() }
    }
    /// Casts `&Node` to `Option<&nodes::Rational>`
    pub fn as_rational(&self) -> Option<&Rational> {
        unsafe { (lib_ruby_parser__external__nodes__get_rational(&self.blob) as *const Rational).as_ref() }
    }
    /// Casts `&Node` to `Option<&nodes::Redo>`
    pub fn as_redo(&self) -> Option<&Redo> {
        unsafe { (lib_ruby_parser__external__nodes__get_redo(&self.blob) as *const Redo).as_ref() }
    }
    /// Casts `&Node` to `Option<&nodes::RegOpt>`
    pub fn as_reg_opt(&self) -> Option<&RegOpt> {
        unsafe { (lib_ruby_parser__external__nodes__get_reg_opt(&self.blob) as *const RegOpt).as_ref() }
    }
    /// Casts `&Node` to `Option<&nodes::Regexp>`
    pub fn as_regexp(&self) -> Option<&Regexp> {
        unsafe { (lib_ruby_parser__external__nodes__get_regexp(&self.blob) as *const Regexp).as_ref() }
    }
    /// Casts `&Node` to `Option<&nodes::Rescue>`
    pub fn as_rescue(&self) -> Option<&Rescue> {
        unsafe { (lib_ruby_parser__external__nodes__get_rescue(&self.blob) as *const Rescue).as_ref() }
    }
    /// Casts `&Node` to `Option<&nodes::RescueBody>`
    pub fn as_rescue_body(&self) -> Option<&RescueBody> {
        unsafe { (lib_ruby_parser__external__nodes__get_rescue_body(&self.blob) as *const RescueBody).as_ref() }
    }
    /// Casts `&Node` to `Option<&nodes::Restarg>`
    pub fn as_restarg(&self) -> Option<&Restarg> {
        unsafe { (lib_ruby_parser__external__nodes__get_restarg(&self.blob) as *const Restarg).as_ref() }
    }
    /// Casts `&Node` to `Option<&nodes::Retry>`
    pub fn as_retry(&self) -> Option<&Retry> {
        unsafe { (lib_ruby_parser__external__nodes__get_retry(&self.blob) as *const Retry).as_ref() }
    }
    /// Casts `&Node` to `Option<&nodes::Return>`
    pub fn as_return(&self) -> Option<&Return> {
        unsafe { (lib_ruby_parser__external__nodes__get_return(&self.blob) as *const Return).as_ref() }
    }
    /// Casts `&Node` to `Option<&nodes::SClass>`
    pub fn as_s_class(&self) -> Option<&SClass> {
        unsafe { (lib_ruby_parser__external__nodes__get_s_class(&self.blob) as *const SClass).as_ref() }
    }
    /// Casts `&Node` to `Option<&nodes::Self_>`
    pub fn as_self(&self) -> Option<&Self_> {
        unsafe { (lib_ruby_parser__external__nodes__get_self(&self.blob) as *const Self_).as_ref() }
    }
    /// Casts `&Node` to `Option<&nodes::Send>`
    pub fn as_send(&self) -> Option<&Send> {
        unsafe { (lib_ruby_parser__external__nodes__get_send(&self.blob) as *const Send).as_ref() }
    }
    /// Casts `&Node` to `Option<&nodes::Shadowarg>`
    pub fn as_shadowarg(&self) -> Option<&Shadowarg> {
        unsafe { (lib_ruby_parser__external__nodes__get_shadowarg(&self.blob) as *const Shadowarg).as_ref() }
    }
    /// Casts `&Node` to `Option<&nodes::Splat>`
    pub fn as_splat(&self) -> Option<&Splat> {
        unsafe { (lib_ruby_parser__external__nodes__get_splat(&self.blob) as *const Splat).as_ref() }
    }
    /// Casts `&Node` to `Option<&nodes::Str>`
    pub fn as_str(&self) -> Option<&Str> {
        unsafe { (lib_ruby_parser__external__nodes__get_str(&self.blob) as *const Str).as_ref() }
    }
    /// Casts `&Node` to `Option<&nodes::Super>`
    pub fn as_super(&self) -> Option<&Super> {
        unsafe { (lib_ruby_parser__external__nodes__get_super(&self.blob) as *const Super).as_ref() }
    }
    /// Casts `&Node` to `Option<&nodes::Sym>`
    pub fn as_sym(&self) -> Option<&Sym> {
        unsafe { (lib_ruby_parser__external__nodes__get_sym(&self.blob) as *const Sym).as_ref() }
    }
    /// Casts `&Node` to `Option<&nodes::True>`
    pub fn as_true(&self) -> Option<&True> {
        unsafe { (lib_ruby_parser__external__nodes__get_true(&self.blob) as *const True).as_ref() }
    }
    /// Casts `&Node` to `Option<&nodes::Undef>`
    pub fn as_undef(&self) -> Option<&Undef> {
        unsafe { (lib_ruby_parser__external__nodes__get_undef(&self.blob) as *const Undef).as_ref() }
    }
    /// Casts `&Node` to `Option<&nodes::UnlessGuard>`
    pub fn as_unless_guard(&self) -> Option<&UnlessGuard> {
        unsafe { (lib_ruby_parser__external__nodes__get_unless_guard(&self.blob) as *const UnlessGuard).as_ref() }
    }
    /// Casts `&Node` to `Option<&nodes::Until>`
    pub fn as_until(&self) -> Option<&Until> {
        unsafe { (lib_ruby_parser__external__nodes__get_until(&self.blob) as *const Until).as_ref() }
    }
    /// Casts `&Node` to `Option<&nodes::UntilPost>`
    pub fn as_until_post(&self) -> Option<&UntilPost> {
        unsafe { (lib_ruby_parser__external__nodes__get_until_post(&self.blob) as *const UntilPost).as_ref() }
    }
    /// Casts `&Node` to `Option<&nodes::When>`
    pub fn as_when(&self) -> Option<&When> {
        unsafe { (lib_ruby_parser__external__nodes__get_when(&self.blob) as *const When).as_ref() }
    }
    /// Casts `&Node` to `Option<&nodes::While>`
    pub fn as_while(&self) -> Option<&While> {
        unsafe { (lib_ruby_parser__external__nodes__get_while(&self.blob) as *const While).as_ref() }
    }
    /// Casts `&Node` to `Option<&nodes::WhilePost>`
    pub fn as_while_post(&self) -> Option<&WhilePost> {
        unsafe { (lib_ruby_parser__external__nodes__get_while_post(&self.blob) as *const WhilePost).as_ref() }
    }
    /// Casts `&Node` to `Option<&nodes::XHeredoc>`
    pub fn as_x_heredoc(&self) -> Option<&XHeredoc> {
        unsafe { (lib_ruby_parser__external__nodes__get_x_heredoc(&self.blob) as *const XHeredoc).as_ref() }
    }
    /// Casts `&Node` to `Option<&nodes::Xstr>`
    pub fn as_xstr(&self) -> Option<&Xstr> {
        unsafe { (lib_ruby_parser__external__nodes__get_xstr(&self.blob) as *const Xstr).as_ref() }
    }
    /// Casts `&Node` to `Option<&nodes::Yield>`
    pub fn as_yield(&self) -> Option<&Yield> {
        unsafe { (lib_ruby_parser__external__nodes__get_yield(&self.blob) as *const Yield).as_ref() }
    }
    /// Casts `&Node` to `Option<&nodes::ZSuper>`
    pub fn as_z_super(&self) -> Option<&ZSuper> {
        unsafe { (lib_ruby_parser__external__nodes__get_z_super(&self.blob) as *const ZSuper).as_ref() }
    }

    // as_<node>_mut FNs
    /// Casts `&Node` to `Option<&mut nodes::Alias>`
    pub fn as_alias_mut(&mut self) -> Option<&mut Alias> {
        unsafe { (lib_ruby_parser__external__nodes__get_alias(&self.blob) as *mut Alias).as_mut() }
    }
    /// Casts `&Node` to `Option<&mut nodes::AndAsgn>`
    pub fn as_and_asgn_mut(&mut self) -> Option<&mut AndAsgn> {
        unsafe { (lib_ruby_parser__external__nodes__get_and_asgn(&self.blob) as *mut AndAsgn).as_mut() }
    }
    /// Casts `&Node` to `Option<&mut nodes::And>`
    pub fn as_and_mut(&mut self) -> Option<&mut And> {
        unsafe { (lib_ruby_parser__external__nodes__get_and(&self.blob) as *mut And).as_mut() }
    }
    /// Casts `&Node` to `Option<&mut nodes::Arg>`
    pub fn as_arg_mut(&mut self) -> Option<&mut Arg> {
        unsafe { (lib_ruby_parser__external__nodes__get_arg(&self.blob) as *mut Arg).as_mut() }
    }
    /// Casts `&Node` to `Option<&mut nodes::Args>`
    pub fn as_args_mut(&mut self) -> Option<&mut Args> {
        unsafe { (lib_ruby_parser__external__nodes__get_args(&self.blob) as *mut Args).as_mut() }
    }
    /// Casts `&Node` to `Option<&mut nodes::Array>`
    pub fn as_array_mut(&mut self) -> Option<&mut Array> {
        unsafe { (lib_ruby_parser__external__nodes__get_array(&self.blob) as *mut Array).as_mut() }
    }
    /// Casts `&Node` to `Option<&mut nodes::ArrayPattern>`
    pub fn as_array_pattern_mut(&mut self) -> Option<&mut ArrayPattern> {
        unsafe { (lib_ruby_parser__external__nodes__get_array_pattern(&self.blob) as *mut ArrayPattern).as_mut() }
    }
    /// Casts `&Node` to `Option<&mut nodes::ArrayPatternWithTail>`
    pub fn as_array_pattern_with_tail_mut(&mut self) -> Option<&mut ArrayPatternWithTail> {
        unsafe { (lib_ruby_parser__external__nodes__get_array_pattern_with_tail(&self.blob) as *mut ArrayPatternWithTail).as_mut() }
    }
    /// Casts `&Node` to `Option<&mut nodes::BackRef>`
    pub fn as_back_ref_mut(&mut self) -> Option<&mut BackRef> {
        unsafe { (lib_ruby_parser__external__nodes__get_back_ref(&self.blob) as *mut BackRef).as_mut() }
    }
    /// Casts `&Node` to `Option<&mut nodes::Begin>`
    pub fn as_begin_mut(&mut self) -> Option<&mut Begin> {
        unsafe { (lib_ruby_parser__external__nodes__get_begin(&self.blob) as *mut Begin).as_mut() }
    }
    /// Casts `&Node` to `Option<&mut nodes::Block>`
    pub fn as_block_mut(&mut self) -> Option<&mut Block> {
        unsafe { (lib_ruby_parser__external__nodes__get_block(&self.blob) as *mut Block).as_mut() }
    }
    /// Casts `&Node` to `Option<&mut nodes::BlockPass>`
    pub fn as_block_pass_mut(&mut self) -> Option<&mut BlockPass> {
        unsafe { (lib_ruby_parser__external__nodes__get_block_pass(&self.blob) as *mut BlockPass).as_mut() }
    }
    /// Casts `&Node` to `Option<&mut nodes::Blockarg>`
    pub fn as_blockarg_mut(&mut self) -> Option<&mut Blockarg> {
        unsafe { (lib_ruby_parser__external__nodes__get_blockarg(&self.blob) as *mut Blockarg).as_mut() }
    }
    /// Casts `&Node` to `Option<&mut nodes::Break>`
    pub fn as_break_mut(&mut self) -> Option<&mut Break> {
        unsafe { (lib_ruby_parser__external__nodes__get_break(&self.blob) as *mut Break).as_mut() }
    }
    /// Casts `&Node` to `Option<&mut nodes::Case>`
    pub fn as_case_mut(&mut self) -> Option<&mut Case> {
        unsafe { (lib_ruby_parser__external__nodes__get_case(&self.blob) as *mut Case).as_mut() }
    }
    /// Casts `&Node` to `Option<&mut nodes::CaseMatch>`
    pub fn as_case_match_mut(&mut self) -> Option<&mut CaseMatch> {
        unsafe { (lib_ruby_parser__external__nodes__get_case_match(&self.blob) as *mut CaseMatch).as_mut() }
    }
    /// Casts `&Node` to `Option<&mut nodes::Casgn>`
    pub fn as_casgn_mut(&mut self) -> Option<&mut Casgn> {
        unsafe { (lib_ruby_parser__external__nodes__get_casgn(&self.blob) as *mut Casgn).as_mut() }
    }
    /// Casts `&Node` to `Option<&mut nodes::Cbase>`
    pub fn as_cbase_mut(&mut self) -> Option<&mut Cbase> {
        unsafe { (lib_ruby_parser__external__nodes__get_cbase(&self.blob) as *mut Cbase).as_mut() }
    }
    /// Casts `&Node` to `Option<&mut nodes::Class>`
    pub fn as_class_mut(&mut self) -> Option<&mut Class> {
        unsafe { (lib_ruby_parser__external__nodes__get_class(&self.blob) as *mut Class).as_mut() }
    }
    /// Casts `&Node` to `Option<&mut nodes::Complex>`
    pub fn as_complex_mut(&mut self) -> Option<&mut Complex> {
        unsafe { (lib_ruby_parser__external__nodes__get_complex(&self.blob) as *mut Complex).as_mut() }
    }
    /// Casts `&Node` to `Option<&mut nodes::Const>`
    pub fn as_const_mut(&mut self) -> Option<&mut Const> {
        unsafe { (lib_ruby_parser__external__nodes__get_const(&self.blob) as *mut Const).as_mut() }
    }
    /// Casts `&Node` to `Option<&mut nodes::ConstPattern>`
    pub fn as_const_pattern_mut(&mut self) -> Option<&mut ConstPattern> {
        unsafe { (lib_ruby_parser__external__nodes__get_const_pattern(&self.blob) as *mut ConstPattern).as_mut() }
    }
    /// Casts `&Node` to `Option<&mut nodes::CSend>`
    pub fn as_c_send_mut(&mut self) -> Option<&mut CSend> {
        unsafe { (lib_ruby_parser__external__nodes__get_c_send(&self.blob) as *mut CSend).as_mut() }
    }
    /// Casts `&Node` to `Option<&mut nodes::Cvar>`
    pub fn as_cvar_mut(&mut self) -> Option<&mut Cvar> {
        unsafe { (lib_ruby_parser__external__nodes__get_cvar(&self.blob) as *mut Cvar).as_mut() }
    }
    /// Casts `&Node` to `Option<&mut nodes::Cvasgn>`
    pub fn as_cvasgn_mut(&mut self) -> Option<&mut Cvasgn> {
        unsafe { (lib_ruby_parser__external__nodes__get_cvasgn(&self.blob) as *mut Cvasgn).as_mut() }
    }
    /// Casts `&Node` to `Option<&mut nodes::Def>`
    pub fn as_def_mut(&mut self) -> Option<&mut Def> {
        unsafe { (lib_ruby_parser__external__nodes__get_def(&self.blob) as *mut Def).as_mut() }
    }
    /// Casts `&Node` to `Option<&mut nodes::Defined>`
    pub fn as_defined_mut(&mut self) -> Option<&mut Defined> {
        unsafe { (lib_ruby_parser__external__nodes__get_defined(&self.blob) as *mut Defined).as_mut() }
    }
    /// Casts `&Node` to `Option<&mut nodes::Defs>`
    pub fn as_defs_mut(&mut self) -> Option<&mut Defs> {
        unsafe { (lib_ruby_parser__external__nodes__get_defs(&self.blob) as *mut Defs).as_mut() }
    }
    /// Casts `&Node` to `Option<&mut nodes::Dstr>`
    pub fn as_dstr_mut(&mut self) -> Option<&mut Dstr> {
        unsafe { (lib_ruby_parser__external__nodes__get_dstr(&self.blob) as *mut Dstr).as_mut() }
    }
    /// Casts `&Node` to `Option<&mut nodes::Dsym>`
    pub fn as_dsym_mut(&mut self) -> Option<&mut Dsym> {
        unsafe { (lib_ruby_parser__external__nodes__get_dsym(&self.blob) as *mut Dsym).as_mut() }
    }
    /// Casts `&Node` to `Option<&mut nodes::EFlipFlop>`
    pub fn as_e_flip_flop_mut(&mut self) -> Option<&mut EFlipFlop> {
        unsafe { (lib_ruby_parser__external__nodes__get_e_flip_flop(&self.blob) as *mut EFlipFlop).as_mut() }
    }
    /// Casts `&Node` to `Option<&mut nodes::EmptyElse>`
    pub fn as_empty_else_mut(&mut self) -> Option<&mut EmptyElse> {
        unsafe { (lib_ruby_parser__external__nodes__get_empty_else(&self.blob) as *mut EmptyElse).as_mut() }
    }
    /// Casts `&Node` to `Option<&mut nodes::Encoding>`
    pub fn as_encoding_mut(&mut self) -> Option<&mut Encoding> {
        unsafe { (lib_ruby_parser__external__nodes__get_encoding(&self.blob) as *mut Encoding).as_mut() }
    }
    /// Casts `&Node` to `Option<&mut nodes::Ensure>`
    pub fn as_ensure_mut(&mut self) -> Option<&mut Ensure> {
        unsafe { (lib_ruby_parser__external__nodes__get_ensure(&self.blob) as *mut Ensure).as_mut() }
    }
    /// Casts `&Node` to `Option<&mut nodes::Erange>`
    pub fn as_erange_mut(&mut self) -> Option<&mut Erange> {
        unsafe { (lib_ruby_parser__external__nodes__get_erange(&self.blob) as *mut Erange).as_mut() }
    }
    /// Casts `&Node` to `Option<&mut nodes::False>`
    pub fn as_false_mut(&mut self) -> Option<&mut False> {
        unsafe { (lib_ruby_parser__external__nodes__get_false(&self.blob) as *mut False).as_mut() }
    }
    /// Casts `&Node` to `Option<&mut nodes::File>`
    pub fn as_file_mut(&mut self) -> Option<&mut File> {
        unsafe { (lib_ruby_parser__external__nodes__get_file(&self.blob) as *mut File).as_mut() }
    }
    /// Casts `&Node` to `Option<&mut nodes::FindPattern>`
    pub fn as_find_pattern_mut(&mut self) -> Option<&mut FindPattern> {
        unsafe { (lib_ruby_parser__external__nodes__get_find_pattern(&self.blob) as *mut FindPattern).as_mut() }
    }
    /// Casts `&Node` to `Option<&mut nodes::Float>`
    pub fn as_float_mut(&mut self) -> Option<&mut Float> {
        unsafe { (lib_ruby_parser__external__nodes__get_float(&self.blob) as *mut Float).as_mut() }
    }
    /// Casts `&Node` to `Option<&mut nodes::For>`
    pub fn as_for_mut(&mut self) -> Option<&mut For> {
        unsafe { (lib_ruby_parser__external__nodes__get_for(&self.blob) as *mut For).as_mut() }
    }
    /// Casts `&Node` to `Option<&mut nodes::ForwardArg>`
    pub fn as_forward_arg_mut(&mut self) -> Option<&mut ForwardArg> {
        unsafe { (lib_ruby_parser__external__nodes__get_forward_arg(&self.blob) as *mut ForwardArg).as_mut() }
    }
    /// Casts `&Node` to `Option<&mut nodes::ForwardedArgs>`
    pub fn as_forwarded_args_mut(&mut self) -> Option<&mut ForwardedArgs> {
        unsafe { (lib_ruby_parser__external__nodes__get_forwarded_args(&self.blob) as *mut ForwardedArgs).as_mut() }
    }
    /// Casts `&Node` to `Option<&mut nodes::Gvar>`
    pub fn as_gvar_mut(&mut self) -> Option<&mut Gvar> {
        unsafe { (lib_ruby_parser__external__nodes__get_gvar(&self.blob) as *mut Gvar).as_mut() }
    }
    /// Casts `&Node` to `Option<&mut nodes::Gvasgn>`
    pub fn as_gvasgn_mut(&mut self) -> Option<&mut Gvasgn> {
        unsafe { (lib_ruby_parser__external__nodes__get_gvasgn(&self.blob) as *mut Gvasgn).as_mut() }
    }
    /// Casts `&Node` to `Option<&mut nodes::Hash>`
    pub fn as_hash_mut(&mut self) -> Option<&mut Hash> {
        unsafe { (lib_ruby_parser__external__nodes__get_hash(&self.blob) as *mut Hash).as_mut() }
    }
    /// Casts `&Node` to `Option<&mut nodes::Kwargs>`
    pub fn as_kwargs_mut(&mut self) -> Option<&mut Kwargs> {
        unsafe { (lib_ruby_parser__external__nodes__get_kwargs(&self.blob) as *mut Kwargs).as_mut() }
    }
    /// Casts `&Node` to `Option<&mut nodes::HashPattern>`
    pub fn as_hash_pattern_mut(&mut self) -> Option<&mut HashPattern> {
        unsafe { (lib_ruby_parser__external__nodes__get_hash_pattern(&self.blob) as *mut HashPattern).as_mut() }
    }
    /// Casts `&Node` to `Option<&mut nodes::Heredoc>`
    pub fn as_heredoc_mut(&mut self) -> Option<&mut Heredoc> {
        unsafe { (lib_ruby_parser__external__nodes__get_heredoc(&self.blob) as *mut Heredoc).as_mut() }
    }
    /// Casts `&Node` to `Option<&mut nodes::If>`
    pub fn as_if_mut(&mut self) -> Option<&mut If> {
        unsafe { (lib_ruby_parser__external__nodes__get_if(&self.blob) as *mut If).as_mut() }
    }
    /// Casts `&Node` to `Option<&mut nodes::IfGuard>`
    pub fn as_if_guard_mut(&mut self) -> Option<&mut IfGuard> {
        unsafe { (lib_ruby_parser__external__nodes__get_if_guard(&self.blob) as *mut IfGuard).as_mut() }
    }
    /// Casts `&Node` to `Option<&mut nodes::IfMod>`
    pub fn as_if_mod_mut(&mut self) -> Option<&mut IfMod> {
        unsafe { (lib_ruby_parser__external__nodes__get_if_mod(&self.blob) as *mut IfMod).as_mut() }
    }
    /// Casts `&Node` to `Option<&mut nodes::IfTernary>`
    pub fn as_if_ternary_mut(&mut self) -> Option<&mut IfTernary> {
        unsafe { (lib_ruby_parser__external__nodes__get_if_ternary(&self.blob) as *mut IfTernary).as_mut() }
    }
    /// Casts `&Node` to `Option<&mut nodes::IFlipFlop>`
    pub fn as_i_flip_flop_mut(&mut self) -> Option<&mut IFlipFlop> {
        unsafe { (lib_ruby_parser__external__nodes__get_i_flip_flop(&self.blob) as *mut IFlipFlop).as_mut() }
    }
    /// Casts `&Node` to `Option<&mut nodes::MatchPattern>`
    pub fn as_match_pattern_mut(&mut self) -> Option<&mut MatchPattern> {
        unsafe { (lib_ruby_parser__external__nodes__get_match_pattern(&self.blob) as *mut MatchPattern).as_mut() }
    }
    /// Casts `&Node` to `Option<&mut nodes::MatchPatternP>`
    pub fn as_match_pattern_p_mut(&mut self) -> Option<&mut MatchPatternP> {
        unsafe { (lib_ruby_parser__external__nodes__get_match_pattern_p(&self.blob) as *mut MatchPatternP).as_mut() }
    }
    /// Casts `&Node` to `Option<&mut nodes::InPattern>`
    pub fn as_in_pattern_mut(&mut self) -> Option<&mut InPattern> {
        unsafe { (lib_ruby_parser__external__nodes__get_in_pattern(&self.blob) as *mut InPattern).as_mut() }
    }
    /// Casts `&Node` to `Option<&mut nodes::Index>`
    pub fn as_index_mut(&mut self) -> Option<&mut Index> {
        unsafe { (lib_ruby_parser__external__nodes__get_index(&self.blob) as *mut Index).as_mut() }
    }
    /// Casts `&Node` to `Option<&mut nodes::IndexAsgn>`
    pub fn as_index_asgn_mut(&mut self) -> Option<&mut IndexAsgn> {
        unsafe { (lib_ruby_parser__external__nodes__get_index_asgn(&self.blob) as *mut IndexAsgn).as_mut() }
    }
    /// Casts `&Node` to `Option<&mut nodes::Int>`
    pub fn as_int_mut(&mut self) -> Option<&mut Int> {
        unsafe { (lib_ruby_parser__external__nodes__get_int(&self.blob) as *mut Int).as_mut() }
    }
    /// Casts `&Node` to `Option<&mut nodes::Irange>`
    pub fn as_irange_mut(&mut self) -> Option<&mut Irange> {
        unsafe { (lib_ruby_parser__external__nodes__get_irange(&self.blob) as *mut Irange).as_mut() }
    }
    /// Casts `&Node` to `Option<&mut nodes::Ivar>`
    pub fn as_ivar_mut(&mut self) -> Option<&mut Ivar> {
        unsafe { (lib_ruby_parser__external__nodes__get_ivar(&self.blob) as *mut Ivar).as_mut() }
    }
    /// Casts `&Node` to `Option<&mut nodes::Ivasgn>`
    pub fn as_ivasgn_mut(&mut self) -> Option<&mut Ivasgn> {
        unsafe { (lib_ruby_parser__external__nodes__get_ivasgn(&self.blob) as *mut Ivasgn).as_mut() }
    }
    /// Casts `&Node` to `Option<&mut nodes::Kwarg>`
    pub fn as_kwarg_mut(&mut self) -> Option<&mut Kwarg> {
        unsafe { (lib_ruby_parser__external__nodes__get_kwarg(&self.blob) as *mut Kwarg).as_mut() }
    }
    /// Casts `&Node` to `Option<&mut nodes::KwBegin>`
    pub fn as_kw_begin_mut(&mut self) -> Option<&mut KwBegin> {
        unsafe { (lib_ruby_parser__external__nodes__get_kw_begin(&self.blob) as *mut KwBegin).as_mut() }
    }
    /// Casts `&Node` to `Option<&mut nodes::Kwnilarg>`
    pub fn as_kwnilarg_mut(&mut self) -> Option<&mut Kwnilarg> {
        unsafe { (lib_ruby_parser__external__nodes__get_kwnilarg(&self.blob) as *mut Kwnilarg).as_mut() }
    }
    /// Casts `&Node` to `Option<&mut nodes::Kwoptarg>`
    pub fn as_kwoptarg_mut(&mut self) -> Option<&mut Kwoptarg> {
        unsafe { (lib_ruby_parser__external__nodes__get_kwoptarg(&self.blob) as *mut Kwoptarg).as_mut() }
    }
    /// Casts `&Node` to `Option<&mut nodes::Kwrestarg>`
    pub fn as_kwrestarg_mut(&mut self) -> Option<&mut Kwrestarg> {
        unsafe { (lib_ruby_parser__external__nodes__get_kwrestarg(&self.blob) as *mut Kwrestarg).as_mut() }
    }
    /// Casts `&Node` to `Option<&mut nodes::Kwsplat>`
    pub fn as_kwsplat_mut(&mut self) -> Option<&mut Kwsplat> {
        unsafe { (lib_ruby_parser__external__nodes__get_kwsplat(&self.blob) as *mut Kwsplat).as_mut() }
    }
    /// Casts `&Node` to `Option<&mut nodes::Lambda>`
    pub fn as_lambda_mut(&mut self) -> Option<&mut Lambda> {
        unsafe { (lib_ruby_parser__external__nodes__get_lambda(&self.blob) as *mut Lambda).as_mut() }
    }
    /// Casts `&Node` to `Option<&mut nodes::Line>`
    pub fn as_line_mut(&mut self) -> Option<&mut Line> {
        unsafe { (lib_ruby_parser__external__nodes__get_line(&self.blob) as *mut Line).as_mut() }
    }
    /// Casts `&Node` to `Option<&mut nodes::Lvar>`
    pub fn as_lvar_mut(&mut self) -> Option<&mut Lvar> {
        unsafe { (lib_ruby_parser__external__nodes__get_lvar(&self.blob) as *mut Lvar).as_mut() }
    }
    /// Casts `&Node` to `Option<&mut nodes::Lvasgn>`
    pub fn as_lvasgn_mut(&mut self) -> Option<&mut Lvasgn> {
        unsafe { (lib_ruby_parser__external__nodes__get_lvasgn(&self.blob) as *mut Lvasgn).as_mut() }
    }
    /// Casts `&Node` to `Option<&mut nodes::Masgn>`
    pub fn as_masgn_mut(&mut self) -> Option<&mut Masgn> {
        unsafe { (lib_ruby_parser__external__nodes__get_masgn(&self.blob) as *mut Masgn).as_mut() }
    }
    /// Casts `&Node` to `Option<&mut nodes::MatchAlt>`
    pub fn as_match_alt_mut(&mut self) -> Option<&mut MatchAlt> {
        unsafe { (lib_ruby_parser__external__nodes__get_match_alt(&self.blob) as *mut MatchAlt).as_mut() }
    }
    /// Casts `&Node` to `Option<&mut nodes::MatchAs>`
    pub fn as_match_as_mut(&mut self) -> Option<&mut MatchAs> {
        unsafe { (lib_ruby_parser__external__nodes__get_match_as(&self.blob) as *mut MatchAs).as_mut() }
    }
    /// Casts `&Node` to `Option<&mut nodes::MatchCurrentLine>`
    pub fn as_match_current_line_mut(&mut self) -> Option<&mut MatchCurrentLine> {
        unsafe { (lib_ruby_parser__external__nodes__get_match_current_line(&self.blob) as *mut MatchCurrentLine).as_mut() }
    }
    /// Casts `&Node` to `Option<&mut nodes::MatchNilPattern>`
    pub fn as_match_nil_pattern_mut(&mut self) -> Option<&mut MatchNilPattern> {
        unsafe { (lib_ruby_parser__external__nodes__get_match_nil_pattern(&self.blob) as *mut MatchNilPattern).as_mut() }
    }
    /// Casts `&Node` to `Option<&mut nodes::MatchRest>`
    pub fn as_match_rest_mut(&mut self) -> Option<&mut MatchRest> {
        unsafe { (lib_ruby_parser__external__nodes__get_match_rest(&self.blob) as *mut MatchRest).as_mut() }
    }
    /// Casts `&Node` to `Option<&mut nodes::MatchVar>`
    pub fn as_match_var_mut(&mut self) -> Option<&mut MatchVar> {
        unsafe { (lib_ruby_parser__external__nodes__get_match_var(&self.blob) as *mut MatchVar).as_mut() }
    }
    /// Casts `&Node` to `Option<&mut nodes::MatchWithLvasgn>`
    pub fn as_match_with_lvasgn_mut(&mut self) -> Option<&mut MatchWithLvasgn> {
        unsafe { (lib_ruby_parser__external__nodes__get_match_with_lvasgn(&self.blob) as *mut MatchWithLvasgn).as_mut() }
    }
    /// Casts `&Node` to `Option<&mut nodes::Mlhs>`
    pub fn as_mlhs_mut(&mut self) -> Option<&mut Mlhs> {
        unsafe { (lib_ruby_parser__external__nodes__get_mlhs(&self.blob) as *mut Mlhs).as_mut() }
    }
    /// Casts `&Node` to `Option<&mut nodes::Module>`
    pub fn as_module_mut(&mut self) -> Option<&mut Module> {
        unsafe { (lib_ruby_parser__external__nodes__get_module(&self.blob) as *mut Module).as_mut() }
    }
    /// Casts `&Node` to `Option<&mut nodes::Next>`
    pub fn as_next_mut(&mut self) -> Option<&mut Next> {
        unsafe { (lib_ruby_parser__external__nodes__get_next(&self.blob) as *mut Next).as_mut() }
    }
    /// Casts `&Node` to `Option<&mut nodes::Nil>`
    pub fn as_nil_mut(&mut self) -> Option<&mut Nil> {
        unsafe { (lib_ruby_parser__external__nodes__get_nil(&self.blob) as *mut Nil).as_mut() }
    }
    /// Casts `&Node` to `Option<&mut nodes::NthRef>`
    pub fn as_nth_ref_mut(&mut self) -> Option<&mut NthRef> {
        unsafe { (lib_ruby_parser__external__nodes__get_nth_ref(&self.blob) as *mut NthRef).as_mut() }
    }
    /// Casts `&Node` to `Option<&mut nodes::Numblock>`
    pub fn as_numblock_mut(&mut self) -> Option<&mut Numblock> {
        unsafe { (lib_ruby_parser__external__nodes__get_numblock(&self.blob) as *mut Numblock).as_mut() }
    }
    /// Casts `&Node` to `Option<&mut nodes::OpAsgn>`
    pub fn as_op_asgn_mut(&mut self) -> Option<&mut OpAsgn> {
        unsafe { (lib_ruby_parser__external__nodes__get_op_asgn(&self.blob) as *mut OpAsgn).as_mut() }
    }
    /// Casts `&Node` to `Option<&mut nodes::Optarg>`
    pub fn as_optarg_mut(&mut self) -> Option<&mut Optarg> {
        unsafe { (lib_ruby_parser__external__nodes__get_optarg(&self.blob) as *mut Optarg).as_mut() }
    }
    /// Casts `&Node` to `Option<&mut nodes::Or>`
    pub fn as_or_mut(&mut self) -> Option<&mut Or> {
        unsafe { (lib_ruby_parser__external__nodes__get_or(&self.blob) as *mut Or).as_mut() }
    }
    /// Casts `&Node` to `Option<&mut nodes::OrAsgn>`
    pub fn as_or_asgn_mut(&mut self) -> Option<&mut OrAsgn> {
        unsafe { (lib_ruby_parser__external__nodes__get_or_asgn(&self.blob) as *mut OrAsgn).as_mut() }
    }
    /// Casts `&Node` to `Option<&mut nodes::Pair>`
    pub fn as_pair_mut(&mut self) -> Option<&mut Pair> {
        unsafe { (lib_ruby_parser__external__nodes__get_pair(&self.blob) as *mut Pair).as_mut() }
    }
    /// Casts `&Node` to `Option<&mut nodes::Pin>`
    pub fn as_pin_mut(&mut self) -> Option<&mut Pin> {
        unsafe { (lib_ruby_parser__external__nodes__get_pin(&self.blob) as *mut Pin).as_mut() }
    }
    /// Casts `&Node` to `Option<&mut nodes::Postexe>`
    pub fn as_postexe_mut(&mut self) -> Option<&mut Postexe> {
        unsafe { (lib_ruby_parser__external__nodes__get_postexe(&self.blob) as *mut Postexe).as_mut() }
    }
    /// Casts `&Node` to `Option<&mut nodes::Preexe>`
    pub fn as_preexe_mut(&mut self) -> Option<&mut Preexe> {
        unsafe { (lib_ruby_parser__external__nodes__get_preexe(&self.blob) as *mut Preexe).as_mut() }
    }
    /// Casts `&Node` to `Option<&mut nodes::Procarg0>`
    pub fn as_procarg0_mut(&mut self) -> Option<&mut Procarg0> {
        unsafe { (lib_ruby_parser__external__nodes__get_procarg0(&self.blob) as *mut Procarg0).as_mut() }
    }
    /// Casts `&Node` to `Option<&mut nodes::Rational>`
    pub fn as_rational_mut(&mut self) -> Option<&mut Rational> {
        unsafe { (lib_ruby_parser__external__nodes__get_rational(&self.blob) as *mut Rational).as_mut() }
    }
    /// Casts `&Node` to `Option<&mut nodes::Redo>`
    pub fn as_redo_mut(&mut self) -> Option<&mut Redo> {
        unsafe { (lib_ruby_parser__external__nodes__get_redo(&self.blob) as *mut Redo).as_mut() }
    }
    /// Casts `&Node` to `Option<&mut nodes::RegOpt>`
    pub fn as_reg_opt_mut(&mut self) -> Option<&mut RegOpt> {
        unsafe { (lib_ruby_parser__external__nodes__get_reg_opt(&self.blob) as *mut RegOpt).as_mut() }
    }
    /// Casts `&Node` to `Option<&mut nodes::Regexp>`
    pub fn as_regexp_mut(&mut self) -> Option<&mut Regexp> {
        unsafe { (lib_ruby_parser__external__nodes__get_regexp(&self.blob) as *mut Regexp).as_mut() }
    }
    /// Casts `&Node` to `Option<&mut nodes::Rescue>`
    pub fn as_rescue_mut(&mut self) -> Option<&mut Rescue> {
        unsafe { (lib_ruby_parser__external__nodes__get_rescue(&self.blob) as *mut Rescue).as_mut() }
    }
    /// Casts `&Node` to `Option<&mut nodes::RescueBody>`
    pub fn as_rescue_body_mut(&mut self) -> Option<&mut RescueBody> {
        unsafe { (lib_ruby_parser__external__nodes__get_rescue_body(&self.blob) as *mut RescueBody).as_mut() }
    }
    /// Casts `&Node` to `Option<&mut nodes::Restarg>`
    pub fn as_restarg_mut(&mut self) -> Option<&mut Restarg> {
        unsafe { (lib_ruby_parser__external__nodes__get_restarg(&self.blob) as *mut Restarg).as_mut() }
    }
    /// Casts `&Node` to `Option<&mut nodes::Retry>`
    pub fn as_retry_mut(&mut self) -> Option<&mut Retry> {
        unsafe { (lib_ruby_parser__external__nodes__get_retry(&self.blob) as *mut Retry).as_mut() }
    }
    /// Casts `&Node` to `Option<&mut nodes::Return>`
    pub fn as_return_mut(&mut self) -> Option<&mut Return> {
        unsafe { (lib_ruby_parser__external__nodes__get_return(&self.blob) as *mut Return).as_mut() }
    }
    /// Casts `&Node` to `Option<&mut nodes::SClass>`
    pub fn as_s_class_mut(&mut self) -> Option<&mut SClass> {
        unsafe { (lib_ruby_parser__external__nodes__get_s_class(&self.blob) as *mut SClass).as_mut() }
    }
    /// Casts `&Node` to `Option<&mut nodes::Self_>`
    pub fn as_self_mut(&mut self) -> Option<&mut Self_> {
        unsafe { (lib_ruby_parser__external__nodes__get_self(&self.blob) as *mut Self_).as_mut() }
    }
    /// Casts `&Node` to `Option<&mut nodes::Send>`
    pub fn as_send_mut(&mut self) -> Option<&mut Send> {
        unsafe { (lib_ruby_parser__external__nodes__get_send(&self.blob) as *mut Send).as_mut() }
    }
    /// Casts `&Node` to `Option<&mut nodes::Shadowarg>`
    pub fn as_shadowarg_mut(&mut self) -> Option<&mut Shadowarg> {
        unsafe { (lib_ruby_parser__external__nodes__get_shadowarg(&self.blob) as *mut Shadowarg).as_mut() }
    }
    /// Casts `&Node` to `Option<&mut nodes::Splat>`
    pub fn as_splat_mut(&mut self) -> Option<&mut Splat> {
        unsafe { (lib_ruby_parser__external__nodes__get_splat(&self.blob) as *mut Splat).as_mut() }
    }
    /// Casts `&Node` to `Option<&mut nodes::Str>`
    pub fn as_str_mut(&mut self) -> Option<&mut Str> {
        unsafe { (lib_ruby_parser__external__nodes__get_str(&self.blob) as *mut Str).as_mut() }
    }
    /// Casts `&Node` to `Option<&mut nodes::Super>`
    pub fn as_super_mut(&mut self) -> Option<&mut Super> {
        unsafe { (lib_ruby_parser__external__nodes__get_super(&self.blob) as *mut Super).as_mut() }
    }
    /// Casts `&Node` to `Option<&mut nodes::Sym>`
    pub fn as_sym_mut(&mut self) -> Option<&mut Sym> {
        unsafe { (lib_ruby_parser__external__nodes__get_sym(&self.blob) as *mut Sym).as_mut() }
    }
    /// Casts `&Node` to `Option<&mut nodes::True>`
    pub fn as_true_mut(&mut self) -> Option<&mut True> {
        unsafe { (lib_ruby_parser__external__nodes__get_true(&self.blob) as *mut True).as_mut() }
    }
    /// Casts `&Node` to `Option<&mut nodes::Undef>`
    pub fn as_undef_mut(&mut self) -> Option<&mut Undef> {
        unsafe { (lib_ruby_parser__external__nodes__get_undef(&self.blob) as *mut Undef).as_mut() }
    }
    /// Casts `&Node` to `Option<&mut nodes::UnlessGuard>`
    pub fn as_unless_guard_mut(&mut self) -> Option<&mut UnlessGuard> {
        unsafe { (lib_ruby_parser__external__nodes__get_unless_guard(&self.blob) as *mut UnlessGuard).as_mut() }
    }
    /// Casts `&Node` to `Option<&mut nodes::Until>`
    pub fn as_until_mut(&mut self) -> Option<&mut Until> {
        unsafe { (lib_ruby_parser__external__nodes__get_until(&self.blob) as *mut Until).as_mut() }
    }
    /// Casts `&Node` to `Option<&mut nodes::UntilPost>`
    pub fn as_until_post_mut(&mut self) -> Option<&mut UntilPost> {
        unsafe { (lib_ruby_parser__external__nodes__get_until_post(&self.blob) as *mut UntilPost).as_mut() }
    }
    /// Casts `&Node` to `Option<&mut nodes::When>`
    pub fn as_when_mut(&mut self) -> Option<&mut When> {
        unsafe { (lib_ruby_parser__external__nodes__get_when(&self.blob) as *mut When).as_mut() }
    }
    /// Casts `&Node` to `Option<&mut nodes::While>`
    pub fn as_while_mut(&mut self) -> Option<&mut While> {
        unsafe { (lib_ruby_parser__external__nodes__get_while(&self.blob) as *mut While).as_mut() }
    }
    /// Casts `&Node` to `Option<&mut nodes::WhilePost>`
    pub fn as_while_post_mut(&mut self) -> Option<&mut WhilePost> {
        unsafe { (lib_ruby_parser__external__nodes__get_while_post(&self.blob) as *mut WhilePost).as_mut() }
    }
    /// Casts `&Node` to `Option<&mut nodes::XHeredoc>`
    pub fn as_x_heredoc_mut(&mut self) -> Option<&mut XHeredoc> {
        unsafe { (lib_ruby_parser__external__nodes__get_x_heredoc(&self.blob) as *mut XHeredoc).as_mut() }
    }
    /// Casts `&Node` to `Option<&mut nodes::Xstr>`
    pub fn as_xstr_mut(&mut self) -> Option<&mut Xstr> {
        unsafe { (lib_ruby_parser__external__nodes__get_xstr(&self.blob) as *mut Xstr).as_mut() }
    }
    /// Casts `&Node` to `Option<&mut nodes::Yield>`
    pub fn as_yield_mut(&mut self) -> Option<&mut Yield> {
        unsafe { (lib_ruby_parser__external__nodes__get_yield(&self.blob) as *mut Yield).as_mut() }
    }
    /// Casts `&Node` to `Option<&mut nodes::ZSuper>`
    pub fn as_z_super_mut(&mut self) -> Option<&mut ZSuper> {
        unsafe { (lib_ruby_parser__external__nodes__get_z_super(&self.blob) as *mut ZSuper).as_mut() }
    }

    // into_<node> FNs
    /// Casts `self` to nodes::Alias, panics if variant doesn't match
    pub fn into_alias(self) -> Alias {
        let blob = unsafe { lib_ruby_parser__external__nodes__into_alias(self.into_blob()) };
        Alias { blob }
    }
    /// Casts `self` to nodes::AndAsgn, panics if variant doesn't match
    pub fn into_and_asgn(self) -> AndAsgn {
        let blob = unsafe { lib_ruby_parser__external__nodes__into_and_asgn(self.into_blob()) };
        AndAsgn { blob }
    }
    /// Casts `self` to nodes::And, panics if variant doesn't match
    pub fn into_and(self) -> And {
        let blob = unsafe { lib_ruby_parser__external__nodes__into_and(self.into_blob()) };
        And { blob }
    }
    /// Casts `self` to nodes::Arg, panics if variant doesn't match
    pub fn into_arg(self) -> Arg {
        let blob = unsafe { lib_ruby_parser__external__nodes__into_arg(self.into_blob()) };
        Arg { blob }
    }
    /// Casts `self` to nodes::Args, panics if variant doesn't match
    pub fn into_args(self) -> Args {
        let blob = unsafe { lib_ruby_parser__external__nodes__into_args(self.into_blob()) };
        Args { blob }
    }
    /// Casts `self` to nodes::Array, panics if variant doesn't match
    pub fn into_array(self) -> Array {
        let blob = unsafe { lib_ruby_parser__external__nodes__into_array(self.into_blob()) };
        Array { blob }
    }
    /// Casts `self` to nodes::ArrayPattern, panics if variant doesn't match
    pub fn into_array_pattern(self) -> ArrayPattern {
        let blob = unsafe { lib_ruby_parser__external__nodes__into_array_pattern(self.into_blob()) };
        ArrayPattern { blob }
    }
    /// Casts `self` to nodes::ArrayPatternWithTail, panics if variant doesn't match
    pub fn into_array_pattern_with_tail(self) -> ArrayPatternWithTail {
        let blob = unsafe { lib_ruby_parser__external__nodes__into_array_pattern_with_tail(self.into_blob()) };
        ArrayPatternWithTail { blob }
    }
    /// Casts `self` to nodes::BackRef, panics if variant doesn't match
    pub fn into_back_ref(self) -> BackRef {
        let blob = unsafe { lib_ruby_parser__external__nodes__into_back_ref(self.into_blob()) };
        BackRef { blob }
    }
    /// Casts `self` to nodes::Begin, panics if variant doesn't match
    pub fn into_begin(self) -> Begin {
        let blob = unsafe { lib_ruby_parser__external__nodes__into_begin(self.into_blob()) };
        Begin { blob }
    }
    /// Casts `self` to nodes::Block, panics if variant doesn't match
    pub fn into_block(self) -> Block {
        let blob = unsafe { lib_ruby_parser__external__nodes__into_block(self.into_blob()) };
        Block { blob }
    }
    /// Casts `self` to nodes::BlockPass, panics if variant doesn't match
    pub fn into_block_pass(self) -> BlockPass {
        let blob = unsafe { lib_ruby_parser__external__nodes__into_block_pass(self.into_blob()) };
        BlockPass { blob }
    }
    /// Casts `self` to nodes::Blockarg, panics if variant doesn't match
    pub fn into_blockarg(self) -> Blockarg {
        let blob = unsafe { lib_ruby_parser__external__nodes__into_blockarg(self.into_blob()) };
        Blockarg { blob }
    }
    /// Casts `self` to nodes::Break, panics if variant doesn't match
    pub fn into_break(self) -> Break {
        let blob = unsafe { lib_ruby_parser__external__nodes__into_break(self.into_blob()) };
        Break { blob }
    }
    /// Casts `self` to nodes::Case, panics if variant doesn't match
    pub fn into_case(self) -> Case {
        let blob = unsafe { lib_ruby_parser__external__nodes__into_case(self.into_blob()) };
        Case { blob }
    }
    /// Casts `self` to nodes::CaseMatch, panics if variant doesn't match
    pub fn into_case_match(self) -> CaseMatch {
        let blob = unsafe { lib_ruby_parser__external__nodes__into_case_match(self.into_blob()) };
        CaseMatch { blob }
    }
    /// Casts `self` to nodes::Casgn, panics if variant doesn't match
    pub fn into_casgn(self) -> Casgn {
        let blob = unsafe { lib_ruby_parser__external__nodes__into_casgn(self.into_blob()) };
        Casgn { blob }
    }
    /// Casts `self` to nodes::Cbase, panics if variant doesn't match
    pub fn into_cbase(self) -> Cbase {
        let blob = unsafe { lib_ruby_parser__external__nodes__into_cbase(self.into_blob()) };
        Cbase { blob }
    }
    /// Casts `self` to nodes::Class, panics if variant doesn't match
    pub fn into_class(self) -> Class {
        let blob = unsafe { lib_ruby_parser__external__nodes__into_class(self.into_blob()) };
        Class { blob }
    }
    /// Casts `self` to nodes::Complex, panics if variant doesn't match
    pub fn into_complex(self) -> Complex {
        let blob = unsafe { lib_ruby_parser__external__nodes__into_complex(self.into_blob()) };
        Complex { blob }
    }
    /// Casts `self` to nodes::Const, panics if variant doesn't match
    pub fn into_const(self) -> Const {
        let blob = unsafe { lib_ruby_parser__external__nodes__into_const(self.into_blob()) };
        Const { blob }
    }
    /// Casts `self` to nodes::ConstPattern, panics if variant doesn't match
    pub fn into_const_pattern(self) -> ConstPattern {
        let blob = unsafe { lib_ruby_parser__external__nodes__into_const_pattern(self.into_blob()) };
        ConstPattern { blob }
    }
    /// Casts `self` to nodes::CSend, panics if variant doesn't match
    pub fn into_c_send(self) -> CSend {
        let blob = unsafe { lib_ruby_parser__external__nodes__into_c_send(self.into_blob()) };
        CSend { blob }
    }
    /// Casts `self` to nodes::Cvar, panics if variant doesn't match
    pub fn into_cvar(self) -> Cvar {
        let blob = unsafe { lib_ruby_parser__external__nodes__into_cvar(self.into_blob()) };
        Cvar { blob }
    }
    /// Casts `self` to nodes::Cvasgn, panics if variant doesn't match
    pub fn into_cvasgn(self) -> Cvasgn {
        let blob = unsafe { lib_ruby_parser__external__nodes__into_cvasgn(self.into_blob()) };
        Cvasgn { blob }
    }
    /// Casts `self` to nodes::Def, panics if variant doesn't match
    pub fn into_def(self) -> Def {
        let blob = unsafe { lib_ruby_parser__external__nodes__into_def(self.into_blob()) };
        Def { blob }
    }
    /// Casts `self` to nodes::Defined, panics if variant doesn't match
    pub fn into_defined(self) -> Defined {
        let blob = unsafe { lib_ruby_parser__external__nodes__into_defined(self.into_blob()) };
        Defined { blob }
    }
    /// Casts `self` to nodes::Defs, panics if variant doesn't match
    pub fn into_defs(self) -> Defs {
        let blob = unsafe { lib_ruby_parser__external__nodes__into_defs(self.into_blob()) };
        Defs { blob }
    }
    /// Casts `self` to nodes::Dstr, panics if variant doesn't match
    pub fn into_dstr(self) -> Dstr {
        let blob = unsafe { lib_ruby_parser__external__nodes__into_dstr(self.into_blob()) };
        Dstr { blob }
    }
    /// Casts `self` to nodes::Dsym, panics if variant doesn't match
    pub fn into_dsym(self) -> Dsym {
        let blob = unsafe { lib_ruby_parser__external__nodes__into_dsym(self.into_blob()) };
        Dsym { blob }
    }
    /// Casts `self` to nodes::EFlipFlop, panics if variant doesn't match
    pub fn into_e_flip_flop(self) -> EFlipFlop {
        let blob = unsafe { lib_ruby_parser__external__nodes__into_e_flip_flop(self.into_blob()) };
        EFlipFlop { blob }
    }
    /// Casts `self` to nodes::EmptyElse, panics if variant doesn't match
    pub fn into_empty_else(self) -> EmptyElse {
        let blob = unsafe { lib_ruby_parser__external__nodes__into_empty_else(self.into_blob()) };
        EmptyElse { blob }
    }
    /// Casts `self` to nodes::Encoding, panics if variant doesn't match
    pub fn into_encoding(self) -> Encoding {
        let blob = unsafe { lib_ruby_parser__external__nodes__into_encoding(self.into_blob()) };
        Encoding { blob }
    }
    /// Casts `self` to nodes::Ensure, panics if variant doesn't match
    pub fn into_ensure(self) -> Ensure {
        let blob = unsafe { lib_ruby_parser__external__nodes__into_ensure(self.into_blob()) };
        Ensure { blob }
    }
    /// Casts `self` to nodes::Erange, panics if variant doesn't match
    pub fn into_erange(self) -> Erange {
        let blob = unsafe { lib_ruby_parser__external__nodes__into_erange(self.into_blob()) };
        Erange { blob }
    }
    /// Casts `self` to nodes::False, panics if variant doesn't match
    pub fn into_false(self) -> False {
        let blob = unsafe { lib_ruby_parser__external__nodes__into_false(self.into_blob()) };
        False { blob }
    }
    /// Casts `self` to nodes::File, panics if variant doesn't match
    pub fn into_file(self) -> File {
        let blob = unsafe { lib_ruby_parser__external__nodes__into_file(self.into_blob()) };
        File { blob }
    }
    /// Casts `self` to nodes::FindPattern, panics if variant doesn't match
    pub fn into_find_pattern(self) -> FindPattern {
        let blob = unsafe { lib_ruby_parser__external__nodes__into_find_pattern(self.into_blob()) };
        FindPattern { blob }
    }
    /// Casts `self` to nodes::Float, panics if variant doesn't match
    pub fn into_float(self) -> Float {
        let blob = unsafe { lib_ruby_parser__external__nodes__into_float(self.into_blob()) };
        Float { blob }
    }
    /// Casts `self` to nodes::For, panics if variant doesn't match
    pub fn into_for(self) -> For {
        let blob = unsafe { lib_ruby_parser__external__nodes__into_for(self.into_blob()) };
        For { blob }
    }
    /// Casts `self` to nodes::ForwardArg, panics if variant doesn't match
    pub fn into_forward_arg(self) -> ForwardArg {
        let blob = unsafe { lib_ruby_parser__external__nodes__into_forward_arg(self.into_blob()) };
        ForwardArg { blob }
    }
    /// Casts `self` to nodes::ForwardedArgs, panics if variant doesn't match
    pub fn into_forwarded_args(self) -> ForwardedArgs {
        let blob = unsafe { lib_ruby_parser__external__nodes__into_forwarded_args(self.into_blob()) };
        ForwardedArgs { blob }
    }
    /// Casts `self` to nodes::Gvar, panics if variant doesn't match
    pub fn into_gvar(self) -> Gvar {
        let blob = unsafe { lib_ruby_parser__external__nodes__into_gvar(self.into_blob()) };
        Gvar { blob }
    }
    /// Casts `self` to nodes::Gvasgn, panics if variant doesn't match
    pub fn into_gvasgn(self) -> Gvasgn {
        let blob = unsafe { lib_ruby_parser__external__nodes__into_gvasgn(self.into_blob()) };
        Gvasgn { blob }
    }
    /// Casts `self` to nodes::Hash, panics if variant doesn't match
    pub fn into_hash(self) -> Hash {
        let blob = unsafe { lib_ruby_parser__external__nodes__into_hash(self.into_blob()) };
        Hash { blob }
    }
    /// Casts `self` to nodes::Kwargs, panics if variant doesn't match
    pub fn into_kwargs(self) -> Kwargs {
        let blob = unsafe { lib_ruby_parser__external__nodes__into_kwargs(self.into_blob()) };
        Kwargs { blob }
    }
    /// Casts `self` to nodes::HashPattern, panics if variant doesn't match
    pub fn into_hash_pattern(self) -> HashPattern {
        let blob = unsafe { lib_ruby_parser__external__nodes__into_hash_pattern(self.into_blob()) };
        HashPattern { blob }
    }
    /// Casts `self` to nodes::Heredoc, panics if variant doesn't match
    pub fn into_heredoc(self) -> Heredoc {
        let blob = unsafe { lib_ruby_parser__external__nodes__into_heredoc(self.into_blob()) };
        Heredoc { blob }
    }
    /// Casts `self` to nodes::If, panics if variant doesn't match
    pub fn into_if(self) -> If {
        let blob = unsafe { lib_ruby_parser__external__nodes__into_if(self.into_blob()) };
        If { blob }
    }
    /// Casts `self` to nodes::IfGuard, panics if variant doesn't match
    pub fn into_if_guard(self) -> IfGuard {
        let blob = unsafe { lib_ruby_parser__external__nodes__into_if_guard(self.into_blob()) };
        IfGuard { blob }
    }
    /// Casts `self` to nodes::IfMod, panics if variant doesn't match
    pub fn into_if_mod(self) -> IfMod {
        let blob = unsafe { lib_ruby_parser__external__nodes__into_if_mod(self.into_blob()) };
        IfMod { blob }
    }
    /// Casts `self` to nodes::IfTernary, panics if variant doesn't match
    pub fn into_if_ternary(self) -> IfTernary {
        let blob = unsafe { lib_ruby_parser__external__nodes__into_if_ternary(self.into_blob()) };
        IfTernary { blob }
    }
    /// Casts `self` to nodes::IFlipFlop, panics if variant doesn't match
    pub fn into_i_flip_flop(self) -> IFlipFlop {
        let blob = unsafe { lib_ruby_parser__external__nodes__into_i_flip_flop(self.into_blob()) };
        IFlipFlop { blob }
    }
    /// Casts `self` to nodes::MatchPattern, panics if variant doesn't match
    pub fn into_match_pattern(self) -> MatchPattern {
        let blob = unsafe { lib_ruby_parser__external__nodes__into_match_pattern(self.into_blob()) };
        MatchPattern { blob }
    }
    /// Casts `self` to nodes::MatchPatternP, panics if variant doesn't match
    pub fn into_match_pattern_p(self) -> MatchPatternP {
        let blob = unsafe { lib_ruby_parser__external__nodes__into_match_pattern_p(self.into_blob()) };
        MatchPatternP { blob }
    }
    /// Casts `self` to nodes::InPattern, panics if variant doesn't match
    pub fn into_in_pattern(self) -> InPattern {
        let blob = unsafe { lib_ruby_parser__external__nodes__into_in_pattern(self.into_blob()) };
        InPattern { blob }
    }
    /// Casts `self` to nodes::Index, panics if variant doesn't match
    pub fn into_index(self) -> Index {
        let blob = unsafe { lib_ruby_parser__external__nodes__into_index(self.into_blob()) };
        Index { blob }
    }
    /// Casts `self` to nodes::IndexAsgn, panics if variant doesn't match
    pub fn into_index_asgn(self) -> IndexAsgn {
        let blob = unsafe { lib_ruby_parser__external__nodes__into_index_asgn(self.into_blob()) };
        IndexAsgn { blob }
    }
    /// Casts `self` to nodes::Int, panics if variant doesn't match
    pub fn into_int(self) -> Int {
        let blob = unsafe { lib_ruby_parser__external__nodes__into_int(self.into_blob()) };
        Int { blob }
    }
    /// Casts `self` to nodes::Irange, panics if variant doesn't match
    pub fn into_irange(self) -> Irange {
        let blob = unsafe { lib_ruby_parser__external__nodes__into_irange(self.into_blob()) };
        Irange { blob }
    }
    /// Casts `self` to nodes::Ivar, panics if variant doesn't match
    pub fn into_ivar(self) -> Ivar {
        let blob = unsafe { lib_ruby_parser__external__nodes__into_ivar(self.into_blob()) };
        Ivar { blob }
    }
    /// Casts `self` to nodes::Ivasgn, panics if variant doesn't match
    pub fn into_ivasgn(self) -> Ivasgn {
        let blob = unsafe { lib_ruby_parser__external__nodes__into_ivasgn(self.into_blob()) };
        Ivasgn { blob }
    }
    /// Casts `self` to nodes::Kwarg, panics if variant doesn't match
    pub fn into_kwarg(self) -> Kwarg {
        let blob = unsafe { lib_ruby_parser__external__nodes__into_kwarg(self.into_blob()) };
        Kwarg { blob }
    }
    /// Casts `self` to nodes::KwBegin, panics if variant doesn't match
    pub fn into_kw_begin(self) -> KwBegin {
        let blob = unsafe { lib_ruby_parser__external__nodes__into_kw_begin(self.into_blob()) };
        KwBegin { blob }
    }
    /// Casts `self` to nodes::Kwnilarg, panics if variant doesn't match
    pub fn into_kwnilarg(self) -> Kwnilarg {
        let blob = unsafe { lib_ruby_parser__external__nodes__into_kwnilarg(self.into_blob()) };
        Kwnilarg { blob }
    }
    /// Casts `self` to nodes::Kwoptarg, panics if variant doesn't match
    pub fn into_kwoptarg(self) -> Kwoptarg {
        let blob = unsafe { lib_ruby_parser__external__nodes__into_kwoptarg(self.into_blob()) };
        Kwoptarg { blob }
    }
    /// Casts `self` to nodes::Kwrestarg, panics if variant doesn't match
    pub fn into_kwrestarg(self) -> Kwrestarg {
        let blob = unsafe { lib_ruby_parser__external__nodes__into_kwrestarg(self.into_blob()) };
        Kwrestarg { blob }
    }
    /// Casts `self` to nodes::Kwsplat, panics if variant doesn't match
    pub fn into_kwsplat(self) -> Kwsplat {
        let blob = unsafe { lib_ruby_parser__external__nodes__into_kwsplat(self.into_blob()) };
        Kwsplat { blob }
    }
    /// Casts `self` to nodes::Lambda, panics if variant doesn't match
    pub fn into_lambda(self) -> Lambda {
        let blob = unsafe { lib_ruby_parser__external__nodes__into_lambda(self.into_blob()) };
        Lambda { blob }
    }
    /// Casts `self` to nodes::Line, panics if variant doesn't match
    pub fn into_line(self) -> Line {
        let blob = unsafe { lib_ruby_parser__external__nodes__into_line(self.into_blob()) };
        Line { blob }
    }
    /// Casts `self` to nodes::Lvar, panics if variant doesn't match
    pub fn into_lvar(self) -> Lvar {
        let blob = unsafe { lib_ruby_parser__external__nodes__into_lvar(self.into_blob()) };
        Lvar { blob }
    }
    /// Casts `self` to nodes::Lvasgn, panics if variant doesn't match
    pub fn into_lvasgn(self) -> Lvasgn {
        let blob = unsafe { lib_ruby_parser__external__nodes__into_lvasgn(self.into_blob()) };
        Lvasgn { blob }
    }
    /// Casts `self` to nodes::Masgn, panics if variant doesn't match
    pub fn into_masgn(self) -> Masgn {
        let blob = unsafe { lib_ruby_parser__external__nodes__into_masgn(self.into_blob()) };
        Masgn { blob }
    }
    /// Casts `self` to nodes::MatchAlt, panics if variant doesn't match
    pub fn into_match_alt(self) -> MatchAlt {
        let blob = unsafe { lib_ruby_parser__external__nodes__into_match_alt(self.into_blob()) };
        MatchAlt { blob }
    }
    /// Casts `self` to nodes::MatchAs, panics if variant doesn't match
    pub fn into_match_as(self) -> MatchAs {
        let blob = unsafe { lib_ruby_parser__external__nodes__into_match_as(self.into_blob()) };
        MatchAs { blob }
    }
    /// Casts `self` to nodes::MatchCurrentLine, panics if variant doesn't match
    pub fn into_match_current_line(self) -> MatchCurrentLine {
        let blob = unsafe { lib_ruby_parser__external__nodes__into_match_current_line(self.into_blob()) };
        MatchCurrentLine { blob }
    }
    /// Casts `self` to nodes::MatchNilPattern, panics if variant doesn't match
    pub fn into_match_nil_pattern(self) -> MatchNilPattern {
        let blob = unsafe { lib_ruby_parser__external__nodes__into_match_nil_pattern(self.into_blob()) };
        MatchNilPattern { blob }
    }
    /// Casts `self` to nodes::MatchRest, panics if variant doesn't match
    pub fn into_match_rest(self) -> MatchRest {
        let blob = unsafe { lib_ruby_parser__external__nodes__into_match_rest(self.into_blob()) };
        MatchRest { blob }
    }
    /// Casts `self` to nodes::MatchVar, panics if variant doesn't match
    pub fn into_match_var(self) -> MatchVar {
        let blob = unsafe { lib_ruby_parser__external__nodes__into_match_var(self.into_blob()) };
        MatchVar { blob }
    }
    /// Casts `self` to nodes::MatchWithLvasgn, panics if variant doesn't match
    pub fn into_match_with_lvasgn(self) -> MatchWithLvasgn {
        let blob = unsafe { lib_ruby_parser__external__nodes__into_match_with_lvasgn(self.into_blob()) };
        MatchWithLvasgn { blob }
    }
    /// Casts `self` to nodes::Mlhs, panics if variant doesn't match
    pub fn into_mlhs(self) -> Mlhs {
        let blob = unsafe { lib_ruby_parser__external__nodes__into_mlhs(self.into_blob()) };
        Mlhs { blob }
    }
    /// Casts `self` to nodes::Module, panics if variant doesn't match
    pub fn into_module(self) -> Module {
        let blob = unsafe { lib_ruby_parser__external__nodes__into_module(self.into_blob()) };
        Module { blob }
    }
    /// Casts `self` to nodes::Next, panics if variant doesn't match
    pub fn into_next(self) -> Next {
        let blob = unsafe { lib_ruby_parser__external__nodes__into_next(self.into_blob()) };
        Next { blob }
    }
    /// Casts `self` to nodes::Nil, panics if variant doesn't match
    pub fn into_nil(self) -> Nil {
        let blob = unsafe { lib_ruby_parser__external__nodes__into_nil(self.into_blob()) };
        Nil { blob }
    }
    /// Casts `self` to nodes::NthRef, panics if variant doesn't match
    pub fn into_nth_ref(self) -> NthRef {
        let blob = unsafe { lib_ruby_parser__external__nodes__into_nth_ref(self.into_blob()) };
        NthRef { blob }
    }
    /// Casts `self` to nodes::Numblock, panics if variant doesn't match
    pub fn into_numblock(self) -> Numblock {
        let blob = unsafe { lib_ruby_parser__external__nodes__into_numblock(self.into_blob()) };
        Numblock { blob }
    }
    /// Casts `self` to nodes::OpAsgn, panics if variant doesn't match
    pub fn into_op_asgn(self) -> OpAsgn {
        let blob = unsafe { lib_ruby_parser__external__nodes__into_op_asgn(self.into_blob()) };
        OpAsgn { blob }
    }
    /// Casts `self` to nodes::Optarg, panics if variant doesn't match
    pub fn into_optarg(self) -> Optarg {
        let blob = unsafe { lib_ruby_parser__external__nodes__into_optarg(self.into_blob()) };
        Optarg { blob }
    }
    /// Casts `self` to nodes::Or, panics if variant doesn't match
    pub fn into_or(self) -> Or {
        let blob = unsafe { lib_ruby_parser__external__nodes__into_or(self.into_blob()) };
        Or { blob }
    }
    /// Casts `self` to nodes::OrAsgn, panics if variant doesn't match
    pub fn into_or_asgn(self) -> OrAsgn {
        let blob = unsafe { lib_ruby_parser__external__nodes__into_or_asgn(self.into_blob()) };
        OrAsgn { blob }
    }
    /// Casts `self` to nodes::Pair, panics if variant doesn't match
    pub fn into_pair(self) -> Pair {
        let blob = unsafe { lib_ruby_parser__external__nodes__into_pair(self.into_blob()) };
        Pair { blob }
    }
    /// Casts `self` to nodes::Pin, panics if variant doesn't match
    pub fn into_pin(self) -> Pin {
        let blob = unsafe { lib_ruby_parser__external__nodes__into_pin(self.into_blob()) };
        Pin { blob }
    }
    /// Casts `self` to nodes::Postexe, panics if variant doesn't match
    pub fn into_postexe(self) -> Postexe {
        let blob = unsafe { lib_ruby_parser__external__nodes__into_postexe(self.into_blob()) };
        Postexe { blob }
    }
    /// Casts `self` to nodes::Preexe, panics if variant doesn't match
    pub fn into_preexe(self) -> Preexe {
        let blob = unsafe { lib_ruby_parser__external__nodes__into_preexe(self.into_blob()) };
        Preexe { blob }
    }
    /// Casts `self` to nodes::Procarg0, panics if variant doesn't match
    pub fn into_procarg0(self) -> Procarg0 {
        let blob = unsafe { lib_ruby_parser__external__nodes__into_procarg0(self.into_blob()) };
        Procarg0 { blob }
    }
    /// Casts `self` to nodes::Rational, panics if variant doesn't match
    pub fn into_rational(self) -> Rational {
        let blob = unsafe { lib_ruby_parser__external__nodes__into_rational(self.into_blob()) };
        Rational { blob }
    }
    /// Casts `self` to nodes::Redo, panics if variant doesn't match
    pub fn into_redo(self) -> Redo {
        let blob = unsafe { lib_ruby_parser__external__nodes__into_redo(self.into_blob()) };
        Redo { blob }
    }
    /// Casts `self` to nodes::RegOpt, panics if variant doesn't match
    pub fn into_reg_opt(self) -> RegOpt {
        let blob = unsafe { lib_ruby_parser__external__nodes__into_reg_opt(self.into_blob()) };
        RegOpt { blob }
    }
    /// Casts `self` to nodes::Regexp, panics if variant doesn't match
    pub fn into_regexp(self) -> Regexp {
        let blob = unsafe { lib_ruby_parser__external__nodes__into_regexp(self.into_blob()) };
        Regexp { blob }
    }
    /// Casts `self` to nodes::Rescue, panics if variant doesn't match
    pub fn into_rescue(self) -> Rescue {
        let blob = unsafe { lib_ruby_parser__external__nodes__into_rescue(self.into_blob()) };
        Rescue { blob }
    }
    /// Casts `self` to nodes::RescueBody, panics if variant doesn't match
    pub fn into_rescue_body(self) -> RescueBody {
        let blob = unsafe { lib_ruby_parser__external__nodes__into_rescue_body(self.into_blob()) };
        RescueBody { blob }
    }
    /// Casts `self` to nodes::Restarg, panics if variant doesn't match
    pub fn into_restarg(self) -> Restarg {
        let blob = unsafe { lib_ruby_parser__external__nodes__into_restarg(self.into_blob()) };
        Restarg { blob }
    }
    /// Casts `self` to nodes::Retry, panics if variant doesn't match
    pub fn into_retry(self) -> Retry {
        let blob = unsafe { lib_ruby_parser__external__nodes__into_retry(self.into_blob()) };
        Retry { blob }
    }
    /// Casts `self` to nodes::Return, panics if variant doesn't match
    pub fn into_return(self) -> Return {
        let blob = unsafe { lib_ruby_parser__external__nodes__into_return(self.into_blob()) };
        Return { blob }
    }
    /// Casts `self` to nodes::SClass, panics if variant doesn't match
    pub fn into_s_class(self) -> SClass {
        let blob = unsafe { lib_ruby_parser__external__nodes__into_s_class(self.into_blob()) };
        SClass { blob }
    }
    /// Casts `self` to nodes::Self_, panics if variant doesn't match
    pub fn into_self(self) -> Self_ {
        let blob = unsafe { lib_ruby_parser__external__nodes__into_self(self.into_blob()) };
        Self_ { blob }
    }
    /// Casts `self` to nodes::Send, panics if variant doesn't match
    pub fn into_send(self) -> Send {
        let blob = unsafe { lib_ruby_parser__external__nodes__into_send(self.into_blob()) };
        Send { blob }
    }
    /// Casts `self` to nodes::Shadowarg, panics if variant doesn't match
    pub fn into_shadowarg(self) -> Shadowarg {
        let blob = unsafe { lib_ruby_parser__external__nodes__into_shadowarg(self.into_blob()) };
        Shadowarg { blob }
    }
    /// Casts `self` to nodes::Splat, panics if variant doesn't match
    pub fn into_splat(self) -> Splat {
        let blob = unsafe { lib_ruby_parser__external__nodes__into_splat(self.into_blob()) };
        Splat { blob }
    }
    /// Casts `self` to nodes::Str, panics if variant doesn't match
    pub fn into_str(self) -> Str {
        let blob = unsafe { lib_ruby_parser__external__nodes__into_str(self.into_blob()) };
        Str { blob }
    }
    /// Casts `self` to nodes::Super, panics if variant doesn't match
    pub fn into_super(self) -> Super {
        let blob = unsafe { lib_ruby_parser__external__nodes__into_super(self.into_blob()) };
        Super { blob }
    }
    /// Casts `self` to nodes::Sym, panics if variant doesn't match
    pub fn into_sym(self) -> Sym {
        let blob = unsafe { lib_ruby_parser__external__nodes__into_sym(self.into_blob()) };
        Sym { blob }
    }
    /// Casts `self` to nodes::True, panics if variant doesn't match
    pub fn into_true(self) -> True {
        let blob = unsafe { lib_ruby_parser__external__nodes__into_true(self.into_blob()) };
        True { blob }
    }
    /// Casts `self` to nodes::Undef, panics if variant doesn't match
    pub fn into_undef(self) -> Undef {
        let blob = unsafe { lib_ruby_parser__external__nodes__into_undef(self.into_blob()) };
        Undef { blob }
    }
    /// Casts `self` to nodes::UnlessGuard, panics if variant doesn't match
    pub fn into_unless_guard(self) -> UnlessGuard {
        let blob = unsafe { lib_ruby_parser__external__nodes__into_unless_guard(self.into_blob()) };
        UnlessGuard { blob }
    }
    /// Casts `self` to nodes::Until, panics if variant doesn't match
    pub fn into_until(self) -> Until {
        let blob = unsafe { lib_ruby_parser__external__nodes__into_until(self.into_blob()) };
        Until { blob }
    }
    /// Casts `self` to nodes::UntilPost, panics if variant doesn't match
    pub fn into_until_post(self) -> UntilPost {
        let blob = unsafe { lib_ruby_parser__external__nodes__into_until_post(self.into_blob()) };
        UntilPost { blob }
    }
    /// Casts `self` to nodes::When, panics if variant doesn't match
    pub fn into_when(self) -> When {
        let blob = unsafe { lib_ruby_parser__external__nodes__into_when(self.into_blob()) };
        When { blob }
    }
    /// Casts `self` to nodes::While, panics if variant doesn't match
    pub fn into_while(self) -> While {
        let blob = unsafe { lib_ruby_parser__external__nodes__into_while(self.into_blob()) };
        While { blob }
    }
    /// Casts `self` to nodes::WhilePost, panics if variant doesn't match
    pub fn into_while_post(self) -> WhilePost {
        let blob = unsafe { lib_ruby_parser__external__nodes__into_while_post(self.into_blob()) };
        WhilePost { blob }
    }
    /// Casts `self` to nodes::XHeredoc, panics if variant doesn't match
    pub fn into_x_heredoc(self) -> XHeredoc {
        let blob = unsafe { lib_ruby_parser__external__nodes__into_x_heredoc(self.into_blob()) };
        XHeredoc { blob }
    }
    /// Casts `self` to nodes::Xstr, panics if variant doesn't match
    pub fn into_xstr(self) -> Xstr {
        let blob = unsafe { lib_ruby_parser__external__nodes__into_xstr(self.into_blob()) };
        Xstr { blob }
    }
    /// Casts `self` to nodes::Yield, panics if variant doesn't match
    pub fn into_yield(self) -> Yield {
        let blob = unsafe { lib_ruby_parser__external__nodes__into_yield(self.into_blob()) };
        Yield { blob }
    }
    /// Casts `self` to nodes::ZSuper, panics if variant doesn't match
    pub fn into_z_super(self) -> ZSuper {
        let blob = unsafe { lib_ruby_parser__external__nodes__into_z_super(self.into_blob()) };
        ZSuper { blob }
    }
}

extern "C"
{
    fn lib_ruby_parser__external__nodes__new_alias(to: Blob<Ptr<Node>>, from: Blob<Ptr<Node>>, keyword_l: Blob<Loc>, expression_l: Blob<Loc>) -> Blob<Node>;
    fn lib_ruby_parser__external__nodes__is_alias(blob_ptr: *const Blob<Node>) -> bool;
    fn lib_ruby_parser__external__nodes__get_alias(blob_ptr: *const Blob<Node>) -> *mut Blob<Alias>;
    fn lib_ruby_parser__external__nodes__into_alias(blob: Blob<Node>) -> Blob<Alias>;
    fn lib_ruby_parser__external__nodes__new_and_asgn(recv: Blob<Ptr<Node>>, value: Blob<Ptr<Node>>, operator_l: Blob<Loc>, expression_l: Blob<Loc>) -> Blob<Node>;
    fn lib_ruby_parser__external__nodes__is_and_asgn(blob_ptr: *const Blob<Node>) -> bool;
    fn lib_ruby_parser__external__nodes__get_and_asgn(blob_ptr: *const Blob<Node>) -> *mut Blob<AndAsgn>;
    fn lib_ruby_parser__external__nodes__into_and_asgn(blob: Blob<Node>) -> Blob<AndAsgn>;
    fn lib_ruby_parser__external__nodes__new_and(lhs: Blob<Ptr<Node>>, rhs: Blob<Ptr<Node>>, operator_l: Blob<Loc>, expression_l: Blob<Loc>) -> Blob<Node>;
    fn lib_ruby_parser__external__nodes__is_and(blob_ptr: *const Blob<Node>) -> bool;
    fn lib_ruby_parser__external__nodes__get_and(blob_ptr: *const Blob<Node>) -> *mut Blob<And>;
    fn lib_ruby_parser__external__nodes__into_and(blob: Blob<Node>) -> Blob<And>;
    fn lib_ruby_parser__external__nodes__new_arg(name: Blob<StringPtr>, expression_l: Blob<Loc>) -> Blob<Node>;
    fn lib_ruby_parser__external__nodes__is_arg(blob_ptr: *const Blob<Node>) -> bool;
    fn lib_ruby_parser__external__nodes__get_arg(blob_ptr: *const Blob<Node>) -> *mut Blob<Arg>;
    fn lib_ruby_parser__external__nodes__into_arg(blob: Blob<Node>) -> Blob<Arg>;
    fn lib_ruby_parser__external__nodes__new_args(args: Blob<List<Node>>, expression_l: Blob<Loc>, begin_l: Blob<Maybe<Loc>>, end_l: Blob<Maybe<Loc>>) -> Blob<Node>;
    fn lib_ruby_parser__external__nodes__is_args(blob_ptr: *const Blob<Node>) -> bool;
    fn lib_ruby_parser__external__nodes__get_args(blob_ptr: *const Blob<Node>) -> *mut Blob<Args>;
    fn lib_ruby_parser__external__nodes__into_args(blob: Blob<Node>) -> Blob<Args>;
    fn lib_ruby_parser__external__nodes__new_array(elements: Blob<List<Node>>, begin_l: Blob<Maybe<Loc>>, end_l: Blob<Maybe<Loc>>, expression_l: Blob<Loc>) -> Blob<Node>;
    fn lib_ruby_parser__external__nodes__is_array(blob_ptr: *const Blob<Node>) -> bool;
    fn lib_ruby_parser__external__nodes__get_array(blob_ptr: *const Blob<Node>) -> *mut Blob<Array>;
    fn lib_ruby_parser__external__nodes__into_array(blob: Blob<Node>) -> Blob<Array>;
    fn lib_ruby_parser__external__nodes__new_array_pattern(elements: Blob<List<Node>>, begin_l: Blob<Maybe<Loc>>, end_l: Blob<Maybe<Loc>>, expression_l: Blob<Loc>) -> Blob<Node>;
    fn lib_ruby_parser__external__nodes__is_array_pattern(blob_ptr: *const Blob<Node>) -> bool;
    fn lib_ruby_parser__external__nodes__get_array_pattern(blob_ptr: *const Blob<Node>) -> *mut Blob<ArrayPattern>;
    fn lib_ruby_parser__external__nodes__into_array_pattern(blob: Blob<Node>) -> Blob<ArrayPattern>;
    fn lib_ruby_parser__external__nodes__new_array_pattern_with_tail(elements: Blob<List<Node>>, begin_l: Blob<Maybe<Loc>>, end_l: Blob<Maybe<Loc>>, expression_l: Blob<Loc>) -> Blob<Node>;
    fn lib_ruby_parser__external__nodes__is_array_pattern_with_tail(blob_ptr: *const Blob<Node>) -> bool;
    fn lib_ruby_parser__external__nodes__get_array_pattern_with_tail(blob_ptr: *const Blob<Node>) -> *mut Blob<ArrayPatternWithTail>;
    fn lib_ruby_parser__external__nodes__into_array_pattern_with_tail(blob: Blob<Node>) -> Blob<ArrayPatternWithTail>;
    fn lib_ruby_parser__external__nodes__new_back_ref(name: Blob<StringPtr>, expression_l: Blob<Loc>) -> Blob<Node>;
    fn lib_ruby_parser__external__nodes__is_back_ref(blob_ptr: *const Blob<Node>) -> bool;
    fn lib_ruby_parser__external__nodes__get_back_ref(blob_ptr: *const Blob<Node>) -> *mut Blob<BackRef>;
    fn lib_ruby_parser__external__nodes__into_back_ref(blob: Blob<Node>) -> Blob<BackRef>;
    fn lib_ruby_parser__external__nodes__new_begin(statements: Blob<List<Node>>, begin_l: Blob<Maybe<Loc>>, end_l: Blob<Maybe<Loc>>, expression_l: Blob<Loc>) -> Blob<Node>;
    fn lib_ruby_parser__external__nodes__is_begin(blob_ptr: *const Blob<Node>) -> bool;
    fn lib_ruby_parser__external__nodes__get_begin(blob_ptr: *const Blob<Node>) -> *mut Blob<Begin>;
    fn lib_ruby_parser__external__nodes__into_begin(blob: Blob<Node>) -> Blob<Begin>;
    fn lib_ruby_parser__external__nodes__new_block(call: Blob<Ptr<Node>>, args: Blob<Maybe<Ptr<Node>>>, body: Blob<Maybe<Ptr<Node>>>, begin_l: Blob<Loc>, end_l: Blob<Loc>, expression_l: Blob<Loc>) -> Blob<Node>;
    fn lib_ruby_parser__external__nodes__is_block(blob_ptr: *const Blob<Node>) -> bool;
    fn lib_ruby_parser__external__nodes__get_block(blob_ptr: *const Blob<Node>) -> *mut Blob<Block>;
    fn lib_ruby_parser__external__nodes__into_block(blob: Blob<Node>) -> Blob<Block>;
    fn lib_ruby_parser__external__nodes__new_block_pass(value: Blob<Ptr<Node>>, operator_l: Blob<Loc>, expression_l: Blob<Loc>) -> Blob<Node>;
    fn lib_ruby_parser__external__nodes__is_block_pass(blob_ptr: *const Blob<Node>) -> bool;
    fn lib_ruby_parser__external__nodes__get_block_pass(blob_ptr: *const Blob<Node>) -> *mut Blob<BlockPass>;
    fn lib_ruby_parser__external__nodes__into_block_pass(blob: Blob<Node>) -> Blob<BlockPass>;
    fn lib_ruby_parser__external__nodes__new_blockarg(name: Blob<StringPtr>, operator_l: Blob<Loc>, name_l: Blob<Loc>, expression_l: Blob<Loc>) -> Blob<Node>;
    fn lib_ruby_parser__external__nodes__is_blockarg(blob_ptr: *const Blob<Node>) -> bool;
    fn lib_ruby_parser__external__nodes__get_blockarg(blob_ptr: *const Blob<Node>) -> *mut Blob<Blockarg>;
    fn lib_ruby_parser__external__nodes__into_blockarg(blob: Blob<Node>) -> Blob<Blockarg>;
    fn lib_ruby_parser__external__nodes__new_break(args: Blob<List<Node>>, keyword_l: Blob<Loc>, expression_l: Blob<Loc>) -> Blob<Node>;
    fn lib_ruby_parser__external__nodes__is_break(blob_ptr: *const Blob<Node>) -> bool;
    fn lib_ruby_parser__external__nodes__get_break(blob_ptr: *const Blob<Node>) -> *mut Blob<Break>;
    fn lib_ruby_parser__external__nodes__into_break(blob: Blob<Node>) -> Blob<Break>;
    fn lib_ruby_parser__external__nodes__new_case(expr: Blob<Maybe<Ptr<Node>>>, when_bodies: Blob<List<Node>>, else_body: Blob<Maybe<Ptr<Node>>>, keyword_l: Blob<Loc>, else_l: Blob<Maybe<Loc>>, end_l: Blob<Loc>, expression_l: Blob<Loc>) -> Blob<Node>;
    fn lib_ruby_parser__external__nodes__is_case(blob_ptr: *const Blob<Node>) -> bool;
    fn lib_ruby_parser__external__nodes__get_case(blob_ptr: *const Blob<Node>) -> *mut Blob<Case>;
    fn lib_ruby_parser__external__nodes__into_case(blob: Blob<Node>) -> Blob<Case>;
    fn lib_ruby_parser__external__nodes__new_case_match(expr: Blob<Ptr<Node>>, in_bodies: Blob<List<Node>>, else_body: Blob<Maybe<Ptr<Node>>>, keyword_l: Blob<Loc>, else_l: Blob<Maybe<Loc>>, end_l: Blob<Loc>, expression_l: Blob<Loc>) -> Blob<Node>;
    fn lib_ruby_parser__external__nodes__is_case_match(blob_ptr: *const Blob<Node>) -> bool;
    fn lib_ruby_parser__external__nodes__get_case_match(blob_ptr: *const Blob<Node>) -> *mut Blob<CaseMatch>;
    fn lib_ruby_parser__external__nodes__into_case_match(blob: Blob<Node>) -> Blob<CaseMatch>;
    fn lib_ruby_parser__external__nodes__new_casgn(scope: Blob<Maybe<Ptr<Node>>>, name: Blob<StringPtr>, value: Blob<Maybe<Ptr<Node>>>, double_colon_l: Blob<Maybe<Loc>>, name_l: Blob<Loc>, operator_l: Blob<Maybe<Loc>>, expression_l: Blob<Loc>) -> Blob<Node>;
    fn lib_ruby_parser__external__nodes__is_casgn(blob_ptr: *const Blob<Node>) -> bool;
    fn lib_ruby_parser__external__nodes__get_casgn(blob_ptr: *const Blob<Node>) -> *mut Blob<Casgn>;
    fn lib_ruby_parser__external__nodes__into_casgn(blob: Blob<Node>) -> Blob<Casgn>;
    fn lib_ruby_parser__external__nodes__new_cbase(expression_l: Blob<Loc>) -> Blob<Node>;
    fn lib_ruby_parser__external__nodes__is_cbase(blob_ptr: *const Blob<Node>) -> bool;
    fn lib_ruby_parser__external__nodes__get_cbase(blob_ptr: *const Blob<Node>) -> *mut Blob<Cbase>;
    fn lib_ruby_parser__external__nodes__into_cbase(blob: Blob<Node>) -> Blob<Cbase>;
    fn lib_ruby_parser__external__nodes__new_class(name: Blob<Ptr<Node>>, superclass: Blob<Maybe<Ptr<Node>>>, body: Blob<Maybe<Ptr<Node>>>, keyword_l: Blob<Loc>, operator_l: Blob<Maybe<Loc>>, end_l: Blob<Loc>, expression_l: Blob<Loc>) -> Blob<Node>;
    fn lib_ruby_parser__external__nodes__is_class(blob_ptr: *const Blob<Node>) -> bool;
    fn lib_ruby_parser__external__nodes__get_class(blob_ptr: *const Blob<Node>) -> *mut Blob<Class>;
    fn lib_ruby_parser__external__nodes__into_class(blob: Blob<Node>) -> Blob<Class>;
    fn lib_ruby_parser__external__nodes__new_complex(value: Blob<StringPtr>, operator_l: Blob<Maybe<Loc>>, expression_l: Blob<Loc>) -> Blob<Node>;
    fn lib_ruby_parser__external__nodes__is_complex(blob_ptr: *const Blob<Node>) -> bool;
    fn lib_ruby_parser__external__nodes__get_complex(blob_ptr: *const Blob<Node>) -> *mut Blob<Complex>;
    fn lib_ruby_parser__external__nodes__into_complex(blob: Blob<Node>) -> Blob<Complex>;
    fn lib_ruby_parser__external__nodes__new_const(scope: Blob<Maybe<Ptr<Node>>>, name: Blob<StringPtr>, double_colon_l: Blob<Maybe<Loc>>, name_l: Blob<Loc>, expression_l: Blob<Loc>) -> Blob<Node>;
    fn lib_ruby_parser__external__nodes__is_const(blob_ptr: *const Blob<Node>) -> bool;
    fn lib_ruby_parser__external__nodes__get_const(blob_ptr: *const Blob<Node>) -> *mut Blob<Const>;
    fn lib_ruby_parser__external__nodes__into_const(blob: Blob<Node>) -> Blob<Const>;
    fn lib_ruby_parser__external__nodes__new_const_pattern(const_: Blob<Ptr<Node>>, pattern: Blob<Ptr<Node>>, begin_l: Blob<Loc>, end_l: Blob<Loc>, expression_l: Blob<Loc>) -> Blob<Node>;
    fn lib_ruby_parser__external__nodes__is_const_pattern(blob_ptr: *const Blob<Node>) -> bool;
    fn lib_ruby_parser__external__nodes__get_const_pattern(blob_ptr: *const Blob<Node>) -> *mut Blob<ConstPattern>;
    fn lib_ruby_parser__external__nodes__into_const_pattern(blob: Blob<Node>) -> Blob<ConstPattern>;
    fn lib_ruby_parser__external__nodes__new_c_send(recv: Blob<Ptr<Node>>, method_name: Blob<StringPtr>, args: Blob<List<Node>>, dot_l: Blob<Loc>, selector_l: Blob<Maybe<Loc>>, begin_l: Blob<Maybe<Loc>>, end_l: Blob<Maybe<Loc>>, operator_l: Blob<Maybe<Loc>>, expression_l: Blob<Loc>) -> Blob<Node>;
    fn lib_ruby_parser__external__nodes__is_c_send(blob_ptr: *const Blob<Node>) -> bool;
    fn lib_ruby_parser__external__nodes__get_c_send(blob_ptr: *const Blob<Node>) -> *mut Blob<CSend>;
    fn lib_ruby_parser__external__nodes__into_c_send(blob: Blob<Node>) -> Blob<CSend>;
    fn lib_ruby_parser__external__nodes__new_cvar(name: Blob<StringPtr>, expression_l: Blob<Loc>) -> Blob<Node>;
    fn lib_ruby_parser__external__nodes__is_cvar(blob_ptr: *const Blob<Node>) -> bool;
    fn lib_ruby_parser__external__nodes__get_cvar(blob_ptr: *const Blob<Node>) -> *mut Blob<Cvar>;
    fn lib_ruby_parser__external__nodes__into_cvar(blob: Blob<Node>) -> Blob<Cvar>;
    fn lib_ruby_parser__external__nodes__new_cvasgn(name: Blob<StringPtr>, value: Blob<Maybe<Ptr<Node>>>, name_l: Blob<Loc>, operator_l: Blob<Maybe<Loc>>, expression_l: Blob<Loc>) -> Blob<Node>;
    fn lib_ruby_parser__external__nodes__is_cvasgn(blob_ptr: *const Blob<Node>) -> bool;
    fn lib_ruby_parser__external__nodes__get_cvasgn(blob_ptr: *const Blob<Node>) -> *mut Blob<Cvasgn>;
    fn lib_ruby_parser__external__nodes__into_cvasgn(blob: Blob<Node>) -> Blob<Cvasgn>;
    fn lib_ruby_parser__external__nodes__new_def(name: Blob<StringPtr>, args: Blob<Maybe<Ptr<Node>>>, body: Blob<Maybe<Ptr<Node>>>, keyword_l: Blob<Loc>, name_l: Blob<Loc>, end_l: Blob<Maybe<Loc>>, assignment_l: Blob<Maybe<Loc>>, expression_l: Blob<Loc>) -> Blob<Node>;
    fn lib_ruby_parser__external__nodes__is_def(blob_ptr: *const Blob<Node>) -> bool;
    fn lib_ruby_parser__external__nodes__get_def(blob_ptr: *const Blob<Node>) -> *mut Blob<Def>;
    fn lib_ruby_parser__external__nodes__into_def(blob: Blob<Node>) -> Blob<Def>;
    fn lib_ruby_parser__external__nodes__new_defined(value: Blob<Ptr<Node>>, keyword_l: Blob<Loc>, begin_l: Blob<Maybe<Loc>>, end_l: Blob<Maybe<Loc>>, expression_l: Blob<Loc>) -> Blob<Node>;
    fn lib_ruby_parser__external__nodes__is_defined(blob_ptr: *const Blob<Node>) -> bool;
    fn lib_ruby_parser__external__nodes__get_defined(blob_ptr: *const Blob<Node>) -> *mut Blob<Defined>;
    fn lib_ruby_parser__external__nodes__into_defined(blob: Blob<Node>) -> Blob<Defined>;
    fn lib_ruby_parser__external__nodes__new_defs(definee: Blob<Ptr<Node>>, name: Blob<StringPtr>, args: Blob<Maybe<Ptr<Node>>>, body: Blob<Maybe<Ptr<Node>>>, keyword_l: Blob<Loc>, operator_l: Blob<Loc>, name_l: Blob<Loc>, assignment_l: Blob<Maybe<Loc>>, end_l: Blob<Maybe<Loc>>, expression_l: Blob<Loc>) -> Blob<Node>;
    fn lib_ruby_parser__external__nodes__is_defs(blob_ptr: *const Blob<Node>) -> bool;
    fn lib_ruby_parser__external__nodes__get_defs(blob_ptr: *const Blob<Node>) -> *mut Blob<Defs>;
    fn lib_ruby_parser__external__nodes__into_defs(blob: Blob<Node>) -> Blob<Defs>;
    fn lib_ruby_parser__external__nodes__new_dstr(parts: Blob<List<Node>>, begin_l: Blob<Maybe<Loc>>, end_l: Blob<Maybe<Loc>>, expression_l: Blob<Loc>) -> Blob<Node>;
    fn lib_ruby_parser__external__nodes__is_dstr(blob_ptr: *const Blob<Node>) -> bool;
    fn lib_ruby_parser__external__nodes__get_dstr(blob_ptr: *const Blob<Node>) -> *mut Blob<Dstr>;
    fn lib_ruby_parser__external__nodes__into_dstr(blob: Blob<Node>) -> Blob<Dstr>;
    fn lib_ruby_parser__external__nodes__new_dsym(parts: Blob<List<Node>>, begin_l: Blob<Maybe<Loc>>, end_l: Blob<Maybe<Loc>>, expression_l: Blob<Loc>) -> Blob<Node>;
    fn lib_ruby_parser__external__nodes__is_dsym(blob_ptr: *const Blob<Node>) -> bool;
    fn lib_ruby_parser__external__nodes__get_dsym(blob_ptr: *const Blob<Node>) -> *mut Blob<Dsym>;
    fn lib_ruby_parser__external__nodes__into_dsym(blob: Blob<Node>) -> Blob<Dsym>;
    fn lib_ruby_parser__external__nodes__new_e_flip_flop(left: Blob<Maybe<Ptr<Node>>>, right: Blob<Maybe<Ptr<Node>>>, operator_l: Blob<Loc>, expression_l: Blob<Loc>) -> Blob<Node>;
    fn lib_ruby_parser__external__nodes__is_e_flip_flop(blob_ptr: *const Blob<Node>) -> bool;
    fn lib_ruby_parser__external__nodes__get_e_flip_flop(blob_ptr: *const Blob<Node>) -> *mut Blob<EFlipFlop>;
    fn lib_ruby_parser__external__nodes__into_e_flip_flop(blob: Blob<Node>) -> Blob<EFlipFlop>;
    fn lib_ruby_parser__external__nodes__new_empty_else(expression_l: Blob<Loc>) -> Blob<Node>;
    fn lib_ruby_parser__external__nodes__is_empty_else(blob_ptr: *const Blob<Node>) -> bool;
    fn lib_ruby_parser__external__nodes__get_empty_else(blob_ptr: *const Blob<Node>) -> *mut Blob<EmptyElse>;
    fn lib_ruby_parser__external__nodes__into_empty_else(blob: Blob<Node>) -> Blob<EmptyElse>;
    fn lib_ruby_parser__external__nodes__new_encoding(expression_l: Blob<Loc>) -> Blob<Node>;
    fn lib_ruby_parser__external__nodes__is_encoding(blob_ptr: *const Blob<Node>) -> bool;
    fn lib_ruby_parser__external__nodes__get_encoding(blob_ptr: *const Blob<Node>) -> *mut Blob<Encoding>;
    fn lib_ruby_parser__external__nodes__into_encoding(blob: Blob<Node>) -> Blob<Encoding>;
    fn lib_ruby_parser__external__nodes__new_ensure(body: Blob<Maybe<Ptr<Node>>>, ensure: Blob<Maybe<Ptr<Node>>>, keyword_l: Blob<Loc>, expression_l: Blob<Loc>) -> Blob<Node>;
    fn lib_ruby_parser__external__nodes__is_ensure(blob_ptr: *const Blob<Node>) -> bool;
    fn lib_ruby_parser__external__nodes__get_ensure(blob_ptr: *const Blob<Node>) -> *mut Blob<Ensure>;
    fn lib_ruby_parser__external__nodes__into_ensure(blob: Blob<Node>) -> Blob<Ensure>;
    fn lib_ruby_parser__external__nodes__new_erange(left: Blob<Maybe<Ptr<Node>>>, right: Blob<Maybe<Ptr<Node>>>, operator_l: Blob<Loc>, expression_l: Blob<Loc>) -> Blob<Node>;
    fn lib_ruby_parser__external__nodes__is_erange(blob_ptr: *const Blob<Node>) -> bool;
    fn lib_ruby_parser__external__nodes__get_erange(blob_ptr: *const Blob<Node>) -> *mut Blob<Erange>;
    fn lib_ruby_parser__external__nodes__into_erange(blob: Blob<Node>) -> Blob<Erange>;
    fn lib_ruby_parser__external__nodes__new_false(expression_l: Blob<Loc>) -> Blob<Node>;
    fn lib_ruby_parser__external__nodes__is_false(blob_ptr: *const Blob<Node>) -> bool;
    fn lib_ruby_parser__external__nodes__get_false(blob_ptr: *const Blob<Node>) -> *mut Blob<False>;
    fn lib_ruby_parser__external__nodes__into_false(blob: Blob<Node>) -> Blob<False>;
    fn lib_ruby_parser__external__nodes__new_file(expression_l: Blob<Loc>) -> Blob<Node>;
    fn lib_ruby_parser__external__nodes__is_file(blob_ptr: *const Blob<Node>) -> bool;
    fn lib_ruby_parser__external__nodes__get_file(blob_ptr: *const Blob<Node>) -> *mut Blob<File>;
    fn lib_ruby_parser__external__nodes__into_file(blob: Blob<Node>) -> Blob<File>;
    fn lib_ruby_parser__external__nodes__new_find_pattern(elements: Blob<List<Node>>, begin_l: Blob<Maybe<Loc>>, end_l: Blob<Maybe<Loc>>, expression_l: Blob<Loc>) -> Blob<Node>;
    fn lib_ruby_parser__external__nodes__is_find_pattern(blob_ptr: *const Blob<Node>) -> bool;
    fn lib_ruby_parser__external__nodes__get_find_pattern(blob_ptr: *const Blob<Node>) -> *mut Blob<FindPattern>;
    fn lib_ruby_parser__external__nodes__into_find_pattern(blob: Blob<Node>) -> Blob<FindPattern>;
    fn lib_ruby_parser__external__nodes__new_float(value: Blob<StringPtr>, operator_l: Blob<Maybe<Loc>>, expression_l: Blob<Loc>) -> Blob<Node>;
    fn lib_ruby_parser__external__nodes__is_float(blob_ptr: *const Blob<Node>) -> bool;
    fn lib_ruby_parser__external__nodes__get_float(blob_ptr: *const Blob<Node>) -> *mut Blob<Float>;
    fn lib_ruby_parser__external__nodes__into_float(blob: Blob<Node>) -> Blob<Float>;
    fn lib_ruby_parser__external__nodes__new_for(iterator: Blob<Ptr<Node>>, iteratee: Blob<Ptr<Node>>, body: Blob<Maybe<Ptr<Node>>>, keyword_l: Blob<Loc>, operator_l: Blob<Loc>, begin_l: Blob<Loc>, end_l: Blob<Loc>, expression_l: Blob<Loc>) -> Blob<Node>;
    fn lib_ruby_parser__external__nodes__is_for(blob_ptr: *const Blob<Node>) -> bool;
    fn lib_ruby_parser__external__nodes__get_for(blob_ptr: *const Blob<Node>) -> *mut Blob<For>;
    fn lib_ruby_parser__external__nodes__into_for(blob: Blob<Node>) -> Blob<For>;
    fn lib_ruby_parser__external__nodes__new_forward_arg(expression_l: Blob<Loc>) -> Blob<Node>;
    fn lib_ruby_parser__external__nodes__is_forward_arg(blob_ptr: *const Blob<Node>) -> bool;
    fn lib_ruby_parser__external__nodes__get_forward_arg(blob_ptr: *const Blob<Node>) -> *mut Blob<ForwardArg>;
    fn lib_ruby_parser__external__nodes__into_forward_arg(blob: Blob<Node>) -> Blob<ForwardArg>;
    fn lib_ruby_parser__external__nodes__new_forwarded_args(expression_l: Blob<Loc>) -> Blob<Node>;
    fn lib_ruby_parser__external__nodes__is_forwarded_args(blob_ptr: *const Blob<Node>) -> bool;
    fn lib_ruby_parser__external__nodes__get_forwarded_args(blob_ptr: *const Blob<Node>) -> *mut Blob<ForwardedArgs>;
    fn lib_ruby_parser__external__nodes__into_forwarded_args(blob: Blob<Node>) -> Blob<ForwardedArgs>;
    fn lib_ruby_parser__external__nodes__new_gvar(name: Blob<StringPtr>, expression_l: Blob<Loc>) -> Blob<Node>;
    fn lib_ruby_parser__external__nodes__is_gvar(blob_ptr: *const Blob<Node>) -> bool;
    fn lib_ruby_parser__external__nodes__get_gvar(blob_ptr: *const Blob<Node>) -> *mut Blob<Gvar>;
    fn lib_ruby_parser__external__nodes__into_gvar(blob: Blob<Node>) -> Blob<Gvar>;
    fn lib_ruby_parser__external__nodes__new_gvasgn(name: Blob<StringPtr>, value: Blob<Maybe<Ptr<Node>>>, name_l: Blob<Loc>, operator_l: Blob<Maybe<Loc>>, expression_l: Blob<Loc>) -> Blob<Node>;
    fn lib_ruby_parser__external__nodes__is_gvasgn(blob_ptr: *const Blob<Node>) -> bool;
    fn lib_ruby_parser__external__nodes__get_gvasgn(blob_ptr: *const Blob<Node>) -> *mut Blob<Gvasgn>;
    fn lib_ruby_parser__external__nodes__into_gvasgn(blob: Blob<Node>) -> Blob<Gvasgn>;
    fn lib_ruby_parser__external__nodes__new_hash(pairs: Blob<List<Node>>, begin_l: Blob<Maybe<Loc>>, end_l: Blob<Maybe<Loc>>, expression_l: Blob<Loc>) -> Blob<Node>;
    fn lib_ruby_parser__external__nodes__is_hash(blob_ptr: *const Blob<Node>) -> bool;
    fn lib_ruby_parser__external__nodes__get_hash(blob_ptr: *const Blob<Node>) -> *mut Blob<Hash>;
    fn lib_ruby_parser__external__nodes__into_hash(blob: Blob<Node>) -> Blob<Hash>;
    fn lib_ruby_parser__external__nodes__new_kwargs(pairs: Blob<List<Node>>, expression_l: Blob<Loc>) -> Blob<Node>;
    fn lib_ruby_parser__external__nodes__is_kwargs(blob_ptr: *const Blob<Node>) -> bool;
    fn lib_ruby_parser__external__nodes__get_kwargs(blob_ptr: *const Blob<Node>) -> *mut Blob<Kwargs>;
    fn lib_ruby_parser__external__nodes__into_kwargs(blob: Blob<Node>) -> Blob<Kwargs>;
    fn lib_ruby_parser__external__nodes__new_hash_pattern(elements: Blob<List<Node>>, begin_l: Blob<Maybe<Loc>>, end_l: Blob<Maybe<Loc>>, expression_l: Blob<Loc>) -> Blob<Node>;
    fn lib_ruby_parser__external__nodes__is_hash_pattern(blob_ptr: *const Blob<Node>) -> bool;
    fn lib_ruby_parser__external__nodes__get_hash_pattern(blob_ptr: *const Blob<Node>) -> *mut Blob<HashPattern>;
    fn lib_ruby_parser__external__nodes__into_hash_pattern(blob: Blob<Node>) -> Blob<HashPattern>;
    fn lib_ruby_parser__external__nodes__new_heredoc(parts: Blob<List<Node>>, heredoc_body_l: Blob<Loc>, heredoc_end_l: Blob<Loc>, expression_l: Blob<Loc>) -> Blob<Node>;
    fn lib_ruby_parser__external__nodes__is_heredoc(blob_ptr: *const Blob<Node>) -> bool;
    fn lib_ruby_parser__external__nodes__get_heredoc(blob_ptr: *const Blob<Node>) -> *mut Blob<Heredoc>;
    fn lib_ruby_parser__external__nodes__into_heredoc(blob: Blob<Node>) -> Blob<Heredoc>;
    fn lib_ruby_parser__external__nodes__new_if(cond: Blob<Ptr<Node>>, if_true: Blob<Maybe<Ptr<Node>>>, if_false: Blob<Maybe<Ptr<Node>>>, keyword_l: Blob<Loc>, begin_l: Blob<Loc>, else_l: Blob<Maybe<Loc>>, end_l: Blob<Maybe<Loc>>, expression_l: Blob<Loc>) -> Blob<Node>;
    fn lib_ruby_parser__external__nodes__is_if(blob_ptr: *const Blob<Node>) -> bool;
    fn lib_ruby_parser__external__nodes__get_if(blob_ptr: *const Blob<Node>) -> *mut Blob<If>;
    fn lib_ruby_parser__external__nodes__into_if(blob: Blob<Node>) -> Blob<If>;
    fn lib_ruby_parser__external__nodes__new_if_guard(cond: Blob<Ptr<Node>>, keyword_l: Blob<Loc>, expression_l: Blob<Loc>) -> Blob<Node>;
    fn lib_ruby_parser__external__nodes__is_if_guard(blob_ptr: *const Blob<Node>) -> bool;
    fn lib_ruby_parser__external__nodes__get_if_guard(blob_ptr: *const Blob<Node>) -> *mut Blob<IfGuard>;
    fn lib_ruby_parser__external__nodes__into_if_guard(blob: Blob<Node>) -> Blob<IfGuard>;
    fn lib_ruby_parser__external__nodes__new_if_mod(cond: Blob<Ptr<Node>>, if_true: Blob<Maybe<Ptr<Node>>>, if_false: Blob<Maybe<Ptr<Node>>>, keyword_l: Blob<Loc>, expression_l: Blob<Loc>) -> Blob<Node>;
    fn lib_ruby_parser__external__nodes__is_if_mod(blob_ptr: *const Blob<Node>) -> bool;
    fn lib_ruby_parser__external__nodes__get_if_mod(blob_ptr: *const Blob<Node>) -> *mut Blob<IfMod>;
    fn lib_ruby_parser__external__nodes__into_if_mod(blob: Blob<Node>) -> Blob<IfMod>;
    fn lib_ruby_parser__external__nodes__new_if_ternary(cond: Blob<Ptr<Node>>, if_true: Blob<Ptr<Node>>, if_false: Blob<Ptr<Node>>, question_l: Blob<Loc>, colon_l: Blob<Loc>, expression_l: Blob<Loc>) -> Blob<Node>;
    fn lib_ruby_parser__external__nodes__is_if_ternary(blob_ptr: *const Blob<Node>) -> bool;
    fn lib_ruby_parser__external__nodes__get_if_ternary(blob_ptr: *const Blob<Node>) -> *mut Blob<IfTernary>;
    fn lib_ruby_parser__external__nodes__into_if_ternary(blob: Blob<Node>) -> Blob<IfTernary>;
    fn lib_ruby_parser__external__nodes__new_i_flip_flop(left: Blob<Maybe<Ptr<Node>>>, right: Blob<Maybe<Ptr<Node>>>, operator_l: Blob<Loc>, expression_l: Blob<Loc>) -> Blob<Node>;
    fn lib_ruby_parser__external__nodes__is_i_flip_flop(blob_ptr: *const Blob<Node>) -> bool;
    fn lib_ruby_parser__external__nodes__get_i_flip_flop(blob_ptr: *const Blob<Node>) -> *mut Blob<IFlipFlop>;
    fn lib_ruby_parser__external__nodes__into_i_flip_flop(blob: Blob<Node>) -> Blob<IFlipFlop>;
    fn lib_ruby_parser__external__nodes__new_match_pattern(value: Blob<Ptr<Node>>, pattern: Blob<Ptr<Node>>, operator_l: Blob<Loc>, expression_l: Blob<Loc>) -> Blob<Node>;
    fn lib_ruby_parser__external__nodes__is_match_pattern(blob_ptr: *const Blob<Node>) -> bool;
    fn lib_ruby_parser__external__nodes__get_match_pattern(blob_ptr: *const Blob<Node>) -> *mut Blob<MatchPattern>;
    fn lib_ruby_parser__external__nodes__into_match_pattern(blob: Blob<Node>) -> Blob<MatchPattern>;
    fn lib_ruby_parser__external__nodes__new_match_pattern_p(value: Blob<Ptr<Node>>, pattern: Blob<Ptr<Node>>, operator_l: Blob<Loc>, expression_l: Blob<Loc>) -> Blob<Node>;
    fn lib_ruby_parser__external__nodes__is_match_pattern_p(blob_ptr: *const Blob<Node>) -> bool;
    fn lib_ruby_parser__external__nodes__get_match_pattern_p(blob_ptr: *const Blob<Node>) -> *mut Blob<MatchPatternP>;
    fn lib_ruby_parser__external__nodes__into_match_pattern_p(blob: Blob<Node>) -> Blob<MatchPatternP>;
    fn lib_ruby_parser__external__nodes__new_in_pattern(pattern: Blob<Ptr<Node>>, guard: Blob<Maybe<Ptr<Node>>>, body: Blob<Maybe<Ptr<Node>>>, keyword_l: Blob<Loc>, begin_l: Blob<Loc>, expression_l: Blob<Loc>) -> Blob<Node>;
    fn lib_ruby_parser__external__nodes__is_in_pattern(blob_ptr: *const Blob<Node>) -> bool;
    fn lib_ruby_parser__external__nodes__get_in_pattern(blob_ptr: *const Blob<Node>) -> *mut Blob<InPattern>;
    fn lib_ruby_parser__external__nodes__into_in_pattern(blob: Blob<Node>) -> Blob<InPattern>;
    fn lib_ruby_parser__external__nodes__new_index(recv: Blob<Ptr<Node>>, indexes: Blob<List<Node>>, begin_l: Blob<Loc>, end_l: Blob<Loc>, expression_l: Blob<Loc>) -> Blob<Node>;
    fn lib_ruby_parser__external__nodes__is_index(blob_ptr: *const Blob<Node>) -> bool;
    fn lib_ruby_parser__external__nodes__get_index(blob_ptr: *const Blob<Node>) -> *mut Blob<Index>;
    fn lib_ruby_parser__external__nodes__into_index(blob: Blob<Node>) -> Blob<Index>;
    fn lib_ruby_parser__external__nodes__new_index_asgn(recv: Blob<Ptr<Node>>, indexes: Blob<List<Node>>, value: Blob<Maybe<Ptr<Node>>>, begin_l: Blob<Loc>, end_l: Blob<Loc>, operator_l: Blob<Maybe<Loc>>, expression_l: Blob<Loc>) -> Blob<Node>;
    fn lib_ruby_parser__external__nodes__is_index_asgn(blob_ptr: *const Blob<Node>) -> bool;
    fn lib_ruby_parser__external__nodes__get_index_asgn(blob_ptr: *const Blob<Node>) -> *mut Blob<IndexAsgn>;
    fn lib_ruby_parser__external__nodes__into_index_asgn(blob: Blob<Node>) -> Blob<IndexAsgn>;
    fn lib_ruby_parser__external__nodes__new_int(value: Blob<StringPtr>, operator_l: Blob<Maybe<Loc>>, expression_l: Blob<Loc>) -> Blob<Node>;
    fn lib_ruby_parser__external__nodes__is_int(blob_ptr: *const Blob<Node>) -> bool;
    fn lib_ruby_parser__external__nodes__get_int(blob_ptr: *const Blob<Node>) -> *mut Blob<Int>;
    fn lib_ruby_parser__external__nodes__into_int(blob: Blob<Node>) -> Blob<Int>;
    fn lib_ruby_parser__external__nodes__new_irange(left: Blob<Maybe<Ptr<Node>>>, right: Blob<Maybe<Ptr<Node>>>, operator_l: Blob<Loc>, expression_l: Blob<Loc>) -> Blob<Node>;
    fn lib_ruby_parser__external__nodes__is_irange(blob_ptr: *const Blob<Node>) -> bool;
    fn lib_ruby_parser__external__nodes__get_irange(blob_ptr: *const Blob<Node>) -> *mut Blob<Irange>;
    fn lib_ruby_parser__external__nodes__into_irange(blob: Blob<Node>) -> Blob<Irange>;
    fn lib_ruby_parser__external__nodes__new_ivar(name: Blob<StringPtr>, expression_l: Blob<Loc>) -> Blob<Node>;
    fn lib_ruby_parser__external__nodes__is_ivar(blob_ptr: *const Blob<Node>) -> bool;
    fn lib_ruby_parser__external__nodes__get_ivar(blob_ptr: *const Blob<Node>) -> *mut Blob<Ivar>;
    fn lib_ruby_parser__external__nodes__into_ivar(blob: Blob<Node>) -> Blob<Ivar>;
    fn lib_ruby_parser__external__nodes__new_ivasgn(name: Blob<StringPtr>, value: Blob<Maybe<Ptr<Node>>>, name_l: Blob<Loc>, operator_l: Blob<Maybe<Loc>>, expression_l: Blob<Loc>) -> Blob<Node>;
    fn lib_ruby_parser__external__nodes__is_ivasgn(blob_ptr: *const Blob<Node>) -> bool;
    fn lib_ruby_parser__external__nodes__get_ivasgn(blob_ptr: *const Blob<Node>) -> *mut Blob<Ivasgn>;
    fn lib_ruby_parser__external__nodes__into_ivasgn(blob: Blob<Node>) -> Blob<Ivasgn>;
    fn lib_ruby_parser__external__nodes__new_kwarg(name: Blob<StringPtr>, name_l: Blob<Loc>, expression_l: Blob<Loc>) -> Blob<Node>;
    fn lib_ruby_parser__external__nodes__is_kwarg(blob_ptr: *const Blob<Node>) -> bool;
    fn lib_ruby_parser__external__nodes__get_kwarg(blob_ptr: *const Blob<Node>) -> *mut Blob<Kwarg>;
    fn lib_ruby_parser__external__nodes__into_kwarg(blob: Blob<Node>) -> Blob<Kwarg>;
    fn lib_ruby_parser__external__nodes__new_kw_begin(statements: Blob<List<Node>>, begin_l: Blob<Maybe<Loc>>, end_l: Blob<Maybe<Loc>>, expression_l: Blob<Loc>) -> Blob<Node>;
    fn lib_ruby_parser__external__nodes__is_kw_begin(blob_ptr: *const Blob<Node>) -> bool;
    fn lib_ruby_parser__external__nodes__get_kw_begin(blob_ptr: *const Blob<Node>) -> *mut Blob<KwBegin>;
    fn lib_ruby_parser__external__nodes__into_kw_begin(blob: Blob<Node>) -> Blob<KwBegin>;
    fn lib_ruby_parser__external__nodes__new_kwnilarg(name_l: Blob<Loc>, expression_l: Blob<Loc>) -> Blob<Node>;
    fn lib_ruby_parser__external__nodes__is_kwnilarg(blob_ptr: *const Blob<Node>) -> bool;
    fn lib_ruby_parser__external__nodes__get_kwnilarg(blob_ptr: *const Blob<Node>) -> *mut Blob<Kwnilarg>;
    fn lib_ruby_parser__external__nodes__into_kwnilarg(blob: Blob<Node>) -> Blob<Kwnilarg>;
    fn lib_ruby_parser__external__nodes__new_kwoptarg(name: Blob<StringPtr>, default: Blob<Ptr<Node>>, name_l: Blob<Loc>, expression_l: Blob<Loc>) -> Blob<Node>;
    fn lib_ruby_parser__external__nodes__is_kwoptarg(blob_ptr: *const Blob<Node>) -> bool;
    fn lib_ruby_parser__external__nodes__get_kwoptarg(blob_ptr: *const Blob<Node>) -> *mut Blob<Kwoptarg>;
    fn lib_ruby_parser__external__nodes__into_kwoptarg(blob: Blob<Node>) -> Blob<Kwoptarg>;
    fn lib_ruby_parser__external__nodes__new_kwrestarg(name: Blob<Maybe<StringPtr>>, operator_l: Blob<Loc>, name_l: Blob<Maybe<Loc>>, expression_l: Blob<Loc>) -> Blob<Node>;
    fn lib_ruby_parser__external__nodes__is_kwrestarg(blob_ptr: *const Blob<Node>) -> bool;
    fn lib_ruby_parser__external__nodes__get_kwrestarg(blob_ptr: *const Blob<Node>) -> *mut Blob<Kwrestarg>;
    fn lib_ruby_parser__external__nodes__into_kwrestarg(blob: Blob<Node>) -> Blob<Kwrestarg>;
    fn lib_ruby_parser__external__nodes__new_kwsplat(value: Blob<Ptr<Node>>, operator_l: Blob<Loc>, expression_l: Blob<Loc>) -> Blob<Node>;
    fn lib_ruby_parser__external__nodes__is_kwsplat(blob_ptr: *const Blob<Node>) -> bool;
    fn lib_ruby_parser__external__nodes__get_kwsplat(blob_ptr: *const Blob<Node>) -> *mut Blob<Kwsplat>;
    fn lib_ruby_parser__external__nodes__into_kwsplat(blob: Blob<Node>) -> Blob<Kwsplat>;
    fn lib_ruby_parser__external__nodes__new_lambda(expression_l: Blob<Loc>) -> Blob<Node>;
    fn lib_ruby_parser__external__nodes__is_lambda(blob_ptr: *const Blob<Node>) -> bool;
    fn lib_ruby_parser__external__nodes__get_lambda(blob_ptr: *const Blob<Node>) -> *mut Blob<Lambda>;
    fn lib_ruby_parser__external__nodes__into_lambda(blob: Blob<Node>) -> Blob<Lambda>;
    fn lib_ruby_parser__external__nodes__new_line(expression_l: Blob<Loc>) -> Blob<Node>;
    fn lib_ruby_parser__external__nodes__is_line(blob_ptr: *const Blob<Node>) -> bool;
    fn lib_ruby_parser__external__nodes__get_line(blob_ptr: *const Blob<Node>) -> *mut Blob<Line>;
    fn lib_ruby_parser__external__nodes__into_line(blob: Blob<Node>) -> Blob<Line>;
    fn lib_ruby_parser__external__nodes__new_lvar(name: Blob<StringPtr>, expression_l: Blob<Loc>) -> Blob<Node>;
    fn lib_ruby_parser__external__nodes__is_lvar(blob_ptr: *const Blob<Node>) -> bool;
    fn lib_ruby_parser__external__nodes__get_lvar(blob_ptr: *const Blob<Node>) -> *mut Blob<Lvar>;
    fn lib_ruby_parser__external__nodes__into_lvar(blob: Blob<Node>) -> Blob<Lvar>;
    fn lib_ruby_parser__external__nodes__new_lvasgn(name: Blob<StringPtr>, value: Blob<Maybe<Ptr<Node>>>, name_l: Blob<Loc>, operator_l: Blob<Maybe<Loc>>, expression_l: Blob<Loc>) -> Blob<Node>;
    fn lib_ruby_parser__external__nodes__is_lvasgn(blob_ptr: *const Blob<Node>) -> bool;
    fn lib_ruby_parser__external__nodes__get_lvasgn(blob_ptr: *const Blob<Node>) -> *mut Blob<Lvasgn>;
    fn lib_ruby_parser__external__nodes__into_lvasgn(blob: Blob<Node>) -> Blob<Lvasgn>;
    fn lib_ruby_parser__external__nodes__new_masgn(lhs: Blob<Ptr<Node>>, rhs: Blob<Ptr<Node>>, operator_l: Blob<Loc>, expression_l: Blob<Loc>) -> Blob<Node>;
    fn lib_ruby_parser__external__nodes__is_masgn(blob_ptr: *const Blob<Node>) -> bool;
    fn lib_ruby_parser__external__nodes__get_masgn(blob_ptr: *const Blob<Node>) -> *mut Blob<Masgn>;
    fn lib_ruby_parser__external__nodes__into_masgn(blob: Blob<Node>) -> Blob<Masgn>;
    fn lib_ruby_parser__external__nodes__new_match_alt(lhs: Blob<Ptr<Node>>, rhs: Blob<Ptr<Node>>, operator_l: Blob<Loc>, expression_l: Blob<Loc>) -> Blob<Node>;
    fn lib_ruby_parser__external__nodes__is_match_alt(blob_ptr: *const Blob<Node>) -> bool;
    fn lib_ruby_parser__external__nodes__get_match_alt(blob_ptr: *const Blob<Node>) -> *mut Blob<MatchAlt>;
    fn lib_ruby_parser__external__nodes__into_match_alt(blob: Blob<Node>) -> Blob<MatchAlt>;
    fn lib_ruby_parser__external__nodes__new_match_as(value: Blob<Ptr<Node>>, as_: Blob<Ptr<Node>>, operator_l: Blob<Loc>, expression_l: Blob<Loc>) -> Blob<Node>;
    fn lib_ruby_parser__external__nodes__is_match_as(blob_ptr: *const Blob<Node>) -> bool;
    fn lib_ruby_parser__external__nodes__get_match_as(blob_ptr: *const Blob<Node>) -> *mut Blob<MatchAs>;
    fn lib_ruby_parser__external__nodes__into_match_as(blob: Blob<Node>) -> Blob<MatchAs>;
    fn lib_ruby_parser__external__nodes__new_match_current_line(re: Blob<Ptr<Node>>, expression_l: Blob<Loc>) -> Blob<Node>;
    fn lib_ruby_parser__external__nodes__is_match_current_line(blob_ptr: *const Blob<Node>) -> bool;
    fn lib_ruby_parser__external__nodes__get_match_current_line(blob_ptr: *const Blob<Node>) -> *mut Blob<MatchCurrentLine>;
    fn lib_ruby_parser__external__nodes__into_match_current_line(blob: Blob<Node>) -> Blob<MatchCurrentLine>;
    fn lib_ruby_parser__external__nodes__new_match_nil_pattern(operator_l: Blob<Loc>, name_l: Blob<Loc>, expression_l: Blob<Loc>) -> Blob<Node>;
    fn lib_ruby_parser__external__nodes__is_match_nil_pattern(blob_ptr: *const Blob<Node>) -> bool;
    fn lib_ruby_parser__external__nodes__get_match_nil_pattern(blob_ptr: *const Blob<Node>) -> *mut Blob<MatchNilPattern>;
    fn lib_ruby_parser__external__nodes__into_match_nil_pattern(blob: Blob<Node>) -> Blob<MatchNilPattern>;
    fn lib_ruby_parser__external__nodes__new_match_rest(name: Blob<Maybe<Ptr<Node>>>, operator_l: Blob<Loc>, expression_l: Blob<Loc>) -> Blob<Node>;
    fn lib_ruby_parser__external__nodes__is_match_rest(blob_ptr: *const Blob<Node>) -> bool;
    fn lib_ruby_parser__external__nodes__get_match_rest(blob_ptr: *const Blob<Node>) -> *mut Blob<MatchRest>;
    fn lib_ruby_parser__external__nodes__into_match_rest(blob: Blob<Node>) -> Blob<MatchRest>;
    fn lib_ruby_parser__external__nodes__new_match_var(name: Blob<StringPtr>, name_l: Blob<Loc>, expression_l: Blob<Loc>) -> Blob<Node>;
    fn lib_ruby_parser__external__nodes__is_match_var(blob_ptr: *const Blob<Node>) -> bool;
    fn lib_ruby_parser__external__nodes__get_match_var(blob_ptr: *const Blob<Node>) -> *mut Blob<MatchVar>;
    fn lib_ruby_parser__external__nodes__into_match_var(blob: Blob<Node>) -> Blob<MatchVar>;
    fn lib_ruby_parser__external__nodes__new_match_with_lvasgn(re: Blob<Ptr<Node>>, value: Blob<Ptr<Node>>, operator_l: Blob<Loc>, expression_l: Blob<Loc>) -> Blob<Node>;
    fn lib_ruby_parser__external__nodes__is_match_with_lvasgn(blob_ptr: *const Blob<Node>) -> bool;
    fn lib_ruby_parser__external__nodes__get_match_with_lvasgn(blob_ptr: *const Blob<Node>) -> *mut Blob<MatchWithLvasgn>;
    fn lib_ruby_parser__external__nodes__into_match_with_lvasgn(blob: Blob<Node>) -> Blob<MatchWithLvasgn>;
    fn lib_ruby_parser__external__nodes__new_mlhs(items: Blob<List<Node>>, begin_l: Blob<Maybe<Loc>>, end_l: Blob<Maybe<Loc>>, expression_l: Blob<Loc>) -> Blob<Node>;
    fn lib_ruby_parser__external__nodes__is_mlhs(blob_ptr: *const Blob<Node>) -> bool;
    fn lib_ruby_parser__external__nodes__get_mlhs(blob_ptr: *const Blob<Node>) -> *mut Blob<Mlhs>;
    fn lib_ruby_parser__external__nodes__into_mlhs(blob: Blob<Node>) -> Blob<Mlhs>;
    fn lib_ruby_parser__external__nodes__new_module(name: Blob<Ptr<Node>>, body: Blob<Maybe<Ptr<Node>>>, keyword_l: Blob<Loc>, end_l: Blob<Loc>, expression_l: Blob<Loc>) -> Blob<Node>;
    fn lib_ruby_parser__external__nodes__is_module(blob_ptr: *const Blob<Node>) -> bool;
    fn lib_ruby_parser__external__nodes__get_module(blob_ptr: *const Blob<Node>) -> *mut Blob<Module>;
    fn lib_ruby_parser__external__nodes__into_module(blob: Blob<Node>) -> Blob<Module>;
    fn lib_ruby_parser__external__nodes__new_next(args: Blob<List<Node>>, keyword_l: Blob<Loc>, expression_l: Blob<Loc>) -> Blob<Node>;
    fn lib_ruby_parser__external__nodes__is_next(blob_ptr: *const Blob<Node>) -> bool;
    fn lib_ruby_parser__external__nodes__get_next(blob_ptr: *const Blob<Node>) -> *mut Blob<Next>;
    fn lib_ruby_parser__external__nodes__into_next(blob: Blob<Node>) -> Blob<Next>;
    fn lib_ruby_parser__external__nodes__new_nil(expression_l: Blob<Loc>) -> Blob<Node>;
    fn lib_ruby_parser__external__nodes__is_nil(blob_ptr: *const Blob<Node>) -> bool;
    fn lib_ruby_parser__external__nodes__get_nil(blob_ptr: *const Blob<Node>) -> *mut Blob<Nil>;
    fn lib_ruby_parser__external__nodes__into_nil(blob: Blob<Node>) -> Blob<Nil>;
    fn lib_ruby_parser__external__nodes__new_nth_ref(name: Blob<StringPtr>, expression_l: Blob<Loc>) -> Blob<Node>;
    fn lib_ruby_parser__external__nodes__is_nth_ref(blob_ptr: *const Blob<Node>) -> bool;
    fn lib_ruby_parser__external__nodes__get_nth_ref(blob_ptr: *const Blob<Node>) -> *mut Blob<NthRef>;
    fn lib_ruby_parser__external__nodes__into_nth_ref(blob: Blob<Node>) -> Blob<NthRef>;
    fn lib_ruby_parser__external__nodes__new_numblock(call: Blob<Ptr<Node>>, numargs: Blob<u8>, body: Blob<Ptr<Node>>, begin_l: Blob<Loc>, end_l: Blob<Loc>, expression_l: Blob<Loc>) -> Blob<Node>;
    fn lib_ruby_parser__external__nodes__is_numblock(blob_ptr: *const Blob<Node>) -> bool;
    fn lib_ruby_parser__external__nodes__get_numblock(blob_ptr: *const Blob<Node>) -> *mut Blob<Numblock>;
    fn lib_ruby_parser__external__nodes__into_numblock(blob: Blob<Node>) -> Blob<Numblock>;
    fn lib_ruby_parser__external__nodes__new_op_asgn(recv: Blob<Ptr<Node>>, operator: Blob<StringPtr>, value: Blob<Ptr<Node>>, operator_l: Blob<Loc>, expression_l: Blob<Loc>) -> Blob<Node>;
    fn lib_ruby_parser__external__nodes__is_op_asgn(blob_ptr: *const Blob<Node>) -> bool;
    fn lib_ruby_parser__external__nodes__get_op_asgn(blob_ptr: *const Blob<Node>) -> *mut Blob<OpAsgn>;
    fn lib_ruby_parser__external__nodes__into_op_asgn(blob: Blob<Node>) -> Blob<OpAsgn>;
    fn lib_ruby_parser__external__nodes__new_optarg(name: Blob<StringPtr>, default: Blob<Ptr<Node>>, name_l: Blob<Loc>, operator_l: Blob<Loc>, expression_l: Blob<Loc>) -> Blob<Node>;
    fn lib_ruby_parser__external__nodes__is_optarg(blob_ptr: *const Blob<Node>) -> bool;
    fn lib_ruby_parser__external__nodes__get_optarg(blob_ptr: *const Blob<Node>) -> *mut Blob<Optarg>;
    fn lib_ruby_parser__external__nodes__into_optarg(blob: Blob<Node>) -> Blob<Optarg>;
    fn lib_ruby_parser__external__nodes__new_or(lhs: Blob<Ptr<Node>>, rhs: Blob<Ptr<Node>>, operator_l: Blob<Loc>, expression_l: Blob<Loc>) -> Blob<Node>;
    fn lib_ruby_parser__external__nodes__is_or(blob_ptr: *const Blob<Node>) -> bool;
    fn lib_ruby_parser__external__nodes__get_or(blob_ptr: *const Blob<Node>) -> *mut Blob<Or>;
    fn lib_ruby_parser__external__nodes__into_or(blob: Blob<Node>) -> Blob<Or>;
    fn lib_ruby_parser__external__nodes__new_or_asgn(recv: Blob<Ptr<Node>>, value: Blob<Ptr<Node>>, operator_l: Blob<Loc>, expression_l: Blob<Loc>) -> Blob<Node>;
    fn lib_ruby_parser__external__nodes__is_or_asgn(blob_ptr: *const Blob<Node>) -> bool;
    fn lib_ruby_parser__external__nodes__get_or_asgn(blob_ptr: *const Blob<Node>) -> *mut Blob<OrAsgn>;
    fn lib_ruby_parser__external__nodes__into_or_asgn(blob: Blob<Node>) -> Blob<OrAsgn>;
    fn lib_ruby_parser__external__nodes__new_pair(key: Blob<Ptr<Node>>, value: Blob<Ptr<Node>>, operator_l: Blob<Loc>, expression_l: Blob<Loc>) -> Blob<Node>;
    fn lib_ruby_parser__external__nodes__is_pair(blob_ptr: *const Blob<Node>) -> bool;
    fn lib_ruby_parser__external__nodes__get_pair(blob_ptr: *const Blob<Node>) -> *mut Blob<Pair>;
    fn lib_ruby_parser__external__nodes__into_pair(blob: Blob<Node>) -> Blob<Pair>;
    fn lib_ruby_parser__external__nodes__new_pin(var: Blob<Ptr<Node>>, selector_l: Blob<Loc>, expression_l: Blob<Loc>) -> Blob<Node>;
    fn lib_ruby_parser__external__nodes__is_pin(blob_ptr: *const Blob<Node>) -> bool;
    fn lib_ruby_parser__external__nodes__get_pin(blob_ptr: *const Blob<Node>) -> *mut Blob<Pin>;
    fn lib_ruby_parser__external__nodes__into_pin(blob: Blob<Node>) -> Blob<Pin>;
    fn lib_ruby_parser__external__nodes__new_postexe(body: Blob<Maybe<Ptr<Node>>>, keyword_l: Blob<Loc>, begin_l: Blob<Loc>, end_l: Blob<Loc>, expression_l: Blob<Loc>) -> Blob<Node>;
    fn lib_ruby_parser__external__nodes__is_postexe(blob_ptr: *const Blob<Node>) -> bool;
    fn lib_ruby_parser__external__nodes__get_postexe(blob_ptr: *const Blob<Node>) -> *mut Blob<Postexe>;
    fn lib_ruby_parser__external__nodes__into_postexe(blob: Blob<Node>) -> Blob<Postexe>;
    fn lib_ruby_parser__external__nodes__new_preexe(body: Blob<Maybe<Ptr<Node>>>, keyword_l: Blob<Loc>, begin_l: Blob<Loc>, end_l: Blob<Loc>, expression_l: Blob<Loc>) -> Blob<Node>;
    fn lib_ruby_parser__external__nodes__is_preexe(blob_ptr: *const Blob<Node>) -> bool;
    fn lib_ruby_parser__external__nodes__get_preexe(blob_ptr: *const Blob<Node>) -> *mut Blob<Preexe>;
    fn lib_ruby_parser__external__nodes__into_preexe(blob: Blob<Node>) -> Blob<Preexe>;
    fn lib_ruby_parser__external__nodes__new_procarg0(args: Blob<List<Node>>, begin_l: Blob<Maybe<Loc>>, end_l: Blob<Maybe<Loc>>, expression_l: Blob<Loc>) -> Blob<Node>;
    fn lib_ruby_parser__external__nodes__is_procarg0(blob_ptr: *const Blob<Node>) -> bool;
    fn lib_ruby_parser__external__nodes__get_procarg0(blob_ptr: *const Blob<Node>) -> *mut Blob<Procarg0>;
    fn lib_ruby_parser__external__nodes__into_procarg0(blob: Blob<Node>) -> Blob<Procarg0>;
    fn lib_ruby_parser__external__nodes__new_rational(value: Blob<StringPtr>, operator_l: Blob<Maybe<Loc>>, expression_l: Blob<Loc>) -> Blob<Node>;
    fn lib_ruby_parser__external__nodes__is_rational(blob_ptr: *const Blob<Node>) -> bool;
    fn lib_ruby_parser__external__nodes__get_rational(blob_ptr: *const Blob<Node>) -> *mut Blob<Rational>;
    fn lib_ruby_parser__external__nodes__into_rational(blob: Blob<Node>) -> Blob<Rational>;
    fn lib_ruby_parser__external__nodes__new_redo(expression_l: Blob<Loc>) -> Blob<Node>;
    fn lib_ruby_parser__external__nodes__is_redo(blob_ptr: *const Blob<Node>) -> bool;
    fn lib_ruby_parser__external__nodes__get_redo(blob_ptr: *const Blob<Node>) -> *mut Blob<Redo>;
    fn lib_ruby_parser__external__nodes__into_redo(blob: Blob<Node>) -> Blob<Redo>;
    fn lib_ruby_parser__external__nodes__new_reg_opt(options: Blob<Maybe<StringPtr>>, expression_l: Blob<Loc>) -> Blob<Node>;
    fn lib_ruby_parser__external__nodes__is_reg_opt(blob_ptr: *const Blob<Node>) -> bool;
    fn lib_ruby_parser__external__nodes__get_reg_opt(blob_ptr: *const Blob<Node>) -> *mut Blob<RegOpt>;
    fn lib_ruby_parser__external__nodes__into_reg_opt(blob: Blob<Node>) -> Blob<RegOpt>;
    fn lib_ruby_parser__external__nodes__new_regexp(parts: Blob<List<Node>>, options: Blob<Maybe<Ptr<Node>>>, begin_l: Blob<Loc>, end_l: Blob<Loc>, expression_l: Blob<Loc>) -> Blob<Node>;
    fn lib_ruby_parser__external__nodes__is_regexp(blob_ptr: *const Blob<Node>) -> bool;
    fn lib_ruby_parser__external__nodes__get_regexp(blob_ptr: *const Blob<Node>) -> *mut Blob<Regexp>;
    fn lib_ruby_parser__external__nodes__into_regexp(blob: Blob<Node>) -> Blob<Regexp>;
    fn lib_ruby_parser__external__nodes__new_rescue(body: Blob<Maybe<Ptr<Node>>>, rescue_bodies: Blob<List<Node>>, else_: Blob<Maybe<Ptr<Node>>>, else_l: Blob<Maybe<Loc>>, expression_l: Blob<Loc>) -> Blob<Node>;
    fn lib_ruby_parser__external__nodes__is_rescue(blob_ptr: *const Blob<Node>) -> bool;
    fn lib_ruby_parser__external__nodes__get_rescue(blob_ptr: *const Blob<Node>) -> *mut Blob<Rescue>;
    fn lib_ruby_parser__external__nodes__into_rescue(blob: Blob<Node>) -> Blob<Rescue>;
    fn lib_ruby_parser__external__nodes__new_rescue_body(exc_list: Blob<Maybe<Ptr<Node>>>, exc_var: Blob<Maybe<Ptr<Node>>>, body: Blob<Maybe<Ptr<Node>>>, keyword_l: Blob<Loc>, assoc_l: Blob<Maybe<Loc>>, begin_l: Blob<Maybe<Loc>>, expression_l: Blob<Loc>) -> Blob<Node>;
    fn lib_ruby_parser__external__nodes__is_rescue_body(blob_ptr: *const Blob<Node>) -> bool;
    fn lib_ruby_parser__external__nodes__get_rescue_body(blob_ptr: *const Blob<Node>) -> *mut Blob<RescueBody>;
    fn lib_ruby_parser__external__nodes__into_rescue_body(blob: Blob<Node>) -> Blob<RescueBody>;
    fn lib_ruby_parser__external__nodes__new_restarg(name: Blob<Maybe<StringPtr>>, operator_l: Blob<Loc>, name_l: Blob<Maybe<Loc>>, expression_l: Blob<Loc>) -> Blob<Node>;
    fn lib_ruby_parser__external__nodes__is_restarg(blob_ptr: *const Blob<Node>) -> bool;
    fn lib_ruby_parser__external__nodes__get_restarg(blob_ptr: *const Blob<Node>) -> *mut Blob<Restarg>;
    fn lib_ruby_parser__external__nodes__into_restarg(blob: Blob<Node>) -> Blob<Restarg>;
    fn lib_ruby_parser__external__nodes__new_retry(expression_l: Blob<Loc>) -> Blob<Node>;
    fn lib_ruby_parser__external__nodes__is_retry(blob_ptr: *const Blob<Node>) -> bool;
    fn lib_ruby_parser__external__nodes__get_retry(blob_ptr: *const Blob<Node>) -> *mut Blob<Retry>;
    fn lib_ruby_parser__external__nodes__into_retry(blob: Blob<Node>) -> Blob<Retry>;
    fn lib_ruby_parser__external__nodes__new_return(args: Blob<List<Node>>, keyword_l: Blob<Loc>, expression_l: Blob<Loc>) -> Blob<Node>;
    fn lib_ruby_parser__external__nodes__is_return(blob_ptr: *const Blob<Node>) -> bool;
    fn lib_ruby_parser__external__nodes__get_return(blob_ptr: *const Blob<Node>) -> *mut Blob<Return>;
    fn lib_ruby_parser__external__nodes__into_return(blob: Blob<Node>) -> Blob<Return>;
    fn lib_ruby_parser__external__nodes__new_s_class(expr: Blob<Ptr<Node>>, body: Blob<Maybe<Ptr<Node>>>, keyword_l: Blob<Loc>, operator_l: Blob<Loc>, end_l: Blob<Loc>, expression_l: Blob<Loc>) -> Blob<Node>;
    fn lib_ruby_parser__external__nodes__is_s_class(blob_ptr: *const Blob<Node>) -> bool;
    fn lib_ruby_parser__external__nodes__get_s_class(blob_ptr: *const Blob<Node>) -> *mut Blob<SClass>;
    fn lib_ruby_parser__external__nodes__into_s_class(blob: Blob<Node>) -> Blob<SClass>;
    fn lib_ruby_parser__external__nodes__new_self(expression_l: Blob<Loc>) -> Blob<Node>;
    fn lib_ruby_parser__external__nodes__is_self(blob_ptr: *const Blob<Node>) -> bool;
    fn lib_ruby_parser__external__nodes__get_self(blob_ptr: *const Blob<Node>) -> *mut Blob<Self_>;
    fn lib_ruby_parser__external__nodes__into_self(blob: Blob<Node>) -> Blob<Self_>;
    fn lib_ruby_parser__external__nodes__new_send(recv: Blob<Maybe<Ptr<Node>>>, method_name: Blob<StringPtr>, args: Blob<List<Node>>, dot_l: Blob<Maybe<Loc>>, selector_l: Blob<Maybe<Loc>>, begin_l: Blob<Maybe<Loc>>, end_l: Blob<Maybe<Loc>>, operator_l: Blob<Maybe<Loc>>, expression_l: Blob<Loc>) -> Blob<Node>;
    fn lib_ruby_parser__external__nodes__is_send(blob_ptr: *const Blob<Node>) -> bool;
    fn lib_ruby_parser__external__nodes__get_send(blob_ptr: *const Blob<Node>) -> *mut Blob<Send>;
    fn lib_ruby_parser__external__nodes__into_send(blob: Blob<Node>) -> Blob<Send>;
    fn lib_ruby_parser__external__nodes__new_shadowarg(name: Blob<StringPtr>, expression_l: Blob<Loc>) -> Blob<Node>;
    fn lib_ruby_parser__external__nodes__is_shadowarg(blob_ptr: *const Blob<Node>) -> bool;
    fn lib_ruby_parser__external__nodes__get_shadowarg(blob_ptr: *const Blob<Node>) -> *mut Blob<Shadowarg>;
    fn lib_ruby_parser__external__nodes__into_shadowarg(blob: Blob<Node>) -> Blob<Shadowarg>;
    fn lib_ruby_parser__external__nodes__new_splat(value: Blob<Maybe<Ptr<Node>>>, operator_l: Blob<Loc>, expression_l: Blob<Loc>) -> Blob<Node>;
    fn lib_ruby_parser__external__nodes__is_splat(blob_ptr: *const Blob<Node>) -> bool;
    fn lib_ruby_parser__external__nodes__get_splat(blob_ptr: *const Blob<Node>) -> *mut Blob<Splat>;
    fn lib_ruby_parser__external__nodes__into_splat(blob: Blob<Node>) -> Blob<Splat>;
    fn lib_ruby_parser__external__nodes__new_str(value: Blob<Bytes>, begin_l: Blob<Maybe<Loc>>, end_l: Blob<Maybe<Loc>>, expression_l: Blob<Loc>) -> Blob<Node>;
    fn lib_ruby_parser__external__nodes__is_str(blob_ptr: *const Blob<Node>) -> bool;
    fn lib_ruby_parser__external__nodes__get_str(blob_ptr: *const Blob<Node>) -> *mut Blob<Str>;
    fn lib_ruby_parser__external__nodes__into_str(blob: Blob<Node>) -> Blob<Str>;
    fn lib_ruby_parser__external__nodes__new_super(args: Blob<List<Node>>, keyword_l: Blob<Loc>, begin_l: Blob<Maybe<Loc>>, end_l: Blob<Maybe<Loc>>, expression_l: Blob<Loc>) -> Blob<Node>;
    fn lib_ruby_parser__external__nodes__is_super(blob_ptr: *const Blob<Node>) -> bool;
    fn lib_ruby_parser__external__nodes__get_super(blob_ptr: *const Blob<Node>) -> *mut Blob<Super>;
    fn lib_ruby_parser__external__nodes__into_super(blob: Blob<Node>) -> Blob<Super>;
    fn lib_ruby_parser__external__nodes__new_sym(name: Blob<Bytes>, begin_l: Blob<Maybe<Loc>>, end_l: Blob<Maybe<Loc>>, expression_l: Blob<Loc>) -> Blob<Node>;
    fn lib_ruby_parser__external__nodes__is_sym(blob_ptr: *const Blob<Node>) -> bool;
    fn lib_ruby_parser__external__nodes__get_sym(blob_ptr: *const Blob<Node>) -> *mut Blob<Sym>;
    fn lib_ruby_parser__external__nodes__into_sym(blob: Blob<Node>) -> Blob<Sym>;
    fn lib_ruby_parser__external__nodes__new_true(expression_l: Blob<Loc>) -> Blob<Node>;
    fn lib_ruby_parser__external__nodes__is_true(blob_ptr: *const Blob<Node>) -> bool;
    fn lib_ruby_parser__external__nodes__get_true(blob_ptr: *const Blob<Node>) -> *mut Blob<True>;
    fn lib_ruby_parser__external__nodes__into_true(blob: Blob<Node>) -> Blob<True>;
    fn lib_ruby_parser__external__nodes__new_undef(names: Blob<List<Node>>, keyword_l: Blob<Loc>, expression_l: Blob<Loc>) -> Blob<Node>;
    fn lib_ruby_parser__external__nodes__is_undef(blob_ptr: *const Blob<Node>) -> bool;
    fn lib_ruby_parser__external__nodes__get_undef(blob_ptr: *const Blob<Node>) -> *mut Blob<Undef>;
    fn lib_ruby_parser__external__nodes__into_undef(blob: Blob<Node>) -> Blob<Undef>;
    fn lib_ruby_parser__external__nodes__new_unless_guard(cond: Blob<Ptr<Node>>, keyword_l: Blob<Loc>, expression_l: Blob<Loc>) -> Blob<Node>;
    fn lib_ruby_parser__external__nodes__is_unless_guard(blob_ptr: *const Blob<Node>) -> bool;
    fn lib_ruby_parser__external__nodes__get_unless_guard(blob_ptr: *const Blob<Node>) -> *mut Blob<UnlessGuard>;
    fn lib_ruby_parser__external__nodes__into_unless_guard(blob: Blob<Node>) -> Blob<UnlessGuard>;
    fn lib_ruby_parser__external__nodes__new_until(cond: Blob<Ptr<Node>>, body: Blob<Maybe<Ptr<Node>>>, keyword_l: Blob<Loc>, begin_l: Blob<Maybe<Loc>>, end_l: Blob<Maybe<Loc>>, expression_l: Blob<Loc>) -> Blob<Node>;
    fn lib_ruby_parser__external__nodes__is_until(blob_ptr: *const Blob<Node>) -> bool;
    fn lib_ruby_parser__external__nodes__get_until(blob_ptr: *const Blob<Node>) -> *mut Blob<Until>;
    fn lib_ruby_parser__external__nodes__into_until(blob: Blob<Node>) -> Blob<Until>;
    fn lib_ruby_parser__external__nodes__new_until_post(cond: Blob<Ptr<Node>>, body: Blob<Ptr<Node>>, keyword_l: Blob<Loc>, expression_l: Blob<Loc>) -> Blob<Node>;
    fn lib_ruby_parser__external__nodes__is_until_post(blob_ptr: *const Blob<Node>) -> bool;
    fn lib_ruby_parser__external__nodes__get_until_post(blob_ptr: *const Blob<Node>) -> *mut Blob<UntilPost>;
    fn lib_ruby_parser__external__nodes__into_until_post(blob: Blob<Node>) -> Blob<UntilPost>;
    fn lib_ruby_parser__external__nodes__new_when(patterns: Blob<List<Node>>, body: Blob<Maybe<Ptr<Node>>>, keyword_l: Blob<Loc>, begin_l: Blob<Loc>, expression_l: Blob<Loc>) -> Blob<Node>;
    fn lib_ruby_parser__external__nodes__is_when(blob_ptr: *const Blob<Node>) -> bool;
    fn lib_ruby_parser__external__nodes__get_when(blob_ptr: *const Blob<Node>) -> *mut Blob<When>;
    fn lib_ruby_parser__external__nodes__into_when(blob: Blob<Node>) -> Blob<When>;
    fn lib_ruby_parser__external__nodes__new_while(cond: Blob<Ptr<Node>>, body: Blob<Maybe<Ptr<Node>>>, keyword_l: Blob<Loc>, begin_l: Blob<Maybe<Loc>>, end_l: Blob<Maybe<Loc>>, expression_l: Blob<Loc>) -> Blob<Node>;
    fn lib_ruby_parser__external__nodes__is_while(blob_ptr: *const Blob<Node>) -> bool;
    fn lib_ruby_parser__external__nodes__get_while(blob_ptr: *const Blob<Node>) -> *mut Blob<While>;
    fn lib_ruby_parser__external__nodes__into_while(blob: Blob<Node>) -> Blob<While>;
    fn lib_ruby_parser__external__nodes__new_while_post(cond: Blob<Ptr<Node>>, body: Blob<Ptr<Node>>, keyword_l: Blob<Loc>, expression_l: Blob<Loc>) -> Blob<Node>;
    fn lib_ruby_parser__external__nodes__is_while_post(blob_ptr: *const Blob<Node>) -> bool;
    fn lib_ruby_parser__external__nodes__get_while_post(blob_ptr: *const Blob<Node>) -> *mut Blob<WhilePost>;
    fn lib_ruby_parser__external__nodes__into_while_post(blob: Blob<Node>) -> Blob<WhilePost>;
    fn lib_ruby_parser__external__nodes__new_x_heredoc(parts: Blob<List<Node>>, heredoc_body_l: Blob<Loc>, heredoc_end_l: Blob<Loc>, expression_l: Blob<Loc>) -> Blob<Node>;
    fn lib_ruby_parser__external__nodes__is_x_heredoc(blob_ptr: *const Blob<Node>) -> bool;
    fn lib_ruby_parser__external__nodes__get_x_heredoc(blob_ptr: *const Blob<Node>) -> *mut Blob<XHeredoc>;
    fn lib_ruby_parser__external__nodes__into_x_heredoc(blob: Blob<Node>) -> Blob<XHeredoc>;
    fn lib_ruby_parser__external__nodes__new_xstr(parts: Blob<List<Node>>, begin_l: Blob<Loc>, end_l: Blob<Loc>, expression_l: Blob<Loc>) -> Blob<Node>;
    fn lib_ruby_parser__external__nodes__is_xstr(blob_ptr: *const Blob<Node>) -> bool;
    fn lib_ruby_parser__external__nodes__get_xstr(blob_ptr: *const Blob<Node>) -> *mut Blob<Xstr>;
    fn lib_ruby_parser__external__nodes__into_xstr(blob: Blob<Node>) -> Blob<Xstr>;
    fn lib_ruby_parser__external__nodes__new_yield(args: Blob<List<Node>>, keyword_l: Blob<Loc>, begin_l: Blob<Maybe<Loc>>, end_l: Blob<Maybe<Loc>>, expression_l: Blob<Loc>) -> Blob<Node>;
    fn lib_ruby_parser__external__nodes__is_yield(blob_ptr: *const Blob<Node>) -> bool;
    fn lib_ruby_parser__external__nodes__get_yield(blob_ptr: *const Blob<Node>) -> *mut Blob<Yield>;
    fn lib_ruby_parser__external__nodes__into_yield(blob: Blob<Node>) -> Blob<Yield>;
    fn lib_ruby_parser__external__nodes__new_z_super(expression_l: Blob<Loc>) -> Blob<Node>;
    fn lib_ruby_parser__external__nodes__is_z_super(blob_ptr: *const Blob<Node>) -> bool;
    fn lib_ruby_parser__external__nodes__get_z_super(blob_ptr: *const Blob<Node>) -> *mut Blob<ZSuper>;
    fn lib_ruby_parser__external__nodes__into_z_super(blob: Blob<Node>) -> Blob<ZSuper>;

    fn lib_ruby_parser__external__node__drop(blob: *mut Blob<Node>);
}

impl Drop for Node {
    fn drop(&mut self) {
        unsafe { lib_ruby_parser__external__node__drop(&mut self.blob) }
    }
}
