use crate::codegen::rust::nodes::helpers::struct_name;

fn contents() -> String {
    let nodes = lib_ruby_parser_nodes::nodes();

    format!(
        "// This file is autogenerated by {generator}

{mods}

{uses}

pub(crate) mod internal {{
    {internal_uses}
}}
",
        generator = file!(),
        mods = nodes.map(mod_).join("\n"),
        uses = nodes.map(use_).join("\n"),
        internal_uses = nodes.map(internal_use).join("\n    "),
    )
}

pub(crate) fn codegen() {
    std::fs::write("src/nodes/types/mod.rs", contents()).unwrap();
}

use crate::codegen::rust::nodes::helpers::filename;

fn mod_(node: &lib_ruby_parser_nodes::Node) -> String {
    format!("mod {};", filename(node))
}

fn use_(node: &lib_ruby_parser_nodes::Node) -> String {
    format!("pub use {}::{};", filename(node), struct_name(node))
}

fn internal_use(node: &lib_ruby_parser_nodes::Node) -> String {
    format!(
        "#[allow(unused_imports)]
    pub(crate) use super::{mod_name}::Internal{struct_name} as {struct_name};",
        mod_name = filename(node),
        struct_name = struct_name(node)
    )
}
