fn contents() -> String {
    let messages = lib_ruby_parser_nodes::messages();

    format!(
        "// This file is autogenerated by {generator}

use super::DiagnosticMessage;

impl DiagnosticMessage {{
    {predicates}
}}
",
        generator = file!(),
        predicates = messages.map(predicate).join("\n    ")
    )
}

pub(crate) fn codegen() {
    std::fs::write("src/error/message/native/predicates.rs", contents()).unwrap();
}

fn predicate(message: &lib_ruby_parser_nodes::Message) -> String {
    format!(
        "/// Returns true if `self` is {variant_name}
    pub fn is_{lower_variant_name}(&self) -> bool {{
        matches!(self, Self::{variant_name} {{ .. }})
    }}",
        variant_name = message.camelcase_name,
        lower_variant_name = message.lower_name()
    )
}
