fn contents() -> String {
    let messages = lib_ruby_parser_nodes::messages();

    format!(
        "// This file is auto-generated by {generator}

use super::{{DiagnosticMessage}};

impl Clone for DiagnosticMessage {{
    fn clone(&self) -> Self {{
        {branches} else {{
            panic!(\"unrecognized diagnostic message type\")
        }}
    }}
}}
",
        generator = file!(),
        branches = messages.map(branch).join(" else ")
    )
}

pub(crate) fn codegen() {
    std::fs::write("src/error/message/external/impl_clone.rs", contents()).unwrap();
}

fn branch(message: &lib_ruby_parser_nodes::Message) -> String {
    let has_fields = !message.fields.0.is_empty();

    let condition = if has_fields {
        format!("let Some(variant) = self.as_{}()", message.lower_name())
    } else {
        format!("self.is_{}()", message.lower_name())
    };

    let arglist = message
        .fields
        .map(|field| match field.field_type {
            lib_ruby_parser_nodes::MessageFieldType::Str => {
                format!("variant.get_{}().clone()", field.name)
            }
            lib_ruby_parser_nodes::MessageFieldType::Byte => {
                format!("*variant.get_{}()", field.name)
            }
        })
        .join(", ");

    format!(
        "if {condition} {{
            Self::new_{message_type}({arglist})
        }}",
        condition = condition,
        message_type = message.lower_name(),
        arglist = arglist,
    )
}
