use crate::codegen::cpp::helpers as cpp_helpers;

fn contents() -> String {
    let nodes = lib_ruby_parser_nodes::nodes();

    format!(
        "// This file is autogenerated by {generator}

#include \"structs.hpp\"

namespace lib_ruby_parser
{{
    {cpp_constructors}
    Node::Node(node_variant_t variant) : variant(std::move(variant)) {{}}

    void drop_node(Node *node)
    {{
        node->~Node();
    }}

    void drop_maybe_node_ptr(std::unique_ptr<Node> *node)
    {{
        node->~unique_ptr();
    }}

    void drop_node_ptr(std::unique_ptr<Node> *node)
    {{
        node->~unique_ptr();
    }}

    void drop_node_list(NodeList *node_list)
    {{
        node_list->~vector();
    }}
}}
",
        generator = file!(),
        cpp_constructors = nodes.map(cpp_constructor).join("\n    "),
    )
}

pub(crate) fn codegen() {
    std::fs::write("external/cpp/nodes.cpp", contents()).unwrap();
}

fn cpp_constructor(node: &lib_ruby_parser_nodes::Node) -> String {
    let constructor_args = node
        .fields
        .map(|field| {
            format!(
                "{} {}",
                cpp_helpers::nodes::field_type(field),
                cpp_helpers::nodes::field_name(field)
            )
        })
        .join(", ");

    let member_initialize_list = node
        .fields
        .map(|field| {
            format!(
                "{name}(std::move({name}))",
                name = cpp_helpers::nodes::field_name(field)
            )
        })
        .join(", ");

    format!(
        "{class_name}::{class_name}({constructor_args}) : {member_initialize_list}{{}};",
        class_name = node.camelcase_name,
        constructor_args = constructor_args,
        member_initialize_list = member_initialize_list
    )
}
