use crate::codegen::cpp::helpers;

fn contents() -> String {
    let messages = lib_ruby_parser_nodes::messages();

    format!(
        "// This file is autogenerated by {generator}
#include \"structs.hpp\"

namespace lib_ruby_parser
{{
    {cpp_constructors}

    {drop_fns}

    DiagnosticMessage::DiagnosticMessage(diagnostic_message_variant_t variant): variant(std::move(variant)) {{}}
    Diagnostic::Diagnostic(
        ErrorLevel level,
        DiagnosticMessage message,
        Loc loc): level(std::move(level)),
                message(std::move(message)),
                loc(std::move(loc)) {{}}

    void drop_diagnostic_message(DiagnosticMessage *message)
    {{
        message->~DiagnosticMessage();
    }}
}}
",
        generator = file!(),
        cpp_constructors = messages.map(cpp_constructor).join("\n    "),
        drop_fns = messages.map(drop_fn).join("\n\n    "),
    )
}

pub(crate) fn codegen() {
    std::fs::write("external/cpp/messages.cpp", contents()).unwrap();
}

fn cpp_constructor(message: &lib_ruby_parser_nodes::Message) -> String {
    let initializer_list = message.fields.map(|field| {
        format!(
            "{name}(std::move({name}))",
            name = helpers::messages::field_name(field)
        )
    });

    let initializer_list = if initializer_list.is_empty() {
        format!("")
    } else {
        format!(" : {}", initializer_list.join(", "))
    };

    format!(
        "{name}::{name}({constructor_arglist}){initializer_list} {{}}",
        name = message.camelcase_name,
        constructor_arglist = helpers::messages::constructor_arglist(message),
        initializer_list = initializer_list
    )
}

fn drop_fn(message: &lib_ruby_parser_nodes::Message) -> String {
    format!(
        "void drop_message_{lower}({struct_name}* variant)
    {{
        variant->~{struct_name}();
    }}",
        lower = message.lower_name(),
        struct_name = message.camelcase_name,
    )
}
