use crate::codegen::c::helpers;

fn contents() -> String {
    let nodes = lib_ruby_parser_nodes::nodes();

    format!(
        "// This file is autogenerated by {generator}

#include \"structs.h\"
#include <stdio.h>
#include <stdlib.h>

// drop variant fns
{drop_variant_fns}

void LIB_RUBY_PARSER_drop_node(LIB_RUBY_PARSER_Node *node)
{{
    {drop_node}
}}

void LIB_RUBY_PARSER_drop_maybe_node_ptr(LIB_RUBY_PARSER_Node **node)
{{
    LIB_RUBY_PARSER_Node *ptr = *node;
    if (ptr) {{
        LIB_RUBY_PARSER_drop_node(ptr);
        free(ptr);
    }}
}}

void LIB_RUBY_PARSER_drop_node_ptr(LIB_RUBY_PARSER_Node **node)
{{
    LIB_RUBY_PARSER_Node *ptr = *node;
    LIB_RUBY_PARSER_drop_node(ptr);
    free(ptr);
}}

void lib_ruby_parser__external__list__of_nodes__drop(LIB_RUBY_PARSER_NodeList *);
void LIB_RUBY_PARSER_drop_node_list(LIB_RUBY_PARSER_NodeList *node_list)
{{
    lib_ruby_parser__external__list__of_nodes__drop(node_list);
}}
",
        generator = file!(),
        drop_variant_fns = nodes.map(drop_variant_fn).join("\n"),
        drop_node = drop_node(&nodes)
    )
}

pub(crate) fn codegen() {
    std::fs::write("external/c/nodes.c", contents()).unwrap();
}

fn drop_variant_fn(node: &lib_ruby_parser_nodes::Node) -> String {
    let drop_fields = node
        .fields
        .map(|field| {
            let fn_name = match field.field_type {
                lib_ruby_parser_nodes::NodeFieldType::Node => "LIB_RUBY_PARSER_drop_node_ptr",
                lib_ruby_parser_nodes::NodeFieldType::Nodes => "LIB_RUBY_PARSER_drop_node_list",
                lib_ruby_parser_nodes::NodeFieldType::MaybeNode { .. } => {
                    "LIB_RUBY_PARSER_drop_maybe_node_ptr"
                }
                lib_ruby_parser_nodes::NodeFieldType::Loc => "LIB_RUBY_PARSER_drop_loc",
                lib_ruby_parser_nodes::NodeFieldType::MaybeLoc => "LIB_RUBY_PARSER_drop_maybe_loc",

                lib_ruby_parser_nodes::NodeFieldType::Str { .. } => {
                    "LIB_RUBY_PARSER_drop_string_ptr"
                }

                lib_ruby_parser_nodes::NodeFieldType::MaybeStr { .. } => {
                    "LIB_RUBY_PARSER_drop_maybe_string_ptr"
                }
                lib_ruby_parser_nodes::NodeFieldType::StringValue => "LIB_RUBY_PARSER_drop_bytes",
                lib_ruby_parser_nodes::NodeFieldType::U8 => "LIB_RUBY_PARSER_drop_byte",
            };

            format!(
                "{fn_name}(&(variant->{field_name}));",
                fn_name = fn_name,
                field_name = helpers::nodes::fields::field_name(field)
            )
        })
        .join("\n    ");

    format!(
        "void LIB_RUBY_PARSER_drop_node_{lower}(LIB_RUBY_PARSER_{struct_name} *variant) {{
    {drop_fields}
}}",
        struct_name = node.camelcase_name,
        drop_fields = drop_fields,
        lower = node.lower_name()
    )
}

fn drop_node(nodes: &lib_ruby_parser_nodes::NodeList) -> String {
    let branches = nodes
        .map(|node| {
            format!(
                "case {tag_name}:
            LIB_RUBY_PARSER_drop_node_{lower}(&(node->as.{member_name}));
            break;",
                tag_name = helpers::nodes::enum_variant_name(node),
                lower = node.lower_name(),
                member_name = helpers::nodes::union_member_name(node)
            )
        })
        .join("\n        ");

    format!(
        "switch (node->tag) {{
        {branches}
    }}",
        branches = branches
    )
}
