use lib_ruby_parser_bindings::helpers::messages::fields::field_name;

fn contents() -> String {
    let messages = lib_ruby_parser_nodes::messages();

    format!(
        "// This file is autogenerated by {generator}
#include \"structs.h\"

{drop_fns}

void LIB_RUBY_PARSER_drop_diagnostic_message(LIB_RUBY_PARSER_DiagnosticMessage *message)
{{
    switch(message->tag)
    {{
        {drop_branches}
    }}
}}
",
        generator = file!(),
        drop_fns = messages.map(drop_fn).join("\n\n"),
        drop_branches = messages.map(drop_branch).join("\n        ")
    )
}

pub(crate) fn codegen() {
    std::fs::write("external/c/messages.c", contents()).unwrap();
}

fn drop_fn(message: &lib_ruby_parser_nodes::Message) -> String {
    let mut drop_fields = message.fields.map(|field| {
        let drop_fn_name = match field.field_type {
            lib_ruby_parser_nodes::MessageFieldType::Str => "LIB_RUBY_PARSER_drop_string_ptr",
            lib_ruby_parser_nodes::MessageFieldType::Byte => "LIB_RUBY_PARSER_drop_byte",
        };
        format!(
            "{drop_fn_name}(&(variant->{field_name}));",
            drop_fn_name = drop_fn_name,
            field_name = field_name(field)
        )
    });
    if drop_fields.is_empty() {
        drop_fields = vec![String::from("(void)variant;")];
    }

    format!(
        "void LIB_RUBY_PARSER_drop_message_{variant}(LIB_RUBY_PARSER_{struct_name}* variant)
{{
    {drop_fields}
}}",
        variant = message.lower_name(),
        struct_name = message.camelcase_name,
        drop_fields = drop_fields.join("\n    ")
    )
}
fn drop_branch(message: &lib_ruby_parser_nodes::Message) -> String {
    format!(
        "case LIB_RUBY_PARSER_MESSAGE_{tag_name}:
            LIB_RUBY_PARSER_drop_message_{variant}(&(message->as.{member_name}));
            break;",
        tag_name = message.upper_name(),
        member_name = message.lower_name(),
        variant = message.lower_name()
    )
}
