fn contents() -> String {
    format!(
        "#ifndef LIB_RUBY_PARSER_EXTERNAL_C_BLOBS_H
#define LIB_RUBY_PARSER_EXTERNAL_C_BLOBS_H

// This file is autogenerated by {generator}

#include \"structs.h\"
#include \"declare_blob.h\"

{node_blobs}

{message_blobs}

#endif // LIB_RUBY_PARSER_EXTERNAL_C_BLOBS_H
",
        generator = file!(),
        // blobs
        node_blobs = lib_ruby_parser_nodes::nodes().map(node_blob).join("\n"),
        message_blobs = lib_ruby_parser_nodes::messages()
            .map(message_blob)
            .join("\n"),
    )
}

pub(crate) fn codegen() {
    std::fs::write("external/c/blobs_gen.h", contents()).unwrap();
}

fn node_blob(node: &lib_ruby_parser_nodes::Node) -> String {
    format!(
        "DECLARE_BLOB_FOR(LIB_RUBY_PARSER_{node_struct});
#define UNPACK_{node_struct}(blob) ((LIB_RUBY_PARSER_{node_struct}_BLOB_UNION){{.as_blob = blob}}).as_value
#define PACK_{node_struct}(value) ((LIB_RUBY_PARSER_{node_struct}_BLOB_UNION){{.as_value = value}}).as_blob",
        node_struct = node.camelcase_name
    )
}
fn message_blob(message: &lib_ruby_parser_nodes::Message) -> String {
    format!(
        "DECLARE_BLOB_FOR(LIB_RUBY_PARSER_{message_struct});
#define UNPACK_{message_struct}(blob) ((LIB_RUBY_PARSER_{message_struct}_BLOB_UNION){{.as_blob = blob}}).as_value
#define PACK_{message_struct}(value) ((LIB_RUBY_PARSER_{message_struct}_BLOB_UNION){{.as_value = value}}).as_blob",
        message_struct = message.camelcase_name
    )
}
