// This file is autogenerated by codegen/rust/visitor.rs

use crate::nodes::*;
use crate::traverse::visitor::{Item, Visit, Visitor};
use crate::Node;

/// Trait that must be implement to observe actions
/// that are performed by `Visitor` while it traverses given `Node`.
pub trait Observer {
    /// Invoked by a `Visitor` on entering into `Alias` node.
    #[allow(unused_variables)]
    fn on_alias(&mut self, node: &Alias) {}

    /// Invoked by a `Visitor` on entering into `AndAsgn` node.
    #[allow(unused_variables)]
    fn on_and_asgn(&mut self, node: &AndAsgn) {}

    /// Invoked by a `Visitor` on entering into `And` node.
    #[allow(unused_variables)]
    fn on_and(&mut self, node: &And) {}

    /// Invoked by a `Visitor` on entering into `Arg` node.
    #[allow(unused_variables)]
    fn on_arg(&mut self, node: &Arg) {}

    /// Invoked by a `Visitor` on entering into `Args` node.
    #[allow(unused_variables)]
    fn on_args(&mut self, node: &Args) {}

    /// Invoked by a `Visitor` on entering into `Array` node.
    #[allow(unused_variables)]
    fn on_array(&mut self, node: &Array) {}

    /// Invoked by a `Visitor` on entering into `ArrayPattern` node.
    #[allow(unused_variables)]
    fn on_array_pattern(&mut self, node: &ArrayPattern) {}

    /// Invoked by a `Visitor` on entering into `ArrayPatternWithTail` node.
    #[allow(unused_variables)]
    fn on_array_pattern_with_tail(&mut self, node: &ArrayPatternWithTail) {}

    /// Invoked by a `Visitor` on entering into `BackRef` node.
    #[allow(unused_variables)]
    fn on_back_ref(&mut self, node: &BackRef) {}

    /// Invoked by a `Visitor` on entering into `Begin` node.
    #[allow(unused_variables)]
    fn on_begin(&mut self, node: &Begin) {}

    /// Invoked by a `Visitor` on entering into `Block` node.
    #[allow(unused_variables)]
    fn on_block(&mut self, node: &Block) {}

    /// Invoked by a `Visitor` on entering into `BlockPass` node.
    #[allow(unused_variables)]
    fn on_block_pass(&mut self, node: &BlockPass) {}

    /// Invoked by a `Visitor` on entering into `Blockarg` node.
    #[allow(unused_variables)]
    fn on_blockarg(&mut self, node: &Blockarg) {}

    /// Invoked by a `Visitor` on entering into `Break` node.
    #[allow(unused_variables)]
    fn on_break(&mut self, node: &Break) {}

    /// Invoked by a `Visitor` on entering into `Case` node.
    #[allow(unused_variables)]
    fn on_case(&mut self, node: &Case) {}

    /// Invoked by a `Visitor` on entering into `CaseMatch` node.
    #[allow(unused_variables)]
    fn on_case_match(&mut self, node: &CaseMatch) {}

    /// Invoked by a `Visitor` on entering into `Casgn` node.
    #[allow(unused_variables)]
    fn on_casgn(&mut self, node: &Casgn) {}

    /// Invoked by a `Visitor` on entering into `Cbase` node.
    #[allow(unused_variables)]
    fn on_cbase(&mut self, node: &Cbase) {}

    /// Invoked by a `Visitor` on entering into `Class` node.
    #[allow(unused_variables)]
    fn on_class(&mut self, node: &Class) {}

    /// Invoked by a `Visitor` on entering into `Complex` node.
    #[allow(unused_variables)]
    fn on_complex(&mut self, node: &Complex) {}

    /// Invoked by a `Visitor` on entering into `Const` node.
    #[allow(unused_variables)]
    fn on_const(&mut self, node: &Const) {}

    /// Invoked by a `Visitor` on entering into `ConstPattern` node.
    #[allow(unused_variables)]
    fn on_const_pattern(&mut self, node: &ConstPattern) {}

    /// Invoked by a `Visitor` on entering into `CSend` node.
    #[allow(unused_variables)]
    fn on_c_send(&mut self, node: &CSend) {}

    /// Invoked by a `Visitor` on entering into `Cvar` node.
    #[allow(unused_variables)]
    fn on_cvar(&mut self, node: &Cvar) {}

    /// Invoked by a `Visitor` on entering into `Cvasgn` node.
    #[allow(unused_variables)]
    fn on_cvasgn(&mut self, node: &Cvasgn) {}

    /// Invoked by a `Visitor` on entering into `Def` node.
    #[allow(unused_variables)]
    fn on_def(&mut self, node: &Def) {}

    /// Invoked by a `Visitor` on entering into `Defined` node.
    #[allow(unused_variables)]
    fn on_defined(&mut self, node: &Defined) {}

    /// Invoked by a `Visitor` on entering into `Defs` node.
    #[allow(unused_variables)]
    fn on_defs(&mut self, node: &Defs) {}

    /// Invoked by a `Visitor` on entering into `Dstr` node.
    #[allow(unused_variables)]
    fn on_dstr(&mut self, node: &Dstr) {}

    /// Invoked by a `Visitor` on entering into `Dsym` node.
    #[allow(unused_variables)]
    fn on_dsym(&mut self, node: &Dsym) {}

    /// Invoked by a `Visitor` on entering into `EFlipFlop` node.
    #[allow(unused_variables)]
    fn on_e_flip_flop(&mut self, node: &EFlipFlop) {}

    /// Invoked by a `Visitor` on entering into `EmptyElse` node.
    #[allow(unused_variables)]
    fn on_empty_else(&mut self, node: &EmptyElse) {}

    /// Invoked by a `Visitor` on entering into `Encoding` node.
    #[allow(unused_variables)]
    fn on_encoding(&mut self, node: &Encoding) {}

    /// Invoked by a `Visitor` on entering into `Ensure` node.
    #[allow(unused_variables)]
    fn on_ensure(&mut self, node: &Ensure) {}

    /// Invoked by a `Visitor` on entering into `Erange` node.
    #[allow(unused_variables)]
    fn on_erange(&mut self, node: &Erange) {}

    /// Invoked by a `Visitor` on entering into `False` node.
    #[allow(unused_variables)]
    fn on_false(&mut self, node: &False) {}

    /// Invoked by a `Visitor` on entering into `File` node.
    #[allow(unused_variables)]
    fn on_file(&mut self, node: &File) {}

    /// Invoked by a `Visitor` on entering into `FindPattern` node.
    #[allow(unused_variables)]
    fn on_find_pattern(&mut self, node: &FindPattern) {}

    /// Invoked by a `Visitor` on entering into `Float` node.
    #[allow(unused_variables)]
    fn on_float(&mut self, node: &Float) {}

    /// Invoked by a `Visitor` on entering into `For` node.
    #[allow(unused_variables)]
    fn on_for(&mut self, node: &For) {}

    /// Invoked by a `Visitor` on entering into `ForwardArg` node.
    #[allow(unused_variables)]
    fn on_forward_arg(&mut self, node: &ForwardArg) {}

    /// Invoked by a `Visitor` on entering into `ForwardedArgs` node.
    #[allow(unused_variables)]
    fn on_forwarded_args(&mut self, node: &ForwardedArgs) {}

    /// Invoked by a `Visitor` on entering into `Gvar` node.
    #[allow(unused_variables)]
    fn on_gvar(&mut self, node: &Gvar) {}

    /// Invoked by a `Visitor` on entering into `Gvasgn` node.
    #[allow(unused_variables)]
    fn on_gvasgn(&mut self, node: &Gvasgn) {}

    /// Invoked by a `Visitor` on entering into `Hash` node.
    #[allow(unused_variables)]
    fn on_hash(&mut self, node: &Hash) {}

    /// Invoked by a `Visitor` on entering into `Kwargs` node.
    #[allow(unused_variables)]
    fn on_kwargs(&mut self, node: &Kwargs) {}

    /// Invoked by a `Visitor` on entering into `HashPattern` node.
    #[allow(unused_variables)]
    fn on_hash_pattern(&mut self, node: &HashPattern) {}

    /// Invoked by a `Visitor` on entering into `Heredoc` node.
    #[allow(unused_variables)]
    fn on_heredoc(&mut self, node: &Heredoc) {}

    /// Invoked by a `Visitor` on entering into `If` node.
    #[allow(unused_variables)]
    fn on_if(&mut self, node: &If) {}

    /// Invoked by a `Visitor` on entering into `IfGuard` node.
    #[allow(unused_variables)]
    fn on_if_guard(&mut self, node: &IfGuard) {}

    /// Invoked by a `Visitor` on entering into `IfMod` node.
    #[allow(unused_variables)]
    fn on_if_mod(&mut self, node: &IfMod) {}

    /// Invoked by a `Visitor` on entering into `IfTernary` node.
    #[allow(unused_variables)]
    fn on_if_ternary(&mut self, node: &IfTernary) {}

    /// Invoked by a `Visitor` on entering into `IFlipFlop` node.
    #[allow(unused_variables)]
    fn on_i_flip_flop(&mut self, node: &IFlipFlop) {}

    /// Invoked by a `Visitor` on entering into `MatchPattern` node.
    #[allow(unused_variables)]
    fn on_match_pattern(&mut self, node: &MatchPattern) {}

    /// Invoked by a `Visitor` on entering into `MatchPatternP` node.
    #[allow(unused_variables)]
    fn on_match_pattern_p(&mut self, node: &MatchPatternP) {}

    /// Invoked by a `Visitor` on entering into `InPattern` node.
    #[allow(unused_variables)]
    fn on_in_pattern(&mut self, node: &InPattern) {}

    /// Invoked by a `Visitor` on entering into `Index` node.
    #[allow(unused_variables)]
    fn on_index(&mut self, node: &Index) {}

    /// Invoked by a `Visitor` on entering into `IndexAsgn` node.
    #[allow(unused_variables)]
    fn on_index_asgn(&mut self, node: &IndexAsgn) {}

    /// Invoked by a `Visitor` on entering into `Int` node.
    #[allow(unused_variables)]
    fn on_int(&mut self, node: &Int) {}

    /// Invoked by a `Visitor` on entering into `Irange` node.
    #[allow(unused_variables)]
    fn on_irange(&mut self, node: &Irange) {}

    /// Invoked by a `Visitor` on entering into `Ivar` node.
    #[allow(unused_variables)]
    fn on_ivar(&mut self, node: &Ivar) {}

    /// Invoked by a `Visitor` on entering into `Ivasgn` node.
    #[allow(unused_variables)]
    fn on_ivasgn(&mut self, node: &Ivasgn) {}

    /// Invoked by a `Visitor` on entering into `Kwarg` node.
    #[allow(unused_variables)]
    fn on_kwarg(&mut self, node: &Kwarg) {}

    /// Invoked by a `Visitor` on entering into `KwBegin` node.
    #[allow(unused_variables)]
    fn on_kw_begin(&mut self, node: &KwBegin) {}

    /// Invoked by a `Visitor` on entering into `Kwnilarg` node.
    #[allow(unused_variables)]
    fn on_kwnilarg(&mut self, node: &Kwnilarg) {}

    /// Invoked by a `Visitor` on entering into `Kwoptarg` node.
    #[allow(unused_variables)]
    fn on_kwoptarg(&mut self, node: &Kwoptarg) {}

    /// Invoked by a `Visitor` on entering into `Kwrestarg` node.
    #[allow(unused_variables)]
    fn on_kwrestarg(&mut self, node: &Kwrestarg) {}

    /// Invoked by a `Visitor` on entering into `Kwsplat` node.
    #[allow(unused_variables)]
    fn on_kwsplat(&mut self, node: &Kwsplat) {}

    /// Invoked by a `Visitor` on entering into `Lambda` node.
    #[allow(unused_variables)]
    fn on_lambda(&mut self, node: &Lambda) {}

    /// Invoked by a `Visitor` on entering into `Line` node.
    #[allow(unused_variables)]
    fn on_line(&mut self, node: &Line) {}

    /// Invoked by a `Visitor` on entering into `Lvar` node.
    #[allow(unused_variables)]
    fn on_lvar(&mut self, node: &Lvar) {}

    /// Invoked by a `Visitor` on entering into `Lvasgn` node.
    #[allow(unused_variables)]
    fn on_lvasgn(&mut self, node: &Lvasgn) {}

    /// Invoked by a `Visitor` on entering into `Masgn` node.
    #[allow(unused_variables)]
    fn on_masgn(&mut self, node: &Masgn) {}

    /// Invoked by a `Visitor` on entering into `MatchAlt` node.
    #[allow(unused_variables)]
    fn on_match_alt(&mut self, node: &MatchAlt) {}

    /// Invoked by a `Visitor` on entering into `MatchAs` node.
    #[allow(unused_variables)]
    fn on_match_as(&mut self, node: &MatchAs) {}

    /// Invoked by a `Visitor` on entering into `MatchCurrentLine` node.
    #[allow(unused_variables)]
    fn on_match_current_line(&mut self, node: &MatchCurrentLine) {}

    /// Invoked by a `Visitor` on entering into `MatchNilPattern` node.
    #[allow(unused_variables)]
    fn on_match_nil_pattern(&mut self, node: &MatchNilPattern) {}

    /// Invoked by a `Visitor` on entering into `MatchRest` node.
    #[allow(unused_variables)]
    fn on_match_rest(&mut self, node: &MatchRest) {}

    /// Invoked by a `Visitor` on entering into `MatchVar` node.
    #[allow(unused_variables)]
    fn on_match_var(&mut self, node: &MatchVar) {}

    /// Invoked by a `Visitor` on entering into `MatchWithLvasgn` node.
    #[allow(unused_variables)]
    fn on_match_with_lvasgn(&mut self, node: &MatchWithLvasgn) {}

    /// Invoked by a `Visitor` on entering into `Mlhs` node.
    #[allow(unused_variables)]
    fn on_mlhs(&mut self, node: &Mlhs) {}

    /// Invoked by a `Visitor` on entering into `Module` node.
    #[allow(unused_variables)]
    fn on_module(&mut self, node: &Module) {}

    /// Invoked by a `Visitor` on entering into `Next` node.
    #[allow(unused_variables)]
    fn on_next(&mut self, node: &Next) {}

    /// Invoked by a `Visitor` on entering into `Nil` node.
    #[allow(unused_variables)]
    fn on_nil(&mut self, node: &Nil) {}

    /// Invoked by a `Visitor` on entering into `NthRef` node.
    #[allow(unused_variables)]
    fn on_nth_ref(&mut self, node: &NthRef) {}

    /// Invoked by a `Visitor` on entering into `Numblock` node.
    #[allow(unused_variables)]
    fn on_numblock(&mut self, node: &Numblock) {}

    /// Invoked by a `Visitor` on entering into `OpAsgn` node.
    #[allow(unused_variables)]
    fn on_op_asgn(&mut self, node: &OpAsgn) {}

    /// Invoked by a `Visitor` on entering into `Optarg` node.
    #[allow(unused_variables)]
    fn on_optarg(&mut self, node: &Optarg) {}

    /// Invoked by a `Visitor` on entering into `Or` node.
    #[allow(unused_variables)]
    fn on_or(&mut self, node: &Or) {}

    /// Invoked by a `Visitor` on entering into `OrAsgn` node.
    #[allow(unused_variables)]
    fn on_or_asgn(&mut self, node: &OrAsgn) {}

    /// Invoked by a `Visitor` on entering into `Pair` node.
    #[allow(unused_variables)]
    fn on_pair(&mut self, node: &Pair) {}

    /// Invoked by a `Visitor` on entering into `Pin` node.
    #[allow(unused_variables)]
    fn on_pin(&mut self, node: &Pin) {}

    /// Invoked by a `Visitor` on entering into `Postexe` node.
    #[allow(unused_variables)]
    fn on_postexe(&mut self, node: &Postexe) {}

    /// Invoked by a `Visitor` on entering into `Preexe` node.
    #[allow(unused_variables)]
    fn on_preexe(&mut self, node: &Preexe) {}

    /// Invoked by a `Visitor` on entering into `Procarg0` node.
    #[allow(unused_variables)]
    fn on_procarg0(&mut self, node: &Procarg0) {}

    /// Invoked by a `Visitor` on entering into `Rational` node.
    #[allow(unused_variables)]
    fn on_rational(&mut self, node: &Rational) {}

    /// Invoked by a `Visitor` on entering into `Redo` node.
    #[allow(unused_variables)]
    fn on_redo(&mut self, node: &Redo) {}

    /// Invoked by a `Visitor` on entering into `RegOpt` node.
    #[allow(unused_variables)]
    fn on_reg_opt(&mut self, node: &RegOpt) {}

    /// Invoked by a `Visitor` on entering into `Regexp` node.
    #[allow(unused_variables)]
    fn on_regexp(&mut self, node: &Regexp) {}

    /// Invoked by a `Visitor` on entering into `Rescue` node.
    #[allow(unused_variables)]
    fn on_rescue(&mut self, node: &Rescue) {}

    /// Invoked by a `Visitor` on entering into `RescueBody` node.
    #[allow(unused_variables)]
    fn on_rescue_body(&mut self, node: &RescueBody) {}

    /// Invoked by a `Visitor` on entering into `Restarg` node.
    #[allow(unused_variables)]
    fn on_restarg(&mut self, node: &Restarg) {}

    /// Invoked by a `Visitor` on entering into `Retry` node.
    #[allow(unused_variables)]
    fn on_retry(&mut self, node: &Retry) {}

    /// Invoked by a `Visitor` on entering into `Return` node.
    #[allow(unused_variables)]
    fn on_return(&mut self, node: &Return) {}

    /// Invoked by a `Visitor` on entering into `SClass` node.
    #[allow(unused_variables)]
    fn on_s_class(&mut self, node: &SClass) {}

    /// Invoked by a `Visitor` on entering into `Self_` node.
    #[allow(unused_variables)]
    fn on_self(&mut self, node: &Self_) {}

    /// Invoked by a `Visitor` on entering into `Send` node.
    #[allow(unused_variables)]
    fn on_send(&mut self, node: &Send) {}

    /// Invoked by a `Visitor` on entering into `Shadowarg` node.
    #[allow(unused_variables)]
    fn on_shadowarg(&mut self, node: &Shadowarg) {}

    /// Invoked by a `Visitor` on entering into `Splat` node.
    #[allow(unused_variables)]
    fn on_splat(&mut self, node: &Splat) {}

    /// Invoked by a `Visitor` on entering into `Str` node.
    #[allow(unused_variables)]
    fn on_str(&mut self, node: &Str) {}

    /// Invoked by a `Visitor` on entering into `Super` node.
    #[allow(unused_variables)]
    fn on_super(&mut self, node: &Super) {}

    /// Invoked by a `Visitor` on entering into `Sym` node.
    #[allow(unused_variables)]
    fn on_sym(&mut self, node: &Sym) {}

    /// Invoked by a `Visitor` on entering into `True` node.
    #[allow(unused_variables)]
    fn on_true(&mut self, node: &True) {}

    /// Invoked by a `Visitor` on entering into `Undef` node.
    #[allow(unused_variables)]
    fn on_undef(&mut self, node: &Undef) {}

    /// Invoked by a `Visitor` on entering into `UnlessGuard` node.
    #[allow(unused_variables)]
    fn on_unless_guard(&mut self, node: &UnlessGuard) {}

    /// Invoked by a `Visitor` on entering into `Until` node.
    #[allow(unused_variables)]
    fn on_until(&mut self, node: &Until) {}

    /// Invoked by a `Visitor` on entering into `UntilPost` node.
    #[allow(unused_variables)]
    fn on_until_post(&mut self, node: &UntilPost) {}

    /// Invoked by a `Visitor` on entering into `When` node.
    #[allow(unused_variables)]
    fn on_when(&mut self, node: &When) {}

    /// Invoked by a `Visitor` on entering into `While` node.
    #[allow(unused_variables)]
    fn on_while(&mut self, node: &While) {}

    /// Invoked by a `Visitor` on entering into `WhilePost` node.
    #[allow(unused_variables)]
    fn on_while_post(&mut self, node: &WhilePost) {}

    /// Invoked by a `Visitor` on entering into `XHeredoc` node.
    #[allow(unused_variables)]
    fn on_x_heredoc(&mut self, node: &XHeredoc) {}

    /// Invoked by a `Visitor` on entering into `Xstr` node.
    #[allow(unused_variables)]
    fn on_xstr(&mut self, node: &Xstr) {}

    /// Invoked by a `Visitor` on entering into `Yield` node.
    #[allow(unused_variables)]
    fn on_yield(&mut self, node: &Yield) {}

    /// Invoked by a `Visitor` on entering into `ZSuper` node.
    #[allow(unused_variables)]
    fn on_z_super(&mut self, node: &ZSuper) {}

    /// Caled when entering any `Node`
    #[allow(unused_variables)]
    fn on_node(&mut self, node: &Node) {}

    /// Called when exiting any `Node`
    #[allow(unused_variables)]
    fn on_node_moving_up(&mut self, node: &Node) {}

    /// Called when entering any optional `Node`
    #[allow(unused_variables)]
    fn on_option_node(&mut self, node: &Option<Box<Node>>) {}

    /// Called when entering any `Vec<Node>`
    #[allow(unused_variables)]
    fn on_node_list(&mut self, nodes: &[Node]) {}

    /// Called when entering any AST node,
    /// `subitem` is different for different `Node` fields,
    /// check documentation of `traverse::visitor::Item`
    #[allow(unused_variables)]
    fn on_subitem(&mut self, subitem: Item) {}

    /// Called when exiting any AST node,
    /// `subitem` is different for different `Node` fields,
    /// check documentation of `traverse::visitor::Item`
    #[allow(unused_variables)]
    fn on_subitem_moving_up(&mut self, subitem: Item) {}
}

impl<TObserver: Observer> Visit<&Node> for Visitor<TObserver> {
    fn visit(&mut self, node: &Node, visit_as: Item) {
        self.observer.on_subitem(visit_as);
        self.observer.on_node(node);

        if let Some(inner) = node.as_alias() {
            self.visit_alias(inner)
        }
        if let Some(inner) = node.as_and_asgn() {
            self.visit_and_asgn(inner)
        }
        if let Some(inner) = node.as_and() {
            self.visit_and(inner)
        }
        if let Some(inner) = node.as_arg() {
            self.visit_arg(inner)
        }
        if let Some(inner) = node.as_args() {
            self.visit_args(inner)
        }
        if let Some(inner) = node.as_array() {
            self.visit_array(inner)
        }
        if let Some(inner) = node.as_array_pattern() {
            self.visit_array_pattern(inner)
        }
        if let Some(inner) = node.as_array_pattern_with_tail() {
            self.visit_array_pattern_with_tail(inner)
        }
        if let Some(inner) = node.as_back_ref() {
            self.visit_back_ref(inner)
        }
        if let Some(inner) = node.as_begin() {
            self.visit_begin(inner)
        }
        if let Some(inner) = node.as_block() {
            self.visit_block(inner)
        }
        if let Some(inner) = node.as_block_pass() {
            self.visit_block_pass(inner)
        }
        if let Some(inner) = node.as_blockarg() {
            self.visit_blockarg(inner)
        }
        if let Some(inner) = node.as_break() {
            self.visit_break(inner)
        }
        if let Some(inner) = node.as_case() {
            self.visit_case(inner)
        }
        if let Some(inner) = node.as_case_match() {
            self.visit_case_match(inner)
        }
        if let Some(inner) = node.as_casgn() {
            self.visit_casgn(inner)
        }
        if let Some(inner) = node.as_cbase() {
            self.visit_cbase(inner)
        }
        if let Some(inner) = node.as_class() {
            self.visit_class(inner)
        }
        if let Some(inner) = node.as_complex() {
            self.visit_complex(inner)
        }
        if let Some(inner) = node.as_const() {
            self.visit_const(inner)
        }
        if let Some(inner) = node.as_const_pattern() {
            self.visit_const_pattern(inner)
        }
        if let Some(inner) = node.as_c_send() {
            self.visit_c_send(inner)
        }
        if let Some(inner) = node.as_cvar() {
            self.visit_cvar(inner)
        }
        if let Some(inner) = node.as_cvasgn() {
            self.visit_cvasgn(inner)
        }
        if let Some(inner) = node.as_def() {
            self.visit_def(inner)
        }
        if let Some(inner) = node.as_defined() {
            self.visit_defined(inner)
        }
        if let Some(inner) = node.as_defs() {
            self.visit_defs(inner)
        }
        if let Some(inner) = node.as_dstr() {
            self.visit_dstr(inner)
        }
        if let Some(inner) = node.as_dsym() {
            self.visit_dsym(inner)
        }
        if let Some(inner) = node.as_e_flip_flop() {
            self.visit_e_flip_flop(inner)
        }
        if let Some(inner) = node.as_empty_else() {
            self.visit_empty_else(inner)
        }
        if let Some(inner) = node.as_encoding() {
            self.visit_encoding(inner)
        }
        if let Some(inner) = node.as_ensure() {
            self.visit_ensure(inner)
        }
        if let Some(inner) = node.as_erange() {
            self.visit_erange(inner)
        }
        if let Some(inner) = node.as_false() {
            self.visit_false(inner)
        }
        if let Some(inner) = node.as_file() {
            self.visit_file(inner)
        }
        if let Some(inner) = node.as_find_pattern() {
            self.visit_find_pattern(inner)
        }
        if let Some(inner) = node.as_float() {
            self.visit_float(inner)
        }
        if let Some(inner) = node.as_for() {
            self.visit_for(inner)
        }
        if let Some(inner) = node.as_forward_arg() {
            self.visit_forward_arg(inner)
        }
        if let Some(inner) = node.as_forwarded_args() {
            self.visit_forwarded_args(inner)
        }
        if let Some(inner) = node.as_gvar() {
            self.visit_gvar(inner)
        }
        if let Some(inner) = node.as_gvasgn() {
            self.visit_gvasgn(inner)
        }
        if let Some(inner) = node.as_hash() {
            self.visit_hash(inner)
        }
        if let Some(inner) = node.as_kwargs() {
            self.visit_kwargs(inner)
        }
        if let Some(inner) = node.as_hash_pattern() {
            self.visit_hash_pattern(inner)
        }
        if let Some(inner) = node.as_heredoc() {
            self.visit_heredoc(inner)
        }
        if let Some(inner) = node.as_if() {
            self.visit_if(inner)
        }
        if let Some(inner) = node.as_if_guard() {
            self.visit_if_guard(inner)
        }
        if let Some(inner) = node.as_if_mod() {
            self.visit_if_mod(inner)
        }
        if let Some(inner) = node.as_if_ternary() {
            self.visit_if_ternary(inner)
        }
        if let Some(inner) = node.as_i_flip_flop() {
            self.visit_i_flip_flop(inner)
        }
        if let Some(inner) = node.as_match_pattern() {
            self.visit_match_pattern(inner)
        }
        if let Some(inner) = node.as_match_pattern_p() {
            self.visit_match_pattern_p(inner)
        }
        if let Some(inner) = node.as_in_pattern() {
            self.visit_in_pattern(inner)
        }
        if let Some(inner) = node.as_index() {
            self.visit_index(inner)
        }
        if let Some(inner) = node.as_index_asgn() {
            self.visit_index_asgn(inner)
        }
        if let Some(inner) = node.as_int() {
            self.visit_int(inner)
        }
        if let Some(inner) = node.as_irange() {
            self.visit_irange(inner)
        }
        if let Some(inner) = node.as_ivar() {
            self.visit_ivar(inner)
        }
        if let Some(inner) = node.as_ivasgn() {
            self.visit_ivasgn(inner)
        }
        if let Some(inner) = node.as_kwarg() {
            self.visit_kwarg(inner)
        }
        if let Some(inner) = node.as_kw_begin() {
            self.visit_kw_begin(inner)
        }
        if let Some(inner) = node.as_kwnilarg() {
            self.visit_kwnilarg(inner)
        }
        if let Some(inner) = node.as_kwoptarg() {
            self.visit_kwoptarg(inner)
        }
        if let Some(inner) = node.as_kwrestarg() {
            self.visit_kwrestarg(inner)
        }
        if let Some(inner) = node.as_kwsplat() {
            self.visit_kwsplat(inner)
        }
        if let Some(inner) = node.as_lambda() {
            self.visit_lambda(inner)
        }
        if let Some(inner) = node.as_line() {
            self.visit_line(inner)
        }
        if let Some(inner) = node.as_lvar() {
            self.visit_lvar(inner)
        }
        if let Some(inner) = node.as_lvasgn() {
            self.visit_lvasgn(inner)
        }
        if let Some(inner) = node.as_masgn() {
            self.visit_masgn(inner)
        }
        if let Some(inner) = node.as_match_alt() {
            self.visit_match_alt(inner)
        }
        if let Some(inner) = node.as_match_as() {
            self.visit_match_as(inner)
        }
        if let Some(inner) = node.as_match_current_line() {
            self.visit_match_current_line(inner)
        }
        if let Some(inner) = node.as_match_nil_pattern() {
            self.visit_match_nil_pattern(inner)
        }
        if let Some(inner) = node.as_match_rest() {
            self.visit_match_rest(inner)
        }
        if let Some(inner) = node.as_match_var() {
            self.visit_match_var(inner)
        }
        if let Some(inner) = node.as_match_with_lvasgn() {
            self.visit_match_with_lvasgn(inner)
        }
        if let Some(inner) = node.as_mlhs() {
            self.visit_mlhs(inner)
        }
        if let Some(inner) = node.as_module() {
            self.visit_module(inner)
        }
        if let Some(inner) = node.as_next() {
            self.visit_next(inner)
        }
        if let Some(inner) = node.as_nil() {
            self.visit_nil(inner)
        }
        if let Some(inner) = node.as_nth_ref() {
            self.visit_nth_ref(inner)
        }
        if let Some(inner) = node.as_numblock() {
            self.visit_numblock(inner)
        }
        if let Some(inner) = node.as_op_asgn() {
            self.visit_op_asgn(inner)
        }
        if let Some(inner) = node.as_optarg() {
            self.visit_optarg(inner)
        }
        if let Some(inner) = node.as_or() {
            self.visit_or(inner)
        }
        if let Some(inner) = node.as_or_asgn() {
            self.visit_or_asgn(inner)
        }
        if let Some(inner) = node.as_pair() {
            self.visit_pair(inner)
        }
        if let Some(inner) = node.as_pin() {
            self.visit_pin(inner)
        }
        if let Some(inner) = node.as_postexe() {
            self.visit_postexe(inner)
        }
        if let Some(inner) = node.as_preexe() {
            self.visit_preexe(inner)
        }
        if let Some(inner) = node.as_procarg0() {
            self.visit_procarg0(inner)
        }
        if let Some(inner) = node.as_rational() {
            self.visit_rational(inner)
        }
        if let Some(inner) = node.as_redo() {
            self.visit_redo(inner)
        }
        if let Some(inner) = node.as_reg_opt() {
            self.visit_reg_opt(inner)
        }
        if let Some(inner) = node.as_regexp() {
            self.visit_regexp(inner)
        }
        if let Some(inner) = node.as_rescue() {
            self.visit_rescue(inner)
        }
        if let Some(inner) = node.as_rescue_body() {
            self.visit_rescue_body(inner)
        }
        if let Some(inner) = node.as_restarg() {
            self.visit_restarg(inner)
        }
        if let Some(inner) = node.as_retry() {
            self.visit_retry(inner)
        }
        if let Some(inner) = node.as_return() {
            self.visit_return(inner)
        }
        if let Some(inner) = node.as_s_class() {
            self.visit_s_class(inner)
        }
        if let Some(inner) = node.as_self() {
            self.visit_self(inner)
        }
        if let Some(inner) = node.as_send() {
            self.visit_send(inner)
        }
        if let Some(inner) = node.as_shadowarg() {
            self.visit_shadowarg(inner)
        }
        if let Some(inner) = node.as_splat() {
            self.visit_splat(inner)
        }
        if let Some(inner) = node.as_str() {
            self.visit_str(inner)
        }
        if let Some(inner) = node.as_super() {
            self.visit_super(inner)
        }
        if let Some(inner) = node.as_sym() {
            self.visit_sym(inner)
        }
        if let Some(inner) = node.as_true() {
            self.visit_true(inner)
        }
        if let Some(inner) = node.as_undef() {
            self.visit_undef(inner)
        }
        if let Some(inner) = node.as_unless_guard() {
            self.visit_unless_guard(inner)
        }
        if let Some(inner) = node.as_until() {
            self.visit_until(inner)
        }
        if let Some(inner) = node.as_until_post() {
            self.visit_until_post(inner)
        }
        if let Some(inner) = node.as_when() {
            self.visit_when(inner)
        }
        if let Some(inner) = node.as_while() {
            self.visit_while(inner)
        }
        if let Some(inner) = node.as_while_post() {
            self.visit_while_post(inner)
        }
        if let Some(inner) = node.as_x_heredoc() {
            self.visit_x_heredoc(inner)
        }
        if let Some(inner) = node.as_xstr() {
            self.visit_xstr(inner)
        }
        if let Some(inner) = node.as_yield() {
            self.visit_yield(inner)
        }
        if let Some(inner) = node.as_z_super() {
            self.visit_z_super(inner)
        }

        self.observer.on_node_moving_up(&node);
        self.observer.on_subitem_moving_up(visit_as);
    }
}

impl<T> Visitor<T>
where
    T: Observer,
{
    fn visit_alias(&mut self, node: &Alias) {
        self.observer.on_alias(node);

        self.visit(node.get_to(), Item::To);
        self.visit(node.get_from(), Item::From);
    }

    fn visit_and_asgn(&mut self, node: &AndAsgn) {
        self.observer.on_and_asgn(node);

        self.visit(node.get_recv(), Item::Recv);
        self.visit(node.get_value(), Item::Value);
    }

    fn visit_and(&mut self, node: &And) {
        self.observer.on_and(node);

        self.visit(node.get_lhs(), Item::Lhs);
        self.visit(node.get_rhs(), Item::Rhs);
    }

    fn visit_arg(&mut self, node: &Arg) {
        self.observer.on_arg(node);

        
    }

    fn visit_args(&mut self, node: &Args) {
        self.observer.on_args(node);

        self.visit(node.get_args(), Item::Arglist);
    }

    fn visit_array(&mut self, node: &Array) {
        self.observer.on_array(node);

        self.visit(node.get_elements(), Item::Elements);
    }

    fn visit_array_pattern(&mut self, node: &ArrayPattern) {
        self.observer.on_array_pattern(node);

        self.visit(node.get_elements(), Item::Elements);
    }

    fn visit_array_pattern_with_tail(&mut self, node: &ArrayPatternWithTail) {
        self.observer.on_array_pattern_with_tail(node);

        self.visit(node.get_elements(), Item::Elements);
    }

    fn visit_back_ref(&mut self, node: &BackRef) {
        self.observer.on_back_ref(node);

        
    }

    fn visit_begin(&mut self, node: &Begin) {
        self.observer.on_begin(node);

        self.visit(node.get_statements(), Item::Stmts);
    }

    fn visit_block(&mut self, node: &Block) {
        self.observer.on_block(node);

        self.visit(node.get_call(), Item::MethodCall);
        self.visit(node.get_args(), Item::Args);
        self.visit(node.get_body(), Item::Body);
    }

    fn visit_block_pass(&mut self, node: &BlockPass) {
        self.observer.on_block_pass(node);

        self.visit(node.get_value(), Item::Value);
    }

    fn visit_blockarg(&mut self, node: &Blockarg) {
        self.observer.on_blockarg(node);

        
    }

    fn visit_break(&mut self, node: &Break) {
        self.observer.on_break(node);

        self.visit(node.get_args(), Item::Args);
    }

    fn visit_case(&mut self, node: &Case) {
        self.observer.on_case(node);

        self.visit(node.get_expr(), Item::Expr);
        self.visit(node.get_when_bodies(), Item::WhenBodies);
        self.visit(node.get_else_body(), Item::ElseBody);
    }

    fn visit_case_match(&mut self, node: &CaseMatch) {
        self.observer.on_case_match(node);

        self.visit(node.get_expr(), Item::Expr);
        self.visit(node.get_in_bodies(), Item::InBodies);
        self.visit(node.get_else_body(), Item::ElseBody);
    }

    fn visit_casgn(&mut self, node: &Casgn) {
        self.observer.on_casgn(node);

        self.visit(node.get_scope(), Item::Scope);
        self.visit(node.get_value(), Item::Value);
    }

    fn visit_cbase(&mut self, node: &Cbase) {
        self.observer.on_cbase(node);

        
    }

    fn visit_class(&mut self, node: &Class) {
        self.observer.on_class(node);

        self.visit(node.get_name(), Item::Name);
        self.visit(node.get_superclass(), Item::Superclass);
        self.visit(node.get_body(), Item::Body);
    }

    fn visit_complex(&mut self, node: &Complex) {
        self.observer.on_complex(node);

        
    }

    fn visit_const(&mut self, node: &Const) {
        self.observer.on_const(node);

        self.visit(node.get_scope(), Item::Scope);
    }

    fn visit_const_pattern(&mut self, node: &ConstPattern) {
        self.observer.on_const_pattern(node);

        self.visit(node.get_const(), Item::Const);
        self.visit(node.get_pattern(), Item::Pattern);
    }

    fn visit_c_send(&mut self, node: &CSend) {
        self.observer.on_c_send(node);

        self.visit(node.get_recv(), Item::Recv);
        self.visit(node.get_args(), Item::Args);
    }

    fn visit_cvar(&mut self, node: &Cvar) {
        self.observer.on_cvar(node);

        
    }

    fn visit_cvasgn(&mut self, node: &Cvasgn) {
        self.observer.on_cvasgn(node);

        self.visit(node.get_value(), Item::Value);
    }

    fn visit_def(&mut self, node: &Def) {
        self.observer.on_def(node);

        self.visit(node.get_args(), Item::Args);
        self.visit(node.get_body(), Item::Body);
    }

    fn visit_defined(&mut self, node: &Defined) {
        self.observer.on_defined(node);

        self.visit(node.get_value(), Item::Value);
    }

    fn visit_defs(&mut self, node: &Defs) {
        self.observer.on_defs(node);

        self.visit(node.get_definee(), Item::Definee);
        self.visit(node.get_args(), Item::Args);
        self.visit(node.get_body(), Item::Body);
    }

    fn visit_dstr(&mut self, node: &Dstr) {
        self.observer.on_dstr(node);

        self.visit(node.get_parts(), Item::Parts);
    }

    fn visit_dsym(&mut self, node: &Dsym) {
        self.observer.on_dsym(node);

        self.visit(node.get_parts(), Item::Parts);
    }

    fn visit_e_flip_flop(&mut self, node: &EFlipFlop) {
        self.observer.on_e_flip_flop(node);

        self.visit(node.get_left(), Item::Left);
        self.visit(node.get_right(), Item::Right);
    }

    fn visit_empty_else(&mut self, node: &EmptyElse) {
        self.observer.on_empty_else(node);

        
    }

    fn visit_encoding(&mut self, node: &Encoding) {
        self.observer.on_encoding(node);

        
    }

    fn visit_ensure(&mut self, node: &Ensure) {
        self.observer.on_ensure(node);

        self.visit(node.get_body(), Item::Body);
        self.visit(node.get_ensure(), Item::Ensure);
    }

    fn visit_erange(&mut self, node: &Erange) {
        self.observer.on_erange(node);

        self.visit(node.get_left(), Item::Left);
        self.visit(node.get_right(), Item::Right);
    }

    fn visit_false(&mut self, node: &False) {
        self.observer.on_false(node);

        
    }

    fn visit_file(&mut self, node: &File) {
        self.observer.on_file(node);

        
    }

    fn visit_find_pattern(&mut self, node: &FindPattern) {
        self.observer.on_find_pattern(node);

        self.visit(node.get_elements(), Item::Elements);
    }

    fn visit_float(&mut self, node: &Float) {
        self.observer.on_float(node);

        
    }

    fn visit_for(&mut self, node: &For) {
        self.observer.on_for(node);

        self.visit(node.get_iterator(), Item::Iterator);
        self.visit(node.get_iteratee(), Item::Iteratee);
        self.visit(node.get_body(), Item::Body);
    }

    fn visit_forward_arg(&mut self, node: &ForwardArg) {
        self.observer.on_forward_arg(node);

        
    }

    fn visit_forwarded_args(&mut self, node: &ForwardedArgs) {
        self.observer.on_forwarded_args(node);

        
    }

    fn visit_gvar(&mut self, node: &Gvar) {
        self.observer.on_gvar(node);

        
    }

    fn visit_gvasgn(&mut self, node: &Gvasgn) {
        self.observer.on_gvasgn(node);

        self.visit(node.get_value(), Item::Value);
    }

    fn visit_hash(&mut self, node: &Hash) {
        self.observer.on_hash(node);

        self.visit(node.get_pairs(), Item::Pairs);
    }

    fn visit_kwargs(&mut self, node: &Kwargs) {
        self.observer.on_kwargs(node);

        self.visit(node.get_pairs(), Item::Pairs);
    }

    fn visit_hash_pattern(&mut self, node: &HashPattern) {
        self.observer.on_hash_pattern(node);

        self.visit(node.get_elements(), Item::Elements);
    }

    fn visit_heredoc(&mut self, node: &Heredoc) {
        self.observer.on_heredoc(node);

        self.visit(node.get_parts(), Item::Parts);
    }

    fn visit_if(&mut self, node: &If) {
        self.observer.on_if(node);

        self.visit(node.get_cond(), Item::Cond);
        self.visit(node.get_if_true(), Item::IfTrue);
        self.visit(node.get_if_false(), Item::IfFalse);
    }

    fn visit_if_guard(&mut self, node: &IfGuard) {
        self.observer.on_if_guard(node);

        self.visit(node.get_cond(), Item::Cond);
    }

    fn visit_if_mod(&mut self, node: &IfMod) {
        self.observer.on_if_mod(node);

        self.visit(node.get_cond(), Item::Cond);
        self.visit(node.get_if_true(), Item::IfTrue);
        self.visit(node.get_if_false(), Item::IfFalse);
    }

    fn visit_if_ternary(&mut self, node: &IfTernary) {
        self.observer.on_if_ternary(node);

        self.visit(node.get_cond(), Item::Cond);
        self.visit(node.get_if_true(), Item::IfTrue);
        self.visit(node.get_if_false(), Item::IfFalse);
    }

    fn visit_i_flip_flop(&mut self, node: &IFlipFlop) {
        self.observer.on_i_flip_flop(node);

        self.visit(node.get_left(), Item::Left);
        self.visit(node.get_right(), Item::Right);
    }

    fn visit_match_pattern(&mut self, node: &MatchPattern) {
        self.observer.on_match_pattern(node);

        self.visit(node.get_value(), Item::Value);
        self.visit(node.get_pattern(), Item::Pattern);
    }

    fn visit_match_pattern_p(&mut self, node: &MatchPatternP) {
        self.observer.on_match_pattern_p(node);

        self.visit(node.get_value(), Item::Value);
        self.visit(node.get_pattern(), Item::Pattern);
    }

    fn visit_in_pattern(&mut self, node: &InPattern) {
        self.observer.on_in_pattern(node);

        self.visit(node.get_pattern(), Item::Pattern);
        self.visit(node.get_guard(), Item::Guard);
        self.visit(node.get_body(), Item::Body);
    }

    fn visit_index(&mut self, node: &Index) {
        self.observer.on_index(node);

        self.visit(node.get_recv(), Item::Recv);
        self.visit(node.get_indexes(), Item::Indexes);
    }

    fn visit_index_asgn(&mut self, node: &IndexAsgn) {
        self.observer.on_index_asgn(node);

        self.visit(node.get_recv(), Item::Recv);
        self.visit(node.get_indexes(), Item::Indexes);
        self.visit(node.get_value(), Item::Value);
    }

    fn visit_int(&mut self, node: &Int) {
        self.observer.on_int(node);

        
    }

    fn visit_irange(&mut self, node: &Irange) {
        self.observer.on_irange(node);

        self.visit(node.get_left(), Item::Left);
        self.visit(node.get_right(), Item::Right);
    }

    fn visit_ivar(&mut self, node: &Ivar) {
        self.observer.on_ivar(node);

        
    }

    fn visit_ivasgn(&mut self, node: &Ivasgn) {
        self.observer.on_ivasgn(node);

        self.visit(node.get_value(), Item::Value);
    }

    fn visit_kwarg(&mut self, node: &Kwarg) {
        self.observer.on_kwarg(node);

        
    }

    fn visit_kw_begin(&mut self, node: &KwBegin) {
        self.observer.on_kw_begin(node);

        self.visit(node.get_statements(), Item::Stmts);
    }

    fn visit_kwnilarg(&mut self, node: &Kwnilarg) {
        self.observer.on_kwnilarg(node);

        
    }

    fn visit_kwoptarg(&mut self, node: &Kwoptarg) {
        self.observer.on_kwoptarg(node);

        self.visit(node.get_default(), Item::DefaultValue);
    }

    fn visit_kwrestarg(&mut self, node: &Kwrestarg) {
        self.observer.on_kwrestarg(node);

        
    }

    fn visit_kwsplat(&mut self, node: &Kwsplat) {
        self.observer.on_kwsplat(node);

        self.visit(node.get_value(), Item::Value);
    }

    fn visit_lambda(&mut self, node: &Lambda) {
        self.observer.on_lambda(node);

        
    }

    fn visit_line(&mut self, node: &Line) {
        self.observer.on_line(node);

        
    }

    fn visit_lvar(&mut self, node: &Lvar) {
        self.observer.on_lvar(node);

        
    }

    fn visit_lvasgn(&mut self, node: &Lvasgn) {
        self.observer.on_lvasgn(node);

        self.visit(node.get_value(), Item::Value);
    }

    fn visit_masgn(&mut self, node: &Masgn) {
        self.observer.on_masgn(node);

        self.visit(node.get_lhs(), Item::Lhs);
        self.visit(node.get_rhs(), Item::Rhs);
    }

    fn visit_match_alt(&mut self, node: &MatchAlt) {
        self.observer.on_match_alt(node);

        self.visit(node.get_lhs(), Item::Lhs);
        self.visit(node.get_rhs(), Item::Rhs);
    }

    fn visit_match_as(&mut self, node: &MatchAs) {
        self.observer.on_match_as(node);

        self.visit(node.get_value(), Item::Value);
        self.visit(node.get_as(), Item::As);
    }

    fn visit_match_current_line(&mut self, node: &MatchCurrentLine) {
        self.observer.on_match_current_line(node);

        self.visit(node.get_re(), Item::Re);
    }

    fn visit_match_nil_pattern(&mut self, node: &MatchNilPattern) {
        self.observer.on_match_nil_pattern(node);

        
    }

    fn visit_match_rest(&mut self, node: &MatchRest) {
        self.observer.on_match_rest(node);

        self.visit(node.get_name(), Item::Name);
    }

    fn visit_match_var(&mut self, node: &MatchVar) {
        self.observer.on_match_var(node);

        
    }

    fn visit_match_with_lvasgn(&mut self, node: &MatchWithLvasgn) {
        self.observer.on_match_with_lvasgn(node);

        self.visit(node.get_re(), Item::Re);
        self.visit(node.get_value(), Item::Value);
    }

    fn visit_mlhs(&mut self, node: &Mlhs) {
        self.observer.on_mlhs(node);

        self.visit(node.get_items(), Item::MlhsItems);
    }

    fn visit_module(&mut self, node: &Module) {
        self.observer.on_module(node);

        self.visit(node.get_name(), Item::Name);
        self.visit(node.get_body(), Item::Body);
    }

    fn visit_next(&mut self, node: &Next) {
        self.observer.on_next(node);

        self.visit(node.get_args(), Item::Args);
    }

    fn visit_nil(&mut self, node: &Nil) {
        self.observer.on_nil(node);

        
    }

    fn visit_nth_ref(&mut self, node: &NthRef) {
        self.observer.on_nth_ref(node);

        
    }

    fn visit_numblock(&mut self, node: &Numblock) {
        self.observer.on_numblock(node);

        self.visit(node.get_call(), Item::MethodCall);
        self.visit(node.get_body(), Item::Body);
    }

    fn visit_op_asgn(&mut self, node: &OpAsgn) {
        self.observer.on_op_asgn(node);

        self.visit(node.get_recv(), Item::Recv);
        self.visit(node.get_value(), Item::Value);
    }

    fn visit_optarg(&mut self, node: &Optarg) {
        self.observer.on_optarg(node);

        self.visit(node.get_default(), Item::DefaultValue);
    }

    fn visit_or(&mut self, node: &Or) {
        self.observer.on_or(node);

        self.visit(node.get_lhs(), Item::Lhs);
        self.visit(node.get_rhs(), Item::Rhs);
    }

    fn visit_or_asgn(&mut self, node: &OrAsgn) {
        self.observer.on_or_asgn(node);

        self.visit(node.get_recv(), Item::Recv);
        self.visit(node.get_value(), Item::Value);
    }

    fn visit_pair(&mut self, node: &Pair) {
        self.observer.on_pair(node);

        self.visit(node.get_key(), Item::Key);
        self.visit(node.get_value(), Item::Value);
    }

    fn visit_pin(&mut self, node: &Pin) {
        self.observer.on_pin(node);

        self.visit(node.get_var(), Item::Var);
    }

    fn visit_postexe(&mut self, node: &Postexe) {
        self.observer.on_postexe(node);

        self.visit(node.get_body(), Item::Body);
    }

    fn visit_preexe(&mut self, node: &Preexe) {
        self.observer.on_preexe(node);

        self.visit(node.get_body(), Item::Body);
    }

    fn visit_procarg0(&mut self, node: &Procarg0) {
        self.observer.on_procarg0(node);

        self.visit(node.get_args(), Item::Arglist);
    }

    fn visit_rational(&mut self, node: &Rational) {
        self.observer.on_rational(node);

        
    }

    fn visit_redo(&mut self, node: &Redo) {
        self.observer.on_redo(node);

        
    }

    fn visit_reg_opt(&mut self, node: &RegOpt) {
        self.observer.on_reg_opt(node);

        
    }

    fn visit_regexp(&mut self, node: &Regexp) {
        self.observer.on_regexp(node);

        self.visit(node.get_parts(), Item::Parts);
        self.visit(node.get_options(), Item::Options);
    }

    fn visit_rescue(&mut self, node: &Rescue) {
        self.observer.on_rescue(node);

        self.visit(node.get_body(), Item::Body);
        self.visit(node.get_rescue_bodies(), Item::RescueBodies);
        self.visit(node.get_else(), Item::ElseBody);
    }

    fn visit_rescue_body(&mut self, node: &RescueBody) {
        self.observer.on_rescue_body(node);

        self.visit(node.get_exc_list(), Item::ExcList);
        self.visit(node.get_exc_var(), Item::ExcVar);
        self.visit(node.get_body(), Item::Body);
    }

    fn visit_restarg(&mut self, node: &Restarg) {
        self.observer.on_restarg(node);

        
    }

    fn visit_retry(&mut self, node: &Retry) {
        self.observer.on_retry(node);

        
    }

    fn visit_return(&mut self, node: &Return) {
        self.observer.on_return(node);

        self.visit(node.get_args(), Item::Args);
    }

    fn visit_s_class(&mut self, node: &SClass) {
        self.observer.on_s_class(node);

        self.visit(node.get_expr(), Item::Expr);
        self.visit(node.get_body(), Item::Body);
    }

    fn visit_self(&mut self, node: &Self_) {
        self.observer.on_self(node);

        
    }

    fn visit_send(&mut self, node: &Send) {
        self.observer.on_send(node);

        self.visit(node.get_recv(), Item::Recv);
        self.visit(node.get_args(), Item::Args);
    }

    fn visit_shadowarg(&mut self, node: &Shadowarg) {
        self.observer.on_shadowarg(node);

        
    }

    fn visit_splat(&mut self, node: &Splat) {
        self.observer.on_splat(node);

        self.visit(node.get_value(), Item::Value);
    }

    fn visit_str(&mut self, node: &Str) {
        self.observer.on_str(node);

        
    }

    fn visit_super(&mut self, node: &Super) {
        self.observer.on_super(node);

        self.visit(node.get_args(), Item::Args);
    }

    fn visit_sym(&mut self, node: &Sym) {
        self.observer.on_sym(node);

        
    }

    fn visit_true(&mut self, node: &True) {
        self.observer.on_true(node);

        
    }

    fn visit_undef(&mut self, node: &Undef) {
        self.observer.on_undef(node);

        self.visit(node.get_names(), Item::Args);
    }

    fn visit_unless_guard(&mut self, node: &UnlessGuard) {
        self.observer.on_unless_guard(node);

        self.visit(node.get_cond(), Item::Cond);
    }

    fn visit_until(&mut self, node: &Until) {
        self.observer.on_until(node);

        self.visit(node.get_cond(), Item::Cond);
        self.visit(node.get_body(), Item::Body);
    }

    fn visit_until_post(&mut self, node: &UntilPost) {
        self.observer.on_until_post(node);

        self.visit(node.get_cond(), Item::Cond);
        self.visit(node.get_body(), Item::Body);
    }

    fn visit_when(&mut self, node: &When) {
        self.observer.on_when(node);

        self.visit(node.get_patterns(), Item::Args);
        self.visit(node.get_body(), Item::Body);
    }

    fn visit_while(&mut self, node: &While) {
        self.observer.on_while(node);

        self.visit(node.get_cond(), Item::Cond);
        self.visit(node.get_body(), Item::Body);
    }

    fn visit_while_post(&mut self, node: &WhilePost) {
        self.observer.on_while_post(node);

        self.visit(node.get_cond(), Item::Cond);
        self.visit(node.get_body(), Item::Body);
    }

    fn visit_x_heredoc(&mut self, node: &XHeredoc) {
        self.observer.on_x_heredoc(node);

        self.visit(node.get_parts(), Item::Parts);
    }

    fn visit_xstr(&mut self, node: &Xstr) {
        self.observer.on_xstr(node);

        self.visit(node.get_parts(), Item::Parts);
    }

    fn visit_yield(&mut self, node: &Yield) {
        self.observer.on_yield(node);

        self.visit(node.get_args(), Item::Args);
    }

    fn visit_z_super(&mut self, node: &ZSuper) {
        self.observer.on_z_super(node);

        
    }
}
