// This file is autogenerated by codegen/rust/nodes/node_file/external.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;
use crate::containers::ExternalPtr as Ptr;

use super::internal::InternalWhilePost;
use crate::blobs::{HasBlob, Blob};

/// Represents a post-while loop
///
/// ```text
/// begin
/// foo
/// end while bar
/// ```
#[repr(C)]
pub struct WhilePost {
    pub(crate) blob: Blob<WhilePost>
}

impl std::fmt::Debug for WhilePost {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        f.debug_struct("WhilePost")
            .field("cond", &self.get_cond())
            .field("body", &self.get_body())
            .field("keyword_l", &self.get_keyword_l())
            .field("expression_l", &self.get_expression_l())
            .finish()
    }
}

impl PartialEq for WhilePost {
    fn eq(&self, other: &Self) -> bool {
        self.get_cond() == other.get_cond()
            && self.get_body() == other.get_body()
            && self.get_keyword_l() == other.get_keyword_l()
            && self.get_expression_l() == other.get_expression_l()
    }
}

impl WhilePost {
    /// Returns `cond` field
    pub fn get_cond(&self) -> &Ptr<Node> {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__while_post__get_cond(&self.blob) as *const Ptr<Node>)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `cond` field
    pub fn set_cond(&mut self, cond: Ptr<Node>) {
        unsafe { lib_ruby_parser__external__nodes__while_post__set_cond(&mut self.blob, cond.into_blob()) }
    }

    /// Returns `body` field
    pub fn get_body(&self) -> &Ptr<Node> {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__while_post__get_body(&self.blob) as *const Ptr<Node>)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `body` field
    pub fn set_body(&mut self, body: Ptr<Node>) {
        unsafe { lib_ruby_parser__external__nodes__while_post__set_body(&mut self.blob, body.into_blob()) }
    }

    /// Returns `keyword_l` field
    pub fn get_keyword_l(&self) -> &Loc {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__while_post__get_keyword_l(&self.blob) as *const Loc)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `keyword_l` field
    pub fn set_keyword_l(&mut self, keyword_l: Loc) {
        unsafe { lib_ruby_parser__external__nodes__while_post__set_keyword_l(&mut self.blob, keyword_l.into_blob()) }
    }

    /// Returns `expression_l` field
    pub fn get_expression_l(&self) -> &Loc {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__while_post__get_expression_l(&self.blob) as *const Loc)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `expression_l` field
    pub fn set_expression_l(&mut self, expression_l: Loc) {
        unsafe { lib_ruby_parser__external__nodes__while_post__set_expression_l(&mut self.blob, expression_l.into_blob()) }
    }

    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> InternalWhilePost {
        let internal = unsafe { lib_ruby_parser__external__nodes__while_post__into_internal(self.blob) };
        std::mem::forget(self);
        internal
    }
}

extern "C" {
    fn lib_ruby_parser__external__nodes__while_post__get_cond(blob: *const Blob<WhilePost>) -> *mut Blob<Ptr<Node>>;
    fn lib_ruby_parser__external__nodes__while_post__set_cond(blob: *mut Blob<WhilePost>, blob: Blob<Ptr<Node>>);
    fn lib_ruby_parser__external__nodes__while_post__get_body(blob: *const Blob<WhilePost>) -> *mut Blob<Ptr<Node>>;
    fn lib_ruby_parser__external__nodes__while_post__set_body(blob: *mut Blob<WhilePost>, blob: Blob<Ptr<Node>>);
    fn lib_ruby_parser__external__nodes__while_post__get_keyword_l(blob: *const Blob<WhilePost>) -> *mut Blob<Loc>;
    fn lib_ruby_parser__external__nodes__while_post__set_keyword_l(blob: *mut Blob<WhilePost>, blob: Blob<Loc>);
    fn lib_ruby_parser__external__nodes__while_post__get_expression_l(blob: *const Blob<WhilePost>) -> *mut Blob<Loc>;
    fn lib_ruby_parser__external__nodes__while_post__set_expression_l(blob: *mut Blob<WhilePost>, blob: Blob<Loc>);
    fn lib_ruby_parser__external__nodes__while_post__into_internal(blob: Blob<WhilePost>) -> InternalWhilePost;
    fn lib_ruby_parser__external__nodes__while_post__drop(blob: *mut Blob<WhilePost>);
}

impl InnerNode for WhilePost {
    fn expression(&self) -> &Loc {
        self.get_expression_l()
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_node(self.get_cond());
        result.push_node(self.get_body());
        
        
        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "while_post"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        self.get_cond().inner_ref().print_with_locs();
        self.get_body().inner_ref().print_with_locs();
        self.get_keyword_l().print("keyword");
        self.get_expression_l().print("expression");
    }
}

impl Drop for WhilePost {
    fn drop(&mut self) {
        unsafe { lib_ruby_parser__external__nodes__while_post__drop(&mut self.blob) }
    }
}
