// This file is autogenerated by codegen/rust/nodes/node_file/native.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;

/// Represents an `unless` guard used in pattern matching (i.e. `in pattern unless guard`)
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct UnlessGuard {
    /// Condition of the guard, `Lvar("foo")` in `in pattern unless guard`
    pub cond: Box<Node>,

    /// Location of the `unless` keyword
    ///
    /// ```text
    /// case foo; in pattern unless cond; end
    ///                      ~~~~~~
    /// ```
    pub keyword_l: Loc,

    /// Location of the full expression
    ///
    /// ```text
    /// case foo; in pattern unless cond; end
    ///                      ~~~~~~~~~~~
    /// ```
    pub expression_l: Loc,
}

impl UnlessGuard {
    #[doc(hidden)]
    pub fn get_cond(&self) -> &Box<Node> {
        &self.cond
    }

    #[doc(hidden)]
    pub fn get_cond_mut(&mut self) -> &mut Box<Node> {
        &mut self.cond
    }

    #[doc(hidden)]
    pub fn get_keyword_l(&self) -> &Loc {
        &self.keyword_l
    }

    #[doc(hidden)]
    pub fn get_keyword_l_mut(&mut self) -> &mut Loc {
        &mut self.keyword_l
    }

    #[doc(hidden)]
    pub fn get_expression_l(&self) -> &Loc {
        &self.expression_l
    }

    #[doc(hidden)]
    pub fn get_expression_l_mut(&mut self) -> &mut Loc {
        &mut self.expression_l
    }

    #[doc(hidden)]
    pub fn set_cond(&mut self, value: Box<Node>) {
        self.cond = value;
    }

    #[doc(hidden)]
    pub fn set_keyword_l(&mut self, value: Loc) {
        self.keyword_l = value;
    }

    #[doc(hidden)]
    pub fn set_expression_l(&mut self, value: Loc) {
        self.expression_l = value;
    }

    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> super::InternalUnlessGuard {
        let Self { cond, keyword_l, expression_l } = self;
        super::InternalUnlessGuard { cond, keyword_l, expression_l }
    }
}

impl InnerNode for UnlessGuard {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_node(&self.cond);
        
        
        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "unless_guard"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        self.cond.inner_ref().print_with_locs();
        self.keyword_l.print("keyword");
        self.expression_l.print("expression");
    }
}
