// This file is autogenerated by codegen/rust/nodes/node_file/native.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;

/// Represents an arguments splat (i.e. `*bar` in a call like `foo(*bar)`)
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct Splat {
    /// Value that is converted to array
    pub value: Option<Box<Node>>,

    /// Location of the `*` operator
    ///
    /// ```text
    /// foo(*bar)
    ///     ~
    /// ```
    pub operator_l: Loc,

    /// Location of the full expression
    ///
    /// ```text
    /// foo(*bar)
    ///     ~~~~
    /// ```
    pub expression_l: Loc,
}

impl Splat {
    #[doc(hidden)]
    pub fn get_value(&self) -> &Option<Box<Node>> {
        &self.value
    }

    #[doc(hidden)]
    pub fn get_value_mut(&mut self) -> &mut Option<Box<Node>> {
        &mut self.value
    }

    #[doc(hidden)]
    pub fn get_operator_l(&self) -> &Loc {
        &self.operator_l
    }

    #[doc(hidden)]
    pub fn get_operator_l_mut(&mut self) -> &mut Loc {
        &mut self.operator_l
    }

    #[doc(hidden)]
    pub fn get_expression_l(&self) -> &Loc {
        &self.expression_l
    }

    #[doc(hidden)]
    pub fn get_expression_l_mut(&mut self) -> &mut Loc {
        &mut self.expression_l
    }

    #[doc(hidden)]
    pub fn set_value(&mut self, value: Option<Box<Node>>) {
        self.value = value;
    }

    #[doc(hidden)]
    pub fn set_operator_l(&mut self, value: Loc) {
        self.operator_l = value;
    }

    #[doc(hidden)]
    pub fn set_expression_l(&mut self, value: Loc) {
        self.expression_l = value;
    }

    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> super::InternalSplat {
        let Self { value, operator_l, expression_l } = self;
        super::InternalSplat { value, operator_l, expression_l }
    }
}

impl InnerNode for Splat {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_maybe_node(&self.value);
        
        
        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "splat"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        self.value.as_ref().map(|node| node.inner_ref().print_with_locs());
        self.operator_l.print("operator");
        self.expression_l.print("expression");
    }
}
