// This file is autogenerated by codegen/rust/nodes/node_file/native.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;

/// Represents a special block argument that "shadows" outer variable (i.e. `|;foo|`)
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct Shadowarg {
    /// Name of the argument
    pub name: String,

    /// Location of the argument
    ///
    /// ```text
    /// proc { |;foo|}
    ///          ~~~
    /// ```
    pub expression_l: Loc,
}

impl Shadowarg {
    #[doc(hidden)]
    pub fn get_name(&self) -> &String {
        &self.name
    }

    #[doc(hidden)]
    pub fn get_name_mut(&mut self) -> &mut String {
        &mut self.name
    }

    #[doc(hidden)]
    pub fn get_expression_l(&self) -> &Loc {
        &self.expression_l
    }

    #[doc(hidden)]
    pub fn get_expression_l_mut(&mut self) -> &mut Loc {
        &mut self.expression_l
    }

    #[doc(hidden)]
    pub fn set_name(&mut self, value: String) {
        self.name = value;
    }

    #[doc(hidden)]
    pub fn set_expression_l(&mut self, value: Loc) {
        self.expression_l = value;
    }

    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> super::InternalShadowarg {
        let Self { name, expression_l } = self;
        super::InternalShadowarg { name, expression_l }
    }
}

impl InnerNode for Shadowarg {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_str(&self.name);
        
        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "shadowarg"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        self.expression_l.print("expression");
    }
}
