// This file is autogenerated by codegen/rust/nodes/node_file/external.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::containers::ExternalStringPtr as StringPtr;

use super::internal::InternalShadowarg;
use crate::blobs::{HasBlob, Blob};

/// Represents a special block argument that "shadows" outer variable (i.e. `|;foo|`)
#[repr(C)]
pub struct Shadowarg {
    pub(crate) blob: Blob<Shadowarg>
}

impl std::fmt::Debug for Shadowarg {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        f.debug_struct("Shadowarg")
            .field("name", &self.get_name())
            .field("expression_l", &self.get_expression_l())
            .finish()
    }
}

impl PartialEq for Shadowarg {
    fn eq(&self, other: &Self) -> bool {
        self.get_name() == other.get_name()
            && self.get_expression_l() == other.get_expression_l()
    }
}

impl Shadowarg {
    /// Returns `name` field
    pub fn get_name(&self) -> &StringPtr {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__shadowarg__get_name(&self.blob) as *const StringPtr)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `name` field
    pub fn set_name(&mut self, name: StringPtr) {
        unsafe { lib_ruby_parser__external__nodes__shadowarg__set_name(&mut self.blob, name.into_blob()) }
    }

    /// Returns `expression_l` field
    pub fn get_expression_l(&self) -> &Loc {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__shadowarg__get_expression_l(&self.blob) as *const Loc)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `expression_l` field
    pub fn set_expression_l(&mut self, expression_l: Loc) {
        unsafe { lib_ruby_parser__external__nodes__shadowarg__set_expression_l(&mut self.blob, expression_l.into_blob()) }
    }

    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> InternalShadowarg {
        let internal = unsafe { lib_ruby_parser__external__nodes__shadowarg__into_internal(self.blob) };
        std::mem::forget(self);
        internal
    }
}

extern "C" {
    fn lib_ruby_parser__external__nodes__shadowarg__get_name(blob: *const Blob<Shadowarg>) -> *mut Blob<StringPtr>;
    fn lib_ruby_parser__external__nodes__shadowarg__set_name(blob: *mut Blob<Shadowarg>, blob: Blob<StringPtr>);
    fn lib_ruby_parser__external__nodes__shadowarg__get_expression_l(blob: *const Blob<Shadowarg>) -> *mut Blob<Loc>;
    fn lib_ruby_parser__external__nodes__shadowarg__set_expression_l(blob: *mut Blob<Shadowarg>, blob: Blob<Loc>);
    fn lib_ruby_parser__external__nodes__shadowarg__into_internal(blob: Blob<Shadowarg>) -> InternalShadowarg;
    fn lib_ruby_parser__external__nodes__shadowarg__drop(blob: *mut Blob<Shadowarg>);
}

impl InnerNode for Shadowarg {
    fn expression(&self) -> &Loc {
        self.get_expression_l()
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_str(self.get_name());
        
        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "shadowarg"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        self.get_expression_l().print("expression");
    }
}

impl Drop for Shadowarg {
    fn drop(&mut self) {
        unsafe { lib_ruby_parser__external__nodes__shadowarg__drop(&mut self.blob) }
    }
}
