// This file is autogenerated by codegen/rust/nodes/node_file/native.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;

/// Represents a method call (e.g. `foo.bar(42)`)
#[derive(Debug, Clone, PartialEq)]
#[repr(C)]
pub struct Send {
    /// Receiver of the method call
    ///
    /// `None` for implicit method call (e.g. `foo(42)`)
    pub recv: Option<Box<Node>>,

    /// Name of the method that is called
    pub method_name: String,

    /// A list of arguments
    pub args: Vec<Node>,

    /// Location of the `.` operator
    ///
    /// ```text
    /// foo.bar(42)
    ///    ~
    /// ```
    ///
    /// `None` for implicit method call (e.g. `foo(42)`)
    pub dot_l: Option<Loc>,

    /// Location of the method name
    ///
    /// ```text
    /// foo.bar(42)
    ///     ~~~
    /// ```
    ///
    /// `None` in a very special case when method call is implicit (i.e. `foo.(42)`)
    pub selector_l: Option<Loc>,

    /// Location of open parenthesis
    ///
    /// ```text
    /// foo(42)
    ///    ~
    /// ```
    ///
    /// `None` if there are no parentheses
    pub begin_l: Option<Loc>,

    /// Location of closing parenthesis
    ///
    /// ```text
    /// foo(42)
    ///       ~
    /// ```
    ///
    /// `None` if there are no parentheses
    pub end_l: Option<Loc>,

    /// Location of the operator if method is a setter
    ///
    /// ```text
    /// foo.bar = 42
    ///         ~
    /// ```
    ///
    /// `None` otherwise
    pub operator_l: Option<Loc>,

    /// Location of the full expression
    ///
    /// ```text
    /// foo.bar(42)
    /// ~~~~~~~~~~~
    /// ```
    pub expression_l: Loc,
}

impl Send {
    #[doc(hidden)]
    pub fn get_recv(&self) -> &Option<Box<Node>> {
        &self.recv
    }

    #[doc(hidden)]
    pub fn get_recv_mut(&mut self) -> &mut Option<Box<Node>> {
        &mut self.recv
    }

    #[doc(hidden)]
    pub fn get_method_name(&self) -> &String {
        &self.method_name
    }

    #[doc(hidden)]
    pub fn get_method_name_mut(&mut self) -> &mut String {
        &mut self.method_name
    }

    #[doc(hidden)]
    pub fn get_args(&self) -> &Vec<Node> {
        &self.args
    }

    #[doc(hidden)]
    pub fn get_args_mut(&mut self) -> &mut Vec<Node> {
        &mut self.args
    }

    #[doc(hidden)]
    pub fn get_dot_l(&self) -> &Option<Loc> {
        &self.dot_l
    }

    #[doc(hidden)]
    pub fn get_dot_l_mut(&mut self) -> &mut Option<Loc> {
        &mut self.dot_l
    }

    #[doc(hidden)]
    pub fn get_selector_l(&self) -> &Option<Loc> {
        &self.selector_l
    }

    #[doc(hidden)]
    pub fn get_selector_l_mut(&mut self) -> &mut Option<Loc> {
        &mut self.selector_l
    }

    #[doc(hidden)]
    pub fn get_begin_l(&self) -> &Option<Loc> {
        &self.begin_l
    }

    #[doc(hidden)]
    pub fn get_begin_l_mut(&mut self) -> &mut Option<Loc> {
        &mut self.begin_l
    }

    #[doc(hidden)]
    pub fn get_end_l(&self) -> &Option<Loc> {
        &self.end_l
    }

    #[doc(hidden)]
    pub fn get_end_l_mut(&mut self) -> &mut Option<Loc> {
        &mut self.end_l
    }

    #[doc(hidden)]
    pub fn get_operator_l(&self) -> &Option<Loc> {
        &self.operator_l
    }

    #[doc(hidden)]
    pub fn get_operator_l_mut(&mut self) -> &mut Option<Loc> {
        &mut self.operator_l
    }

    #[doc(hidden)]
    pub fn get_expression_l(&self) -> &Loc {
        &self.expression_l
    }

    #[doc(hidden)]
    pub fn get_expression_l_mut(&mut self) -> &mut Loc {
        &mut self.expression_l
    }

    #[doc(hidden)]
    pub fn set_recv(&mut self, value: Option<Box<Node>>) {
        self.recv = value;
    }

    #[doc(hidden)]
    pub fn set_method_name(&mut self, value: String) {
        self.method_name = value;
    }

    #[doc(hidden)]
    pub fn set_args(&mut self, value: Vec<Node>) {
        self.args = value;
    }

    #[doc(hidden)]
    pub fn set_dot_l(&mut self, value: Option<Loc>) {
        self.dot_l = value;
    }

    #[doc(hidden)]
    pub fn set_selector_l(&mut self, value: Option<Loc>) {
        self.selector_l = value;
    }

    #[doc(hidden)]
    pub fn set_begin_l(&mut self, value: Option<Loc>) {
        self.begin_l = value;
    }

    #[doc(hidden)]
    pub fn set_end_l(&mut self, value: Option<Loc>) {
        self.end_l = value;
    }

    #[doc(hidden)]
    pub fn set_operator_l(&mut self, value: Option<Loc>) {
        self.operator_l = value;
    }

    #[doc(hidden)]
    pub fn set_expression_l(&mut self, value: Loc) {
        self.expression_l = value;
    }

    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> super::InternalSend {
        let Self { recv, method_name, args, dot_l, selector_l, begin_l, end_l, operator_l, expression_l } = self;
        super::InternalSend { recv, method_name, args, dot_l, selector_l, begin_l, end_l, operator_l, expression_l }
    }
}

impl InnerNode for Send {
    fn expression(&self) -> &Loc {
        &self.expression_l
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_maybe_node_or_nil(&self.recv);
        result.push_str(&self.method_name);
        result.push_nodes(&self.args);
        
        
        
        
        
        
        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "send"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        self.recv.as_ref().map(|node| node.inner_ref().print_with_locs());
        for node in self.args.iter() {
          node.inner_ref().print_with_locs();
        }
        self.dot_l.as_ref().map(|loc| loc.print("dot"));
        self.selector_l.as_ref().map(|loc| loc.print("selector"));
        self.begin_l.as_ref().map(|loc| loc.print("begin"));
        self.end_l.as_ref().map(|loc| loc.print("end"));
        self.operator_l.as_ref().map(|loc| loc.print("operator"));
        self.expression_l.print("expression");
    }
}
