// This file is autogenerated by codegen/rust/nodes/node_file/external.rs

use crate::nodes::InnerNode;
use crate::nodes::InspectVec;
use crate::Loc;
use crate::Node;
use crate::containers::ExternalMaybePtr as MaybePtr;
use crate::containers::ExternalList as List;
use crate::containers::ExternalMaybeLoc as MaybeLoc;
use crate::containers::ExternalStringPtr as StringPtr;

use super::internal::InternalSend;
use crate::blobs::{HasBlob, Blob};

/// Represents a method call (e.g. `foo.bar(42)`)
#[repr(C)]
pub struct Send {
    pub(crate) blob: Blob<Send>
}

impl std::fmt::Debug for Send {
    fn fmt(&self, f: &mut std::fmt::Formatter<'_>) -> std::fmt::Result {
        f.debug_struct("Send")
            .field("recv", &self.get_recv())
            .field("method_name", &self.get_method_name())
            .field("args", &self.get_args())
            .field("dot_l", &self.get_dot_l())
            .field("selector_l", &self.get_selector_l())
            .field("begin_l", &self.get_begin_l())
            .field("end_l", &self.get_end_l())
            .field("operator_l", &self.get_operator_l())
            .field("expression_l", &self.get_expression_l())
            .finish()
    }
}

impl PartialEq for Send {
    fn eq(&self, other: &Self) -> bool {
        self.get_recv() == other.get_recv()
            && self.get_method_name() == other.get_method_name()
            && self.get_args() == other.get_args()
            && self.get_dot_l() == other.get_dot_l()
            && self.get_selector_l() == other.get_selector_l()
            && self.get_begin_l() == other.get_begin_l()
            && self.get_end_l() == other.get_end_l()
            && self.get_operator_l() == other.get_operator_l()
            && self.get_expression_l() == other.get_expression_l()
    }
}

impl Send {
    /// Returns `recv` field
    pub fn get_recv(&self) -> &MaybePtr<Node> {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__send__get_recv(&self.blob) as *const MaybePtr<Node>)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `recv` field
    pub fn set_recv(&mut self, recv: MaybePtr<Node>) {
        unsafe { lib_ruby_parser__external__nodes__send__set_recv(&mut self.blob, recv.into_blob()) }
    }

    /// Returns `method_name` field
    pub fn get_method_name(&self) -> &StringPtr {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__send__get_method_name(&self.blob) as *const StringPtr)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `method_name` field
    pub fn set_method_name(&mut self, method_name: StringPtr) {
        unsafe { lib_ruby_parser__external__nodes__send__set_method_name(&mut self.blob, method_name.into_blob()) }
    }

    /// Returns `args` field
    pub fn get_args(&self) -> &List<Node> {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__send__get_args(&self.blob) as *const List<Node>)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `args` field
    pub fn set_args(&mut self, args: List<Node>) {
        unsafe { lib_ruby_parser__external__nodes__send__set_args(&mut self.blob, args.into_blob()) }
    }

    /// Returns `dot_l` field
    pub fn get_dot_l(&self) -> &MaybeLoc {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__send__get_dot_l(&self.blob) as *const MaybeLoc)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `dot_l` field
    pub fn set_dot_l(&mut self, dot_l: MaybeLoc) {
        unsafe { lib_ruby_parser__external__nodes__send__set_dot_l(&mut self.blob, dot_l.into_blob()) }
    }

    /// Returns `selector_l` field
    pub fn get_selector_l(&self) -> &MaybeLoc {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__send__get_selector_l(&self.blob) as *const MaybeLoc)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `selector_l` field
    pub fn set_selector_l(&mut self, selector_l: MaybeLoc) {
        unsafe { lib_ruby_parser__external__nodes__send__set_selector_l(&mut self.blob, selector_l.into_blob()) }
    }

    /// Returns `begin_l` field
    pub fn get_begin_l(&self) -> &MaybeLoc {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__send__get_begin_l(&self.blob) as *const MaybeLoc)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `begin_l` field
    pub fn set_begin_l(&mut self, begin_l: MaybeLoc) {
        unsafe { lib_ruby_parser__external__nodes__send__set_begin_l(&mut self.blob, begin_l.into_blob()) }
    }

    /// Returns `end_l` field
    pub fn get_end_l(&self) -> &MaybeLoc {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__send__get_end_l(&self.blob) as *const MaybeLoc)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `end_l` field
    pub fn set_end_l(&mut self, end_l: MaybeLoc) {
        unsafe { lib_ruby_parser__external__nodes__send__set_end_l(&mut self.blob, end_l.into_blob()) }
    }

    /// Returns `operator_l` field
    pub fn get_operator_l(&self) -> &MaybeLoc {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__send__get_operator_l(&self.blob) as *const MaybeLoc)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `operator_l` field
    pub fn set_operator_l(&mut self, operator_l: MaybeLoc) {
        unsafe { lib_ruby_parser__external__nodes__send__set_operator_l(&mut self.blob, operator_l.into_blob()) }
    }

    /// Returns `expression_l` field
    pub fn get_expression_l(&self) -> &Loc {
        unsafe {
            #[allow(trivial_casts)]
            (lib_ruby_parser__external__nodes__send__get_expression_l(&self.blob) as *const Loc)
                .as_ref()
                .unwrap()
        }
    }

    /// Sets `expression_l` field
    pub fn set_expression_l(&mut self, expression_l: Loc) {
        unsafe { lib_ruby_parser__external__nodes__send__set_expression_l(&mut self.blob, expression_l.into_blob()) }
    }

    #[allow(dead_code)]
    pub(crate) fn into_internal(self) -> InternalSend {
        let internal = unsafe { lib_ruby_parser__external__nodes__send__into_internal(self.blob) };
        std::mem::forget(self);
        internal
    }
}

extern "C" {
    fn lib_ruby_parser__external__nodes__send__get_recv(blob: *const Blob<Send>) -> *mut Blob<MaybePtr<Node>>;
    fn lib_ruby_parser__external__nodes__send__set_recv(blob: *mut Blob<Send>, blob: Blob<MaybePtr<Node>>);
    fn lib_ruby_parser__external__nodes__send__get_method_name(blob: *const Blob<Send>) -> *mut Blob<StringPtr>;
    fn lib_ruby_parser__external__nodes__send__set_method_name(blob: *mut Blob<Send>, blob: Blob<StringPtr>);
    fn lib_ruby_parser__external__nodes__send__get_args(blob: *const Blob<Send>) -> *mut Blob<List<Node>>;
    fn lib_ruby_parser__external__nodes__send__set_args(blob: *mut Blob<Send>, blob: Blob<List<Node>>);
    fn lib_ruby_parser__external__nodes__send__get_dot_l(blob: *const Blob<Send>) -> *mut Blob<MaybeLoc>;
    fn lib_ruby_parser__external__nodes__send__set_dot_l(blob: *mut Blob<Send>, blob: Blob<MaybeLoc>);
    fn lib_ruby_parser__external__nodes__send__get_selector_l(blob: *const Blob<Send>) -> *mut Blob<MaybeLoc>;
    fn lib_ruby_parser__external__nodes__send__set_selector_l(blob: *mut Blob<Send>, blob: Blob<MaybeLoc>);
    fn lib_ruby_parser__external__nodes__send__get_begin_l(blob: *const Blob<Send>) -> *mut Blob<MaybeLoc>;
    fn lib_ruby_parser__external__nodes__send__set_begin_l(blob: *mut Blob<Send>, blob: Blob<MaybeLoc>);
    fn lib_ruby_parser__external__nodes__send__get_end_l(blob: *const Blob<Send>) -> *mut Blob<MaybeLoc>;
    fn lib_ruby_parser__external__nodes__send__set_end_l(blob: *mut Blob<Send>, blob: Blob<MaybeLoc>);
    fn lib_ruby_parser__external__nodes__send__get_operator_l(blob: *const Blob<Send>) -> *mut Blob<MaybeLoc>;
    fn lib_ruby_parser__external__nodes__send__set_operator_l(blob: *mut Blob<Send>, blob: Blob<MaybeLoc>);
    fn lib_ruby_parser__external__nodes__send__get_expression_l(blob: *const Blob<Send>) -> *mut Blob<Loc>;
    fn lib_ruby_parser__external__nodes__send__set_expression_l(blob: *mut Blob<Send>, blob: Blob<Loc>);
    fn lib_ruby_parser__external__nodes__send__into_internal(blob: Blob<Send>) -> InternalSend;
    fn lib_ruby_parser__external__nodes__send__drop(blob: *mut Blob<Send>);
}

impl InnerNode for Send {
    fn expression(&self) -> &Loc {
        self.get_expression_l()
    }

    fn inspected_children(&self, indent: usize) -> Vec<String> {
        let mut result = InspectVec::new(indent);
        result.push_maybe_node_or_nil(self.get_recv());
        result.push_str(self.get_method_name());
        result.push_nodes(self.get_args());
        
        
        
        
        
        
        result.strings()
    }

    fn str_type(&self) -> &'static str {
        "send"
    }

    fn print_with_locs(&self) {
        println!("{}", self.inspect(0));
        self.get_recv().as_ref().map(|node| node.inner_ref().print_with_locs());
        for node in self.get_args().iter() {
          node.inner_ref().print_with_locs();
        }
        self.get_dot_l().as_ref().map(|loc| loc.print("dot"));
        self.get_selector_l().as_ref().map(|loc| loc.print("selector"));
        self.get_begin_l().as_ref().map(|loc| loc.print("begin"));
        self.get_end_l().as_ref().map(|loc| loc.print("end"));
        self.get_operator_l().as_ref().map(|loc| loc.print("operator"));
        self.get_expression_l().print("expression");
    }
}

impl Drop for Send {
    fn drop(&mut self) {
        unsafe { lib_ruby_parser__external__nodes__send__drop(&mut self.blob) }
    }
}
